/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.param.InvRoDUpdateParam;
import com.elitesland.inv.repo.InvRoDRepo;
import com.elitesland.inv.service.InvLotStkCommonService;
import com.elitesland.inv.service.InvRoDService;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvRoCommon31InVO;
import com.elitesland.inv.vo.InvRoDDownloadVO;
import com.elitesland.inv.vo.InvRoDVO;
import com.elitesland.inv.vo.param.InvRoDQueryParamVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inv/invRoD"})
@Api(value="\u9884\u7559\u5355\u660e\u7ec6", tags={"\u9884\u7559\u5355\u660e\u7ec6"})
public class InvRoDController {
    private final InvRoDService invRoDService;
    private final InvLotStkCommonService invLotStkCommonService;
    private final InvRoDRepo invRoDRepo;

    @GetMapping(value={"/findRoDListById/{docNo}"})
    @ApiOperation(value="\u6839\u636e\u9884\u7559\u5355ID\u67e5\u8be2\u660e\u7ec6\u6570\u636e")
    public ApiResult<?> findById(@PathVariable String docNo, @RequestParam(required=false) String applyNo) {
        return ApiResult.ok((Object)this.invRoDService.findRoDListById(docNo, applyNo));
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody InvRoDQueryParamVO param) {
        PagingVO ret = this.invRoDService.findInvRODVOS(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e(\u542b\u4e1a\u52a1\u5904\u7406)")
    public ApiResult<?> create(@RequestBody InvRoCommon31InVO invRoCommon31InVO) {
        return ApiResult.ok((Object)this.invRoDService.createDoc(invRoCommon31InVO));
    }

    @PutMapping(value={"/check"})
    @ApiOperation(value="\u9884\u7559\u5355\u5ba1\u6279\u901a\u8fc7\uff08\u6279\u91cf\uff09")
    public ApiResult<?> check(@RequestBody List<Long> ids) {
        this.invRoDService.checkBatch(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/refuse"})
    @ApiOperation(value="\u9884\u7559\u5355\u5ba1\u6279\u62d2\u7edd\uff08\u6279\u91cf\uff09")
    public ApiResult<?> refuse(@RequestBody List<Long> ids) {
        this.invRoDService.refuseBatch(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/release"})
    @ApiOperation(value="\u91ca\u653e\u9884\u7559\u5355\uff08\u6279\u91cf\uff09")
    public ApiResult<?> releaseInvRoList(@RequestBody List<Long> ids) {
        this.invRoDService.releaseInvRoList(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/cancelBatch"})
    @ApiOperation(value="\u9884\u7559\u5355\u53d6\u6d88\uff08\u6279\u91cf\uff09")
    public ApiResult<?> cancelBatch(@RequestBody List<Long> ids) {
        this.invRoDService.cancelBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/downloadRoCommon"})
    @ApiOperation(value="\u5e93\u5b58\u9884\u7559")
    public void downloadRoCommon(HttpServletResponse response, @RequestBody InvRoCommon30InVO param) throws IOException {
        PagingVO ret = this.invRoDService.findCombine(param);
        List list = ret.getRecords();
        List collect = list.stream().map(i -> {
            InvRoDDownloadVO downloadVO = new InvRoDDownloadVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            return downloadVO;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, collect, InvRoDDownloadVO.class, "\u5e93\u5b58\u9884\u7559", "\u5e93\u5b58\u9884\u7559");
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createBatch(@RequestBody List<InvRoDVO> list) {
        List invRoDVOS = this.invRoDService.useInvLotStkCommon24(list);
        return ApiResult.ok((Object)this.invRoDService.createBatch(invRoDVOS));
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    public ApiResult<?> update(@RequestBody InvRoDUpdateParam param) {
        this.invRoDService.updateUseInvLotStkCommon24(param);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteOne/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e")
    public ApiResult<?> deleteOne(@PathVariable Long id) {
        this.invRoDService.deleteOne(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<?> deleteBatch(@RequestBody List<Long> ids) {
        this.invRoDService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    public ApiResult<?> updateDeleteFlag(@PathVariable Long id) {
        this.invRoDService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @PatchMapping(value={"/submit"})
    @ApiOperation(value="\u63d0\u4ea4\u6570\u636e")
    public ApiResult<?> submit(@RequestBody List<Long> ids) {
        this.invRoDService.submit(ids);
        return ApiResult.ok();
    }

    public InvRoDController(InvRoDService invRoDService, InvLotStkCommonService invLotStkCommonService, InvRoDRepo invRoDRepo) {
        this.invRoDService = invRoDService;
        this.invLotStkCommonService = invLotStkCommonService;
        this.invRoDRepo = invRoDRepo;
    }
}

