/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.convert.InvStkConvert;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.vo.InvStkDExcelVO;
import com.elitesland.inv.vo.InvlotDExcelVO;
import com.elitesland.inv.vo.param.InvStkDQueryParamVO;
import com.elitesland.inv.vo.param.InvStkQueryParamVO;
import com.elitesland.inv.vo.resp.InvStkDRespVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/inv/invStk"})
@Api(value="\u5e93\u5b58\u7ed3\u5b58\u660e\u7ec6", tags={"\u5e93\u5b58\u7ed3\u5b58\u660e\u7ec6"})
public class InvStkController {
    private final InvStkService invStkService;

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    ApiResult<?> findIdOne(@PathVariable Long id) {
        return this.invStkService.findIdOne(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @GetMapping(value={"/findCodeOne/{key}"})
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u6bb5\u67e5\u8be2\u6570\u636e")
    public ApiResult<?> findCodeOne(@PathVariable String key) {
        return this.invStkService.findCodeOne(key).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody InvStkQueryParamVO param) {
        PagingVO ret = this.invStkService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchD"})
    @ApiOperation(value="\u8be6\u7ec6\u6570\u636e\u67e5\u8be2(\u5e93\u5b58\u4f59\u989d\u67e5\u8be2)")
    public ApiResult<PagingVO<InvStkDRespVO>> searchD(@RequestBody InvStkDQueryParamVO param) {
        PagingVO ret = this.invStkService.searchD(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchD/export"})
    @ApiOperation(value="\u8be6\u7ec6\u6570\u636e\u5bfc\u51fa(\u5e93\u5b58\u4f59\u989d\u67e5\u8be2\u5bfc\u51fa)")
    public void export(HttpServletResponse response, @RequestBody InvStkDQueryParamVO param) throws IOException {
        List ret = this.invStkService.searchD(param).getRecords();
        List records = ret.stream().map(v -> {
            InvStkDExcelVO newDo = InvStkConvert.INSTANCE.respVOTOExcelVo((InvStkDRespVO)v);
            return newDo;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, records, InvStkDExcelVO.class, "\u5e93\u5b58\u53ef\u4f9b\u91cf", "\u5e93\u5b58\u53ef\u4f9b\u91cf");
    }

    @PostMapping(value={"/searchInvLot"})
    @ApiOperation(value="\u5e93\u5b58\u6279\u6b21\u67e5\u8be2")
    public ApiResult<PagingVO<InvStkDRespVO>> searchInvLot(@RequestBody InvStkDQueryParamVO param) {
        PagingVO ret = this.invStkService.searchLot(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchInvLot/export"})
    @ApiOperation(value="\u5e93\u5b58\u6279\u6b21\u67e5\u8be2\u5bfc\u51fa")
    public void lotExport(HttpServletResponse response, @RequestBody InvStkDQueryParamVO param) throws IOException {
        List ret = this.invStkService.searchLot(param).getRecords();
        List records = ret.stream().map(v -> {
            InvlotDExcelVO newDo = InvStkConvert.INSTANCE.lotRespVOTOExcelVO((InvStkDRespVO)v);
            return newDo;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, records, InvlotDExcelVO.class, "\u6279\u6b21\u5e93\u5b58\u67e5\u8be2", "\u6279\u6b21\u5e93\u5b58\u67e5\u8be2");
    }

    public InvStkController(InvStkService invStkService) {
        this.invStkService = invStkService;
    }
}

