/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.controller;

import com.alibaba.excel.util.StringUtils;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.convert.InvWhConvert;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.param.InvWhAreaParamVO;
import com.elitesland.inv.vo.param.InvWhKeywordParamVO;
import com.elitesland.inv.vo.param.InvWhListParamVO;
import com.elitesland.inv.vo.param.InvWhParamVO;
import com.elitesland.inv.vo.resp.InvExportWhRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.resp.InvWhRptRespVO;
import com.elitesland.inv.vo.save.InvWhSaveVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inv/invWh"})
@Api(value="\u4ed3\u5e93", tags={"\u4ed3\u5e93"})
public class InvWhController {
    private final InvWhService invWhService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody InvWhAreaParamVO param) {
        PagingVO ret = this.invWhService.searchWhArea(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u65b0\u589e\u3001\u4fee\u6539\u6570\u636e")
    public ApiResult<?> createOne(@RequestBody InvWhSaveVO param) {
        Long id = this.invWhService.createWh(param);
        return ApiResult.ok((Object)id.toString());
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ApiResult<?> findIdOne(@PathVariable Long id) {
        Optional vo = this.invWhService.findWhAreaById(id);
        return vo.isPresent() ? ApiResult.ok((Object)((InvWhRespVO)vo.get())) : ApiResult.ok();
    }

    @PostMapping(value={"/exportW"})
    @ApiOperation(value="\u4ed3\u5e93\u5bfc\u51fa")
    public void exportW(HttpServletResponse response, @RequestBody InvWhAreaParamVO param) throws IOException {
        param.setSize(Integer.valueOf(200000));
        PagingVO orgWhAreaVOPagingVO = this.invWhService.searchWhArea(param);
        List records = orgWhAreaVOPagingVO.getRecords();
        List<InvExportWhRespVO> collect = records.stream().map(v -> {
            InvExportWhRespVO invExportWhRespVO = new InvExportWhRespVO();
            BeanUtils.copyProperties((Object)v, (Object)invExportWhRespVO);
            InvWhRespVO invWhRespVO = v.getInvWhRespVO();
            BeanUtils.copyProperties((Object)invWhRespVO, (Object)invExportWhRespVO);
            invExportWhRespVO.setOuterCode(v.getOuterCode());
            return invExportWhRespVO;
        }).collect(Collectors.toList());
        collect.forEach(ll -> {
            String country = StringUtils.isEmpty((Object)ll.getCountry()) ? "" : ll.getCountry() + "-";
            String provinceName = StringUtils.isEmpty((Object)ll.getProvinceName()) ? "" : ll.getProvinceName() + "-";
            String city = StringUtils.isEmpty((Object)ll.getCityName()) ? "" : ll.getCityName();
            String county = StringUtils.isEmpty((Object)ll.getCountyName()) ? "" : ll.getCountyName();
            ll.setCityName(country + provinceName + city + county);
            if (ll.getThirdplFlag() != null) {
                if (ll.getThirdplFlag().equals(1)) {
                    ll.setThirdplFlagName("\u5426");
                } else {
                    ll.setThirdplFlagName("\u662f");
                }
            }
        });
        ExcelWriteUtil.excelWrite(response, collect, InvExportWhRespVO.class, "\u4ed3\u5e93\u67e5\u8be2\u5bfc\u51fa", "\u4ed3\u5e93");
    }

    @PostMapping(value={"/searchSalWh"})
    @ApiOperation(value="\u9500\u552e\u8ba2\u5355:\u4ed3\u5e93\u4e0b\u62c9\u6846\uff1a\u8fd4\u56deid\u3001code\u3001name,physicalWhCode,deter1,deter2,temperature(????)")
    public ApiResult<?> searchSalWh(@RequestBody InvWhListParamVO param) throws ExecutionException, InterruptedException {
        List ret = this.invWhService.searchSalWh(param.getKeyword());
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchWh"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2(\u524d\u7aef\u5f39\u7a97\u7ec4\u4ef6\u4e13\u7528)")
    public ApiResult<?> search(@RequestBody InvWhParamVO param) {
        PagingVO ret = this.invWhService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchWhRpt"})
    public ApiResult<?> searchRpt(@RequestBody InvWhAreaParamVO param) {
        PagingVO orgWhAreaVOSPaging = this.invWhService.searchWhArea(param);
        List ret = orgWhAreaVOSPaging.getRecords().stream().map(v -> {
            InvWhRptRespVO rptVO = InvWhConvert.INSTANCE.voToRptVo(v.getInvWhRespVO());
            rptVO.setRId(Long.valueOf(v.hashCode()));
            rptVO.setDeter1(v.getDeter1());
            rptVO.setDeter1Name(v.getDeter1Name());
            rptVO.setDeter2(v.getDeter2());
            rptVO.setDeter2Name(v.getDeter2Name());
            rptVO.setOuterCode(v.getOuterCode());
            rptVO.setOuterCodeName(v.getOuterCodeName());
            rptVO.setOuterCode2(v.getOuterCode2());
            rptVO.setOuterCode2Name(v.getOuterCode2Name());
            rptVO.setCustCode(v.getPCode());
            rptVO.setCustName(v.getPName());
            rptVO.setDeter3(v.getDeter3());
            rptVO.setPType(v.getPType());
            rptVO.setPCode(v.getPCode());
            rptVO.setPName(v.getPName());
            return rptVO;
        }).collect(Collectors.toList());
        PagingVO paging = new PagingVO();
        paging.setRecords(ret);
        paging.setTotal(orgWhAreaVOSPaging.getTotal());
        return ApiResult.ok((Object)paging);
    }

    @PostMapping(value={"/searchByKeyword"})
    public ApiResult<?> searchByKeyword(@RequestBody InvWhKeywordParamVO param) {
        return ApiResult.ok((Object)this.invWhService.findByMultiKeyword(param));
    }

    @PostMapping(value={"/findByCodes"})
    @ApiOperation(value="\u6839\u636ecodeList\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody List<String> codes) {
        return ApiResult.ok((Object)this.invWhService.findByCodes(codes));
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u4ed3\u5e93list\u4e0b\u62c9(\u8fd4\u56deid\u3001code\u3001name,physicalWhCode,deter1,deter2,deter3,whAbbr)")
    public ApiResult<?> list(@RequestBody InvWhListParamVO param) throws ExecutionException, InterruptedException {
        List ret = this.invWhService.list(param.getKeyword());
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/listWhType"})
    @ApiOperation(value="\u4ed3\u5e93list\u4e0b\u62c9(\u8fd4\u56deid\u3001code\u3001name,physicalWhCode,deter1,deter2,deter3,whAbbr)")
    public ApiResult<?> listWhType(@RequestBody InvWhListParamVO param) throws ExecutionException, InterruptedException {
        List ret = this.invWhService.listWhType(param.getKeyword());
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/listGroup"})
    @ApiOperation(value="\u4ed3\u5e93list\u4e0b\u62c9:\u8fc7\u6ee4\u6389\u4ed3\u5e93\u7c7b\u578b\u4e0d\u4e3a\u7269\u7406\u4ed3\u7684\u6570\u636e")
    public ApiResult<?> listGroup(@RequestBody InvWhListParamVO param) throws ExecutionException, InterruptedException {
        List ret = this.invWhService.listGroup(param.getKeyword());
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/listBuId"})
    @ApiOperation(value="\u4ed3\u5e93\u4e0b\u62c9\u6846\uff0c\u6839\u636e\u5df2\u9009\u62e9\u7684\u9500\u552e\u7ec4\u7ec7\uff0c\u67e5\u627e\u76f8\u5173\u6570\u636e\uff0c\u9500\u552e\u8ba2\u5355\u4e13\u7528")
    public ApiResult<?> listBuId(@RequestBody InvWhListParamVO param) throws ExecutionException, InterruptedException {
        List ret = this.invWhService.listBuId(param);
        return ApiResult.ok((Object)ret);
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<?> deleteBatch(List<Long> ids) {
        this.invWhService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @GetMapping(value={"/nonInterface"})
    @ApiOperation(value="nonInterface")
    public ApiResult<?> nonInterface(Long whId) {
        return ApiResult.ok((Object)this.invWhService.nonInterface(whId));
    }

    @PostMapping(value={"/findByOuterCode"})
    @ApiOperation(value="\u4ed3\u5e93\u4e0b\u62c9\u6846\uff0c\u6839\u636eouterCode\uff0c\u67e5\u627e\u76f8\u5173\u6570\u636e")
    public ApiResult<?> findByOuterCode(@RequestBody InvWhAreaParamVO queryParam) {
        return ApiResult.ok((Object)this.invWhService.findByOuterCode(queryParam));
    }

    public InvWhController(InvWhService invWhService) {
        this.invWhService = invWhService;
    }
}

