/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvAjDConvert;
import com.elitesland.inv.entity.InvAjDDO;
import com.elitesland.inv.entity.InvAjDO;
import com.elitesland.inv.entity.QInvAjDO;
import com.elitesland.inv.param.InvAjDQueryParam;
import com.elitesland.inv.param.PriGroupParam;
import com.elitesland.inv.repo.InvAjDRepo;
import com.elitesland.inv.repo.InvAjDRepoProc;
import com.elitesland.inv.repo.InvAjRepo;
import com.elitesland.inv.service.InvAjDService;
import com.elitesland.inv.service.InvCorssentryPricepolicyService;
import com.elitesland.inv.service.InvLotStkCommonService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvAjAndInvAjDDownloadVO;
import com.elitesland.inv.vo.InvAjDVO;
import com.elitesland.inv.vo.InvLotStkCommon24InVO;
import com.elitesland.inv.vo.param.InvAjDQueryAllParamVO;
import com.elitesland.inv.vo.param.InvStkDQueryParamVO;
import com.elitesland.inv.vo.resp.InvAjAndInvAjDRespVO;
import com.elitesland.inv.vo.resp.InvStkDRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvAjDSaveVO;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.out.vo.param.OrgQueryParamVO;
import com.elitesland.out.vo.resp.OrgRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.google.common.collect.Maps;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvAjDServiceImpl
implements InvAjDService {
    private final JPAQueryFactory jpaQueryFactory;
    private final InvAjDRepo invAjDRepo;
    private final InvAjRepo invAjRepo;
    private final InvAjDRepoProc invAjDRepoProc;
    private final InvWhService invWhService;
    private final InvStkService invStkService;
    public final InvLotStkCommonService invLotStkCommonService;
    private final InvCorssentryPricepolicyService invCorssentryPricepolicyService;
    private final SysUdcService sysUdcService;
    private final InvWhAreaService invWhAreaService;
    private final OutService outService;

    public PagingVO<InvAjAndInvAjDRespVO> searchAll(InvAjDQueryAllParamVO param) {
        List brands = param.getBrands();
        if (!CollectionUtils.isEmpty((Collection)brands)) {
            List itemIds = null;
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            itmItemPartParam.setBrands(brands);
            List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
            if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                itemIds = itmItemPartDTOS.stream().map(ItmItemPartDTO::getId).collect(Collectors.toList());
            }
            if (param.getItemIds() != null) {
                param.getItemIds().addAll(itemIds);
            } else {
                param.setItemIds(itemIds);
            }
        }
        JPAQuery emps = (JPAQuery)this.invAjDRepoProc.ajSelect().where(this.invAjDRepoProc.searchWhere(param));
        param.fillOrders(emps, (EntityPathBase)QInvAjDO.invAjDO);
        param.setPaging(emps);
        List fetch = emps.fetch();
        this.fillUpNameList(fetch);
        return PagingVO.builder().total(Long.valueOf(emps.fetchCount())).records(fetch).build();
    }

    @SysCodeProc
    public List<InvAjAndInvAjDRespVO> searchAllList(InvAjDQueryAllParamVO param) {
        JPAQuery emps = (JPAQuery)this.invAjDRepoProc.select().where(this.invAjDRepoProc.wherealllist(param));
        List fetch = emps.fetch();
        this.fillUpNameList(fetch);
        return fetch;
    }

    public Long update(InvAjDVO data) {
        InvAjDDO invAjDDO = new InvAjDDO();
        BeanUtils.copyProperties((Object)data, (Object)invAjDDO);
        return ((InvAjDDO)this.invAjDRepo.save(invAjDDO)).getId();
    }

    public Long add(InvAjDVO data) {
        InvAjDDO invAjDDO = new InvAjDDO();
        BeanUtils.copyProperties((Object)data, (Object)invAjDDO);
        return ((InvAjDDO)this.invAjDRepo.save(invAjDDO)).getId();
    }

    public void delete(Long id) {
        this.invAjDRepo.deleteById(id);
    }

    public List<Long> addInBatch(List<InvAjDSaveVO> data) {
        return this.updateInBatch(data);
    }

    public List<Long> updateInBatch(List<InvAjDSaveVO> data) {
        List invAjDDOS = data.stream().map(e -> {
            InvAjDDO invAjDDO = new InvAjDDO();
            BeanUtils.copyProperties((Object)e, (Object)invAjDDO);
            return invAjDDO;
        }).collect(Collectors.toList());
        return this.invAjDRepo.saveAll(invAjDDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public PagingVO<InvAjDVO> search(InvAjDQueryParam param) {
        Page invAjs = this.invAjDRepo.findAll(this.invAjDRepoProc.where(param), (Pageable)param.getPageRequest());
        List ajs = invAjs.getContent();
        List ajsVos = ajs.stream().map(InvAjDConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(invAjs.getTotalElements())).records(ajsVos).build();
    }

    public void deleteInBatch(List<InvAjDVO> data) {
        List invAjDDOS = data.stream().map(e -> {
            InvAjDDO invAjDDO = new InvAjDDO();
            BeanUtils.copyProperties((Object)e, (Object)invAjDDO);
            return invAjDDO;
        }).collect(Collectors.toList());
        this.invAjDRepo.deleteAll(invAjDDOS);
    }

    @SysCodeProc
    public List<InvAjDVO> findByMasId(Long masId) {
        List<InvAjDVO> invAjDVOS = this.invAjDRepo.findByMasId(masId).stream().map(InvAjDConvert.INSTANCE::doToVO).collect(Collectors.toList());
        this.fillUpNameList2(invAjDVOS);
        invAjDVOS.stream().forEach(i -> {
            InvStkDQueryParamVO tskParam = new InvStkDQueryParamVO();
            tskParam.setWhIds(List.of(i.getWhId()));
            tskParam.setDeter1(i.getDeter1());
            tskParam.setDeter2(i.getDeter2());
            tskParam.setLotNo(i.getLotNo());
            ArrayList<Long> itemIds = new ArrayList<Long>();
            itemIds.add(i.getItemId());
            tskParam.setItemIds(itemIds);
            List ret = this.invStkService.searchD(tskParam).getRecords();
            if (!CollectionUtils.isEmpty((Collection)ret)) {
                i.setAvalQty(((InvStkDRespVO)ret.get(0)).getAvalQty());
            }
        });
        return invAjDVOS;
    }

    public void deleteByMasId(Long masId) {
        this.invAjDRepo.deleteByMasId(masId);
    }

    public List<InvAjDVO> findByMasIds(List<Long> ajIds) {
        return this.invAjDRepo.findByMasIdIn(ajIds).stream().map(v -> (InvAjDVO)BeanUtil.copyProperties((Object)v, InvAjDVO.class)).collect(Collectors.toList());
    }

    public List<Long> updateInvAjDList(List<InvAjDSaveVO> list) {
        LinkedList<InvLotStkCommon24InVO> inVOList = new LinkedList<InvLotStkCommon24InVO>();
        Iterator<InvAjDSaveVO> it = list.iterator();
        while (it.hasNext()) {
            InvLotStkCommon24InVO inVo = new InvLotStkCommon24InVO();
            InvAjDSaveVO current = it.next();
            inVo.setItemId(current.getItemId());
            inVo.setVariId(current.getVariId());
            inVo.setWhId(current.getWhId());
            inVo.setDeter1(current.getDeter1());
            inVo.setDeter2(current.getDeter2());
            inVo.setLotNo(current.getLotNo());
            inVOList.add(inVo);
        }
        Map outVoMap = this.invLotStkCommonService.invLotStkQuery(inVOList);
        LinkedList<InvAjDSaveVO> validatedList = new LinkedList<InvAjDSaveVO>();
        for (Map.Entry elem : outVoMap.entrySet()) {
            validatedList.add(list.get((Integer)elem.getKey()));
        }
        validatedList.addAll(list.stream().filter(v -> v.getDestroyFlag() != null && v.getDestroyFlag() != false && !validatedList.contains(v)).collect(Collectors.toList()));
        InvAjDO invAjDO = (InvAjDO)this.invAjRepo.findById(list.stream().findAny().map(InvAjDSaveVO::getMasId).orElseThrow()).orElseThrow();
        validatedList.forEach(v -> {
            PriGroupParam param = new PriGroupParam();
            param.setItemId(v.getItemId());
            param.setDocTime(invAjDO.getIoDate());
            param.setFromOuId(invAjDO.getOuId());
            PriSalePriceVO priSalePriceVO = this.invCorssentryPricepolicyService.costPrice(param);
            if (priSalePriceVO != null) {
                v.setCostPrice(priSalePriceVO.getCostPrice());
            }
            if (v.getCostPrice() != null && v.getQty() != null) {
                v.setCostAmt(v.getCostPrice().multiply(new BigDecimal(v.getQty())));
            }
        });
        List<Long> ret = this.updateInBatch(validatedList);
        return ret;
    }

    public List<InvAjAndInvAjDDownloadVO> findInvAjAndInvAjDDownloadVOs(InvAjDQueryAllParamVO param) {
        param.setSize(Integer.valueOf(20000));
        PagingVO<InvAjAndInvAjDRespVO> ret = this.searchAll(param);
        List list = ret.getRecords();
        List<InvAjAndInvAjDDownloadVO> invAjAndInvAjDDownloadVOS = list.stream().map(i -> {
            InvAjAndInvAjDDownloadVO downloadVO = new InvAjAndInvAjDDownloadVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            return downloadVO;
        }).collect(Collectors.toList());
        return invAjAndInvAjDDownloadVOS;
    }

    private void fillUpNameList(List<InvAjAndInvAjDRespVO> vos) {
        Map ajStatusMap = this.sysUdcService.getCodeMap(UdcEnum.INV_AJ_STATUS_DR.getModel(), UdcEnum.INV_AJ_STATUS_DR.getCode());
        Map docTypeMap = this.sysUdcService.getCodeMap(UdcEnum.INV_AJ_TYPE_LOT.getModel(), UdcEnum.INV_AJ_TYPE_LOT.getCode());
        Map reasonMap = this.sysUdcService.getCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map deter2Map = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_ADJUST.getModel(), UdcEnum.INV_FUNC_TYPE_ADJUST.getCode());
        Map uomMap = this.sysUdcService.getCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map pTypeMap = this.sysUdcService.getCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
        List itemIds = vos.stream().filter(f -> f.getItemId() != null).map(InvAjAndInvAjDRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ouIds = vos.stream().map(InvAjAndInvAjDRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List whIds = vos.stream().map(InvAjAndInvAjDRespVO::getWhId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<String> pTypes = vos.stream().map(InvAjAndInvAjDRespVO::getPType).distinct().collect(Collectors.toList());
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(itemIds);
        List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
        List<OrgOuVO> orgOuVOS = this.outService.listOrgOuVOByIds(ouIds);
        List orgSuppVOS = this.invWhService.findIdBatch(whIds);
        HashMap pTypeNameMap = Maps.newHashMap();
        pTypes.forEach(p -> {
            OrgQueryParamVO param = new OrgQueryParamVO();
            param.setType(p);
            List<OrgRespVO> orgRespVOS = this.outService.findcodeAndName(param);
            pTypeNameMap.put(p, orgRespVOS);
        });
        vos.forEach(vo -> {
            List orgRespVOS;
            Optional<ItmItemPartDTO> itmItemVO;
            Optional<OrgOuVO> orgOuVO = orgOuVOS.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst();
            Optional<InvWhRespVO> orgWhVO = orgSuppVOS.stream().filter(v -> v.getId().equals(vo.getWhId())).findFirst();
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS) && (itmItemVO = itmItemPartDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst()).isPresent()) {
                ItmItemPartDTO itemVO = itmItemVO.get();
                vo.setItemCode(itemVO.getItemCode());
                vo.setItemName(itemVO.getItemName());
                vo.setBrand(itemVO.getBrand());
            }
            if (orgOuVO.isPresent()) {
                OrgOuVO ouVO = orgOuVO.get();
                vo.setOuName(ouVO.getName());
                vo.setOuCode(ouVO.getCode());
            }
            if (orgWhVO.isPresent()) {
                InvWhRespVO whVO = orgWhVO.get();
                vo.setWhCode(whVO.getWhCode());
                vo.setWhName(whVO.getWhName());
            }
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(vo.getDocStatus())) {
                vo.setDocStatusName((String)ajStatusMap.get(vo.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)docTypeMap) && docTypeMap.containsKey(vo.getDocType())) {
                vo.setDocTypeName((String)docTypeMap.get(vo.getDocType()));
            }
            if (!CollectionUtils.isEmpty((Map)reasonMap) && reasonMap.containsKey(vo.getReasonCode())) {
                vo.setReasonCodeName((String)reasonMap.get(vo.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty((Map)deter2Map) && deter2Map.containsKey(vo.getDeter2())) {
                vo.setDeter2Name((String)deter2Map.get(vo.getDeter2()));
            }
            if (!CollectionUtils.isEmpty((Map)uomMap) && uomMap.containsKey(vo.getUom())) {
                vo.setUomName((String)uomMap.get(vo.getUom()));
            }
            if (!CollectionUtils.isEmpty((Map)pTypeMap) && pTypeMap.containsKey(vo.getPType())) {
                vo.setPTypeName((String)pTypeMap.get(vo.getPType()));
            }
            if (!CollectionUtils.isEmpty((Map)pTypeNameMap) && pTypeNameMap.containsKey(vo.getPType()) && !CollectionUtils.isEmpty((Collection)(orgRespVOS = (List)pTypeNameMap.get(vo.getPType()))) && !StringUtils.isEmpty((Object)vo.getPCode())) {
                orgRespVOS.stream().filter(f -> f.getCode().equals(vo.getPCode())).findFirst().ifPresent(o -> vo.setPName(o.getName()));
            }
        });
    }

    private void fillUpNameList2(List<InvAjDVO> vos) {
        List itemIds = vos.stream().map(InvAjDVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public InvAjDServiceImpl(JPAQueryFactory jpaQueryFactory, InvAjDRepo invAjDRepo, InvAjRepo invAjRepo, InvAjDRepoProc invAjDRepoProc, InvWhService invWhService, InvStkService invStkService, InvLotStkCommonService invLotStkCommonService, InvCorssentryPricepolicyService invCorssentryPricepolicyService, SysUdcService sysUdcService, InvWhAreaService invWhAreaService, OutService outService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.invAjDRepo = invAjDRepo;
        this.invAjRepo = invAjRepo;
        this.invAjDRepoProc = invAjDRepoProc;
        this.invWhService = invWhService;
        this.invStkService = invStkService;
        this.invLotStkCommonService = invLotStkCommonService;
        this.invCorssentryPricepolicyService = invCorssentryPricepolicyService;
        this.sysUdcService = sysUdcService;
        this.invWhAreaService = invWhAreaService;
        this.outService = outService;
    }
}

