/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.NumSendObjectEnum;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvAjConvert;
import com.elitesland.inv.entity.InvAjDDO;
import com.elitesland.inv.entity.InvAjDO;
import com.elitesland.inv.entity.QInvAjDO;
import com.elitesland.inv.param.InvAjQueryParam;
import com.elitesland.inv.param.PriGroupParam;
import com.elitesland.inv.repo.InvAjDRepo;
import com.elitesland.inv.repo.InvAjRepo;
import com.elitesland.inv.repo.InvAjRepoProc;
import com.elitesland.inv.service.InvAjDService;
import com.elitesland.inv.service.InvAjService;
import com.elitesland.inv.service.InvCorssentryPricepolicyService;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvRoDService;
import com.elitesland.inv.service.InvRoService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvAjDVO;
import com.elitesland.inv.vo.InvAjVO;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.ServiceResult;
import com.elitesland.inv.vo.resp.InvAjDRespVO;
import com.elitesland.inv.vo.resp.InvAjRespVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.resp.InvStkRespVO;
import com.elitesland.inv.vo.resp.InvWhAreaRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvAjSaveVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.system.service.SysUserService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.Predicate;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@DubboService
public class InvAjServiceImpl
implements InvAjService {
    private final InvAjRepo invAjRepo;
    private final InvAjDRepo invAjDRepo;
    private final InvAjRepoProc invAjRepoProc;
    private final InvAjDService invAjDService;
    private final InvWhService invWhService;
    private final SysUserService sysUserService;
    private final InvLotService invLotService;
    private final InvRoService invRoService;
    private final InvRoDService invRODService;
    private final SysNumberRuleService sysNumberRuleService;
    private final InvWhAreaService invWhAreaService;
    private final InvCorssentryPricepolicyService invCorssentryPricepolicyService;
    private final InvStkCommonService invStkCommonService;
    private final InvStkService invStkService;
    private final InvLotCommonService invLotCommonService;
    private final SysUdcService sysUdcService;
    private final OutService outService;

    @SysCodeProc
    public PagingVO<InvAjVO> search(InvAjQueryParam param) {
        Page invAjs = this.invAjRepo.findAll(this.invAjRepoProc.where(param), (Pageable)param.getPageRequest());
        List ajs = invAjs.getContent();
        List ajsVos = ajs.stream().map(InvAjConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(invAjs.getTotalElements())).records(ajsVos).build();
    }

    public Long add(InvAjVO data) {
        InvAjDO invAjDO = new InvAjDO();
        BeanUtils.copyProperties((Object)data, (Object)invAjDO);
        return ((InvAjDO)this.invAjRepo.save(invAjDO)).getId();
    }

    public void update(InvAjVO data) {
        this.add(data);
    }

    public List<Long> updateInBatch(List<InvAjVO> list) {
        List invAjDOS = list.stream().map(e -> {
            InvAjDO invAjDO = new InvAjDO();
            BeanUtils.copyProperties((Object)e, (Object)invAjDO);
            return invAjDO;
        }).collect(Collectors.toList());
        return this.invAjRepo.saveAll(invAjDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public void delete(Long id) {
        this.invAjRepo.deleteById(id);
    }

    @SysCodeProc
    public Optional<InvAjVO> findIdOne(Long id) {
        Optional temp;
        Optional<InvAjVO> invAjVOOptional = this.invAjRepo.findById(id).map(invAjDO -> (InvAjVO)BeanUtil.copyProperties((Object)invAjDO, InvAjVO.class));
        if (invAjVOOptional.isPresent() && invAjVOOptional.get() != null && (temp = this.invWhService.findById(invAjVOOptional.get().getWhId().longValue())).isPresent()) {
            invAjVOOptional.get().setWhCode(((InvWhRespVO)temp.get()).getWhCode());
        }
        return invAjVOOptional;
    }

    private void updateDocStatusAndApprStatus(String valueCode, String name, Long id) {
        if (this.invAjRepo.existsById(id)) {
            InvAjDO invAjDO = new InvAjDO();
            invAjDO.setId(id);
            invAjDO.setDocStatus(valueCode);
            invAjDO.setApprStatus(name);
            invAjDO.setApprTime(LocalDateTime.now());
            this.update(invAjDO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(InvAjDO objDo) {
        Optional optional = this.invAjRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (InvAjDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invAjRepo.save((InvAjDO)optional.get());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ids.forEach(id -> {
            Optional optional = this.invAjRepo.findById(id);
            if (!optional.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u7533\u8bf7\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
            }
            InvAjDO invAjDO = (InvAjDO)optional.get();
            if (!UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAjDO.getDocStatus()) && !UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAjDO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f/\u5df2\u62d2\u7edd\u72b6\u6001\u7684\u8c03\u6574\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
            }
            InvAjDO invAjDOUpdate = new InvAjDO();
            invAjDOUpdate.setId((Long)id);
            invAjDOUpdate.setDocStatus(UdcEnum.INV_AJ_STATUS_CL.getValueCode());
            this.update(invAjDOUpdate);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void approveBatch(List<Long> ids) {
        ids.forEach(id -> {
            Optional optional = this.invAjRepo.findById(id);
            if (!optional.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u5ba1\u6279\uff0c\u8bf7\u68c0\u67e5");
            }
            InvAjDO invAjDO = (InvAjDO)optional.get();
            if (!UdcEnum.INV_AJ_STATUS_APPING.getValueCode().equals(invAjDO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u5ba1\u6279\uff0c\u8bf7\u68c0\u67e5");
            }
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDO.getDocType())) {
                List invAjDVOS = this.invAjDService.findByMasId(invAjDO.getId());
                List itemIds = invAjDVOS.stream().filter(f -> f.getItemId() != null).map(InvAjDVO::getItemId).distinct().collect(Collectors.toList());
                ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
                itmItemPartParam.setIds(itemIds);
                List<ItmItemDTO> itmItemDTOS = this.outService.itmItemAllSearch(itmItemPartParam);
                ArrayList invLotVOList = new ArrayList();
                invAjDVOS.stream().forEach(i -> {
                    ArrayList<CallSite> param = new ArrayList<CallSite>();
                    param.add((CallSite)((Object)(i.getItemId() + "_" + i.getLotNo())));
                    List ret = this.invLotService.findByAndItemIdAndLotNo(param);
                    if (ret.isEmpty()) {
                        if (i.getToLotNo() != null) {
                            InvLotSaveVO tmp = new InvLotSaveVO();
                            tmp.setItemId(i.getItemId());
                            tmp.setManuDate(i.getManuDate());
                            tmp.setExpireDate(i.getExpireDate());
                            tmp.setLotNo(i.getToLotNo());
                            tmp.setSrcDocNo(invAjDO.getDocNo());
                            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
                            tmp.setOuId(invAjDO.getOuId());
                            tmp.setBuId(invAjDO.getBuId());
                            if (!CollectionUtils.isEmpty((Collection)itmItemDTOS)) {
                                itmItemDTOS.stream().filter(f -> f.getId().equals(i.getItemId()) && f.getGuaranteePeriod() != null).findFirst().ifPresent(item -> tmp.setExpireDays(Integer.valueOf(item.getGuaranteePeriod().intValue())));
                            }
                            invLotVOList.add(tmp);
                        }
                    } else {
                        ArrayList invLotVOS = new ArrayList();
                        ret.stream().forEach(v -> {
                            v.setMenuLotNo(i.getMenuLotNo());
                            InvLotVO lotVO = (InvLotVO)BeanUtil.copyProperties((Object)v, InvLotVO.class);
                            invLotVOS.add(lotVO);
                        });
                        this.invLotCommonService.updateInvLotInfo(invLotVOS);
                    }
                });
                this.invLotCommonService.createInvLotInfo(invLotVOList);
            }
            InvAjDO invAjDOUpdate = new InvAjDO();
            invAjDOUpdate.setId((Long)id);
            invAjDOUpdate.setDocStatus(UdcEnum.INV_AJ_STATUS_APPED.getValueCode());
            this.update(invAjDOUpdate);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void refuseBatch(List<Long> ids) {
        ids.forEach(id -> {
            Optional<InvAjVO> invAjVOOptional = this.findIdOne((Long)id);
            if (!invAjVOOptional.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01 id" + id);
            }
            InvAjVO invAjVO = invAjVOOptional.get();
            if (!UdcEnum.INV_AJ_STATUS_APPING.getValueCode().equals(invAjVO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u5ba1\u6279\uff0c\u8bf7\u68c0\u67e5");
            }
            List invAjDVOS = this.invAjDService.findByMasId(id);
            List<InvStkCommon37InVO> invStkCommon37InVOS = this.convertCommon37InVO(invAjDVOS, invAjVO, InvStk28Enum.T_TYPE_26);
            if (!CollectionUtils.isEmpty(invStkCommon37InVOS)) {
                this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
            }
            InvAjDO invAjDOUpdate = new InvAjDO();
            invAjDOUpdate.setId((Long)id);
            invAjDOUpdate.setDocStatus(UdcEnum.INV_AJ_STATUS_RJ.getValueCode());
            this.update(invAjDOUpdate);
        });
    }

    @SysCodeProc
    public Optional<InvAjRespVO> findOneInvAj(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        Optional<InvAjRespVO> optional = this.invAjRepo.findById(id).map(InvAjConvert.INSTANCE::doToRespVO);
        if (optional.isPresent()) {
            InvAjRespVO invAjRespVO = optional.get();
            this.fillUpNameList(List.of(invAjRespVO));
            List invAjDVOS = this.invAjDService.findByMasId(id);
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            List itemIds = invAjDVOS.stream().filter(f -> f.getItemId() != null).map(InvAjDVO::getItemId).distinct().collect(Collectors.toList());
            itmItemPartParam.setIds(itemIds);
            List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
            List invAjDRespVOList = invAjDVOS.stream().map(e -> {
                InvAjDRespVO invAjDRespVO = new InvAjDRespVO();
                BeanUtils.copyProperties((Object)e, (Object)invAjDRespVO);
                invAjDRespVO.setDeter2Name(this.getUdcDesc(UdcEnum.INV_FUNC_TYPE_ADJUST.getModel(), UdcEnum.INV_FUNC_TYPE_ADJUST.getCode(), e.getDeter2()));
                invAjDRespVO.setReasonCodeName(this.getUdcDesc(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode(), e.getReasonCode()));
                invAjDRespVO.setUomName(this.getUdcDesc(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode(), e.getUom()));
                if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(i -> {
                        invAjDRespVO.setItemCode(i.getItemCode());
                        invAjDRespVO.setItemName(i.getItemName());
                    });
                }
                return invAjDRespVO;
            }).collect(Collectors.toList());
            invAjRespVO.setInvAjDVOList(invAjDRespVOList);
            return Optional.of(invAjRespVO);
        }
        return Optional.empty();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveOneInvAj(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.getInvAjDSaveVOList().stream().forEach(i -> {
            InvRoCommon30InVO param = new InvRoCommon30InVO();
            param.setItemId(i.getItemId());
            param.setLotNo(i.getLotNo());
            param.setWhId(i.getWhId());
            param.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
            param.setDeter2(i.getDeter2());
            param.setDeter3(i.getDeter3());
            param.setQty(i.getQty());
            param.setDocStatus(UdcEnum.INV_RO_STATUS_APPED.getValueCode());
            if (!invAjSaveVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_DES.getValueCode()) && !invAjSaveVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_STK.getValueCode()) && this.invRoService.checkRoExist(param).booleanValue()) {
                throw new BusinessException(ApiCode.FAIL, "\u5e93\u5b58\u6279\u6b21\u5b58\u5728\u9884\u7559\u5355\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
        });
        if (!CollectionUtils.isEmpty((Collection)invAjSaveVO.getInvAjDSaveVOList())) {
            invAjSaveVO.getInvAjDSaveVOList().stream().forEach(i -> {
                InvWhAreaRespVO invWhAreaRespVO = this.invWhAreaService.findByWhIdAndWhArea(i.getWhId(), i.getDeter2());
                if (invWhAreaRespVO == null) {
                    throw new BusinessException(ApiCode.FAIL, String.format("[%s],\u8be5\u4ed3\u5e93\u6ca1\u6709\u529f\u80fd\u5e93\u533a[%s],\u8bf7\u68c0\u67e5\u6570\u636e\uff01", i.getWhName(), i.getDeter2Name()));
                }
            });
        }
        Long masId = this.saveInvAj(invAjSaveVO);
        if (!CollectionUtils.isEmpty((Collection)invAjSaveVO.getInvAjDSaveVOList())) {
            List invAjDSaveVOS = invAjSaveVO.getInvAjDSaveVOList();
            Long finalMasId = masId;
            AtomicDouble linoNo = new AtomicDouble(0.0);
            List invAjDDOS = invAjDSaveVOS.stream().map(d -> {
                InvAjDDO invAjDDO = (InvAjDDO)BeanUtil.copyProperties((Object)d, InvAjDDO.class);
                invAjDDO.setMasId(finalMasId);
                invAjDDO.setLineNo(linoNo.addAndGet(1.0));
                PriGroupParam param = new PriGroupParam();
                param.setItemId(d.getItemId());
                param.setFromOuId(invAjSaveVO.getOuId());
                param.setToOuId(invAjSaveVO.getOuId());
                param.setDocTime(invAjSaveVO.getIoDate());
                PriSalePriceVO priSalePriceVO = this.invCorssentryPricepolicyService.costPrice(param);
                if (priSalePriceVO != null) {
                    invAjDDO.setCostPrice(priSalePriceVO.getCostPrice());
                }
                invAjDDO.setCostAmt(invAjDDO.getCostPrice() == null || invAjDDO.getQty() == null ? null : invAjDDO.getCostPrice().multiply(new BigDecimal(invAjDDO.getQty())));
                invAjDDO.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                return invAjDDO;
            }).collect(Collectors.toList());
            this.invAjDRepo.saveAll(invAjDDOS);
        }
        return masId;
    }

    private Long saveInvAj(InvAjSaveVO invAjSaveVO) {
        InvAjDO invAjDO = (InvAjDO)BeanUtil.copyProperties((Object)invAjSaveVO, InvAjDO.class);
        Long masId = invAjDO.getId();
        invAjDO.setDocStatus(UdcEnum.INV_AJ_STATUS_DR.getValueCode());
        invAjDO.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        if (masId != null) {
            Optional optional = this.invAjRepo.findById(masId);
            if (optional.isPresent()) {
                if (!UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(((InvAjDO)optional.get()).getDocStatus()) && !UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(((InvAjDO)optional.get()).getDocStatus())) {
                    throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u518d\u6b21\u4fdd\u5b58");
                }
                this.update(invAjDO);
                this.invAjDService.deleteByMasId(masId);
            } else {
                invAjDO.setDocNo(this.getInvAjDocNo(invAjSaveVO));
                masId = ((InvAjDO)this.invAjRepo.save(invAjDO)).getId();
            }
        } else {
            invAjDO.setDocNo(this.getInvAjDocNo(invAjSaveVO));
            masId = ((InvAjDO)this.invAjRepo.save(invAjDO)).getId();
        }
        return masId;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long submitOneInvAj(InvAjSaveVO invAjSaveVO) {
        Long masId = invAjSaveVO.getId();
        if (masId == null) {
            masId = this.saveOneInvAj(invAjSaveVO);
        } else {
            Optional optional = this.invAjRepo.findById(masId);
            if (optional.isEmpty() || UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(((InvAjDO)optional.get()).getDocStatus()) || UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(((InvAjDO)optional.get()).getDocStatus())) {
                masId = this.saveOneInvAj(invAjSaveVO);
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u8349\u7a3f\u548c\u62d2\u7edd\u72b6\u6001\u5355\u636e\u624d\u53ef\u63d0\u4ea4");
            }
        }
        this.findIdOne(masId).ifPresent(w -> {
            w.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
            this.update((InvAjDO)BeanUtil.copyProperties((Object)w, InvAjDO.class));
            List invAjDVOS = this.invAjDService.findByMasId(w.getId());
            List<InvStkCommon37InVO> invStkCommon37InVOS = this.convertCommon37InVO(invAjDVOS, (InvAjVO)w, InvStk28Enum.T_TYPE_22);
            if (!CollectionUtils.isEmpty(invStkCommon37InVOS)) {
                this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
            }
            switch (w.getDocType()) {
                case "LOT": {
                    break;
                }
            }
        });
        return masId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirmInvAj(List<Long> ids) {
        for (Long id : ids) {
            Optional<InvAjVO> invAjVOOptional = this.findIdOne(id);
            if (!invAjVOOptional.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            }
            InvAjVO invAjVO = invAjVOOptional.get();
            invAjVO.setIoDate(LocalDateTime.now());
            if (!UdcEnum.INV_AJ_STATUS_APPED.getValueCode().equals(invAjVO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u5ba1\u6279\u5b8c\u6210\u5355\u636e\u624d\u53ef\u786e\u8ba4");
            }
            List invAjDVOS = this.invAjDService.findByMasId(id);
            ArrayList invStkCommon28InVOS = new ArrayList();
            if (UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjVO.getDocType())) {
                invAjDVOS.forEach(invAjDVO -> {
                    InvStkCommon28InVO invStkCommon28InVO = this.setInvStkCommon28InVO(invAjVO, (InvAjDVO)invAjDVO);
                    invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_05);
                    invStkCommon28InVO.setQty(invAjDVO.getQty());
                    invStkCommon28InVO.setUom(invAjDVO.getUom());
                    invStkCommon28InVOS.add(invStkCommon28InVO);
                });
            } else if (UdcEnum.INV_AJ_TYPE_STK.getValueCode().equals(invAjVO.getDocType())) {
                invAjDVOS.forEach(invAjDVO -> {
                    InvStkCommon28InVO invStkCommon28InVO = this.setInvStkCommon28InVO(invAjVO, (InvAjDVO)invAjDVO);
                    invStkCommon28InVO.setInvStk28Enum1(invAjDVO.getQty() > 0.0 ? InvStk28Enum.I_TYPE_04 : InvStk28Enum.O_TYPE_05);
                    invStkCommon28InVO.setQty(invAjDVO.getQty());
                    invStkCommon28InVO.setUom(invAjDVO.getUom());
                    invStkCommon28InVOS.add(invStkCommon28InVO);
                });
            } else if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjVO.getDocType())) {
                this.createLot(invAjVO, invAjDVOS);
                invAjDVOS.forEach(invAjDVO -> {
                    InvStkCommon28InVO invStkCommon28InVO = this.setInvStkCommon28InVO(invAjVO, (InvAjDVO)invAjDVO);
                    invStkCommon28InVO.setQty(invAjDVO.getQty());
                    invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_05);
                    invStkCommon28InVO.setUom(invAjDVO.getUom());
                    invStkCommon28InVOS.add(invStkCommon28InVO);
                    InvStkCommon28InVO invStkCommon28InVO2 = this.setInvStkCommon28InVO(invAjVO, (InvAjDVO)invAjDVO);
                    invStkCommon28InVO2.setLotNo(invAjDVO.getToLotNo());
                    invStkCommon28InVO2.setQty(invAjDVO.getQty());
                    invStkCommon28InVO2.setUom(invAjDVO.getUom());
                    invStkCommon28InVO2.setInvStk28Enum1(InvStk28Enum.I_TYPE_04);
                    invStkCommon28InVOS.add(invStkCommon28InVO2);
                });
            } else if (UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjVO.getDocType())) {
                this.createLot(invAjVO, invAjDVOS);
                invAjDVOS.forEach(invAjDVO -> {
                    InvStkCommon28InVO invStkCommon28InVO2 = this.setInvStkCommon28InVO(invAjVO, (InvAjDVO)invAjDVO);
                    invStkCommon28InVO2.setLotNo(invAjDVO.getToLotNo());
                    invStkCommon28InVO2.setQty(invAjDVO.getQty());
                    invStkCommon28InVO2.setUom(invAjDVO.getUom());
                    invStkCommon28InVO2.setInvStk28Enum1(InvStk28Enum.I_TYPE_04);
                    invStkCommon28InVOS.add(invStkCommon28InVO2);
                });
            }
            List<InvStkCommon37InVO> invStkCommon37InVOS = this.convertCommon37InVO(invAjDVOS, invAjVO, InvStk28Enum.T_TYPE_26);
            if (!CollectionUtils.isEmpty(invStkCommon37InVOS)) {
                this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
            }
            this.invStkCommonService.invStkCommon28(invStkCommon28InVOS);
            InvAjDO invAjDO = new InvAjDO();
            invAjDO.setId(invAjVO.getId());
            invAjDO.setDocStatus(UdcEnum.INV_AJ_STATUS_CF.getValueCode());
            invAjDO.setIoDate(LocalDateTime.now());
            this.update(invAjDO);
        }
    }

    public List<InvAjVO> findByIntfFlagAndRelate2No(Integer i, String relate2No) {
        return this.invAjRepo.findByIntfFlagAndRelate2No(i, relate2No).stream().map(v -> (InvAjVO)BeanUtil.copyProperties((Object)v, InvAjVO.class)).collect(Collectors.toList());
    }

    public List<InvAjVO> findByDocNos(List<String> docNos) {
        QInvAjDO invAjDO = QInvAjDO.invAjDO;
        Iterable all = this.invAjRepo.findAll((Predicate)invAjDO.deleteFlag.eq((Object)0).or((Predicate)invAjDO.deleteFlag.isNull()).and((Predicate)invAjDO.docNo.in(docNos)));
        ArrayList invAjDOS = Lists.newArrayList((Iterable)all);
        List<Object> invAjVOS = new ArrayList<InvAjVO>();
        if (!CollectionUtils.isEmpty((Collection)invAjDOS)) {
            invAjVOS = invAjDOS.stream().map(e -> {
                InvAjVO invAjVO = new InvAjVO();
                BeanUtils.copyProperties((Object)e, (Object)invAjVO);
                return invAjVO;
            }).collect(Collectors.toList());
        }
        return invAjVOS;
    }

    private InvStkRespVO getInvBaseModel(InvAjVO invAjVO, InvAjDVO invAjDVO) {
        InvBaseModel invBaseModel = new InvBaseModel();
        invBaseModel.setWhId(invAjVO.getWhId());
        invBaseModel.setItemId(invAjDVO.getItemId());
        invBaseModel.setLotNo(invAjDVO.getLotNo());
        invBaseModel.setDeter1(invAjDVO.getDeter1());
        invBaseModel.setDeter2(invAjDVO.getDeter2());
        invBaseModel.setDeter3(invAjDVO.getDeter3());
        return this.invStkService.getInvStk(invBaseModel);
    }

    private InvStkCommon37InVO setInvStkCommon37InVO(InvAjVO invAjVO, InvAjDVO invAjDVO) {
        InvStkCommon37InVO invStkCommon37InVO = new InvStkCommon37InVO();
        invStkCommon37InVO.setDocNo(invAjVO.getDocNo());
        invStkCommon37InVO.setQty(invAjDVO.getQty());
        invStkCommon37InVO.setLineNo(invAjDVO.getLineNo());
        invStkCommon37InVO.setOpDate(invAjVO.getIoDate());
        invStkCommon37InVO.setCreateUserId(invAjVO.getCreateUserId());
        invStkCommon37InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
        invStkCommon37InVO.setSrcDocId(invAjVO.getId());
        invStkCommon37InVO.setSrcDocDid(invAjDVO.getId());
        invStkCommon37InVO.setInvStk28Enum2(null);
        invStkCommon37InVO.setDeter1(invAjDVO.getDeter1());
        invStkCommon37InVO.setDeter2(invAjDVO.getDeter2());
        invStkCommon37InVO.setDeter3(invAjDVO.getDeter3());
        invStkCommon37InVO.setItemId(invAjDVO.getItemId());
        invStkCommon37InVO.setVariId(invAjDVO.getVariId());
        invStkCommon37InVO.setLotNo(invAjDVO.getLotNo());
        invStkCommon37InVO.setWhId(invAjVO.getWhId());
        invStkCommon37InVO.setUom(invAjDVO.getUom());
        return invStkCommon37InVO;
    }

    private InvStkCommon28InVO setInvStkCommon28InVO(InvAjVO invAjVO, InvAjDVO invAjDVO) {
        InvStkCommon28InVO invStkCommon28InVO = new InvStkCommon28InVO();
        invStkCommon28InVO.setDocNo(invAjVO.getDocNo());
        invStkCommon28InVO.setLineNo(invAjDVO.getLineNo());
        invStkCommon28InVO.setOpDate(invAjVO.getApplyDate());
        invStkCommon28InVO.setCreateUserId(invAjVO.getApplyEmpId());
        invStkCommon28InVO.setInvStk28Enum2(null);
        invStkCommon28InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
        invStkCommon28InVO.setSrcDocId(invAjVO.getId());
        invStkCommon28InVO.setSrcDocDid(invAjDVO.getId());
        invStkCommon28InVO.setItemId(invAjDVO.getItemId());
        invStkCommon28InVO.setVariId(invAjDVO.getVariId());
        invStkCommon28InVO.setWhId(invAjVO.getWhId());
        invStkCommon28InVO.setDeter1(invAjDVO.getDeter1());
        invStkCommon28InVO.setDeter2(invAjDVO.getDeter2());
        invStkCommon28InVO.setDeter3(invAjDVO.getDeter3());
        invStkCommon28InVO.setLotNo(invAjDVO.getLotNo());
        return invStkCommon28InVO;
    }

    private String createLot(InvAjVO invAjVO, List<InvAjDVO> invAjDVOS) {
        ServiceResult invLotInfo;
        ArrayList invLots = new ArrayList();
        List invLotCommon21InVOS = invAjDVOS.stream().map(grd -> {
            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO();
            invLotCommon21InVO.setItemId(grd.getItemId());
            invLotCommon21InVO.setVariId(grd.getVariId());
            invLotCommon21InVO.setLotNo(grd.getToLotNo());
            return invLotCommon21InVO;
        }).collect(Collectors.toList());
        Map invLotVOMap = this.invLotCommonService.getInvLotVOList(invLotCommon21InVOS);
        List invLotCommon21InVOS2 = invAjDVOS.stream().map(grd -> {
            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO();
            invLotCommon21InVO.setItemId(grd.getItemId());
            invLotCommon21InVO.setVariId(grd.getVariId());
            invLotCommon21InVO.setLotNo(grd.getLotNo());
            return invLotCommon21InVO;
        }).collect(Collectors.toList());
        Map invLotVOMap2 = this.invLotCommonService.getInvLotVOList(invLotCommon21InVOS2);
        invAjDVOS.forEach(grd -> {
            if (invLotVOMap.get(invAjDVOS.indexOf(grd)) != null && ((List)invLotVOMap.get(invAjDVOS.indexOf(grd))).size() != 0) {
                return;
            }
            InvLotSaveVO invLotSaveVO = new InvLotSaveVO();
            invLotSaveVO.setOuId(invAjVO.getOuId());
            invLotSaveVO.setItemId(grd.getItemId());
            invLotSaveVO.setManuDate(grd.getManuDate());
            invLotSaveVO.setExpireDate(grd.getExpireDate());
            List invLotVOS = (List)invLotVOMap2.get(invAjDVOS.indexOf(grd));
            if (invLotVOS.size() == 1) {
                InvLotRespVO invLotRespVO = (InvLotRespVO)invLotVOS.get(0);
                invLotSaveVO.setExpireDays(invLotRespVO.getExpireDays());
                invLotSaveVO.setUntilExpireDays(invLotRespVO.getUntilExpireDays());
            } else if (invLotVOS.size() == 0 && invAjVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKO.getValueCode())) {
                invLotSaveVO.setExpireDays(Integer.valueOf((int)(grd.getExpireDate().toLocalDate().toEpochDay() - grd.getManuDate().toLocalDate().toEpochDay())));
                invLotSaveVO.setUntilExpireDays(Integer.valueOf((int)(grd.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay())));
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u6279\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            invLotSaveVO.setLotNo(grd.getToLotNo());
            invLotSaveVO.setMenuLotNo(grd.getMenuLotNo());
            invLotSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
            invLotSaveVO.setSrcDocId(invAjVO.getId());
            invLotSaveVO.setSrcDocNo(invAjVO.getDocNo());
            invLotSaveVO.setSrcDocDid(grd.getId());
            invLotSaveVO.setVariId(grd.getVariId());
            invLots.add(invLotSaveVO);
        });
        if (!CollectionUtils.isEmpty(invLots) && (invLotInfo = this.invLotCommonService.createInvLotInfo(invLots)).getCode() == 1) {
            return invLotInfo.getMsg();
        }
        return null;
    }

    private void fillUpNameList(List<InvAjRespVO> vos) {
        List whIds = vos.stream().map(InvAjRespVO::getWhId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map docTypeMap = this.sysUdcService.getCodeMap(UdcEnum.INV_AJ_TYPE_LOT.getModel(), UdcEnum.INV_AJ_TYPE_LOT.getCode());
        Map docStatusMap = this.sysUdcService.getCodeMap(UdcEnum.INV_AJ_STATUS_DR.getModel(), UdcEnum.INV_AJ_STATUS_DR.getCode());
        Map reasonMap = this.sysUdcService.getCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map deter2Map = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_ADJUST.getModel(), UdcEnum.INV_FUNC_TYPE_ADJUST.getCode());
        Map apprStatusMap = this.sysUdcService.getCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        List orgSuppVOS = this.invWhService.findIdBatch(whIds);
        vos.forEach(vo -> {
            Optional<InvWhRespVO> orgWhVO = orgSuppVOS.stream().filter(v -> v.getId().equals(vo.getWhId())).findFirst();
            if (orgWhVO.isPresent()) {
                InvWhRespVO whVO = orgWhVO.get();
                vo.setWhCode(whVO.getWhCode());
                vo.setWhName(whVO.getWhName());
                vo.setWhType(whVO.getWhType());
            }
            if (!CollectionUtils.isEmpty((Map)docTypeMap) && docTypeMap.containsKey(vo.getDocType())) {
                vo.setDocTypeName((String)docTypeMap.get(vo.getDocType()));
            }
            if (!CollectionUtils.isEmpty((Map)docStatusMap) && docStatusMap.containsKey(vo.getDocStatus())) {
                vo.setDocStatusName((String)docStatusMap.get(vo.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)reasonMap) && reasonMap.containsKey(vo.getReasonCode())) {
                vo.setReasonCodeName((String)reasonMap.get(vo.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty((Map)deter2Map) && deter2Map.containsKey(vo.getDeter2())) {
                vo.setDeter2Name((String)deter2Map.get(vo.getDeter2()));
            }
            if (!CollectionUtils.isEmpty((Map)apprStatusMap) && apprStatusMap.containsKey(vo.getApprStatus())) {
                vo.setApprStatusName((String)apprStatusMap.get(vo.getApprStatus()));
            }
        });
    }

    private String getInvAjDocNo(InvAjSaveVO invAjSaveVO) {
        String docNo = null;
        if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.sysNumberRuleService.generateCode(NumSendObjectEnum.INV_IE.getCode(), List.of(String.valueOf(invAjSaveVO.getOuId())));
        } else if (UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.sysNumberRuleService.generateCode(NumSendObjectEnum.INV_ID.getCode(), List.of(String.valueOf(invAjSaveVO.getOuId())));
        } else if (UdcEnum.INV_AJ_TYPE_STK.getValueCode().equals(invAjSaveVO.getDocType()) || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.sysNumberRuleService.generateCode(NumSendObjectEnum.INV_IA.getCode(), List.of(String.valueOf(invAjSaveVO.getOuId())));
        }
        return docNo;
    }

    private List<InvStkCommon37InVO> convertCommon37InVO(List<InvAjDVO> invAjDVOS, InvAjVO invAjVO, InvStk28Enum invStk28Enum) {
        ArrayList<InvStkCommon37InVO> invStkCommon37InVOS = new ArrayList<InvStkCommon37InVO>();
        invAjDVOS.forEach(invAjDVO -> {
            InvStkCommon37InVO invStkCommon37InVO = this.setInvStkCommon37InVO(invAjVO, (InvAjDVO)invAjDVO);
            invStkCommon37InVO.setInvStk28Enum1(invStk28Enum);
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjVO.getDocType()) || UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjVO.getDocType())) {
                invStkCommon37InVOS.add(invStkCommon37InVO);
            }
            if (UdcEnum.INV_AJ_TYPE_STK.getValueCode().equals(invAjVO.getDocType()) && invAjDVO.getQty() < 0.0) {
                invStkCommon37InVOS.add(invStkCommon37InVO);
            }
        });
        return invStkCommon37InVOS;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty((Object)udcVal) || StringUtils.isEmpty((Object)domain) || StringUtils.isEmpty((Object)udcCode)) {
            return null;
        }
        Map codeMap = this.sysUdcService.getCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty((Map)codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return (String)codeMap.get(udcVal);
        }
        return null;
    }

    public InvAjServiceImpl(InvAjRepo invAjRepo, InvAjDRepo invAjDRepo, InvAjRepoProc invAjRepoProc, InvAjDService invAjDService, InvWhService invWhService, SysUserService sysUserService, InvLotService invLotService, InvRoService invRoService, InvRoDService invRODService, SysNumberRuleService sysNumberRuleService, InvWhAreaService invWhAreaService, InvCorssentryPricepolicyService invCorssentryPricepolicyService, InvStkCommonService invStkCommonService, InvStkService invStkService, InvLotCommonService invLotCommonService, SysUdcService sysUdcService, OutService outService) {
        this.invAjRepo = invAjRepo;
        this.invAjDRepo = invAjDRepo;
        this.invAjRepoProc = invAjRepoProc;
        this.invAjDService = invAjDService;
        this.invWhService = invWhService;
        this.sysUserService = sysUserService;
        this.invLotService = invLotService;
        this.invRoService = invRoService;
        this.invRODService = invRODService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.invWhAreaService = invWhAreaService;
        this.invCorssentryPricepolicyService = invCorssentryPricepolicyService;
        this.invStkCommonService = invStkCommonService;
        this.invStkService = invStkService;
        this.invLotCommonService = invLotCommonService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

