/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvSinConvert;
import com.elitesland.inv.convert.InvSinDConvert;
import com.elitesland.inv.entity.InvAsmDDO;
import com.elitesland.inv.entity.InvAsmDO;
import com.elitesland.inv.entity.InvLotDO;
import com.elitesland.inv.entity.InvSinDDO;
import com.elitesland.inv.param.InvSinCreateParam;
import com.elitesland.inv.param.InvSinDCreateParam;
import com.elitesland.inv.repo.InvAsmDRepo;
import com.elitesland.inv.repo.InvAsmDRepoProc;
import com.elitesland.inv.repo.InvAsmRepo;
import com.elitesland.inv.repo.InvSinDRepo;
import com.elitesland.inv.repo.InvSinRepo;
import com.elitesland.inv.service.InvAsmDService;
import com.elitesland.inv.service.InvAsmService;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvSinService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvAsmDVO;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvSinVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.InvStkVO;
import com.elitesland.inv.vo.param.InvAsmAllQueryParam;
import com.elitesland.inv.vo.resp.InvAsmAndAsmDDownloadRespVO;
import com.elitesland.inv.vo.resp.InvAsmAndAsmDRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.entity.OrgEmpDO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvAsmDServiceImpl
implements InvAsmDService {
    private final InvAsmRepo invAsmRepo;
    private final InvAsmDRepo invAsmDRepo;
    private final InvAsmDRepoProc invAsmDRepoProc;
    private final InvStkCommonService invStkCommonService;
    private final InvAsmService invAsmService;
    private final InvSinService invSinService;
    private final InvSinDRepo invSinDRepo;
    private final InvSinRepo invSinRepo;
    private final InvLotCommonService invLotCommonService;
    private final InvLotService invLotService;
    private final InvWhService invWhService;
    private final SysUdcService sysUdcService;
    private final OutService outService;

    @SysCodeProc
    public PagingVO<InvAsmAndAsmDRespVO> search(InvAsmAllQueryParam param) {
        JPAQuery<InvAsmAndAsmDRespVO> invAsms = this.invAsmDRepoProc.selectH(param);
        param.fillOrders(invAsms);
        param.setPaging(invAsms);
        List asms = invAsms.fetch();
        if (!StringUtils.isEmpty((Object)param.getReasonCode())) {
            asms = asms.stream().filter(v -> v.getReasonCode().equals(param.getReasonCode())).collect(Collectors.toList());
        }
        this.fillupNameList(asms);
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = this.udcChange(asms);
        return PagingVO.builder().total(Long.valueOf(invAsms.fetchCount())).records(invAsmAndAsmDRespVOS).build();
    }

    @SysCodeProc
    public PagingVO<InvAsmAndAsmDRespVO> searchD(InvAsmAllQueryParam param) {
        JPAQuery<InvAsmAndAsmDRespVO> invAsmDs = this.invAsmDRepoProc.selectD(param);
        param.fillOrders(invAsmDs);
        param.setPaging(invAsmDs);
        List asmds = invAsmDs.fetch();
        this.fillupNameList(asmds);
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = this.udcChange(asmds);
        return PagingVO.builder().total(Long.valueOf(invAsmDs.fetchCount())).records(invAsmAndAsmDRespVOS).build();
    }

    @SysCodeProc
    public List<InvAsmAndAsmDRespVO> findAll(InvAsmAllQueryParam param) {
        List invAsms = this.invAsmDRepoProc.selectD(param).fetch();
        this.fillupNameList(invAsms);
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = this.udcChange(invAsms);
        return invAsmAndAsmDRespVOS;
    }

    public List<InvAsmAndAsmDRespVO> udcChange(List<InvAsmAndAsmDRespVO> asms) {
        Map udcDocType = this.sysUdcService.getCodeMap(UdcEnum.INV_TRN_TYPE_DEF.getModel(), UdcEnum.INV_TRN_TYPE_DEF.getCode());
        Map udcDocStatus = this.sysUdcService.getCodeMap(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode());
        Map udcApprStatus = this.sysUdcService.getCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        Map udcIO = this.sysUdcService.getCodeMap(UdcEnum.COM_IO_I.getModel(), UdcEnum.COM_IO_I.getCode());
        Map udcDeter1 = this.sysUdcService.getCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map udcDeter2 = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_GD.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
        Map udcReasonCode = this.sysUdcService.getCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map udcUom = this.sysUdcService.getCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        asms.stream().forEach(Asm -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDocType()) && !MapUtils.isEmpty((Map)udcDocType)) {
                Asm.setDocTypeName((String)udcDocType.get(Asm.getDocType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDocStatus()) && !MapUtils.isEmpty((Map)udcDocStatus)) {
                Asm.setDocStatusName((String)udcDocStatus.get(Asm.getDocStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getApprStatus()) && !MapUtils.isEmpty((Map)udcApprStatus)) {
                Asm.setApprStatusName((String)udcApprStatus.get(Asm.getApprStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                Asm.setDeter1Name((String)udcDeter1.get(Asm.getDeter1()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDeter2()) && !MapUtils.isEmpty((Map)udcDeter2)) {
                Asm.setDeter2Name((String)udcDeter2.get(Asm.getDeter2()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getReasonCode()) && !MapUtils.isEmpty((Map)udcReasonCode)) {
                Asm.setReasonCodeName((String)udcReasonCode.get(Asm.getReasonCode()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                Asm.setUomName((String)udcUom.get(Asm.getUom()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getLineType()) && !MapUtils.isEmpty((Map)udcIO)) {
                Asm.setLineTypeName((String)udcIO.get(Asm.getLineType()));
            }
        });
        return asms;
    }

    public List<Long> createInBatch(List<InvAsmDVO> list) {
        InvAsmDDO invAsmDDO = new InvAsmDDO();
        ArrayList InvAsmDDOD = new ArrayList();
        list.stream().forEach(InvAsmDDOS -> {
            BeanUtils.copyProperties((Object)InvAsmDDOS, (Object)invAsmDDO);
            InvAsmDDOD.add(invAsmDDO);
        });
        return this.invAsmDRepo.saveAll(InvAsmDDOD).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public int removeInBatch(List<Long> ids) {
        ids.forEach(id -> this.invAsmDRepo.deleteById(id));
        return ids.size();
    }

    public void useInvStkCommon37InVOS(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO) {
        ArrayList invStkCommon37InVOS = new ArrayList();
        invAsmDDOS.stream().forEach(v -> {
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO((InvAsmDDO)v);
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_27);
                tmp.setDeter1(invAsmDO.getDeter1());
                tmp.setDeter2(invAsmDO.getDeter2());
                tmp.setDeter3(invAsmDO.getDeter3());
                tmp.setWhId(invAsmDO.getWhId());
                tmp.setDocNo(invAsmDO.getDocNo());
                tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                tmp.setSrcDocId(v.getMasId());
                tmp.setSrcDocDid(v.getId());
                tmp.setOpDate(LocalDateTime.now());
                invStkCommon37InVOS.add(tmp);
            }
        });
        if (!CollectionUtils.isEmpty(invStkCommon37InVOS)) {
            this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
        }
    }

    public void useCreateInvLotInfo(List<InvAsmDDO> invAsmDDOS) {
        if (this.invLotService.findByAndItemIdAndLotNo(invAsmDDOS.stream().filter(v -> v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())).map(v -> v.getItemId() + "_" + v.getLotNo()).collect(Collectors.toList())).isEmpty()) {
            ArrayList invLotDOS = new ArrayList();
            invAsmDDOS.stream().filter(v -> v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())).findAny().ifPresent(m -> {
                InvLotDO tmp = InvCommonConvert.INSTANCE.invAsmDDOTOInvLotDO((InvAsmDDO)m);
                InvAsmDDO tmpAsm = invAsmDDOS.stream().filter(j -> j.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())).min(Comparator.comparing(InvAsmDDO::getExpireDate)).orElse(new InvAsmDDO());
                tmp.setExpireDays((int)ChronoUnit.DAYS.between(tmpAsm.getManuDate().toLocalDate(), tmpAsm.getExpireDate().toLocalDate()));
                Optional invAsmDOOptional1 = this.invAsmRepo.findById(tmpAsm.getMasId());
                if (invAsmDOOptional1.isPresent()) {
                    tmp.setSrcDocNo(((InvAsmDO)invAsmDOOptional1.get()).getDocNo());
                    tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                    tmp.setOuId(((InvAsmDO)invAsmDOOptional1.get()).getOuId());
                    tmp.setBuId(((InvAsmDO)invAsmDOOptional1.get()).getBuId());
                }
                invLotDOS.add(tmp);
            });
            InvLotSaveVO invLotVO = new InvLotSaveVO();
            ArrayList invLotDOS1 = new ArrayList();
            invLotDOS.stream().forEach(invLotVOS -> {
                BeanUtils.copyProperties((Object)invLotVOS, (Object)invLotVO);
                invLotDOS1.add(invLotVO);
            });
            this.invLotCommonService.createInvLotInfo(invLotDOS1);
        }
    }

    public void useInvStkCommon28(Long masId) {
        InvAsmAllQueryParam param = new InvAsmAllQueryParam();
        param.setMasId(masId);
        this.invStkCommonService.invStkCommon28(this.findAll(param).stream().map(v -> {
            InvStkCommon28InVO tmp = InvCommonConvert.INSTANCE.invAsmDVOAndInvAsmVOToInvStkCommon28InRespVO((InvAsmAndAsmDRespVO)v);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            if (v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())) {
                tmp.setInvStk28Enum1(InvStk28Enum.I_TYPE_18);
            } else if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                tmp.setInvStk28Enum1(InvStk28Enum.O_TYPE_19);
            }
            tmp.setOpDate(LocalDateTime.now());
            return tmp;
        }).collect(Collectors.toList()));
    }

    @Transactional
    public void confirm(Long masId) {
        InvAsmDO invAsmDO = (InvAsmDO)this.invAsmRepo.findById(masId).orElseThrow(new BusinessException("\u6570\u636e\u9519\u8bef"));
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(masId);
        this.useInvStkCommon37InVOS(invAsmDDOS, invAsmDO);
        this.useCreateInvLotInfo(invAsmDDOS);
        this.useInvStkCommon28(masId);
        List invSinDDOS = this.invSinDRepo.findAllByItemIdIsInAndLotNoIsIn(invAsmDDOS.stream().map(InvAsmDDO::getItemId).collect(Collectors.toList()), invAsmDDOS.stream().map(InvAsmDDO::getLotNo).collect(Collectors.toList())).orElse(new ArrayList());
        List invSinVOS = this.invSinRepo.findAllById(invSinDDOS.stream().map(InvSinDDO::getMasId).collect(Collectors.toList()));
        InvSinVO invSinVO1 = new InvSinVO();
        ArrayList invSinVOS1 = new ArrayList();
        invSinVOS.stream().forEach(invSinVo -> {
            BeanUtils.copyProperties((Object)invSinVo, (Object)invSinVO1);
            invSinVOS1.add(invSinVO1);
        });
        InvAsmDDO invAsmIDDO = invAsmDDOS.stream().filter(v -> v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())).findAny().orElseThrow(new BusinessException("\u6570\u636e\u9519\u8bef"));
        List itemIds = invAsmDDOS.stream().map(InvAsmDDO::getItemId).collect(Collectors.toList());
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(itemIds);
        List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
        for (InvSinVO invSinVO : invSinVOS1) {
            List backupList = invSinDDOS.stream().filter(v -> v.getMasId().equals(invSinVO.getId())).map(InvSinDConvert.INSTANCE::doToNew).collect(Collectors.toList());
            InvSinCreateParam invSinCreateParam = InvSinConvert.INSTANCE.voToNew(invSinVO);
            InvSinDCreateParam dParam = new InvSinDCreateParam();
            dParam.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            dParam.setSrcDocId(invAsmDO.getId());
            dParam.setSrcDocNo(invAsmDO.getDocNo());
            dParam.setSrcDocDid(invAsmIDDO.getId());
            dParam.setLotNo(invAsmIDDO.getLotNo());
            dParam.setMasId(invSinVO.getId());
            dParam.setItemId(invAsmIDDO.getItemId());
            itmItemPartDTOS.stream().filter(v -> v.getId().equals(invAsmIDDO.getItemId())).findFirst().ifPresent(m -> dParam.setItemCode(m.getItemCode()));
            dParam.setUom(invAsmIDDO.getUom());
            dParam.setSinQty(Double.valueOf(invAsmIDDO.getQty().doubleValue()));
            dParam.setSrcQty(Double.valueOf(invAsmIDDO.getQty().doubleValue()));
            backupList.add(dParam);
            invSinCreateParam.setInvSinDCreateParamList(backupList);
            this.invSinService.saveOneInvSin(invSinCreateParam);
        }
        this.invAsmService.updateStatusInBatch(List.of(masId), UdcEnum.INV_ASM_STATUS_CF.getValueCode());
    }

    public void check(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        if (!invAsmDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvAsmDO)invAsmDOOptional.get()).setDocStatus(UdcEnum.INV_ASM_STATUS_APPED.getValueCode());
        this.invAsmRepo.save((InvAsmDO)invAsmDOOptional.get());
    }

    public void refuse(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        if (!invAsmDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvAsmDO)invAsmDOOptional.get()).setDocStatus(UdcEnum.INV_ASM_STATUS_RJ.getValueCode());
        this.invAsmRepo.save((InvAsmDO)invAsmDOOptional.get());
        this.releasLockQty(masId);
    }

    public List<InvAsmAndAsmDDownloadRespVO> outerNoAndOuterType(List<InvAsmAndAsmDRespVO> list) {
        List<InvAsmAndAsmDDownloadRespVO> collect = list.stream().map(i -> {
            InvAsmAndAsmDDownloadRespVO downloadVO = new InvAsmAndAsmDDownloadRespVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            String outerType = StringUtils.isEmpty((Object)downloadVO.getOuterType()) ? "" : downloadVO.getOuterType();
            String outerNo = StringUtils.isEmpty((Object)downloadVO.getOuterNo()) ? "" : downloadVO.getOuterNo();
            downloadVO.setOuterNo(outerType + outerNo);
            return downloadVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public void releasLockQty(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        ArrayList invStkCommon37InVOS = new ArrayList();
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(masId);
        invAsmDDOS.stream().forEach(v -> {
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO((InvAsmDDO)v);
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_27);
                if (invAsmDOOptional.isPresent()) {
                    tmp.setDeter1(((InvAsmDO)invAsmDOOptional.get()).getDeter1());
                    tmp.setDeter2(((InvAsmDO)invAsmDOOptional.get()).getDeter2());
                    tmp.setDeter3(((InvAsmDO)invAsmDOOptional.get()).getDeter3());
                    tmp.setWhId(((InvAsmDO)invAsmDOOptional.get()).getWhId());
                    tmp.setDocNo(((InvAsmDO)invAsmDOOptional.get()).getDocNo());
                    tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                    tmp.setSrcDocId(v.getMasId());
                    tmp.setSrcDocDid(v.getId());
                    tmp.setOpDate(LocalDateTime.now());
                }
                invStkCommon37InVOS.add(tmp);
            }
        });
        this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
    }

    public List<InvAsmAndAsmDRespVO> fillupNameList(List<InvAsmAndAsmDRespVO> items) {
        List itemIds = items.stream().map(InvAsmAndAsmDRespVO::getItemId).collect(Collectors.toList());
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(itemIds);
        List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
        items.forEach(a -> {
            Optional<OrgEmpDO> byUserId;
            Optional orgWh;
            OrgOuVO orgOu;
            if (!StringUtils.isEmpty((Object)a.getItemId()) && !CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(v -> v.getId().equals(a.getItemId())).findFirst().ifPresent(m -> {
                    a.setItemCode(m.getItemCode());
                    a.setItemName(m.getItemName());
                    a.setPackageSpec(m.getPackageSpec());
                    a.setBrand(m.getBrand());
                    a.setBrandName(m.getBrandName());
                });
            }
            if (!StringUtils.isEmpty((Object)(orgOu = this.outService.findOrgOuVOById(a.getOuId() == null ? 0L : a.getOuId())))) {
                a.setOuName(orgOu.getName());
            }
            if ((orgWh = this.invWhService.findById(a.getWhId() == null ? 0L : a.getWhId())).isPresent()) {
                a.setWhCode(((InvWhRespVO)orgWh.get()).getWhCode());
                a.setWhName(((InvWhRespVO)orgWh.get()).getWhName());
            }
            InvBaseModel invStkParam = new InvBaseModel();
            invStkParam.setItemId(a.getItemId());
            invStkParam.setWhId(a.getWhId());
            invStkParam.setVariId(a.getVariId());
            invStkParam.setLotNo(a.getLotNo());
            invStkParam.setDeter1(a.getDeter1());
            invStkParam.setDeter2(a.getDeter2());
            InvStkVO invStk = this.invStkCommonService.getInvStk(invStkParam);
            if (invStk != null) {
                a.setAvalQty(invStk.getAvalQty());
            }
            if (!StringUtils.isEmpty((Object)a.getApplyEmpId()) && (byUserId = this.outService.findByUserId(a.getApplyEmpId())).isPresent()) {
                a.setApplyEmpIdName(byUserId.get().getEmpName());
            }
        });
        return items;
    }

    public InvAsmDServiceImpl(InvAsmRepo invAsmRepo, InvAsmDRepo invAsmDRepo, InvAsmDRepoProc invAsmDRepoProc, InvStkCommonService invStkCommonService, InvAsmService invAsmService, InvSinService invSinService, InvSinDRepo invSinDRepo, InvSinRepo invSinRepo, InvLotCommonService invLotCommonService, InvLotService invLotService, InvWhService invWhService, SysUdcService sysUdcService, OutService outService) {
        this.invAsmRepo = invAsmRepo;
        this.invAsmDRepo = invAsmDRepo;
        this.invAsmDRepoProc = invAsmDRepoProc;
        this.invStkCommonService = invStkCommonService;
        this.invAsmService = invAsmService;
        this.invSinService = invSinService;
        this.invSinDRepo = invSinDRepo;
        this.invSinRepo = invSinRepo;
        this.invLotCommonService = invLotCommonService;
        this.invLotService = invLotService;
        this.invWhService = invWhService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

