/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.entity.InvAsmDDO;
import com.elitesland.inv.entity.InvAsmDO;
import com.elitesland.inv.param.PriGroupParam;
import com.elitesland.inv.repo.InvAsmDRepo;
import com.elitesland.inv.repo.InvAsmRepo;
import com.elitesland.inv.repo.InvAsmRepoProc;
import com.elitesland.inv.service.InvAsmService;
import com.elitesland.inv.service.InvCorssentryPricepolicyService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.resp.InvAsmAndAsmDSaveVO;
import com.elitesland.inv.vo.resp.InvAsmRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.out.entity.OrgEmpDO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.system.service.SysUdcService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class InvAsmServiceImpl
implements InvAsmService {
    private final InvAsmRepo invAsmRepo;
    private final InvAsmRepoProc invAsmRepoProc;
    private final InvAsmDRepo invAsmDRepo;
    private final InvWhService invWhService;
    private final InvStkCommonService invStkCommonService;
    private final SysUdcService sysUdcService;
    private final SysNumberRuleService sysNumberRuleService;
    private final InvCorssentryPricepolicyService invCorssentryPricepolicyService;
    private final OutService outService;
    private final String IY = "IY";

    public Optional<InvAsmRespVO> findIdOne(Long id) {
        Optional<InvAsmRespVO> invAsmVo = this.invAsmRepo.findById(id).map(invAsmDO -> (InvAsmRespVO)BeanUtil.copyProperties((Object)invAsmDO, InvAsmRespVO.class));
        if (invAsmVo.isPresent()) {
            Optional<OrgEmpDO> byUserId;
            Optional wh = this.invWhService.findIdOne(Long.valueOf(invAsmVo.get().getWhId() != null ? invAsmVo.get().getWhId() : 0L));
            if (wh.isPresent()) {
                invAsmVo.get().setWhName(((InvWhRespVO)wh.get()).getWhName());
            }
            if (invAsmVo.get().getApplyEmpId() != null && (byUserId = this.outService.findByUserId(invAsmVo.get().getApplyEmpId())).isPresent()) {
                invAsmVo.get().setApplyEmpName(byUserId.get().getEmpName());
            }
            invAsmVo = this.udcChange(invAsmVo);
            return invAsmVo;
        }
        return invAsmVo;
    }

    public Optional<InvAsmRespVO> udcChange(Optional<InvAsmRespVO> invAsmVo) {
        Map udcDocType = this.sysUdcService.getCodeMap(UdcEnum.INV_ASM_TYPE_DEF.getModel(), UdcEnum.INV_ASM_TYPE_DEF.getCode());
        Map udcDocStatus = this.sysUdcService.getCodeMap(UdcEnum.INV_ASM_STATUS_DR.getModel(), UdcEnum.INV_ASM_STATUS_DR.getCode());
        Map udcApprStatus = this.sysUdcService.getCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        Map udcDeter1 = this.sysUdcService.getCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map udcDeter2 = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_GD.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
        Map udcReasonCode = this.sysUdcService.getCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map udcRelateDocCls = this.sysUdcService.getCodeMap(UdcEnum.COM_DOC_CLS_SPA.getModel(), UdcEnum.COM_DOC_CLS_SPA.getCode());
        invAsmVo.stream().forEach(Asm -> {
            if (StringUtils.isNotBlank((CharSequence)Asm.getDocType()) && !MapUtils.isEmpty((Map)udcDocType)) {
                Asm.setDocTypeName((String)udcDocType.get(Asm.getDocType()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDocStatus()) && !MapUtils.isEmpty((Map)udcDocStatus)) {
                Asm.setDocStatusName((String)udcDocStatus.get(Asm.getDocStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getApprStatus()) && !MapUtils.isEmpty((Map)udcApprStatus)) {
                Asm.setApprStatusName((String)udcApprStatus.get(Asm.getApprStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                Asm.setDeter1Name((String)udcDeter1.get(Asm.getDeter1()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDeter2()) && !MapUtils.isEmpty((Map)udcDeter2)) {
                Asm.setDeter2Name((String)udcDeter2.get(Asm.getDeter2()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getReasonCode()) && !MapUtils.isEmpty((Map)udcReasonCode)) {
                Asm.setReasonCodeName((String)udcReasonCode.get(Asm.getReasonCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getRelateDocCls()) && !MapUtils.isEmpty((Map)udcRelateDocCls)) {
                Asm.setRelateDocClsName((String)udcRelateDocCls.get(Asm.getRelateDocCls()));
            }
        });
        return invAsmVo;
    }

    public Long create(InvAsmAndAsmDSaveVO inv) {
        inv.getHeader().setDeter1(inv.getHeader().getDeter1() != null ? inv.getHeader().getDeter1() : UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        ArrayList<String> runtimeValues = new ArrayList<String>();
        runtimeValues.add(String.valueOf(inv.getHeader().getOuId()));
        String code = this.sysNumberRuleService.generateCode("IY", runtimeValues);
        InvAsmDO DO = new InvAsmDO();
        inv.getHeader().setDocNo(inv.getHeader().getDocNo() != null ? inv.getHeader().getDocNo() : code);
        inv.getHeader().setDocStatus(UdcEnum.INV_ASM_STATUS_DR.getValueCode());
        inv.getHeader().setDocType(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
        BeanUtils.copyProperties((Object)inv.getHeader(), (Object)DO);
        Long id = ((InvAsmDO)this.invAsmRepo.save(DO)).getId();
        if (inv.getDetails().size() > 0) {
            List detailDOs = inv.getDetails().stream().map(d -> {
                InvAsmDDO DDO = new InvAsmDDO();
                BeanUtils.copyProperties((Object)d, (Object)DDO);
                DDO.setMasId(id);
                PriGroupParam param = new PriGroupParam();
                param.setItemId(d.getItemId());
                param.setFromOuId(DO.getOuId());
                param.setToOuId(DO.getOuId());
                param.setDocTime(DO.getIoDate());
                PriSalePriceVO priSalePriceVO = this.invCorssentryPricepolicyService.costPrice(param);
                if (priSalePriceVO != null) {
                    DDO.setCostPrice(priSalePriceVO.getCostPrice());
                }
                DDO.setCostAmt(DDO.getCostPrice() == null || DDO.getQty() == null ? null : DDO.getCostPrice().multiply(new BigDecimal(DDO.getQty().floatValue())));
                return DDO;
            }).collect(Collectors.toList());
            this.invAsmDRepo.saveAll(detailDOs);
            return id;
        }
        return id;
    }

    public List<Long> updateInBatch(List<InvAsmDO> list) {
        return this.invAsmRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        Iterable asms = this.invAsmRepo.findAll(this.invAsmRepoProc.where(ids));
        ArrayList listAsms = Lists.newArrayList((Iterable)asms);
        if (listAsms.size() > 0) {
            listAsms.stream().forEach(a -> a.setDocStatus(status));
            List<Long> ret = this.updateInBatch(listAsms);
            return ret;
        }
        return ids;
    }

    public Long submit(Long id) {
        InvAsmDO invAsmDO = (InvAsmDO)this.invAsmRepo.findById(id).orElseThrow(new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728"));
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(id);
        ArrayList invStkCommon37InVOS = new ArrayList();
        invAsmDDOS.stream().forEach(v -> {
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO((InvAsmDDO)v);
                tmp.setDeter1(invAsmDO.getDeter1());
                tmp.setDeter2(invAsmDO.getDeter2());
                tmp.setDeter3(invAsmDO.getDeter3());
                tmp.setDocNo(invAsmDO.getDocNo());
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_23);
                tmp.setWhId(invAsmDO.getWhId());
                tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                tmp.setSrcDocId(v.getMasId());
                tmp.setSrcDocDid(v.getId());
                tmp.setOpDate(LocalDateTime.now());
                invStkCommon37InVOS.add(tmp);
            }
        });
        if (!CollectionUtils.isEmpty(invStkCommon37InVOS)) {
            this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
        }
        invAsmDO.setDocStatus(UdcEnum.INV_ASM_STATUS_APPING.getValueCode());
        invAsmDO.setIoDate(LocalDateTime.now());
        invAsmDO.setApprTime(LocalDateTime.now());
        this.invAsmRepo.save(invAsmDO);
        return id;
    }

    public InvAsmServiceImpl(InvAsmRepo invAsmRepo, InvAsmRepoProc invAsmRepoProc, InvAsmDRepo invAsmDRepo, InvWhService invWhService, InvStkCommonService invStkCommonService, SysUdcService sysUdcService, SysNumberRuleService sysNumberRuleService, InvCorssentryPricepolicyService invCorssentryPricepolicyService, OutService outService) {
        this.invAsmRepo = invAsmRepo;
        this.invAsmRepoProc = invAsmRepoProc;
        this.invAsmDRepo = invAsmDRepo;
        this.invWhService = invWhService;
        this.invStkCommonService = invStkCommonService;
        this.sysUdcService = sysUdcService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.invCorssentryPricepolicyService = invCorssentryPricepolicyService;
        this.outService = outService;
    }
}

