/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.excel.listener.DchExcelEntityDataListener;
import com.elitesland.inv.entity.InvCkDDO;
import com.elitesland.inv.repo.InvCkDRepo;
import com.elitesland.inv.repo.InvCkDRepoProc;
import com.elitesland.inv.service.InvCkDService;
import com.elitesland.inv.vo.InvCkDDownloadVO;
import com.elitesland.inv.vo.save.InvCkDSaveVO;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InvCkDServiceImpl
implements InvCkDService {
    private final InvCkDRepo invCkDRepo;
    private final InvCkDRepoProc invCkDRepoProc;

    public Long saveInvCkD(InvCkDSaveVO invCkDSaveVO) {
        InvCkDDO invCkDDO = new InvCkDDO();
        BeanUtils.copyProperties((Object)invCkDSaveVO, (Object)invCkDDO);
        return ((InvCkDDO)this.invCkDRepo.save(invCkDDO)).getId();
    }

    public void saveInvCkDList(List<InvCkDSaveVO> invCkDSaveVOList) {
        if (CollectionUtils.isEmpty(invCkDSaveVOList)) {
            throw new BusinessException(ApiCode.FAIL, "\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List invCkDDOS = invCkDSaveVOList.stream().map(e -> {
            InvCkDDO invCkDDO = new InvCkDDO();
            BeanUtils.copyProperties((Object)e, (Object)invCkDDO);
            return invCkDDO;
        }).collect(Collectors.toList());
        this.invCkDRepo.saveAll(invCkDDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importInvCkDList(MultipartFile file) {
        DchExcelEntityDataListener dataListener = new DchExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), InvCkDDownloadVO.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
        }
        catch (Exception e2) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List<InvCkDDownloadVO> invCkDDownloadVOS = dataListener.getDatas();
        if (CollectionUtils.isEmpty(invCkDDownloadVOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "excel\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        invCkDDownloadVOS.forEach(e -> {
            Long id = Long.valueOf(e.getId());
            Double factQty = e.getFactQty();
            if (factQty != null) {
                this.invCkDRepoProc.updateFactQtyById(id, factQty);
            }
        });
    }

    public InvCkDServiceImpl(InvCkDRepo invCkDRepo, InvCkDRepoProc invCkDRepoProc) {
        this.invCkDRepo = invCkDRepo;
        this.invCkDRepoProc = invCkDRepoProc;
    }
}

