/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.NumSendObjectEnum;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCkConvert;
import com.elitesland.inv.entity.InvCkDDO;
import com.elitesland.inv.entity.InvCkDO;
import com.elitesland.inv.repo.InvCkDRepo;
import com.elitesland.inv.repo.InvCkDRepoProc;
import com.elitesland.inv.repo.InvCkRepo;
import com.elitesland.inv.repo.InvCkRepoProc;
import com.elitesland.inv.service.InvCkService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvCkDDownloadVO;
import com.elitesland.inv.vo.InvCkDownloadVO;
import com.elitesland.inv.vo.param.InvCkCreateParamVO;
import com.elitesland.inv.vo.param.InvCkParamVO;
import com.elitesland.inv.vo.param.InvStkQueryParamVO;
import com.elitesland.inv.vo.resp.InvCkAndCkDRespVO;
import com.elitesland.inv.vo.resp.InvCkDRespVO;
import com.elitesland.inv.vo.resp.InvCkRespVO;
import com.elitesland.inv.vo.resp.InvStkRespVO;
import com.elitesland.inv.vo.save.InvCkAndCkDSaveVO;
import com.elitesland.inv.vo.save.InvCkSaveVO;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCkServiceImpl
implements InvCkService {
    private final InvCkRepo invCkRepo;
    private final InvCkRepoProc invCkRepoProc;
    private final InvCkDRepo invCkDRepo;
    private final InvCkDRepoProc invCkDRepoProc;
    private final InvStkService invStkService;
    private final SysNumberRuleService sysNumberRuleService;
    private final SysUdcService sysUdcService;
    private final InvWhService invWhService;
    private final OutService outService;

    public Long saveInvCk(InvCkSaveVO invCkSaveVO) {
        InvCkDO invCkDO = new InvCkDO();
        BeanUtils.copyProperties((Object)invCkSaveVO, (Object)invCkDO);
        return ((InvCkDO)this.invCkRepo.save(invCkDO)).getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveOrSubmitInvCkAndCkD(InvCkAndCkDSaveVO invCkAndCkDSaveVO, boolean isSubmit) {
        if (invCkAndCkDSaveVO.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Optional invCkDOOptional = this.invCkRepo.findById(invCkAndCkDSaveVO.getId());
        if (!invCkDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u4e0d\u5b58\u5728\uff01");
        }
        InvCkDO invCkDO = (InvCkDO)invCkDOOptional.get();
        if (!UdcEnum.INV_CK_STATUS_DR.getValueCode().equals(invCkDO.getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u624d\u80fd\u4fdd\u5b58/\u63d0\u4ea4\uff01");
        }
        invCkDO.setRemark(invCkAndCkDSaveVO.getRemark());
        invCkDO.setOuId(invCkAndCkDSaveVO.getOuId());
        invCkDO.setDocType(invCkAndCkDSaveVO.getDocType());
        if (isSubmit) {
            invCkDO.setDocStatus(UdcEnum.INV_CK_STATUS_APPING.getValueCode());
        }
        Long id = ((InvCkDO)this.invCkRepo.save(invCkDO)).getId();
        List invCkDs = invCkAndCkDSaveVO.getInvCkDs();
        List<InvCkDRespVO> invCkDRespVOS = this.invCkDRepoProc.selectByMasId(id);
        if (!CollectionUtils.isEmpty(invCkDRespVOS)) {
            this.invCkDRepo.deleteByMasId(id);
        }
        if (!CollectionUtils.isEmpty((Collection)invCkDs)) {
            List invCkDDOS = invCkDs.stream().map(e -> {
                InvCkDDO invCkDDO = new InvCkDDO();
                BeanUtils.copyProperties((Object)e, (Object)invCkDDO);
                invCkDDO.setMasId(id);
                return invCkDDO;
            }).collect(Collectors.toList());
            this.invCkDRepo.saveAll(invCkDDOS);
        }
        return id;
    }

    public PagingVO<InvCkRespVO> list(InvCkParamVO invCkParamVO) {
        Page invCkDOPage = this.invCkRepo.findAll(this.invCkRepoProc.where(invCkParamVO), (Pageable)invCkParamVO.getPageRequest());
        List invCkDOS = invCkDOPage.getContent();
        List whIdList = invCkDOS.stream().filter(f -> f.getWhId() != null).map(InvCkDO::getWhId).distinct().collect(Collectors.toList());
        List<Long> ouIdList = invCkDOS.stream().filter(f -> f.getOuId() != null).map(InvCkDO::getOuId).distinct().collect(Collectors.toList());
        List invWhRespVOList = new ArrayList();
        List<OrgOuVO> orgOuVOS = this.outService.listOrgOuVOByIds(ouIdList);
        if (!CollectionUtils.isEmpty(whIdList)) {
            invWhRespVOList = this.invWhService.findIdBatch(whIdList);
        }
        ArrayList finalInvWhRespVOList = invWhRespVOList;
        Map deter2Map = this.sysUdcService.getCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
        Map docStatusMap = this.sysUdcService.getCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_STATUS_DR.getCode());
        Map docTypeMap = this.sysUdcService.getCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_TYPE_DAY.getCode());
        Map docMethodMap = this.sysUdcService.getCodeMap(UdcEnum.INV_CK_METHOD_BLD.getModel(), UdcEnum.INV_CK_METHOD_BLD.getCode());
        List invCkRespVOS = invCkDOS.stream().map(e -> {
            InvCkRespVO invCkRespVO = InvCkConvert.INSTANCE.doToInvCkRespVO((InvCkDO)e);
            if (!CollectionUtils.isEmpty((Map)docStatusMap) && docStatusMap.containsKey(e.getDocStatus())) {
                invCkRespVO.setDocStatusName((String)docStatusMap.get(e.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)docTypeMap) && docTypeMap.containsKey(e.getDocType())) {
                invCkRespVO.setDocTypeName((String)docTypeMap.get(e.getDocType()));
            }
            if (!CollectionUtils.isEmpty((Map)docMethodMap) && docMethodMap.containsKey(e.getDocMethod())) {
                invCkRespVO.setDocMethodName((String)docMethodMap.get(e.getDocMethod()));
            }
            if (!CollectionUtils.isEmpty((Collection)finalInvWhRespVOList)) {
                finalInvWhRespVOList.stream().filter(f -> f.getId().equals(e.getWhId())).findFirst().ifPresent(w -> {
                    invCkRespVO.setWhCode(w.getWhCode());
                    invCkRespVO.setWhName(w.getWhName());
                });
            }
            if (!CollectionUtils.isEmpty((Map)deter2Map) && deter2Map.containsKey(e.getDeter2())) {
                invCkRespVO.setDeter2Name((String)deter2Map.get(e.getDeter2()));
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS)) {
                orgOuVOS.stream().filter(f -> f.getId().equals(invCkRespVO.getOuId())).findFirst().ifPresent(o -> {
                    invCkRespVO.setOuName(o.getName());
                    invCkRespVO.setOuCode(o.getCode());
                });
            }
            return invCkRespVO;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(invCkDOPage.getTotalElements())).records(invCkRespVOS).build();
    }

    @Transactional(rollbackFor={Exception.class})
    public void approval(Long id) {
        Optional invCkDOOptional = this.invCkRepo.findById(id);
        if (!invCkDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba1\u6279\u5931\u8d25,\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        if (!UdcEnum.INV_CK_STATUS_APPING.getValueCode().equals(((InvCkDO)invCkDOOptional.get()).getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u72b6\u6001\u5f02\u5e38");
        }
        this.invCkRepoProc.updateDocStatus(id, UdcEnum.INV_CK_STATUS_APPED.getValueCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void reject(Long id) {
        Optional invCkDOOptional = this.invCkRepo.findById(id);
        if (!invCkDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba1\u6279\u5931\u8d25,\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        this.invCkRepoProc.updateDocStatus(id, UdcEnum.INV_CK_STATUS_RJ.getValueCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(InvCkCreateParamVO invCkCreateParamVO) {
        List whIdList = invCkCreateParamVO.getWhIdList();
        List deter2List = invCkCreateParamVO.getDeter2List();
        if (CollectionUtils.isEmpty((Collection)whIdList)) {
            throw new BusinessException(ApiCode.FAIL, "\u4ed3\u5e93id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)deter2List)) {
            throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Map<Long, Long> whIdMap = this.createInvCk(whIdList, invCkCreateParamVO);
        Map<Long, List<InvStkRespVO>> invCkMap = this.getInvCkMap(whIdMap, invCkCreateParamVO);
        if (CollectionUtils.isEmpty(invCkMap)) {
            throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u8be2\u5230\u5339\u914d\u5546\u54c1\uff01");
        }
        for (Map.Entry<Long, List<InvStkRespVO>> m : invCkMap.entrySet()) {
            List<InvStkRespVO> invStkRespVOS = m.getValue();
            for (InvStkRespVO invStkRespVO : invStkRespVOS) {
                InvCkDDO invCkDDO = new InvCkDDO();
                invCkDDO.setMasId(m.getKey());
                invCkDDO.setItemId(invStkRespVO.getItemId());
                invCkDDO.setLotNo(invStkRespVO.getLotNo());
                invCkDDO.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                invCkDDO.setDeter2(invStkRespVO.getDeter2());
                invCkDDO.setAccQty(invStkRespVO.getOhQty());
                invCkDDO.setUom(invStkRespVO.getUom());
                invCkDDO.setWhId(invStkRespVO.getWhId());
                this.invCkDRepo.save(invCkDDO);
            }
        }
    }

    public InvCkAndCkDRespVO findInvCkAndCkDInfo(Long id) {
        List<InvCkDRespVO> invCkDRespVOS;
        OrgOuVO orgOuVO;
        InvCkAndCkDRespVO invCkAndCkDRespVO = new InvCkAndCkDRespVO();
        Optional invckOptional = this.invCkRepo.findById(id);
        if (!invckOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u4e0d\u5b58\u5728");
        }
        InvCkDO invCkDO = (InvCkDO)invckOptional.get();
        BeanUtils.copyProperties((Object)invCkDO, (Object)invCkAndCkDRespVO);
        String docMethod = invCkDO.getDocMethod();
        invCkAndCkDRespVO.setDocStatusName(this.getUdcDesc(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_STATUS_DR.getCode(), invCkAndCkDRespVO.getDocStatus()));
        invCkAndCkDRespVO.setDocTypeName(this.getUdcDesc(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_TYPE_DAY.getCode(), invCkAndCkDRespVO.getDocType()));
        if (invCkDO.getOuId() != null && (orgOuVO = this.outService.findOrgOuVOById(invCkDO.getOuId())) != null) {
            invCkAndCkDRespVO.setOuName(orgOuVO.getName());
        }
        if (!CollectionUtils.isEmpty(invCkDRespVOS = this.invCkDRepoProc.selectByMasId(id))) {
            Map deter2Map = this.sysUdcService.getCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
            List itemIds = invCkDRespVOS.stream().filter(f -> f.getItemId() != null).map(InvCkDRespVO::getItemId).distinct().collect(Collectors.toList());
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            itmItemPartParam.setIds(itemIds);
            List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
            invCkDRespVOS.stream().map(e -> {
                if (!CollectionUtils.isEmpty((Map)deter2Map) && deter2Map.containsKey(e.getDeter2())) {
                    e.setDeter2Name((String)deter2Map.get(e.getDeter2()));
                }
                if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(item -> {
                        e.setItemCode(item.getItemCode());
                        e.setItemName(item.getItemName());
                        e.setBrand(item.getBrand());
                        e.setBrandName(item.getBrandName());
                    });
                }
                return e;
            }).collect(Collectors.toList());
            invCkAndCkDRespVO.setInvCkDs(invCkDRespVOS);
            List diffInvCkDs = invCkDRespVOS.stream().filter(f -> f.getFactQty() != null && f.getFactQty() - f.getAccQty() != 0.0).map(e -> {
                e.setDiffQty(Double.valueOf(e.getFactQty() - e.getAccQty()));
                return e;
            }).collect(Collectors.toList());
            invCkAndCkDRespVO.setDiffInvCkDs(diffInvCkDs);
        }
        return invCkAndCkDRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelInvCk(Long id) {
        Optional invCkDOOptional = this.invCkRepo.findById(id);
        if (!invCkDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u53d6\u6d88\u5931\u8d25\uff01\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        this.invCkRepoProc.updateDocStatus(id, UdcEnum.INV_CK_STATUS_CL.getValueCode());
    }

    public List<InvCkDownloadVO> findInvCkDownloadVOList(InvCkParamVO invCkParamVO) {
        List<Object> invCkDownloadVOS = new ArrayList<InvCkDownloadVO>();
        invCkParamVO.setSize(Integer.valueOf(20000));
        PagingVO<InvCkRespVO> invCkPage = this.list(invCkParamVO);
        List invCkRespVOS = invCkPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)invCkRespVOS)) {
            invCkDownloadVOS = invCkRespVOS.stream().map(e -> {
                InvCkDownloadVO invCkDownloadVO = new InvCkDownloadVO();
                BeanUtils.copyProperties((Object)e, (Object)invCkDownloadVO);
                invCkDownloadVO.setCreateDate(e.getCreateTime());
                return invCkDownloadVO;
            }).collect(Collectors.toList());
        }
        return invCkDownloadVOS;
    }

    public List<InvCkDDownloadVO> findInvCkDDownloadVOList(Long masId) {
        InvCkAndCkDRespVO invCkAndCkDInfo = this.findInvCkAndCkDInfo(masId);
        List invCkDs = invCkAndCkDInfo.getInvCkDs();
        List<Object> invCkDDownloadVOS = new ArrayList<InvCkDDownloadVO>();
        if (!CollectionUtils.isEmpty((Collection)invCkDs)) {
            invCkDDownloadVOS = invCkDs.stream().map(e -> {
                InvCkDDownloadVO invCkDDownloadVO = new InvCkDDownloadVO();
                BeanUtils.copyProperties((Object)e, (Object)invCkDDownloadVO);
                invCkDDownloadVO.setId(String.valueOf(e.getId()));
                return invCkDDownloadVO;
            }).collect(Collectors.toList());
        }
        return invCkDDownloadVOS;
    }

    private Map<Long, List<InvStkRespVO>> getInvCkMap(Map<Long, Long> whIdMap, InvCkCreateParamVO invCkCreateParamVO) {
        HashMap resultMap = Maps.newHashMap();
        List itemIdList = invCkCreateParamVO.getItemIdList();
        for (Map.Entry<Long, Long> m : whIdMap.entrySet()) {
            InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
            invStkQueryParamVO.setOuId(invCkCreateParamVO.getOuId());
            invStkQueryParamVO.setWhId(m.getKey());
            invStkQueryParamVO.setDeter2List(invCkCreateParamVO.getDeter2List());
            invStkQueryParamVO.setItemIdList(itemIdList);
            List invStkRespVOs = this.invStkService.findInvStkRespVOs(invStkQueryParamVO);
            if (CollectionUtils.isEmpty((Collection)invStkRespVOs)) continue;
            resultMap.put(m.getValue(), invStkRespVOs);
        }
        return resultMap;
    }

    private Map<Long, Long> createInvCk(List<Long> whIdList, InvCkCreateParamVO invCkCreateParamVO) {
        HashMap whIdMap = Maps.newHashMap();
        for (Long whId : whIdList) {
            InvCkDO invCkDO = new InvCkDO();
            invCkDO.setDocStatus(UdcEnum.INV_CK_STATUS_DR.getValueCode());
            invCkDO.setOuId(invCkCreateParamVO.getOuId());
            String docNo = this.sysNumberRuleService.generateCode(NumSendObjectEnum.INV_CK.getCode(), Arrays.asList(String.valueOf(invCkDO.getOuId())));
            invCkDO.setDocNo(docNo);
            invCkDO.setDocType(invCkCreateParamVO.getDocType());
            if (CollectionUtils.isEmpty((Collection)invCkCreateParamVO.getItemIdList())) {
                invCkDO.setDocMode(UdcEnum.INV_CK_MODE_ALL.getValueCode());
            } else {
                invCkDO.setDocMode(UdcEnum.INV_CK_MODE_ITEM.getValueCode());
            }
            invCkDO.setDocMethod(invCkCreateParamVO.getDocMethod());
            invCkDO.setRemark(invCkCreateParamVO.getRemark());
            invCkDO.setWhId(whId);
            invCkDO.setCreateUserId(invCkCreateParamVO.getCreateUserId());
            this.invCkRepo.save(invCkDO);
            whIdMap.put(whId, invCkDO.getId());
        }
        return whIdMap;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty((Object)udcVal) || StringUtils.isEmpty((Object)domain) || StringUtils.isEmpty((Object)udcCode)) {
            return null;
        }
        Map codeMap = this.sysUdcService.getCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty((Map)codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return (String)codeMap.get(udcVal);
        }
        return null;
    }

    public InvCkServiceImpl(InvCkRepo invCkRepo, InvCkRepoProc invCkRepoProc, InvCkDRepo invCkDRepo, InvCkDRepoProc invCkDRepoProc, InvStkService invStkService, SysNumberRuleService sysNumberRuleService, SysUdcService sysUdcService, InvWhService invWhService, OutService outService) {
        this.invCkRepo = invCkRepo;
        this.invCkRepoProc = invCkRepoProc;
        this.invCkDRepo = invCkDRepo;
        this.invCkDRepoProc = invCkDRepoProc;
        this.invStkService = invStkService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.sysUdcService = sysUdcService;
        this.invWhService = invWhService;
        this.outService = outService;
    }
}

