/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.entity.QInvCorssentryPricepolicyDO;
import com.elitesland.inv.param.PriGroupParam;
import com.elitesland.inv.repo.InvCorssentryPricepolicyRepo;
import com.elitesland.inv.repo.InvCorssentryPricepolicyRepoProc;
import com.elitesland.inv.service.InvCorssentryPricepolicyService;
import com.elitesland.inv.service.PriSalePriceService;
import com.elitesland.inv.vo.InvCorssentryPricepolicyVO;
import com.elitesland.inv.vo.param.InvCorssentryPricepolicyQueryParam;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="invCorssentryPricepolicyService")
public class InvCorssentryPricepolicyServiceImpl
implements InvCorssentryPricepolicyService {
    private final InvCorssentryPricepolicyRepo invCorssentryPricepolicyRepo;
    private final InvCorssentryPricepolicyRepoProc invCorssentryPricepolicyRepoProc;
    private final PriSalePriceService priSalePriceService;

    public List<InvCorssentryPricepolicyVO> findList(InvCorssentryPricepolicyQueryParam param) {
        JPAQuery<InvCorssentryPricepolicyVO> jpaQuery = this.invCorssentryPricepolicyRepoProc.select(param);
        return jpaQuery.fetch();
    }

    public List<InvCorssentryPricepolicyVO> findAllByAllId(Long buId, Long ouId, Long bdId, Long itemId) {
        QInvCorssentryPricepolicyDO jpaQDo = QInvCorssentryPricepolicyDO.invCorssentryPricepolicyDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where((Predicate)(buId == null ? jpaQDo.fromBuId.isNull() : jpaQDo.fromBuId.eq((Object)buId)))).where((Predicate)(ouId == null ? jpaQDo.fromOuId.isNull() : jpaQDo.fromOuId.eq((Object)ouId)))).where((Predicate)jpaQDo.itemId.eq((Object)itemId))).where((Predicate)jpaQDo.policyType.eq((Object)"BASE"));
        return jpaQuery.fetch();
    }

    public List<InvCorssentryPricepolicyVO> listByParam(InvCorssentryPricepolicyQueryParam param) {
        JPAQuery<InvCorssentryPricepolicyVO> jpaQuery = this.invCorssentryPricepolicyRepoProc.select(param);
        return Lists.newArrayList((Iterable)jpaQuery.fetch());
    }

    public InvCorssentryPricepolicyVO findAddUpRatioByParam(InvCorssentryPricepolicyQueryParam param) {
        InvCorssentryPricepolicyVO crossrefVO = null;
        if (StringUtils.isEmpty((Object)param.getFromOuId()) || StringUtils.isEmpty((Object)param.getToOuId())) {
            crossrefVO = new InvCorssentryPricepolicyVO();
            return crossrefVO;
        }
        param.setDateTime(LocalDateTime.now());
        if (!StringUtils.isEmpty((Object)param.getToOuId()) && 0L == param.getToOuId()) {
            param.setToOuId(Long.valueOf(0L));
        }
        param.setPolicyType(UdcEnum.PRI_CE_POLICY_OU.getValueCode());
        crossrefVO = this.findOneByParam(param);
        if ((Objects.isNull(crossrefVO) || StringUtils.isEmpty((Object)crossrefVO.getAddupRatio())) && !StringUtils.isEmpty((Object)param.getToOuId())) {
            param.setPolicyType(UdcEnum.PRI_CE_POLICY_OU.getValueCode());
            param.setToOuId(Long.valueOf(0L));
            crossrefVO = this.findOneByParam(param);
        }
        if (Objects.isNull(crossrefVO) || StringUtils.isEmpty((Object)crossrefVO.getAddupRatio())) {
            param.setPolicyType(UdcEnum.PRI_CE_POLICY_BASE.getValueCode());
            crossrefVO = this.findOneByParam(param);
        }
        if ((Objects.isNull(crossrefVO) || StringUtils.isEmpty((Object)crossrefVO.getAddupRatio())) && !StringUtils.isEmpty((Object)param.getToOuId())) {
            param.setPolicyType(UdcEnum.PRI_CE_POLICY_BASE.getValueCode());
            param.setToOuId(Long.valueOf(0L));
            crossrefVO = this.findOneByParam(param);
        }
        if (Objects.isNull(crossrefVO)) {
            crossrefVO = new InvCorssentryPricepolicyVO();
        }
        Double addupRatio = StringUtils.isEmpty((Object)crossrefVO.getAddupRatio()) ? 0.0 : crossrefVO.getAddupRatio();
        crossrefVO.setAddupRatio(addupRatio);
        return crossrefVO;
    }

    public InvCorssentryPricepolicyVO findOneByParam(InvCorssentryPricepolicyQueryParam param) {
        QInvCorssentryPricepolicyDO jpaQDo = QInvCorssentryPricepolicyDO.invCorssentryPricepolicyDO;
        JPAQuery<InvCorssentryPricepolicyVO> jpaQuery = this.invCorssentryPricepolicyRepoProc.select(null);
        jpaQuery.where((Predicate)jpaQDo.addupRatio.isNotNull());
        jpaQuery.where(this.invCorssentryPricepolicyRepoProc.repetitiveCheckWhere(param));
        jpaQuery.orderBy(jpaQDo.id.desc());
        InvCorssentryPricepolicyVO crossrefVO = (InvCorssentryPricepolicyVO)jpaQuery.fetchFirst();
        return crossrefVO;
    }

    public PriSalePriceVO costPrice(PriGroupParam priGroupParam) {
        List priSalePriceVO = this.priSalePriceService.findByItemIdAndPriceType(priGroupParam.getFromOuId(), priGroupParam.getItemId(), UdcEnum.PRI_SALE_PRICE_TYPE_COST_PRICE.getValueCode(), priGroupParam.getDocTime());
        if (priSalePriceVO != null && priSalePriceVO.size() > 0) {
            return priSalePriceVO.stream().filter(i -> i.getCreateTime() != null).max(Comparator.comparing(i -> i.getCreateTime())).get();
        }
        List priSalePriceVO1 = this.priSalePriceService.findByItemIdAndPriceType(null, priGroupParam.getItemId(), UdcEnum.PRI_SALE_PRICE_TYPE_COST_PRICE.getValueCode(), priGroupParam.getDocTime());
        if (priSalePriceVO1 != null && priSalePriceVO1.size() > 0) {
            PriSalePriceVO salePriceVO = priSalePriceVO1.stream().filter(i -> i.getCreateTime() != null).max(Comparator.comparing(i -> i.getCreateTime())).get();
            InvCorssentryPricepolicyVO priCorssentryPricepolicyVO = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(priGroupParam.getItemId(), null, priGroupParam.getToOuId(), UdcEnum.PRI_CE_POLICY_BASE.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
            if (priCorssentryPricepolicyVO != null) {
                return this.splicPrice(salePriceVO, priCorssentryPricepolicyVO);
            }
            InvCorssentryPricepolicyVO priCorssentryPricepolicyVO1 = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(priGroupParam.getItemId(), null, null, UdcEnum.PRI_CE_POLICY_BASE.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
            if (priCorssentryPricepolicyVO1 != null) {
                return this.splicPrice(salePriceVO, priCorssentryPricepolicyVO1);
            }
            return salePriceVO;
        }
        throw new BusinessException(ApiCode.FAIL, "\u627e\u4e0d\u5230\u5546\u54c1\u6210\u672c\u4ef7\uff0c\u8bf7\u7ef4\u62a4\uff01");
    }

    @SysCodeProc
    public PriSalePriceVO groupPrice(PriGroupParam priGroupParam) {
        PriSalePriceVO salePriceVO = this.costPrice(priGroupParam);
        InvCorssentryPricepolicyVO invCorssentryPricepolicyVO = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(priGroupParam.getItemId(), priGroupParam.getFromOuId(), priGroupParam.getToOuId(), UdcEnum.PRI_CE_POLICY_ITEM.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
        if (salePriceVO != null) {
            if (invCorssentryPricepolicyVO == null) {
                InvCorssentryPricepolicyVO invCorssentryPricepolicyVO1 = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(priGroupParam.getItemId(), priGroupParam.getFromOuId(), null, UdcEnum.PRI_CE_POLICY_ITEM.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
                if (invCorssentryPricepolicyVO1 == null) {
                    InvCorssentryPricepolicyVO invCorssentryPricepolicyVO2 = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(null, priGroupParam.getFromOuId(), priGroupParam.getToOuId(), UdcEnum.PRI_CE_POLICY_OU.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
                    if (invCorssentryPricepolicyVO2 == null) {
                        InvCorssentryPricepolicyVO invCorssentryPricepolicyVO3 = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(null, priGroupParam.getFromOuId(), null, UdcEnum.PRI_CE_POLICY_OU.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
                        if (invCorssentryPricepolicyVO3 == null) {
                            InvCorssentryPricepolicyVO invCorssentryPricepolicyVO4 = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(priGroupParam.getItemId(), priGroupParam.getFromOuId(), priGroupParam.getToOuId(), UdcEnum.PRI_CE_POLICY_BASE.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
                            if (invCorssentryPricepolicyVO4 == null) {
                                InvCorssentryPricepolicyVO invCorssentryPricepolicyVO5 = (InvCorssentryPricepolicyVO)((JPAQuery)this.invCorssentryPricepolicyRepoProc.select(null).where(this.invCorssentryPricepolicyRepoProc.groupWhere(priGroupParam.getItemId(), priGroupParam.getFromOuId(), null, UdcEnum.PRI_CE_POLICY_BASE.getValueCode(), priGroupParam.getDocTime()))).fetchFirst();
                                if (invCorssentryPricepolicyVO5 == null) {
                                    salePriceVO.setContractPrice(salePriceVO.getCostPrice());
                                    return salePriceVO;
                                }
                                return this.splicPrice(salePriceVO, invCorssentryPricepolicyVO5);
                            }
                            return this.splicPrice(salePriceVO, invCorssentryPricepolicyVO4);
                        }
                        return this.splicPrice(salePriceVO, invCorssentryPricepolicyVO3);
                    }
                    return this.splicPrice(salePriceVO, invCorssentryPricepolicyVO2);
                }
                return this.splicPrice(salePriceVO, invCorssentryPricepolicyVO1);
            }
            return this.splicPrice(salePriceVO, invCorssentryPricepolicyVO);
        }
        throw new BusinessException("\u5546\u54c1id:" + priGroupParam.getItemId() + ",\u6ca1\u6709\u627e\u5230\u6210\u672c\u4ef7\uff0c\u8bf7\u7ef4\u62a4\u5546\u54c1\u7684\u6210\u672c\u4ef7!");
    }

    public List<PriSalePriceVO> groupPriceALL(List<PriGroupParam> priGroupParamList) {
        List itemIds = priGroupParamList.stream().map(PriGroupParam::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List custIds = priGroupParamList.stream().map(PriGroupParam::getCustId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return null;
    }

    private PriSalePriceVO splicPrice(PriSalePriceVO priSalePriceVO, InvCorssentryPricepolicyVO invCorssentryPricepolicyVO) {
        BigDecimal costPrice = priSalePriceVO.getCostPrice();
        if (costPrice == null) {
            throw new BusinessException("\u5546\u54c1\u6ca1\u6709\u627e\u5230\u6210\u672c\u4ef7\uff0c\u8bf7\u7ef4\u62a4\u5546\u54c1\u7684\u6210\u672c\u4ef7!");
        }
        Double add = 1.0;
        if (invCorssentryPricepolicyVO.getAddupRatio() != null) {
            add = add + invCorssentryPricepolicyVO.getAddupRatio();
        }
        if (invCorssentryPricepolicyVO.getAlterRatio2() != null) {
            add = add + invCorssentryPricepolicyVO.getAlterRatio2();
        }
        if (invCorssentryPricepolicyVO.getAlterRatio3() != null) {
            add = add + invCorssentryPricepolicyVO.getAlterRatio3();
        }
        priSalePriceVO.setContractPrice(costPrice.multiply(new BigDecimal(String.valueOf(add))));
        return priSalePriceVO;
    }

    public InvCorssentryPricepolicyServiceImpl(InvCorssentryPricepolicyRepo invCorssentryPricepolicyRepo, InvCorssentryPricepolicyRepoProc invCorssentryPricepolicyRepoProc, PriSalePriceService priSalePriceService) {
        this.invCorssentryPricepolicyRepo = invCorssentryPricepolicyRepo;
        this.invCorssentryPricepolicyRepoProc = invCorssentryPricepolicyRepoProc;
        this.priSalePriceService = priSalePriceService;
    }
}

