/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.InvUdcEnum;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvIoConvert;
import com.elitesland.inv.entity.InvIoDO;
import com.elitesland.inv.entity.QInvIoDO;
import com.elitesland.inv.param.InvIoQueryParam;
import com.elitesland.inv.param.InvIoSearchBatchParam;
import com.elitesland.inv.repo.InvIoRepo;
import com.elitesland.inv.repo.InvIoRepoProc;
import com.elitesland.inv.service.InvIoService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvIoVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.resp.InvIoStkAcctRespVO;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmBrandPartParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmBrandAllDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invIoService")
public class InvIoServiceImpl
implements InvIoService {
    private final InvIoRepo invIoRepo;
    private final InvIoRepoProc invIoRepoProc;
    private final InvWhService invWhService;
    private final SysUdcService sysUdcService;
    private final OutService outService;
    private String T = "T";

    @SysCodeProc
    public PagingVO<InvIoVO> search(InvIoQueryParam param) {
        Page ret = this.invIoRepo.findAll(this.invIoRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(InvIoConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<InvIoVO> findCodeOne(String itemCode) {
        InvIoVO vo = (InvIoVO)this.invIoRepoProc.select(null).fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<InvIoVO> findIdOne(Long id) {
        return this.invIoRepo.findById(id).map(InvIoConvert.INSTANCE::doToVO);
    }

    @SysCodeProc
    public List<InvIoVO> findIdBatch(List<Long> idList) {
        return this.invIoRepo.findAllById(idList).stream().map(InvIoConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(InvIoDO invIoDO) {
        return ((InvIoDO)this.invIoRepo.save(invIoDO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvIoDO> list) {
        return this.invIoRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(InvIoDO objDo) {
        Optional optional = this.invIoRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (InvIoDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invIoRepo.save((InvIoDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QInvIoDO jpaQDo = QInvIoDO.invIoDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invIoRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvIoDO do1 = (InvIoDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.invIoRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.invIoRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invIoRepo.deleteById(id));
    }

    public List<InvIoVO> findByParams(InvIoQueryParam queryParam) {
        List fetch = this.invIoRepoProc.select(queryParam).fetch();
        return fetch;
    }

    @SysCodeProc
    public PagingVO<InvIoStkAcctRespVO> searchStkAcct(InvIoSearchBatchParam param) {
        if (param.getBrandIds() != null) {
            ItmBrandPartParam itmBrandPartParam = new ItmBrandPartParam();
            itmBrandPartParam.setIds(param.getBrandIds());
            List itemBrands = this.outService.itmBrandAllSearch(itmBrandPartParam).stream().map(ItmBrandAllDTO::getBrandName).collect(Collectors.toList());
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            itmItemPartParam.setBrands(itemBrands);
            List additionalItemIdList = this.outService.itmItemAllSearch(itmItemPartParam).stream().map(ItmItemDTO::getId).collect(Collectors.toList());
            if (additionalItemIdList.size() > 0) {
                param.setItemIds(Stream.concat(param.getItemIds().stream(), additionalItemIdList.stream()).collect(Collectors.toList()));
            } else {
                return PagingVO.builder().total(Long.valueOf(0L)).records(new ArrayList()).build();
            }
        }
        JPAQuery<InvIoStkAcctRespVO> query = this.invIoRepoProc.searchStkAcct(param);
        param.fillOrders(query);
        param.setPaging(query);
        List invIoDetailedVOList = query.fetch();
        invIoDetailedVOList.forEach(v -> {
            if (v.getIoCode() != null) {
                v.setIoName(InvStk28Enum.valueOf((String)v.getIoCode()).getIoName());
            }
        });
        this.results(invIoDetailedVOList);
        List<InvIoStkAcctRespVO> invIoStkAcctRespVOS = this.udcChange(invIoDetailedVOList);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(invIoStkAcctRespVOS).build();
    }

    public void results(List<InvIoStkAcctRespVO> invIoDetailedVOList) {
        List<Long> ouIdList;
        List whIdList;
        List itemIdList = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getItemId).collect(Collectors.toList());
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(itemIdList);
        List<ItmItemDTO> itmItemDTOS = this.outService.itmItemAllSearch(itmItemPartParam);
        if (!itemIdList.isEmpty()) {
            invIoDetailedVOList.forEach(v -> itmItemDTOS.stream().filter(i -> i.getId().equals(v.getItemId())).findAny().ifPresent(m -> {
                v.setItemCode(m.getItemCode());
                v.setItemName(m.getItemName());
                v.setPackageSpec(m.getPackageSpec());
                v.setEn1(m.getEn1());
                if (v.getQty() != null && m.getEn1() != null) {
                    v.setPkgQty(Integer.valueOf((int)Math.round(v.getQty() / (double)m.getEn1().floatValue())));
                }
                v.setBrand(m.getBrand());
                v.setBrandName(m.getBrandName());
                v.setBarCode(m.getBarCode());
            }));
        }
        if (!(whIdList = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getWhId).collect(Collectors.toList())).isEmpty()) {
            List whVoList = this.invWhService.findIdBatch(whIdList);
            invIoDetailedVOList.forEach(v -> whVoList.stream().filter(i -> i.getId().equals(v.getWhId())).findAny().ifPresent(m -> {
                v.setWhCode(m.getWhCode());
                v.setWhName(m.getWhName());
            }));
        }
        if (!(ouIdList = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getOuId).collect(Collectors.toList())).isEmpty()) {
            List<OrgOuVO> ouVoList = this.outService.listOrgOuVOByIds(ouIdList);
            invIoDetailedVOList.forEach(v -> {
                if (v.getOuId() != null) {
                    ouVoList.stream().filter(i -> i.getId().equals(v.getOuId())).findAny().ifPresent(m -> {
                        v.setOuCode(m.getCode());
                        v.setOuName(m.getName());
                    });
                }
            });
        }
    }

    public List<InvIoStkAcctRespVO> udcChange(List<InvIoStkAcctRespVO> asms) {
        Map udcDeter1 = this.sysUdcService.getCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map udcDeter2 = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_GD.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
        Map udcUom = this.sysUdcService.getCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map udcDoccls = this.sysUdcService.getCodeMap(UdcEnum.COM_DOC_CLS_SPA.getModel(), UdcEnum.COM_DOC_CLS_SPA.getCode());
        Map udcBusiType = this.sysUdcService.getCodeMap(InvUdcEnum.INV_BUSI_TYPE_1.getModel(), InvUdcEnum.INV_BUSI_TYPE_1.getCode());
        asms.stream().forEach(Asm -> {
            if (StringUtils.isNotBlank((CharSequence)Asm.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                Asm.setDeter1Name((String)udcDeter1.get(Asm.getDeter1()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDeter2()) && !MapUtils.isEmpty((Map)udcDeter2)) {
                Asm.setDeter2Name((String)udcDeter2.get(Asm.getDeter2()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getSrcDocCls()) && !MapUtils.isEmpty((Map)udcDoccls)) {
                Asm.setSrcDocClsName((String)udcDoccls.get(Asm.getSrcDocCls()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                Asm.setUomName((String)udcUom.get(Asm.getUom()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getBusiType()) && !MapUtils.isEmpty((Map)udcBusiType)) {
                Asm.setBusiTypeName((String)udcBusiType.get(Asm.getBusiType()));
            }
        });
        return asms;
    }

    public InvIoServiceImpl(InvIoRepo invIoRepo, InvIoRepoProc invIoRepoProc, InvWhService invWhService, SysUdcService sysUdcService, OutService outService) {
        this.invIoRepo = invIoRepo;
        this.invIoRepoProc = invIoRepoProc;
        this.invWhService = invWhService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

