/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.entity.InvLotDO;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.repo.InvLotRepo;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.vo.InvLotCommon21FilterVO;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.ServiceResult;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.out.service.OutService;
import com.elitesland.out.service.SysSettingService;
import com.elitesland.pur.dto.SysSettingVO;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invCommon21Service")
public class InvLotCommonServiceImpl
implements InvLotCommonService {
    private static final Logger log = LoggerFactory.getLogger(InvLotCommonServiceImpl.class);
    private final InvLotService invLotService;
    private final InvLotRepo invLotRepo;
    private final OutService outService;
    private final SysSettingService sysSettingService;

    public Map<Integer, List<InvLotRespVO>> getInvLotVOList(List<InvLotCommon21InVO> inVOList) {
        log.info("\u5171\u901a\u65b9\u6cd521\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", inVOList.stream().map(InvLotCommon21InVO::toString).collect(Collectors.toList())));
        Map<Integer, List<InvLotRespVO>> result = Collections.synchronizedMap(new HashMap());
        if (CollectionUtils.isEmpty(inVOList)) {
            List invLotList = this.invLotService.findByParams(new InvLotParam());
            result.put(0, invLotList);
        } else {
            this.checkIn21(inVOList);
            inVOList.stream().forEach(i -> {
                InvLotParam queryParam = new InvLotParam();
                queryParam.setItemId(i.getItemId());
                queryParam.setVariId(i.getVariId());
                queryParam.setLotNo(i.getLotNo());
                List invLotList = this.invLotService.findByParams(queryParam);
                result.put(inVOList.indexOf(i), invLotList);
            });
        }
        return result;
    }

    public List<InvLotRespVO> getInvLotCheckedList(List<InvLotRespVO> source, InvLotCommon21FilterVO filterVO) {
        return source.stream().filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getLotStatus())) {
                return filterVO.getLotStatus().equals(i.getLotStatus());
            }
            return true;
        }).filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getQcStatus())) {
                return filterVO.getQcStatus().equals(i.getQcStatus());
            }
            return true;
        }).filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getFirstLotNo())) {
                return filterVO.getFirstLotNo().compareTo(i.getLotNo()) <= 0;
            }
            return true;
        }).filter(i -> {
            if (StringUtils.isEmpty((Object)filterVO.getFressType())) {
                return true;
            }
            return filterVO.getFressType().equals(i.getFressType());
        }).filter(i -> {
            if (filterVO.getFressTypeDays() != null) {
                if (filterVO.getAdjustDays() == null) {
                    return (i.getUntilExpireDays() == null ? 0.0 : (double)i.getUntilExpireDays().intValue()) >= filterVO.getFressTypeDays();
                }
                return (i.getUntilExpireDays() == null ? 0.0 : (double)i.getUntilExpireDays().intValue()) >= filterVO.getFressTypeDays() + filterVO.getAdjustDays();
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Transactional
    public ServiceResult createInvLotInfo(List<InvLotSaveVO> source) {
        log.info("\u5171\u901a\u65b9\u6cd522\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", source.stream().map(InvLotSaveVO::toString).collect(Collectors.toList())));
        List<InvLotVO> lotVOS = source.stream().map(i -> {
            InvLotVO vo = new InvLotVO();
            BeanUtils.copyProperties((Object)i, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        Map<Integer, List<InvLotRespVO>> map = this.checkIn(lotVOS);
        try {
            List<InvLotVO> sourceClone = BeanCopyUtil.deepCopy(lotVOS);
            map.keySet().stream().forEach(key -> {
                List list = (List)map.get(key);
                list.stream().forEach(v -> {
                    String a = v.getItemId() + "_" + v.getVariId() + "_" + v.getLotNo();
                    Iterator ite = sourceClone.iterator();
                    while (ite.hasNext()) {
                        InvLotVO s = (InvLotVO)ite.next();
                        String b = s.getItemId() + "_" + s.getVariId() + "_" + s.getLotNo();
                        if (!a.equals(b)) continue;
                        ite.remove();
                    }
                });
            });
            ArrayList<InvLotDO> invLotDOS = new ArrayList<InvLotDO>();
            for (InvLotVO invLotVO : sourceClone) {
                InvLotDO invLotDO = new InvLotDO();
                BeanUtils.copyProperties((Object)invLotVO, (Object)invLotDO);
                invLotDOS.add(invLotDO);
            }
            List<String> noticeMsgList = this.checkStoreExpireDaysAndSetLockReason(invLotDOS);
            sourceClone.forEach(i -> i.setFirstInDate(LocalDateTime.now()));
            this.invLotRepo.saveAll(invLotDOS);
            if (CollectionUtils.isEmpty(noticeMsgList)) {
                return ServiceResult.builder().success(true).code(0).data(source).msg("\u64cd\u4f5c\u6210\u529f").build();
            }
            return ServiceResult.builder().success(true).code(1).data(source).msg("\u4fdd\u8d28\u671f\u5929\u6570\u7591\u4f3c\u9519\u8bef\uff0c\u6279\u6b21" + noticeMsgList.stream().collect(Collectors.joining(",")) + "\u5df2\u521b\u5efa\u5e76\u9501\u5b9a\uff0c\u8bf7\u786e\u8ba4\u3002").build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return ServiceResult.builder().success(false).data(source).msg("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage()).build();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return ServiceResult.builder().success(false).data(source).msg("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage()).build();
        }
    }

    @Transactional
    public ServiceResult updateInvLotInfo(List<InvLotVO> source) {
        log.info("\u5171\u901a\u65b9\u6cd523\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", source.stream().map(InvLotVO::toString).collect(Collectors.toList())));
        Map<Integer, List<InvLotRespVO>> map = this.checkIn(source);
        List errMsgList = Collections.synchronizedList(new ArrayList());
        map.keySet().stream().forEach(key -> {
            List list = (List)map.get(key);
            if (CollectionUtils.isEmpty((Collection)list)) {
                InvLotVO invLotVO = (InvLotVO)source.get((int)key);
                errMsgList.add(String.format("[\u5546\u54c1\uff1a%s\u3001VARI_ID:%s\u3001\u6279\u6b21\u53f7:%s]", invLotVO.getItemId(), invLotVO.getVariId(), invLotVO.getLotNo()));
            }
        });
        if (!CollectionUtils.isEmpty(errMsgList)) {
            throw new BusinessException("\u7ef4\u62a4\u6279\u6b21" + errMsgList.stream().collect(Collectors.joining(",")) + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002");
        }
        ArrayList<InvLotDO> invLotDOS = new ArrayList<InvLotDO>();
        for (InvLotVO invLotVO : source) {
            InvLotDO invLotDO = new InvLotDO();
            BeanUtils.copyProperties((Object)invLotVO, (Object)invLotDO);
            invLotDOS.add(invLotDO);
        }
        this.invLotRepo.saveAll(invLotDOS);
        return ServiceResult.builder().success(true).code(0).data(source).msg("\u64cd\u4f5c\u6210\u529f").build();
    }

    private List<String> checkStoreExpireDaysAndSetLockReason(List<InvLotDO> source) {
        List itemLists = source.stream().map(InvLotDO::getItemId).distinct().collect(Collectors.toList());
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemLists);
        List<ItmItemDTO> itemVOList = this.outService.itmItemAllSearch(partParam);
        SysSettingVO sysSettingVO = this.sysSettingService.findBySettingName("\u4fdd\u8d28\u671f\u5929\u6570\u8bbe\u5b9a\u9608\u503c");
        long storeExpireDaysSetting = 0L;
        if (sysSettingVO != null) {
            storeExpireDaysSetting = Math.abs(StringUtils.isEmpty((Object)sysSettingVO.getSettingVal()) ? 0L : Long.parseLong(sysSettingVO.getSettingVal()));
        }
        String warnMsg = "[\u5546\u54c1:%s\u3001VARI_ID:%s\u3001\u6279\u6b21\u53f7:%s]";
        ArrayList<String> warnMsgList = new ArrayList<String>();
        long finalStoreExpireDaysSetting = storeExpireDaysSetting;
        source.forEach(i -> {
            ItmItemDTO itmItemVO;
            if (!CollectionUtils.isEmpty((Collection)itemVOList) && (itmItemVO = itemVOList.stream().filter(item -> item.getId().equals(i.getItemId())).findAny().get()) != null) {
                i.setItemCode(itmItemVO.getItemCode());
                i.setMenuCountry(itmItemVO.getMenuCountry());
            }
            if ("LOCK".equals(i.getQcStatus())) {
                i.setLotStatus("1");
            } else {
                long between = ChronoUnit.DAYS.between(i.getManuDate().toLocalDate(), i.getExpireDate().toLocalDate());
                i.setLotStatus("0");
                if (Math.abs(between - i.getExpireDays().longValue()) > finalStoreExpireDaysSetting) {
                    i.setLotStatus("1");
                    i.setLockReason(UdcEnum.INV_LOT_LOCK_REASON_EXP.getValueCode());
                    warnMsgList.add(String.format(warnMsg, i.getItemId(), i.getVariId(), i.getLotNo()));
                    log.info("\u5171\u901a\u65b9\u6cd522(\u51fa\u73b0\u9501\u5b9a\u72b6\u6001\u6570\u636e)\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)i.toString());
                }
            }
            Long expireDays = i.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay();
            i.setUntilExpireDays(expireDays < 0L ? 0 : expireDays.intValue());
            Long days = LocalDate.now().toEpochDay() - i.getManuDate().toLocalDate().toEpochDay();
            double fress = days.doubleValue() / i.getExpireDays().doubleValue();
            if (fress < 0.3333333333333333) {
                i.setFressType(UdcEnum.COM_FRESS_TYPE_1.getValueCode());
            } else if (fress >= 0.3333333333333333 && fress < 0.5) {
                i.setFressType(UdcEnum.COM_FRESS_TYPE_2.getValueCode());
            } else if (fress >= 0.5 && fress < 0.6666666666666666) {
                i.setFressType(UdcEnum.COM_FRESS_TYPE_3.getValueCode());
            } else if (fress >= 0.6666666666666666 && fress < 1.0) {
                i.setFressType(UdcEnum.COM_FRESS_TYPE_4.getValueCode());
            } else {
                i.setFressType(UdcEnum.COM_FRESS_TYPE_5.getValueCode());
            }
            i.setDeleteFlag(0);
        });
        return warnMsgList;
    }

    private Map<Integer, List<InvLotRespVO>> checkIn(List<InvLotVO> lotVOList) {
        List<InvLotCommon21InVO> invLotCommon21InVOS = Collections.synchronizedList(new ArrayList());
        lotVOList.stream().forEach(i -> {
            InvLotCommon21InVO inVO = new InvLotCommon21InVO();
            inVO.setItemId(i.getItemId());
            inVO.setItemCode(i.getItemCode());
            inVO.setVariId(i.getVariId());
            inVO.setLotNo(i.getLotNo());
            invLotCommon21InVOS.add(inVO);
        });
        return this.getInvLotVOList(invLotCommon21InVOS);
    }

    private void checkIn21(List<InvLotCommon21InVO> inVOList) {
    }

    public InvLotCommonServiceImpl(InvLotService invLotService, InvLotRepo invLotRepo, OutService outService, SysSettingService sysSettingService) {
        this.invLotService = invLotService;
        this.invLotRepo = invLotRepo;
        this.outService = outService;
        this.sysSettingService = sysSettingService;
    }
}

