/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.convert.InvLotConvert;
import com.elitesland.inv.convert.InvLotCovert;
import com.elitesland.inv.dto.ComC2VO;
import com.elitesland.inv.entity.InvLotDO;
import com.elitesland.inv.entity.QInvLotDO;
import com.elitesland.inv.param.InvLotCombineParam;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.param.InvStkDParam;
import com.elitesland.inv.repo.InvLotRepo;
import com.elitesland.inv.repo.InvLotRepoProc;
import com.elitesland.inv.service.InvItemPkgService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvLotAllVO;
import com.elitesland.inv.vo.InvStkDVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.resp.InvWhAreaRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.pur.vo.resp.PurPoRespVO;
import com.elitesland.pur.vo.resp.PurSuppRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invLotService")
@DubboService
public class InvLotServiceImpl
implements InvLotService {
    private final InvLotRepo invLotRepo;
    private final InvLotRepoProc invLotRepoProc;
    private final OrgOuService orgOuService;
    private final InvWhService invWhService;
    private final InvWhAreaService invWhAreaService;
    private final OutService outService;
    private InvItemPkgService invItemPkgService;

    @SysCodeProc
    public PagingVO<InvLotRespVO> search(InvLotParam param) {
        return this.invLotRepoProc.useSelect(param);
    }

    @SysCodeProc
    public Optional<InvLotRespVO> findCodeOne(String key) {
        InvLotRespVO vo = (InvLotRespVO)this.invLotRepoProc.select(null).fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<InvLotRespVO> findIdOne(Long id) {
        Optional header = this.invLotRepo.findById(id);
        InvLotRespVO vo = new InvLotRespVO();
        if (header.isPresent()) {
            InvLotDO invLotDO = (InvLotDO)header.get();
            InvLotRespVO invLotVO = new InvLotRespVO();
            BeanUtils.copyProperties((Object)invLotDO, (Object)invLotVO);
            this.fillUpNameList(List.of(invLotVO));
            BeanUtil.copyProperties((Object)invLotVO, (Object)vo);
        }
        return Optional.of(vo);
    }

    @SysCodeProc
    public List<InvLotRespVO> findIdBatch(List<Long> idList) {
        return ((JPAQuery)this.invLotRepoProc.select(null).where((Predicate)QInvLotDO.invLotDO.id.in(idList))).fetch();
    }

    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNo(List<String> itmIdNo) {
        ArrayList<InvLotDO> invLotDOlist = new ArrayList<InvLotDO>();
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            if (split.length != 2) {
                throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u9519\u8bef");
            }
            List<InvLotDO> invo = this.invLotRepo.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            if (invo == null || invo.size() != 1) continue;
            invLotDOlist.add(invo.get(0));
        }
        return invLotDOlist.stream().map(InvLotCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @SysCodeProc
    public List<InvLotRespVO> findListByAndItemIdAndLotNo(List<String> itmIdNo) {
        ArrayList<InvLotDO> invLotDOlist = new ArrayList<InvLotDO>();
        if (CollectionUtils.isEmpty(itmIdNo)) {
            return Lists.newArrayList();
        }
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            if (split.length != 2) {
                throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u9519\u8bef");
            }
            List<InvLotDO> invo = this.invLotRepo.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            if (CollectionUtils.isEmpty(invo)) continue;
            invLotDOlist.add(invo.get(0));
        }
        return invLotDOlist.stream().map(InvLotCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNo2(List<String> itmIdNo) {
        ArrayList<InvLotDO> invLotDOlist = new ArrayList<InvLotDO>();
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            List<InvLotDO> invo = this.invLotRepo.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            if (invo == null || invo.size() != 1) continue;
            invLotDOlist.add(invo.get(0));
        }
        return invLotDOlist.stream().map(InvLotCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNoList(List<String> itmIdNo) {
        ArrayList<InvLotRespVO> invLotDOlist = new ArrayList<InvLotRespVO>();
        for (String itmid : itmIdNo) {
            List invo;
            String[] split = itmid.split("_");
            InvLotParam param = new InvLotParam();
            if (split.length != 3) continue;
            if (!"null".equals(split[0])) {
                param.setItemId(Long.valueOf(split[0]));
            }
            if (!"null".equals(split[1])) {
                param.setVariId(Long.valueOf(split[1]));
            }
            if (!"null".equals(split[2])) {
                param.setLotNo(split[2]);
            }
            if ((invo = this.invLotRepoProc.findAllByItemIdAndLotNoAndVariId(param).fetch()) == null || invo.size() <= 0) continue;
            invLotDOlist.add((InvLotRespVO)invo.get(0));
        }
        return invLotDOlist;
    }

    @Transactional
    public Long createOne(InvLotSaveVO invLotVO) {
        return ((InvLotDO)this.invLotRepo.save(InvLotCovert.INSTANCE.voToSaveDO(invLotVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvLotSaveVO> list) {
        List lotDOS = list.stream().map(InvLotCovert.INSTANCE::voToSaveDO).collect(Collectors.toList());
        return this.invLotRepo.saveAll(lotDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(InvLotSaveVO item) {
        Optional optional = this.invLotRepo.findById(item.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + item.getId());
        }
        this.invLotRepo.save(InvLotCovert.INSTANCE.voToSaveDO(item));
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QInvLotDO jpaQDo = QInvLotDO.invLotDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invLotRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvLotDO do1 = (InvLotDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.invLotRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        QInvLotDO jpaQDo = QInvLotDO.invLotDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invLotRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        this.invLotRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invLotRepo.deleteById(id));
    }

    public Optional<InvLotAllVO> findInvLotAllOne(Long id) {
        Optional header = this.invLotRepo.findById(id);
        InvLotAllVO vo = new InvLotAllVO();
        if (header.isPresent()) {
            InvLotDO invLotDO = (InvLotDO)header.get();
            InvLotRespVO invLotVO = new InvLotRespVO();
            BeanUtils.copyProperties((Object)invLotDO, (Object)invLotVO);
            this.fillUpNameList(List.of(invLotVO));
            BeanUtil.copyProperties((Object)invLotVO, (Object)vo);
        }
        return Optional.of(vo);
    }

    @SysCodeProc
    public PagingVO<InvLotRespVO> findCombine(InvLotCombineParam param) {
        Page ret = this.invLotRepo.findAll(this.invLotRepoProc.searchWhere(param), (Pageable)param.getPageRequest());
        List<InvLotRespVO> records = ret.getContent().stream().map(InvLotConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
        this.fillUpNameList(records);
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(records).build();
    }

    public List<InvLotRespVO> findByParams(InvLotParam queryParam) {
        return ((JPAQuery)this.invLotRepoProc.select(null).where(this.invLotRepoProc.where(queryParam))).fetch();
    }

    public void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo) {
        this.invLotRepo.addSinQty(lotNo, itemId, sinQty, sinStatus, sinNo);
    }

    @SysCodeProc
    public PagingVO<InvStkDVO> searchD(InvStkDParam param) {
        PagingVO pagingVO = this.invLotRepoProc.useSelectD(param);
        List invStkDResults = pagingVO.getRecords();
        List orgWhResults = this.invWhService.findIdBatch(invStkDResults.stream().map(InvStkDVO::getWhId).collect(Collectors.toList()));
        List itemIds = invStkDResults.stream().map(InvStkDVO::getItemId).collect(Collectors.toList());
        ItmItemPartParam itmParam = new ItmItemPartParam();
        itmParam.setIds(itemIds);
        List<ItmItemDTO> itmItemDTOS = this.outService.itmItemAllSearch(itmParam);
        List<OrgOuVO> orgOuResults = this.outService.findBatchOus(orgWhResults.stream().map(InvWhRespVO::getOuId).filter(Objects::nonNull).collect(Collectors.toList()));
        List invItmPkgResults = this.invItemPkgService.findByItemIdIn(invStkDResults.stream().map(InvStkDVO::getItemId).collect(Collectors.toList()));
        List c2VOs = Collections.emptyList();
        invStkDResults.stream().forEach(i -> {
            InvWhAreaRespVO orgWhAreaVo;
            orgWhResults.stream().filter(v -> v.getId().equals(i.getWhId())).findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
            });
            if (!CollectionUtils.isEmpty((Collection)itmItemDTOS)) {
                itmItemDTOS.stream().filter(v -> v.getItemCode().equals(i.getItemCode())).findAny().ifPresent(m -> {
                    i.setItemCode(m.getItemCode());
                    i.setItemName(m.getItemName());
                    i.setBrand(m.getBrand());
                    i.setPackageSpec(m.getPackageSpec());
                    i.setAgency(m.getAgency());
                    i.setItemType3(m.getItemType3());
                    i.setEn1(m.getEn1());
                    i.setC2Name((String)c2VOs.stream().filter(v -> v.getC2Code().equals(i.getBrand())).findAny().map(ComC2VO::getC2Name).orElse(null));
                    i.setBrandName(i.getC2Name());
                    i.setVolume(m.getVolume() == null ? null : Double.valueOf(m.getVolume().doubleValue()));
                    i.setGrossWeight(m.getGrossWeight() == null ? null : Double.valueOf(m.getGrossWeight().doubleValue()));
                    i.setNetWeight(m.getNetWeight() == null ? null : Double.valueOf(m.getNetWeight().doubleValue()));
                    i.setTVolume(i.getOhQty() == null || m.getVolume() == null ? null : Double.valueOf(i.getOhQty() * (double)m.getVolume().floatValue()));
                    i.setTGrossWeight(i.getOhQty() == null || m.getGrossWeight() == null ? null : Double.valueOf(i.getOhQty() * (double)m.getGrossWeight().floatValue()));
                    i.setTNetWeight(i.getOhQty() == null || m.getNetWeight() == null ? null : Double.valueOf(i.getOhQty() * (double)m.getNetWeight().floatValue()));
                    i.setTAvalQty(i.getAvalQty() == null || m.getEn1() == null ? null : Double.valueOf(i.getAvalQty() / (double)m.getEn1().floatValue()));
                    i.setTOhQty(i.getOhQty() == null || m.getEn1() == null ? null : Double.valueOf(i.getOhQty() / (double)m.getEn1().floatValue()));
                    i.setTRsvQty(i.getRsvQty() == null || m.getEn1() == null ? null : Double.valueOf(i.getRsvQty() / (double)m.getEn1().floatValue()));
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuResults)) {
                orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                    i.setOuCode(m.getCode());
                    i.setOuName(m.getName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)invItmPkgResults)) {
                invItmPkgResults.stream().filter(v -> v.getItemId().equals(i.getItemId()) && v.getPkgType().equals("SMALL")).findAny().ifPresent(m -> {
                    i.setPkgGrossWeight(m.getGrossWeight());
                    i.setPkgHeight(m.getDimHeight());
                    i.setPkgLength(m.getDimLen());
                    i.setPkgWidth(m.getDimWeight());
                    if (i.getOhQty() != null && m.getGrossWeight() != null) {
                        i.setStkWeight(Double.valueOf(i.getOhQty() * (double)m.getGrossWeight().floatValue()));
                    }
                    if (i.getOhQty() != null && m.getVolume() != null) {
                        i.setStkVolume(Double.valueOf(i.getOhQty() * (double)m.getVolume().floatValue()));
                    }
                });
            }
            if ((orgWhAreaVo = this.invWhAreaService.findByWhIdAndWhArea(i.getWhId(), i.getWhArea())) != null) {
                i.setOuterCode(orgWhAreaVo.getOuterCode());
            }
        });
        invStkDResults.stream().forEach(i -> {
            if (i.getManuDate() == null) {
                i.setManuDate(LocalDateTime.now());
            }
        });
        invStkDResults = invStkDResults.stream().sorted(Comparator.comparing(InvStkDVO::getManuDate)).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(invStkDResults).build();
    }

    public void fillUpNameList(List<InvLotRespVO> vos) {
        List itemIds = vos.stream().map(InvLotRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> suppIds = vos.stream().map(InvLotRespVO::getSuppId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ouIds = vos.stream().map(InvLotRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> poIds = vos.stream().map(InvLotRespVO::getPoId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<PurSuppRespVO> purSuppVOS = this.outService.findSuppByIdBatch(suppIds);
        List<OrgOuVO> orgOuVOS = this.outService.findBatchOus(ouIds);
        ItmItemPartParam itmParam = new ItmItemPartParam();
        itmParam.setIds(itemIds);
        List<ItmItemPartDTO> itemPartDTOS = this.outService.itmItemPartSearch(itmParam);
        List<PurPoRespVO> poRespVOS = this.outService.findPurPoByIdBatch(poIds);
        vos.forEach(vo -> {
            Optional<PurPoRespVO> purPoVO;
            Optional<ItmItemPartDTO> itmItemVO;
            Optional<PurSuppRespVO> orgSuppVO;
            Optional<OrgOuVO> orgOuVO;
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS) && (orgOuVO = orgOuVOS.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst()).isPresent()) {
                OrgOuVO ouVO = orgOuVO.get();
                vo.setOuName(ouVO.getName());
                vo.setOuCode(ouVO.getCode());
            }
            if (!CollectionUtils.isEmpty((Collection)purSuppVOS) && (orgSuppVO = purSuppVOS.stream().filter(v -> v.getId().equals(vo.getSuppId())).findFirst()).isPresent()) {
                PurSuppRespVO suppVO = orgSuppVO.get();
                vo.setSuppCode(suppVO.getSuppCode());
                vo.setSuppName(suppVO.getSuppName());
            }
            if (!CollectionUtils.isEmpty((Collection)itemPartDTOS) && (itmItemVO = itemPartDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst()).isPresent()) {
                ItmItemPartDTO itemVO = itmItemVO.get();
                vo.setItemCode(itemVO.getItemCode());
                vo.setItemName(itemVO.getItemName());
            }
            if (!CollectionUtils.isEmpty((Collection)poRespVOS) && (purPoVO = poRespVOS.stream().filter(v -> v.getId().equals(vo.getPoId())).findFirst()).isPresent()) {
                PurPoRespVO poVO = purPoVO.get();
                vo.setPoNo(poVO.getDocNo());
                vo.setPoType(poVO.getDocType());
            }
        });
    }

    public InvLotServiceImpl(InvLotRepo invLotRepo, InvLotRepoProc invLotRepoProc, OrgOuService orgOuService, InvWhService invWhService, InvWhAreaService invWhAreaService, OutService outService) {
        this.invLotRepo = invLotRepo;
        this.invLotRepoProc = invLotRepoProc;
        this.orgOuService = orgOuService;
        this.invWhService = invWhService;
        this.invWhAreaService = invWhAreaService;
        this.outService = outService;
    }
}

