/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.convert.InvLotSsConvert;
import com.elitesland.inv.repo.InvLotSsRepo;
import com.elitesland.inv.repo.InvLotSsRepoProc;
import com.elitesland.inv.service.InvLotSsService;
import com.elitesland.inv.vo.InvLotSsME1ExcelVO;
import com.elitesland.inv.vo.InvLotSsMVO;
import com.elitesland.inv.vo.InvLotSsVO;
import com.elitesland.inv.vo.param.InvLotSsMQueryParamVO;
import com.elitesland.inv.vo.param.InvLotSsQueryParamVO;
import com.elitesland.inv.vo.resp.InvLotSsMRespVO;
import com.elitesland.inv.vo.resp.InvLotSsRespVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.system.annotation.SysCodeProc;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="invLotSsService")
public class InvLotSsServiceImpl
implements InvLotSsService {
    private final InvLotSsRepo invLotSsRepo;
    private final InvLotSsRepoProc invLotSsRepoProc;
    private final OrgOuService orgOuService;

    @SysCodeProc
    public PagingVO<InvLotSsRespVO> search(InvLotSsQueryParamVO param) {
        Page ret = this.invLotSsRepo.findAll(this.invLotSsRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(InvLotSsConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<InvLotSsRespVO> findCodeOne(String itemCode) {
        InvLotSsVO invLotSsVO = (InvLotSsVO)this.invLotSsRepoProc.select(null).fetchOne();
        InvLotSsRespVO invLotSsRespVO = new InvLotSsRespVO();
        BeanUtils.copyProperties((Object)invLotSsVO, (Object)invLotSsRespVO);
        return Optional.ofNullable(invLotSsRespVO);
    }

    @SysCodeProc
    public Optional<InvLotSsRespVO> findIdOne(Long id) {
        return this.invLotSsRepo.findById(id).map(InvLotSsConvert.INSTANCE::doToRespVO);
    }

    public List<InvLotSsME1ExcelVO> searchMDownLoad(InvLotSsMQueryParamVO param) {
        List records = this.searchM(param).getRecords();
        ArrayList<InvLotSsME1ExcelVO> excelList = new ArrayList<InvLotSsME1ExcelVO>();
        records.stream().forEach(D -> {
            InvLotSsME1ExcelVO invLotSsME1ExcelVO = new InvLotSsME1ExcelVO();
            BeanUtils.copyProperties((Object)D, (Object)invLotSsME1ExcelVO);
            excelList.add(invLotSsME1ExcelVO);
        });
        return excelList;
    }

    @SysCodeProc
    public PagingVO<InvLotSsMRespVO> searchM(InvLotSsMQueryParamVO param) {
        PagingVO pagingVO = this.invLotSsRepoProc.useSelectM(param);
        List invLotSsMVOList = pagingVO.getRecords();
        param.setWhIds(param.getWhIds() != null && param.getWhIds().size() > 0 ? param.getWhIds() : invLotSsMVOList.stream().map(InvLotSsMVO::getWhId).collect(Collectors.toList()));
        param.setItemIds(param.getItemIds() != null ? param.getItemIds() : invLotSsMVOList.stream().map(InvLotSsMVO::getItemId).collect(Collectors.toList()));
        param.setOuIds(param.getOuIds() != null ? param.getOuIds() : invLotSsMVOList.stream().map(InvLotSsMVO::getOuId).collect(Collectors.toList()));
        List collect = invLotSsMVOList.stream().map(D -> {
            InvLotSsMRespVO invLotSsMRespVO = new InvLotSsMRespVO();
            BeanUtils.copyProperties((Object)D, (Object)invLotSsMRespVO);
            return invLotSsMRespVO;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(collect).build();
    }

    public InvLotSsServiceImpl(InvLotSsRepo invLotSsRepo, InvLotSsRepoProc invLotSsRepoProc, OrgOuService orgOuService) {
        this.invLotSsRepo = invLotSsRepo;
        this.invLotSsRepoProc = invLotSsRepoProc;
        this.orgOuService = orgOuService;
    }
}

