/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.param.InvIoQueryParam;
import com.elitesland.inv.param.InvLotStkCommon24And30InParam;
import com.elitesland.inv.param.InvRoDQueryParam;
import com.elitesland.inv.param.InvRoDeducQueryParam;
import com.elitesland.inv.param.ManualAllocLotParam;
import com.elitesland.inv.repo.InvSinDRepo;
import com.elitesland.inv.repo.InvSinRepo;
import com.elitesland.inv.service.InvIoService;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvLotStkCommonService;
import com.elitesland.inv.service.InvRoCommonService;
import com.elitesland.inv.service.InvRoDService;
import com.elitesland.inv.service.InvRoDeducService;
import com.elitesland.inv.service.InvRoService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvIoVO;
import com.elitesland.inv.vo.InvLotCommon21FilterVO;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvLotCommon25InVO;
import com.elitesland.inv.vo.InvLotCommon25OutVO;
import com.elitesland.inv.vo.InvLotCommon26InVO;
import com.elitesland.inv.vo.InvLotCommon27InVO;
import com.elitesland.inv.vo.InvLotStkCommon24And30VO;
import com.elitesland.inv.vo.InvLotStkCommon24InVO;
import com.elitesland.inv.vo.InvLotStkCommon24OutVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvRoCommon30OutVO;
import com.elitesland.inv.vo.InvRoCommon32InVO;
import com.elitesland.inv.vo.InvRoDVO;
import com.elitesland.inv.vo.InvRoDeducVO;
import com.elitesland.inv.vo.InvRoVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.ValidationUtil;
import io.jsonwebtoken.lang.Assert;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invStkLotAllocService")
public class InvLotStkCommonServiceImpl
implements InvLotStkCommonService {
    private static final Logger log = LoggerFactory.getLogger(InvLotStkCommonServiceImpl.class);
    private final InvWhService invWhService;
    private final InvRoService invRoService;
    private final InvRoDService invRoDService;
    private final InvRoDeducService invRoDeducService;
    private final InvIoService invIoService;
    private final InvLotCommonService invLotCommonService;
    private final InvRoCommonService invRoCommonService;
    private final InvStkCommonService invStkCommonService;
    private final InvLotService invLotService;
    private final InvSinRepo invSinRepo;
    private final InvSinDRepo invSinDRepo;
    private final InvStkService invStkService;

    public Map<Integer, List<InvLotStkCommon24OutVO>> invLotStkQuery(List<InvLotStkCommon24InVO> inVOList) {
        log.info("\u5171\u901a\u65b9\u6cd524\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", inVOList.stream().map(InvLotStkCommon24InVO::toString).collect(Collectors.toList())));
        Map<Integer, List<InvLotStkCommon24OutVO>> result = Collections.synchronizedMap(new HashMap());
        inVOList.parallelStream().forEach(inVO -> {
            List<InvLotRespVO> invLotList = this.getInvLotList(inVO.getItemId(), inVO.getVariId(), inVO.getLotNo());
            invLotList = this.getInvLotCheckedList(inVO.getFclFlag() == null ? null : (inVO.getFclFlag() == 1 ? inVO.getFclNum() : null), inVO.getSinStatus(), inVO.getFirstLotNo(), inVO.getFressTypeDays(), inVO.getAdjustDays(), inVO.getQcStatus(), inVO.getLotStatus(), invLotList);
            if (CollectionUtils.isEmpty(invLotList)) {
                result.put(inVOList.indexOf(inVO), Collections.EMPTY_LIST);
                return;
            }
            ArrayList queryParamList = new ArrayList();
            invLotList.forEach(i -> {
                InvBaseModel queryParam = new InvBaseModel();
                queryParam.setItemId(i.getItemId());
                queryParam.setVariId(i.getVariId());
                queryParam.setLotNo(i.getLotNo());
                queryParam.setWhId(inVO.getWhId());
                queryParam.setDeter1(inVO.getDeter1());
                queryParam.setDeter2(inVO.getDeter2());
                queryParam.setDeter3(inVO.getDeter3());
                queryParam.setUom(inVO.getUom());
                queryParamList.add(queryParam);
            });
            List invStkList = this.invStkCommonService.getInvStkList(queryParamList);
            InvLotCommon21FilterVO invLotCommon21FilterVO = new InvLotCommon21FilterVO((InvLotStkCommon24InVO)inVO){
                final /* synthetic */ InvLotStkCommon24InVO val$inVO;
                {
                    this.val$inVO = invLotStkCommon24InVO;
                    this.setFclNum("1".equals(this.val$inVO.getFclFlag()) ? this.val$inVO.getFclNum() : null);
                    this.setFressTypeDays(this.val$inVO.getFressTypeDays());
                    this.setAdjustDays(this.val$inVO.getAdjustDays());
                    this.setFirstLotNo(this.val$inVO.getFirstLotNo());
                }
            };
            invStkList = this.invStkCommonService.getInvStkCheckedList(invStkList, invLotCommon21FilterVO);
            List<InvLotRespVO> finalInvLotList = invLotList;
            List invLotStkCommon24OutVOList = invStkList.stream().map(i -> {
                InvLotStkCommon24OutVO out = InvCommonConvert.INSTANCE.invStkVOToInvLotStkCommon24OutVO((InvStkVO)i);
                finalInvLotList.stream().filter(lot -> lot.getItemId().equals(i.getItemId()) && (StringUtils.isEmpty((Object)i.getVariId()) ? StringUtils.isEmpty((Object)lot.getVariId()) : i.getVariId().equals(lot.getVariId())) && (StringUtils.isEmpty((Object)i.getLotNo()) ? StringUtils.isEmpty((Object)lot.getLotNo()) : i.getLotNo().equals(lot.getLotNo()))).findAny().ifPresent(lot -> {
                    out.setManuDate(lot.getManuDate());
                    out.setExpireDate(lot.getExpireDate());
                    out.setUntilExpireDays(lot.getUntilExpireDays());
                });
                out.setInvStkId(i.getId());
                return out;
            }).collect(Collectors.toList());
            result.put(inVOList.indexOf(inVO), invLotStkCommon24OutVOList);
        });
        return result;
    }

    @Transactional
    public Map<InvLotCommon25InVO, List<InvLotCommon25OutVO>> autoInvStkAlloc(List<InvLotCommon25InVO> inVOList) {
        log.info("\u5171\u901a\u65b9\u6cd525\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", inVOList.stream().map(InvLotCommon25InVO::toString).collect(Collectors.toList())));
        Map<InvLotCommon25InVO, List<InvLotCommon25OutVO>> resultMap = Collections.synchronizedMap(new HashMap());
        this.checkIn25(inVOList);
        Map<String, List<InvLotCommon25InVO>> collect = inVOList.stream().collect(Collectors.groupingBy(i -> i.getItemId() + "_" + i.getWhId()));
        collect.keySet().stream().forEach(key -> this.doProsess(resultMap, (List)collect.get(key)));
        return resultMap;
    }

    @Transactional
    public void invStkAllocChange(List<InvLotCommon26InVO> inVOList) {
        log.info("\u5171\u901a\u65b9\u6cd526\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", inVOList.stream().map(InvLotCommon26InVO::toString).collect(Collectors.toList())));
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(inVOList);
        if (validResult.isError()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\u3010\u884c\u53f7\u3001\u9000\u56de\u6570\u91cf\u3001\u6765\u6e90\u5355\u636e\u7c7b\u522b\u3001\u6765\u6e90\u5355\u636eID\u3001\u6765\u6e90\u5355\u636e\u7f16\u53f7\u3001\u6765\u6e90\u5355\u636e\u660e\u7ec6ID\u3001\u5206\u914d\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inVOList.stream().filter(i -> (i.getRoId() == null || i.getRoDid() == null) && UdcEnum.SAL_SO_ALLOC_TYPE_USE_RO.getValueCode().equals(i.getOrderType())).count() > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u9884\u7559\u5355\u914d\u8d27\u65f6\uff0c\u9884\u7559\u5355ID\u3001\u9884\u7559\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inVOList.stream().filter(i -> i.getInvStkId() == null && UdcEnum.SAL_SO_ALLOC_TYPE_RSV_OH.getValueCode().equals(i.getOrderType())).count() > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u914d\u8d27\u65f6\uff0c\u5e93\u5b58ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inVOList.stream().filter(i -> i.getReturnQty() == null).count() > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        inVOList.forEach(i -> i.setReturnQty(Double.valueOf(Math.abs(i.getReturnQty()))));
        inVOList = inVOList.stream().filter(i -> i.getReturnQty().compareTo(0.0) != 0).collect(Collectors.toList());
        List roInVOList = inVOList.stream().filter(i -> UdcEnum.SAL_SO_ALLOC_TYPE_USE_RO.getValueCode().equals(i.getOrderType())).collect(Collectors.toList());
        List stkInVOList = inVOList.stream().filter(i -> UdcEnum.SAL_SO_ALLOC_TYPE_RSV_OH.getValueCode().equals(i.getOrderType())).collect(Collectors.toList());
        List errMsgList = Collections.synchronizedList(new ArrayList());
        CompletableFuture<Void> roInVOFuture = CompletableFuture.runAsync(() -> {
            if (!CollectionUtils.isEmpty((Collection)roInVOList)) {
                errMsgList.addAll(this.doRoInVoProcess(roInVOList));
            }
        });
        CompletableFuture<Void> stkInVOFuture = CompletableFuture.runAsync(() -> {
            if (!CollectionUtils.isEmpty((Collection)stkInVOList)) {
                errMsgList.addAll(this.doStkInVOProcess(stkInVOList));
            }
        });
        try {
            CompletableFuture.allOf(roInVOFuture, stkInVOFuture).get();
            if (!CollectionUtils.isEmpty(errMsgList)) {
                throw new BusinessException(ApiCode.SPRING_BOOT_PLUS_EXCEPTION, errMsgList.stream().collect(Collectors.joining(",")));
            }
            this.doCommon26Process(inVOList);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BusinessException(ApiCode.SPRING_BOOT_PLUS_EXCEPTION, CollectionUtils.isEmpty(errMsgList) ? e.getMessage() : errMsgList.stream().collect(Collectors.joining(",")));
        }
    }

    @Transactional
    public String invStkAllocSalSo(ManualAllocLotParam param) {
        List inVOList = param.getInvLotCommon27InVOList();
        List collect = inVOList.stream().map(InvLotCommon27InVO::getSalSoDId).distinct().collect(Collectors.toList());
        Assert.notNull(collect, (String)"\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3anull");
        Assert.notNull(collect.get(0), (String)"\u8ba2\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3anull");
        return null;
    }

    @Transactional
    public String invStkAllocSalSo(List<InvLotCommon27InVO> inVOList) {
        List collect = inVOList.stream().map(InvLotCommon27InVO::getSalSoDId).distinct().collect(Collectors.toList());
        Assert.notNull(collect, (String)"\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3anull");
        Assert.notNull(collect.get(0), (String)"\u8ba2\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3anull");
        return null;
    }

    @Transactional
    public void invStkAllocByPerson(List<InvLotCommon27InVO> inVOList) {
        log.info("\u5171\u901a\u65b9\u6cd527\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", inVOList.stream().map(InvLotCommon27InVO::toString).collect(Collectors.toList())));
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(inVOList);
        if (validResult.isError()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\u3010\u5ba2\u6237ID\u3001\u914d\u8d27\u6570\u91cf\u3001\u5355\u636e\u53f7\u3001\u884c\u53f7\u3001\u9500\u552e\u8ba2\u5355\u660e\u7ec6ID\u3001\u9500\u552e\u8ba2\u5355ID\u3001\u9500\u552e\u8ba2\u5355\u6765\u6e90\u3001\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inVOList.stream().filter(i -> (i.getRoId() != null || i.getRoDid() != null || !StringUtils.isEmpty((Object)i.getRoNo())) && i.getInvStkId() != null).count() > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u9884\u7559\u5355ID\u3001\u9884\u7559\u5355\u5355\u53f7\u3001\u9884\u7559\u5355\u660e\u7ec6ID\u4e0e\u5e93\u5b58ID\u4e0d\u80fd\u540c\u65f6\u5b58\u5728");
        }
        if (inVOList.stream().filter(i -> (i.getRoId() == null || i.getRoDid() == null || StringUtils.isEmpty((Object)i.getRoNo())) && i.getInvStkId() == null).count() > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u9884\u7559\u5355\u914d\u8d27\u65f6\uff0c\u9884\u7559\u5355ID\u3001\u9884\u7559\u5355\u5355\u53f7\u3001\u9884\u7559\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inVOList.stream().filter(i -> i.getAdjustQty() == null).count() > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u914d\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        inVOList.forEach(i -> i.setAdjustQty(Double.valueOf(Math.abs(i.getAdjustQty()))));
        inVOList = inVOList.stream().filter(i -> i.getAdjustQty().compareTo(0.0) != 0).collect(Collectors.toList());
        List<String> errMsgList = Collections.synchronizedList(new ArrayList());
        List<InvLotCommon27InVO> hasRoNoList = inVOList.stream().filter(i -> !StringUtils.isEmpty((Object)i.getRoNo())).collect(Collectors.toList());
        CompletableFuture<Void> hasRoNoFuture = CompletableFuture.runAsync(() -> this.doHasRoNoProcess(hasRoNoList, errMsgList));
        List<InvLotCommon27InVO> noRoNoList = inVOList.stream().filter(i -> !StringUtils.isEmpty((Object)i.getInvStkId())).collect(Collectors.toList());
        this.doNoRoNoProcess(noRoNoList, errMsgList);
        try {
            CompletableFuture.allOf(hasRoNoFuture).get();
            if (!CollectionUtils.isEmpty(errMsgList)) {
                throw new BusinessException(ApiCode.SPRING_BOOT_PLUS_EXCEPTION, errMsgList.stream().collect(Collectors.joining(",")));
            }
            this.doCommon27Process(hasRoNoList, noRoNoList);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BusinessException(ApiCode.SPRING_BOOT_PLUS_EXCEPTION, CollectionUtils.isEmpty(errMsgList) ? e.getMessage() : errMsgList.stream().collect(Collectors.joining(",")));
        }
    }

    @SysCodeProc
    public List<InvLotStkCommon24And30VO> distManualStk(List<InvLotStkCommon24And30InParam> params) {
        ArrayList inVOList = new ArrayList();
        List<InvLotStkCommon24InVO> invLotStkCommon24InVOS = params.stream().map(v -> {
            InvLotStkCommon24InVO invLotStkCommon24InVO = new InvLotStkCommon24InVO();
            BeanUtils.copyProperties((Object)v, (Object)invLotStkCommon24InVO);
            invLotStkCommon24InVO.setLotStatus("0");
            return invLotStkCommon24InVO;
        }).collect(Collectors.toList());
        List invRoCommon30InVOS = params.stream().map(v -> {
            InvRoCommon30InVO invRoCommon30InVO = new InvRoCommon30InVO();
            BeanUtils.copyProperties((Object)v, (Object)invRoCommon30InVO);
            return invRoCommon30InVO;
        }).collect(Collectors.toList());
        Map<Integer, List<InvLotStkCommon24OutVO>> common24ResultMap = this.invLotStkQuery(invLotStkCommon24InVOS);
        Map common30ResultMap = this.invRoCommonService.invRoDListQuery(invRoCommon30InVOS);
        Set<Map.Entry<Integer, List<InvLotStkCommon24OutVO>>> common24Result = common24ResultMap.entrySet();
        List<Object> invLotStkCommon24OutVOS = new ArrayList();
        for (Map.Entry<Integer, List<InvLotStkCommon24OutVO>> entry : common24Result) {
            invLotStkCommon24OutVOS.addAll((Collection)entry.getValue());
        }
        invLotStkCommon24OutVOS = invLotStkCommon24OutVOS.stream().sorted(Comparator.comparing(InvLotStkCommon24OutVO::getManuDate, Comparator.nullsLast(LocalDateTime::compareTo))).collect(Collectors.toList());
        List collect = invLotStkCommon24OutVOS.stream().filter(Objects::nonNull).map(v -> {
            InvLotStkCommon24And30VO invLotStkCommon24And30VO = new InvLotStkCommon24And30VO();
            BeanUtils.copyProperties((Object)v, (Object)invLotStkCommon24And30VO);
            return invLotStkCommon24And30VO;
        }).collect(Collectors.toList());
        inVOList.addAll(collect);
        Set common30Result = common30ResultMap.entrySet();
        List<Object> invRoCommon30OutVOS = new ArrayList();
        for (Map.Entry entry : common30Result) {
            invRoCommon30OutVOS.addAll((Collection)entry.getValue());
        }
        invRoCommon30OutVOS = invRoCommon30OutVOS.stream().sorted(Comparator.comparing(InvRoCommon30OutVO::getManuDate, Comparator.nullsLast(LocalDateTime::compareTo))).collect(Collectors.toList());
        List collect1 = invRoCommon30OutVOS.stream().filter(Objects::nonNull).map(v -> {
            InvLotStkCommon24And30VO invLotStkCommon24And30VO = new InvLotStkCommon24And30VO();
            BeanUtils.copyProperties((Object)v, (Object)invLotStkCommon24And30VO);
            return invLotStkCommon24And30VO;
        }).collect(Collectors.toList());
        inVOList.addAll(collect1);
        List whIds = inVOList.stream().map(InvLotStkCommon24And30VO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List whs = this.invWhService.findIdBatch(whIds);
        List<InvLotStkCommon24And30VO> collect3 = inVOList.stream().filter(v -> v.getAvalQty() != null && v.getAvalQty() > 0.0).collect(Collectors.toList());
        List collect4 = inVOList.stream().filter(v -> (v.getAvalQty() == null || v.getAvalQty() == 0.0) && v.getRoQty() != null && v.getRoQty() > 0.0).collect(Collectors.toList());
        collect4.stream().forEach(v -> v.setAvalQty(v.getRoQty()));
        collect3.addAll(collect4);
        collect3.stream().forEach(v -> {
            Optional<InvWhRespVO> whOptional = whs.stream().filter(w -> v.getWhId() != null && v.getWhId().equals(w.getId())).findFirst();
            whOptional.ifPresent(w -> v.setWhName(w.getWhName()));
        });
        List querySinNoParams = collect3.stream().map(c -> {
            Long itemId = Objects.isNull(c.getItemId()) ? 0L : c.getItemId();
            String lotNo = StringUtils.isEmpty((Object)c.getLotNo()) ? "0" : c.getLotNo();
            return itemId + "_" + lotNo;
        }).collect(Collectors.toList());
        List invLotVos = this.invLotService.findListByAndItemIdAndLotNo(querySinNoParams);
        if (!CollectionUtils.isEmpty((Collection)invLotVos)) {
            Map<String, InvLotRespVO> invLotVosMap = invLotVos.stream().collect(Collectors.toMap(s -> s.getItemId() + "_" + s.getLotNo(), s -> s));
            collect3.stream().forEach(c -> {
                InvLotRespVO invLotVO = (InvLotRespVO)invLotVosMap.get(c.getItemId() + "_" + c.getLotNo());
                if (Objects.nonNull(invLotVO)) {
                    // empty if block
                }
            });
        }
        return collect3;
    }

    private void doCommon26Process(List<InvLotCommon26InVO> inVOList) {
        List<InvLotCommon26InVO> roInVOList = inVOList.stream().filter(i -> UdcEnum.SAL_SO_ALLOC_TYPE_USE_RO.getValueCode().equals(i.getOrderType())).collect(Collectors.toList());
        List<InvLotCommon26InVO> stkInVOList = inVOList.stream().filter(i -> UdcEnum.SAL_SO_ALLOC_TYPE_RSV_OH.getValueCode().equals(i.getOrderType())).collect(Collectors.toList());
        ArrayList invRoCommon32InVOS = new ArrayList();
        ArrayList invStkCommon28InVOS = new ArrayList();
        List invRoDIdList = roInVOList.stream().map(InvLotCommon26InVO::getRoDid).distinct().collect(Collectors.toList());
        List invRoDVOList = this.invRoDService.findIdBatch(invRoDIdList);
        roInVOList.forEach(roInVO -> invRoDVOList.forEach(roDVO -> {
            if (roDVO.getId().equals(roInVO.getRoDid())) {
                InvRoCommon32InVO common32InVO = InvCommonConvert.INSTANCE.invRoDVOToInvRoCommon32InVO((InvRoDVO)roDVO);
                common32InVO.setFclFlag(Integer.valueOf(0));
                common32InVO.setFclNum(null);
                common32InVO.setMode("USE");
                common32InVO.setUsedQty(roInVO.getReturnQty());
                common32InVO.setDeducType(UdcEnum.INV_RO_USE_TYPE_CH_ALLOC.getValueCode());
                common32InVO.setSrcDocCls(roInVO.getSrcDocCls());
                common32InVO.setSrcDocId(roInVO.getSrcDocId());
                common32InVO.setSrcDocDid(roInVO.getSrcDocDid());
                common32InVO.setSrcDocNo(roInVO.getSrcDocNo());
                common32InVO.setDocNo(roDVO.getDocNo());
                invRoCommon32InVOS.add(common32InVO);
                InvStkCommon28InVO common28InVO = InvCommonConvert.INSTANCE.invRoDVOToInvStkCommon28InVO((InvRoDVO)roDVO);
                common28InVO.setQty(roInVO.getReturnQty());
                common28InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_07_02);
                common28InVO.setInvStk28Enum2(InvStk28Enum.T_TYPE_07_03);
                common28InVO.setOpDate(LocalDateTime.now());
                common28InVO.setLineNo(roInVO.getLineNo());
                common28InVO.setSrcDocCls(roInVO.getSrcDocCls());
                common28InVO.setSrcDocId(roInVO.getSrcDocId());
                common28InVO.setSrcDocDid(roInVO.getSrcDocDid());
                common28InVO.setDocNo(roInVO.getSrcDocNo());
                invStkCommon28InVOS.add(common28InVO);
            }
        }));
        List invStkIds = stkInVOList.stream().map(i -> i.getInvStkId()).collect(Collectors.toList());
        List invStkList = this.invStkCommonService.getInvStkListByIds(invStkIds);
        stkInVOList.forEach(stkInVO -> invStkList.forEach(invStk -> {
            if (invStk.getId().equals(stkInVO.getInvStkId())) {
                InvStkCommon28InVO common28InVO = InvCommonConvert.INSTANCE.invStkVOToInvStkCommon28InVO((InvStkVO)invStk);
                common28InVO.setQty(stkInVO.getReturnQty());
                common28InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_07_02);
                common28InVO.setInvStk28Enum2(null);
                common28InVO.setOpDate(LocalDateTime.now());
                common28InVO.setLineNo(stkInVO.getLineNo());
                common28InVO.setSrcDocCls(stkInVO.getSrcDocCls());
                common28InVO.setSrcDocId(stkInVO.getSrcDocId());
                common28InVO.setSrcDocDid(stkInVO.getSrcDocDid());
                common28InVO.setDocNo(stkInVO.getSrcDocNo());
                invStkCommon28InVOS.add(common28InVO);
            }
        }));
        if (!CollectionUtils.isEmpty(invRoCommon32InVOS)) {
            this.invRoCommonService.invRoDListUpdate(invRoCommon32InVOS);
        }
        if (!CollectionUtils.isEmpty(invStkCommon28InVOS)) {
            this.invStkCommonService.invStkCommon28(invStkCommon28InVOS);
        }
    }

    private List<String> doStkInVOProcess(List<InvLotCommon26InVO> stkInVOList) {
        String invIOErrMsg0 = "\u67e5\u8be2[\u5355\u636e\u7c7b\u578b\uff1a%s,\u5355\u636e\u53f7\uff1a%s]\u5e93\u5b58\u51fa\u5165\u5c65\u5386\u672a\u627e\u5230";
        String invIOErrMsg1 = "\u67e5\u8be2\u6279\u6b21[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u5e93\u5b58\u51fa\u5165\u5c65\u5386\u672a\u627e\u5230";
        String invIOErrMsg2 = "\u67e5\u8be2\u6279\u6b21[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u5e93\u5b58\u51fa\u5165\u6570\u91cf\u4e0d\u8db3";
        ArrayList<String> errMsgList = new ArrayList<String>();
        InvIoQueryParam invIoQueryParam = new InvIoQueryParam();
        invIoQueryParam.setWhId(stkInVOList.get(0).getWhId());
        invIoQueryParam.setDeter1(stkInVOList.get(0).getDeter1());
        invIoQueryParam.setDeter2(stkInVOList.get(0).getDeter2());
        invIoQueryParam.setDeter3(stkInVOList.get(0).getDeter3());
        invIoQueryParam.setSrcDocCls(stkInVOList.get(0).getSrcDocCls());
        invIoQueryParam.setSrcDocId(stkInVOList.get(0).getSrcDocId());
        invIoQueryParam.setSrcDocNo(stkInVOList.get(0).getSrcDocNo());
        List invIoVOList = this.invIoService.findByParams(invIoQueryParam);
        if (CollectionUtils.isEmpty((Collection)invIoVOList)) {
            errMsgList.add(String.format(invIOErrMsg0, stkInVOList.get(0).getSrcDocCls(), stkInVOList.get(0).getSrcDocNo()));
        } else {
            stkInVOList.forEach(i -> {
                List ioVOS = invIoVOList.stream().filter(io -> (i.getItemId() + "_" + i.getVariId() + "_" + i.getLotNo() + "_" + i.getSrcDocDid()).equals(io.getItemId() + "_" + io.getVariId() + "_" + io.getLotNo() + "_" + io.getSrcDocDid())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(ioVOS)) {
                    errMsgList.add(String.format(invIOErrMsg1, i.getItemId(), i.getVariId(), i.getLotNo()));
                } else {
                    Double reduce = ioVOS.stream().map(InvIoVO::getQty).reduce(0.0, Double::sum);
                    if (reduce.compareTo(i.getReturnQty()) < 0) {
                        errMsgList.add(String.format(invIOErrMsg2, i.getItemId(), i.getVariId(), i.getLotNo()));
                    }
                }
            });
        }
        return errMsgList;
    }

    private List<String> doRoInVoProcess(List<InvLotCommon26InVO> roInVOList) {
        String roErrMsg0 = "\u67e5\u8be2[\u5355\u636e\u7c7b\u578b\uff1a%s,\u5355\u636e\u53f7\uff1a%s]\u9884\u7559\u5355\u51fa\u5165\u5c65\u5386\u672a\u627e\u5230";
        String roErrMsg1 = "\u67e5\u8be2\u6279\u6b21[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u9884\u7559\u5355\u6263\u51cf\u5c65\u5386\u672a\u627e\u5230";
        String roErrMsg2 = "\u67e5\u8be2\u6279\u6b21[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u9884\u7559\u5355\u6263\u51cf\u5c65\u5386\u6570\u91cf\u4e0d\u8db3";
        ArrayList<String> errMsgList = new ArrayList<String>();
        InvRoDeducQueryParam roDeducQueryParam = new InvRoDeducQueryParam();
        roDeducQueryParam.setSrcDocCls(roInVOList.get(0).getSrcDocCls());
        roDeducQueryParam.setSrcDocId(roInVOList.get(0).getSrcDocId());
        roDeducQueryParam.setSrcDocNo(roInVOList.get(0).getSrcDocNo());
        List roDeducVOList = this.invRoDeducService.findByParams(roDeducQueryParam);
        if (CollectionUtils.isEmpty((Collection)roDeducVOList)) {
            errMsgList.add(String.format(roErrMsg0, roInVOList.get(0).getSrcDocCls(), roInVOList.get(0).getSrcDocNo()));
        } else {
            roInVOList.forEach(i -> {
                List roDeducVOS = roDeducVOList.stream().filter(ro -> (i.getRoId() + "_" + i.getRoDid() + "_" + i.getSrcDocId() + "_" + i.getSrcDocDid()).equals(ro.getRoId() + "_" + ro.getRoDId() + "_" + ro.getSrcDocId() + "_" + ro.getSrcDocDid())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(roDeducVOS)) {
                    errMsgList.add(String.format(roErrMsg1, i.getItemId(), i.getVariId(), i.getLotNo()));
                } else {
                    Double reduce = roDeducVOS.stream().map(InvRoDeducVO::getQty).reduce(0.0, Double::sum);
                    if (reduce.compareTo(i.getReturnQty()) < 0) {
                        errMsgList.add(String.format(roErrMsg2, i.getItemId(), i.getVariId(), i.getLotNo()));
                    }
                }
            });
        }
        return errMsgList;
    }

    private void doCommon27Process(List<InvLotCommon27InVO> hasRoNoList, List<InvLotCommon27InVO> noRoNoList) {
        ArrayList invStkCommon28InVOS = new ArrayList();
        ArrayList invRoCommon32InVOS = new ArrayList();
        List roDidList = hasRoNoList.stream().map(InvLotCommon27InVO::getRoDid).distinct().collect(Collectors.toList());
        List invStkIdList = noRoNoList.stream().map(InvLotCommon27InVO::getInvStkId).distinct().collect(Collectors.toList());
        List invRoDVOS = this.invRoDService.findIdBatch(roDidList);
        List invStkList = this.invStkCommonService.getInvStkListByIds(invStkIdList);
        hasRoNoList.forEach(i -> {
            if (i.getAdjustQty().compareTo(0.0) != 0) {
                InvRoCommon32InVO invRoCommon32InVO = InvCommonConvert.INSTANCE.invLotCommon27InVOToInvRoCommon32InVO((InvLotCommon27InVO)i);
                invRoCommon32InVO.setDeducType(UdcEnum.INV_RO_USE_TYPE_SO_ALLOC.getValueCode());
                invRoCommon32InVO.setMode("USE");
                invRoCommon32InVO.setSrcDocDid(i.getSalSoDId());
                invRoCommon32InVO.setSrcDocId(i.getSalSoId());
                invRoCommon32InVO.setSrcDocNo(i.getSoDocNo());
                invRoCommon32InVO.setSrcDocCls(i.getSrcDocCls());
                invRoCommon32InVO.setDocNo(i.getRoNo());
                invRoDVOS.stream().filter(invRoDVO -> invRoDVO.getId().equals(i.getRoDid()) && invRoDVO.getMasId().equals(i.getRoId())).findAny().ifPresent(invRoDVO -> invRoCommon32InVO.setLineNo(invRoDVO.getLineNo()));
                invRoCommon32InVO.setFclFlag(Integer.valueOf(0));
                invRoCommon32InVO.setUsedQty(i.getAdjustQty());
                invRoCommon32InVOS.add(invRoCommon32InVO);
                InvStkCommon28InVO invStkCommon28InVO = InvCommonConvert.INSTANCE.invLotCommon27InVOToInvStkCommon28InVO((InvLotCommon27InVO)i);
                invStkCommon28InVO.setQty(i.getAdjustQty());
                invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_07_04);
                invStkCommon28InVO.setInvStk28Enum2(InvStk28Enum.T_TYPE_07_01);
                invStkCommon28InVO.setSrcDocDid(i.getSalSoDId());
                invStkCommon28InVO.setSrcDocId(i.getSalSoId());
                invStkCommon28InVO.setSrcDocCls(i.getSrcDocCls());
                invStkCommon28InVO.setOpDate(LocalDateTime.now());
                invStkCommon28InVO.setDocNo(i.getAllocOrderNo());
                invStkCommon28InVOS.add(invStkCommon28InVO);
            }
        });
        noRoNoList.forEach(i -> {
            if (i.getAdjustQty().compareTo(0.0) != 0) {
                InvStkCommon28InVO invStkCommon28InVO = InvCommonConvert.INSTANCE.invLotCommon27InVOToInvStkCommon28InVO((InvLotCommon27InVO)i);
                invStkCommon28InVO.setQty(i.getAdjustQty());
                invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_07_01);
                invStkCommon28InVO.setInvStk28Enum2(null);
                invStkCommon28InVO.setSrcDocDid(i.getSalSoDId());
                invStkCommon28InVO.setSrcDocId(i.getSalSoId());
                invStkCommon28InVO.setSrcDocCls(i.getSrcDocCls());
                invStkCommon28InVO.setOpDate(LocalDateTime.now());
                invStkCommon28InVO.setDocNo(i.getAllocOrderNo());
                invStkCommon28InVOS.add(invStkCommon28InVO);
            }
        });
        if (!CollectionUtils.isEmpty(invRoCommon32InVOS)) {
            this.invRoCommonService.invRoDListUpdate(invRoCommon32InVOS);
        }
        if (!CollectionUtils.isEmpty(invStkCommon28InVOS)) {
            this.invStkCommonService.invStkCommon28(invStkCommon28InVOS);
        }
    }

    private void doHasRoNoProcess(List<InvLotCommon27InVO> hasRoNoList, List<String> errMsgList) {
        List roIdList = hasRoNoList.stream().map(InvLotCommon27InVO::getRoId).distinct().collect(Collectors.toList());
        List roVOS = this.invRoService.findIdBatch(roIdList);
        List rodIdList = hasRoNoList.stream().map(InvLotCommon27InVO::getRoDid).distinct().collect(Collectors.toList());
        List invRoDVOS = this.invRoDService.findIdBatch(rodIdList);
        String roErrMsg1 = "[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u9884\u7559\u5355\u4fe1\u606f\u672a\u627e\u5230";
        String rodErrMsg2 = "[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u9884\u7559\u5355\u660e\u7ec6\u4fe1\u606f\u672a\u627e\u5230";
        String rodErrMsg3 = "[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u9884\u7559\u5355\u660e\u7ec6\u4fe1\u606f\u53ef\u7528\u91cf\u4e0d\u8db3";
        hasRoNoList.forEach(i -> {
            InvRoVO roVO = roVOS.stream().filter(invRoVO -> invRoVO.getId().equals(i.getRoId())).findAny().orElse(null);
            if (roVO == null) {
                errMsgList.add(String.format(roErrMsg1, i.getItemId(), i.getVariId(), i.getLotNo()));
            } else {
                InvRoDVO roDVO = invRoDVOS.stream().filter(invRoDVO -> invRoDVO.getMasId().equals(roVO.getId()) && invRoDVO.getId().equals(i.getRoDid())).findAny().orElse(null);
                if (roDVO == null) {
                    errMsgList.add(String.format(rodErrMsg2, i.getItemId(), i.getVariId(), i.getLotNo()));
                } else if (i.getAdjustQty() > roDVO.getQty() - roDVO.getUsedQty()) {
                    errMsgList.add(String.format(rodErrMsg3, i.getItemId(), i.getVariId(), i.getLotNo()));
                }
            }
        });
    }

    private void doNoRoNoProcess(List<InvLotCommon27InVO> noRoNoList, List<String> errMsgList) {
        List invStkIds = noRoNoList.stream().map(InvLotCommon27InVO::getInvStkId).distinct().collect(Collectors.toList());
        List invStkList = this.invStkCommonService.getInvStkListByIds(invStkIds);
        String stkErrMsg1 = "[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u5e93\u5b58\u4fe1\u606f\u672a\u627e\u5230";
        String stkErrMsg2 = "[\u5546\u54c1\uff1a%s,VARIID\uff1a%s,\u6279\u6b21\uff1a%s]\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3";
        noRoNoList.forEach(i -> {
            InvStkVO invStkVO1 = invStkList.stream().filter(invStkVO -> invStkVO.getId().equals(i.getInvStkId())).findAny().orElse(null);
            if (invStkVO1 == null) {
                errMsgList.add(String.format(stkErrMsg1, i.getItemId(), i.getVariId(), i.getLotNo()));
            } else {
                Double avalQty = invStkVO1.getAvalQty() == null ? 0.0 : invStkVO1.getAvalQty();
                if (i.getAdjustQty() > avalQty) {
                    errMsgList.add(String.format(stkErrMsg2, i.getItemId(), i.getVariId(), i.getLotNo()));
                }
            }
        });
    }

    private void doProsess(Map<InvLotCommon25InVO, List<InvLotCommon25OutVO>> resultMap, List<InvLotCommon25InVO> value) {
        for (final InvLotCommon25InVO inVO : value) {
            ApiResult validInvStkResult;
            ArrayList resultList = new ArrayList();
            if (inVO.getDemandQty() == 0.0) {
                resultMap.put(inVO, resultList);
                continue;
            }
            if (inVO.getFclFlag() == null || inVO.getFclFlag() == 0) {
                inVO.setFclFlag(Integer.valueOf(0));
                inVO.setFclNum(null);
            }
            if (StringUtils.isEmpty((Object)inVO.getSinStatus())) {
                inVO.setSinStatus("0");
            }
            List<InvLotRespVO> invLotList = this.getInvLotList(inVO.getItemId(), inVO.getVariId(), inVO.getLotNo());
            List<Long> invLotIds = invLotList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
            List<Tuple> sinQty = this.invSinRepo.findSinQty(invLotIds);
            invLotList = this.getInvLotCheckedList(inVO.getFclNum(), inVO.getSinStatus(), inVO.getFirstLotNo(), inVO.getFressTypeDays(), inVO.getAdjustDays(), null, "0", invLotList);
            if (CollectionUtils.isEmpty(invLotList)) {
                resultMap.put(inVO, resultList);
                continue;
            }
            List<Object> invRoDAllList = this.getInvRoDList(inVO.getWhId(), inVO.getCustId(), invLotList, inVO.getFclNum());
            invRoDAllList = invRoDAllList.stream().filter(i -> UdcEnum.INV_RO_STATUS_APPED.getValueCode().equals(i.getDocStatus())).collect(Collectors.toList());
            ApiResult validInvRoDResult = this.getInvRodListBy(invRoDAllList, inVO.getDemandQty(), inVO.getMaxLotNum(), inVO.getFclNum());
            Double stkDemandNum = 0.0;
            ArrayList<InvLotCommon25OutVO> inv25OutVORoDList = new ArrayList<InvLotCommon25OutVO>();
            if (validInvRoDResult.isSuccess()) {
                List validInvRoDVOList = (List)validInvRoDResult.getData();
                ArrayList<InvRoCommon32InVO> common32InVOList = new ArrayList<InvRoCommon32InVO>();
                ArrayList<InvStkCommon28InVO> common28InVOList = new ArrayList<InvStkCommon28InVO>();
                Double demandNum = inVO.getDemandQty();
                for (InvRoDVO roDVO : validInvRoDVOList) {
                    Double adjustQty;
                    InvRoCommon32InVO common32InVO = InvCommonConvert.INSTANCE.invRoDVOToInvRoCommon32InVO(roDVO);
                    common32InVO.setFclFlag(inVO.getFclFlag());
                    common32InVO.setFclNum(inVO.getFclNum());
                    common32InVO.setMode("USE");
                    common32InVO.setDeducType(UdcEnum.INV_RO_USE_TYPE_SO_ALLOC.getValueCode());
                    common32InVO.setSrcDocCls(inVO.getSrcDocCls());
                    common32InVO.setSrcDocId(inVO.getSrcDocId());
                    common32InVO.setSrcDocDid(inVO.getSrcDocDid());
                    common32InVO.setSrcDocNo(inVO.getSrcDocNo());
                    common32InVO.setDocNo(roDVO.getDocNo());
                    Double avalQty = roDVO.getQty() - roDVO.getUsedQty();
                    if (avalQty > demandNum) {
                        adjustQty = demandNum;
                    } else {
                        adjustQty = inVO.getFclFlag() == 1 ? Double.valueOf((double)((int)(avalQty / inVO.getFclNum())) * inVO.getFclNum()) : avalQty;
                        demandNum = demandNum - adjustQty;
                    }
                    if (adjustQty.compareTo(0.0) == 0) continue;
                    common32InVO.setUsedQty(adjustQty);
                    common32InVOList.add(common32InVO);
                    InvLotCommon25OutVO out = new InvLotCommon25OutVO();
                    InvLotRespVO invLotVO = invLotList.stream().filter(i -> (i.getItemId() + "_" + i.getVariId() + "_" + i.getLotNo()).equals(inVO.getItemId() + "_" + inVO.getVariId() + "_" + roDVO.getLotNo())).findAny().orElse(new InvLotRespVO());
                    out.setOrderType(UdcEnum.SAL_SO_ALLOC_TYPE_USE_RO.getValueCode());
                    out.setId(roDVO.getId());
                    out.setOuId(invLotVO.getOuId());
                    out.setInDate(invLotVO.getFirstInDate());
                    out.setManuDate(invLotVO.getManuDate());
                    out.setExpireDate(invLotVO.getExpireDate());
                    out.setUntilExpireDays(invLotVO.getUntilExpireDays());
                    out.setItemId(roDVO.getItemId());
                    out.setVariId(roDVO.getVariId());
                    out.setWhId(roDVO.getWhId());
                    out.setLotNo(roDVO.getLotNo());
                    out.setDeter1(roDVO.getDeter1());
                    out.setDeter2(roDVO.getDeter2());
                    out.setDeter3(roDVO.getDeter3());
                    out.setItemCode(inVO.getItemCode());
                    out.setWhCode(inVO.getWhCode());
                    out.setWhName(inVO.getWhName());
                    out.setDemandQty(inVO.getDemandQty());
                    out.setAllocQty(adjustQty);
                    out.setSrcDocCls(inVO.getSrcDocCls());
                    out.setSrcDocId(inVO.getSrcDocId());
                    out.setSrcDocDid(inVO.getSrcDocDid());
                    out.setSrcDocNo(inVO.getSrcDocNo());
                    inv25OutVORoDList.add(out);
                    InvStkCommon28InVO common28InVO = InvCommonConvert.INSTANCE.invRoDVOToInvStkCommon28InVO(roDVO);
                    common28InVO.setQty(adjustQty);
                    common28InVO.setLineNo(roDVO.getLineNo());
                    common28InVO.setOpDate(LocalDateTime.now());
                    common28InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_07_04);
                    common28InVO.setInvStk28Enum2(InvStk28Enum.T_TYPE_07_01);
                    common28InVO.setSrcDocCls(inVO.getSrcDocCls());
                    common28InVO.setSrcDocId(inVO.getSrcDocId());
                    common28InVO.setSrcDocDid(inVO.getSrcDocDid());
                    common28InVO.setDocNo(inVO.getAllocOrderNo());
                    common28InVOList.add(common28InVO);
                }
                this.invRoCommonService.invRoDListUpdate(common32InVOList);
                this.invStkCommonService.invStkCommon28(common28InVOList);
                if (!CollectionUtils.isEmpty(inv25OutVORoDList)) {
                    resultList.addAll(inv25OutVORoDList);
                }
                if (1 == validInvRoDResult.getCode()) {
                    resultMap.put(inVO, resultList);
                    continue;
                }
                if (2 == validInvRoDResult.getCode()) {
                    stkDemandNum = demandNum;
                }
            } else {
                stkDemandNum = inVO.getDemandQty();
            }
            if (stkDemandNum == 0.0) continue;
            ArrayList baseModels = new ArrayList();
            invLotList.forEach(i -> {
                InvBaseModel baseModel = new InvBaseModel((InvLotRespVO)i, inVO){
                    final /* synthetic */ InvLotRespVO val$i;
                    final /* synthetic */ InvLotCommon25InVO val$inVO;
                    {
                        this.val$i = invLotRespVO;
                        this.val$inVO = invLotCommon25InVO;
                        this.setItemId(this.val$i.getItemId());
                        this.setVariId(this.val$i.getVariId());
                        this.setLotNo(this.val$i.getLotNo());
                        this.setWhId(this.val$inVO.getWhId());
                        this.setDeter1(this.val$inVO.getDeter1());
                        this.setDeter2(this.val$inVO.getDeter2());
                        this.setDeter3(this.val$inVO.getDeter3());
                        this.setUom(this.val$inVO.getUom());
                    }
                };
                baseModels.add(baseModel);
            });
            List invStkList = this.invStkCommonService.getInvStkList(baseModels);
            invStkList = invStkList.stream().filter(i -> i.getAvalQty() != null && i.getAvalQty() > 0.0).collect(Collectors.toList());
            InvLotCommon21FilterVO lotCommon21FilterVO = new InvLotCommon21FilterVO(){
                {
                    this.setFirstLotNo(inVO.getFirstLotNo());
                    this.setFressTypeDays(inVO.getFressTypeDays());
                    this.setAdjustDays(inVO.getAdjustDays());
                }
            };
            lotCommon21FilterVO.setFclNum(inVO.getFclNum());
            invStkList = this.invStkCommonService.getInvStkCheckedList(invStkList, lotCommon21FilterVO);
            if (CollectionUtils.isEmpty((Collection)invStkList)) {
                resultMap.put(inVO, resultList);
                continue;
            }
            if (validInvRoDResult.isSuccess()) {
                List validInvRoDVOList = (List)validInvRoDResult.getData();
                List invRoDStkList = invStkList.stream().filter(i -> {
                    Iterator iterator = validInvRoDVOList.iterator();
                    if (iterator.hasNext()) {
                        InvRoDVO roDVO = (InvRoDVO)iterator.next();
                        if (roDVO.getItemId().equals(i.getItemId()) && (StringUtils.isEmpty((Object)i.getVariId()) ? StringUtils.isEmpty((Object)roDVO.getVariId()) : i.getVariId().equals(roDVO.getVariId())) && (StringUtils.isEmpty((Object)i.getWhId()) ? StringUtils.isEmpty((Object)roDVO.getWhId()) : i.getWhId().equals(roDVO.getWhId()))) {
                            if (!StringUtils.isEmpty((Object)roDVO.getLotNo()) && !roDVO.getLotNo().equals(i.getLotNo())) {
                                return false;
                            }
                            if (!StringUtils.isEmpty((Object)roDVO.getDeter1()) && !StringUtils.isEmpty((Object)roDVO.getDeter2())) {
                                return roDVO.getDeter1().equals(i.getDeter1()) && roDVO.getDeter2().equals(i.getDeter2());
                            }
                            if (!StringUtils.isEmpty((Object)roDVO.getDeter3())) {
                                return roDVO.getDeter3().equals(i.getDeter3());
                            }
                        }
                        return false;
                    }
                    return false;
                }).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(invRoDStkList) && inVO.getMaxLotNum() != null) {
                    resultMap.put(inVO, resultList);
                    continue;
                }
                Double allAvalQty = invRoDStkList.stream().map(i -> {
                    Double avalQty = i.getAvalQty();
                    if (inVO.getFclFlag() == 1) {
                        return (double)((int)(avalQty / inVO.getFclNum())) * inVO.getFclNum();
                    }
                    return avalQty;
                }).reduce(0.0, Double::sum);
                if (allAvalQty - stkDemandNum >= 0.0) {
                    resultMap.put(inVO, resultList);
                    continue;
                }
                if (inVO.getMaxLotNum() != null) {
                    resultMap.put(inVO, resultList);
                    continue;
                }
                invStkList.removeAll(invRoDStkList);
                stkDemandNum = stkDemandNum - allAvalQty;
            }
            if ((validInvStkResult = this.getInvStkListBy(invStkList, stkDemandNum, inVO.getMaxLotNum(), inVO.getFclNum())).isSuccess()) {
                List list = (List)validInvStkResult.getData();
            }
            resultMap.put(inVO, resultList);
        }
    }

    private List<InvLotCommon25OutVO> invStkUpdate(List<InvStkVO> invStkVOList, Double stkDemandNum, InvLotCommon25InVO inVO, List<InvLotVO> invLotList, List<?> salSoAllocDOList) {
        ArrayList<InvLotCommon25OutVO> inv25OutVOStkList = new ArrayList<InvLotCommon25OutVO>();
        for (InvStkVO invStk : invStkVOList) {
            if (stkDemandNum == 0.0) break;
            Double newAvalQty = invStk.getAvalQty();
            if (inVO.getFclFlag() == 1) {
                newAvalQty = (double)((int)(invStk.getAvalQty() / inVO.getFclNum())) * inVO.getFclNum();
            }
            Double qty = newAvalQty < stkDemandNum ? newAvalQty : stkDemandNum;
            stkDemandNum = stkDemandNum - qty;
            if (qty.compareTo(0.0) == 0) continue;
            InvStkCommon28InVO common28InVO = InvCommonConvert.INSTANCE.invStkVOToInvStkCommon28InVO(invStk);
            common28InVO.setQty(qty);
            common28InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_07_01);
            common28InVO.setInvStk28Enum2(null);
            common28InVO.setLineNo(inVO.getLineNo());
            common28InVO.setOpDate(LocalDateTime.now());
            common28InVO.setSrcDocCls(inVO.getSrcDocCls());
            common28InVO.setSrcDocId(inVO.getSrcDocId());
            common28InVO.setSrcDocDid(inVO.getSrcDocDid());
            common28InVO.setDocNo(inVO.getAllocOrderNo());
            this.invStkCommonService.invStkCommon28(Arrays.asList(common28InVO));
            InvLotCommon25OutVO out = new InvLotCommon25OutVO();
            InvLotVO invLotVO = invLotList.stream().filter(i -> (i.getItemId() + "_" + i.getVariId() + "_" + i.getLotNo()).equals(invStk.getItemId() + "_" + invStk.getVariId() + "_" + invStk.getLotNo())).findAny().orElse(new InvLotVO());
            out.setOrderType(UdcEnum.SAL_SO_ALLOC_TYPE_RSV_OH.getValueCode());
            out.setId(invStk.getId());
            out.setItemId(invStk.getItemId());
            out.setWhId(invStk.getWhId());
            out.setVariId(invStk.getVariId());
            out.setLotNo(invStk.getLotNo());
            out.setDeter1(invStk.getDeter1());
            out.setDeter2(invStk.getDeter2());
            out.setDeter3(invStk.getDeter3());
            out.setOuId(invLotVO.getOuId());
            out.setInDate(invLotVO.getFirstInDate());
            out.setManuDate(invLotVO.getManuDate());
            out.setExpireDate(invLotVO.getExpireDate());
            out.setUntilExpireDays(invLotVO.getUntilExpireDays());
            out.setSinNo(invLotVO.getSinNo());
            out.setItemCode(inVO.getItemCode());
            out.setWhCode(inVO.getWhCode());
            out.setWhName(inVO.getWhName());
            out.setWhId(inVO.getWhId());
            out.setDemandQty(inVO.getDemandQty());
            out.setAllocQty(qty);
            out.setSrcDocCls(inVO.getSrcDocCls());
            out.setSrcDocId(inVO.getSrcDocId());
            out.setSrcDocDid(inVO.getSrcDocDid());
            out.setSrcDocNo(inVO.getSrcDocNo());
            inv25OutVOStkList.add(out);
        }
        return inv25OutVOStkList;
    }

    private ApiResult getInvStkListBy(List<InvStkVO> invStkVOList, Double demandNum, Integer maxLotNum, Double fclNum) {
        if (CollectionUtils.isEmpty(invStkVOList)) {
            return ApiResult.builder().success(false).code(0).build();
        }
        invStkVOList = invStkVOList.stream().sorted(Comparator.comparing(InvStkVO::getUntilExpireDays, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
        List<List<Object>> calcValidInvStkList = InvLotStkCommonServiceImpl.calcValidInvStkList(invStkVOList);
        calcValidInvStkList = calcValidInvStkList.stream().filter(i -> i.size() > 0).filter(i -> maxLotNum == null ? true : i.size() <= maxLotNum).collect(Collectors.toList());
        List plentyList = Collections.synchronizedList(new ArrayList());
        List lackList = Collections.synchronizedList(new ArrayList());
        calcValidInvStkList.stream().forEach(i -> {
            Double totalAvalQty = i.stream().map(invS -> {
                if (fclNum == null) {
                    return invS.getAvalQty();
                }
                return (double)((int)(invS.getAvalQty() / fclNum)) * fclNum;
            }).reduce((a, b) -> a + b).get();
            if (totalAvalQty.compareTo(demandNum) >= 0) {
                plentyList.add(i);
            } else {
                lackList.add(i);
            }
        });
        if (!CollectionUtils.isEmpty(plentyList)) {
            List newPlentyList = plentyList.stream().sorted((o1, o2) -> {
                String a = o1.stream().map(o -> String.valueOf(o.getUntilExpireDays())).collect(Collectors.joining("_"));
                String b = o2.stream().map(o -> String.valueOf(o.getUntilExpireDays())).collect(Collectors.joining("_"));
                return a.compareTo(b);
            }).collect(Collectors.toList());
            return ApiResult.builder().success(true).code(1).data(newPlentyList.get(0)).build();
        }
        List newLackListList = lackList.stream().max(Comparator.comparing(o -> o.stream().map(invS -> {
            if (fclNum == null) {
                return invS.getAvalQty();
            }
            return (double)((int)(invS.getAvalQty() / fclNum)) * fclNum;
        }).reduce((a, b) -> a + b).get())).get();
        return ApiResult.builder().success(true).code(2).data((Object)newLackListList).build();
    }

    private ApiResult getInvRodListBy(List<InvRoDVO> invRoDVOList, Double demandNum, Integer maxLotNum, Double fclNum) {
        if (CollectionUtils.isEmpty(invRoDVOList)) {
            return ApiResult.builder().success(false).code(0).build();
        }
        invRoDVOList = invRoDVOList.stream().map(i -> {
            i.setUsedQty(this.setQty(i.getUsedQty()));
            i.setUsedQty2(this.setQty(i.getUsedQty2()));
            i.setQty(this.setQty(i.getQty()));
            i.setQty2(this.setQty(i.getQty2()));
            i.setRoQty(this.setQty(i.getRoQty()));
            return i;
        }).sorted(Comparator.comparing(InvRoDVO::getUntilExpireDays, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
        List<InvRoDVO> result = Collections.synchronizedList(new ArrayList());
        Double demandNumClone = (double)demandNum;
        AtomicInteger atomicInteger = new AtomicInteger(1);
        for (int i2 = 0; i2 < invRoDVOList.size(); ++i2) {
            if (!(demandNumClone > 0.0)) continue;
            InvRoDVO roDVO = (InvRoDVO)invRoDVOList.get(i2);
            Double qty = roDVO.getQty() - roDVO.getUsedQty();
            if (fclNum != null && (int)(qty / fclNum) <= 0 || maxLotNum != null && maxLotNum < atomicInteger.get()) continue;
            double v = qty - demandNumClone;
            demandNumClone = v >= 0.0 ? Double.valueOf(0.0) : (fclNum != null ? Double.valueOf(demandNumClone - (double)((int)(qty / fclNum)) * fclNum) : Double.valueOf(demandNumClone - qty));
            atomicInteger.incrementAndGet();
            result.add(roDVO);
        }
        if (demandNumClone > 0.0) {
            return ApiResult.builder().success(true).code(2).data(result).build();
        }
        return ApiResult.builder().success(true).code(1).data(result).build();
    }

    public static List<List<InvStkVO>> calcValidInvStkList(List<InvStkVO> set) {
        int size = 2 << set.size();
        ArrayList<List<InvStkVO>> powerSet = new ArrayList<List<InvStkVO>>(size);
        powerSet.add(Collections.emptyList());
        for (InvStkVO element : set) {
            int preSize = powerSet.size();
            for (int i = 0; i < preSize; ++i) {
                ArrayList<InvStkVO> combineSubset = new ArrayList<InvStkVO>((Collection)powerSet.get(i));
                combineSubset.add(element);
                powerSet.add(combineSubset);
            }
        }
        return powerSet;
    }

    private List<InvRoDVO> getInvRoDList(final Long whId, Long custId, List<InvLotRespVO> invLotList, Double fclNum) {
        List result = Collections.synchronizedList(new ArrayList());
        invLotList.parallelStream().forEach(inVO -> {
            InvRoDQueryParam queryParam = new InvRoDQueryParam((InvLotRespVO)inVO, custId){
                final /* synthetic */ InvLotRespVO val$inVO;
                final /* synthetic */ Long val$custId;
                {
                    this.val$inVO = invLotRespVO;
                    this.val$custId = l2;
                    this.setWhId(whId);
                    this.setItemId(this.val$inVO.getItemId());
                    this.setVariId(this.val$inVO.getVariId());
                    this.setLotNo(this.val$inVO.getLotNo());
                    this.setCustId(this.val$custId);
                }
            };
            List invRoDList = this.invRoDService.findByParams(queryParam);
            if (!CollectionUtils.isEmpty(invRoDList = invRoDList.stream().filter(i -> {
                Double qty = i.getQty() == null ? 0.0 : i.getQty();
                Double usedQty = i.getUsedQty() == null ? 0.0 : i.getUsedQty();
                if (qty - usedQty > 0.0) {
                    if (fclNum != null) {
                        return (int)((qty - usedQty) / fclNum) > 0;
                    }
                    return true;
                }
                return false;
            }).collect(Collectors.toList()))) {
                result.addAll(invRoDList);
            }
        });
        return result.stream().distinct().collect(Collectors.toList());
    }

    private List<InvLotRespVO> getInvLotList(final Long itemId, final Long variId, final String lotNo) {
        InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO(){
            {
                this.setItemId(itemId);
                this.setVariId(variId);
                this.setLotNo(lotNo);
            }
        };
        Map map = this.invLotCommonService.getInvLotVOList(Arrays.asList(invLotCommon21InVO));
        List vos = (List)map.get(0);
        return vos;
    }

    private List<InvLotRespVO> getInvLotCheckedList(final Double fclNum, final String sinStatus, final String firstLotNo, final Double fressTypeDays, final Double adjustDays, final String qcStatus, final String lotStatus, List<InvLotRespVO> source) {
        InvLotCommon21FilterVO lotCommon21FilterVO = new InvLotCommon21FilterVO(){
            {
                this.setFclNum(fclNum);
                this.setSinStatus(sinStatus);
                this.setFirstLotNo(firstLotNo);
                this.setFressTypeDays(fressTypeDays);
                this.setAdjustDays(adjustDays);
                this.setQcStatus(qcStatus);
                this.setLotStatus(lotStatus);
            }
        };
        List s = source.stream().map(i -> {
            InvLotRespVO vo = new InvLotRespVO();
            BeanUtils.copyProperties((Object)i, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        return this.invLotCommonService.getInvLotCheckedList(s, lotCommon21FilterVO);
    }

    private void checkIn25(List<InvLotCommon25InVO> inVOList) {
        inVOList.forEach(i -> {
            if (i.getItemId() == null && StringUtils.isEmpty((Object)i.getItemCode()) || i.getWhId() == null || i.getDemandQty() == null) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570");
            }
            if (!(!StringUtils.isEmpty((Object)i.getDeter1()) && !StringUtils.isEmpty((Object)i.getDeter2()) && StringUtils.isEmpty((Object)i.getDeter3()) || StringUtils.isEmpty((Object)i.getDeter1()) && StringUtils.isEmpty((Object)i.getDeter2()) && !StringUtils.isEmpty((Object)i.getDeter3()))) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u6e29\u5c42\u3001\u529f\u80fd\u5e93\u533a\u3001\u5ba2\u6237\u53f7 \u4e09\u8005\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u4e0d\u5b58\u5728");
            }
            if (1 == i.getFclFlag()) {
                if (i.getFclNum() == null) {
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570");
                }
                if (i.getDemandQty() % i.getFclNum() > 0.0) {
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u8981\u6c42\u6570\u91cf\u5fc5\u987b\u4e3a\u7bb1\u88c5\u6570\u7684\u6574\u6570\u500d");
                }
            }
        });
    }

    private Double setQty(Double qty) {
        return qty == null ? 0.0 : qty;
    }

    public InvLotStkCommonServiceImpl(InvWhService invWhService, InvRoService invRoService, InvRoDService invRoDService, InvRoDeducService invRoDeducService, InvIoService invIoService, InvLotCommonService invLotCommonService, InvRoCommonService invRoCommonService, InvStkCommonService invStkCommonService, InvLotService invLotService, InvSinRepo invSinRepo, InvSinDRepo invSinDRepo, InvStkService invStkService) {
        this.invWhService = invWhService;
        this.invRoService = invRoService;
        this.invRoDService = invRoDService;
        this.invRoDeducService = invRoDeducService;
        this.invIoService = invIoService;
        this.invLotCommonService = invLotCommonService;
        this.invRoCommonService = invRoCommonService;
        this.invStkCommonService = invStkCommonService;
        this.invLotService = invLotService;
        this.invSinRepo = invSinRepo;
        this.invSinDRepo = invSinDRepo;
        this.invStkService = invStkService;
    }
}

