/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvRoConvert;
import com.elitesland.inv.convert.InvRoDConvert;
import com.elitesland.inv.entity.InvRoDDO;
import com.elitesland.inv.entity.InvRoDO;
import com.elitesland.inv.entity.InvRoDeducDO;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.param.InvRoCreateParam;
import com.elitesland.inv.param.InvRoDCreateParam;
import com.elitesland.inv.param.InvRoDQueryParam;
import com.elitesland.inv.repo.InvRoDRepo;
import com.elitesland.inv.repo.InvRoDeducRepo;
import com.elitesland.inv.repo.InvRoRepo;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvRoCommonService;
import com.elitesland.inv.service.InvRoDService;
import com.elitesland.inv.service.InvRoDeducService;
import com.elitesland.inv.service.InvRoService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvLotCommon21FilterVO;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvRoCommon30OutVO;
import com.elitesland.inv.vo.InvRoCommon31InVO;
import com.elitesland.inv.vo.InvRoCommon32InVO;
import com.elitesland.inv.vo.InvRoCommon32OutVO;
import com.elitesland.inv.vo.InvRoDVO;
import com.elitesland.inv.vo.InvRoVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.util.ValidationUtil;
import com.google.common.util.concurrent.AtomicDouble;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invRoDCommonService")
public class InvRoCommonServiceImpl
implements InvRoCommonService {
    private static final Logger log = LoggerFactory.getLogger(InvRoCommonServiceImpl.class);
    private final Object $lock = new Object[0];
    private static final String INV_COMMON_ERR_MSG = "\u5546\u54c1ID:%s,\u5f02\u6784ID:%s,\u6279\u6b21\u53f7:%s(%s)";
    private static final String INV_COMMON_SUC_MSG = "\u884c\u53f7:%s,\u5546\u54c1ID:%s,\u5f02\u6784ID:%s,\u6279\u6b21\u53f7:%s(\u6210\u529f)";
    private final InvRoService invRoService;
    private final InvRoRepo invRoRepo;
    private final InvRoDService invRoDService;
    private final InvRoDRepo invRoDRepo;
    private final InvRoDeducService invRoDeducService;
    private final InvRoDeducRepo invRoDeducRepo;
    private final InvStkCommonService invStkCommonService;
    private final InvLotCommonService invLotCommonService;
    private final InvWhService invWhService;
    private final InvLotService invLotService;
    private final String UPDATE = "UPDATE";
    private final String USE = "USE";
    private final String RELEASE = "RELEASE";

    public Map<Integer, List<InvRoCommon30OutVO>> invRoDListQuery(List<InvRoCommon30InVO> common30InVOList) {
        log.info("\u5171\u901a\u65b9\u6cd530\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", common30InVOList.stream().map(InvRoCommon30InVO::toString).collect(Collectors.toList())));
        Map<Integer, List<InvRoCommon30OutVO>> result = Collections.synchronizedMap(new HashMap());
        common30InVOList.parallelStream().forEach(inVO -> {
            List<InvRoDVO> checkInvRoDList = this.getCheckInvRoDList((InvRoCommon30InVO)inVO);
            if (!CollectionUtils.isEmpty(checkInvRoDList)) {
                ArrayList outVOS = new ArrayList();
                checkInvRoDList.forEach(i -> {
                    InvRoCommon30OutVO invRoCommon30OutVO = InvCommonConvert.INSTANCE.invRoDVOToInvRoCommon30OutVO((InvRoDVO)i);
                    invRoCommon30OutVO.setRoId(i.getMasId());
                    invRoCommon30OutVO.setRoDId(i.getId());
                    invRoCommon30OutVO.setApprProcInstId(i.getApprProcInstId());
                    outVOS.add(invRoCommon30OutVO);
                });
                result.put(common30InVOList.indexOf(inVO), outVOS);
            } else {
                result.put(common30InVOList.indexOf(inVO), Collections.EMPTY_LIST);
            }
        });
        return result;
    }

    @Transactional
    public Long invRoDListSave(InvRoCommon31InVO invRoCommon31InVO) {
        log.info("\u5171\u901a\u65b9\u6cd531\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)(invRoCommon31InVO == null ? null : invRoCommon31InVO.toString()));
        InvRoCreateParam invRoCreateParam = invRoCommon31InVO.getInvRoCreateParam();
        Map<InvRoDCreateParam, InvStkVO> map = this.saveCheckIn(invRoCreateParam, invRoCommon31InVO.getInvRoDCreateParamList());
        InvRoDO invRoDO = InvRoConvert.INSTANCE.invRoCreateParamToInvRoDO(invRoCreateParam);
        invRoDO.setDocType(UdcEnum.COM_DOC_CLS_RO.getValueCode());
        invRoDO.setDocStatus(UdcEnum.INV_RO_STATUS_DR.getValueCode());
        Long id = ((InvRoDO)this.invRoRepo.save(invRoDO)).getId();
        AtomicDouble lineNo = new AtomicDouble(0.0);
        map.forEach((key, value) -> {
            InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.invRoDCreateParamToInvRoDO((InvRoDCreateParam)key);
            invRoDDO.setMasId(id);
            if (invRoDDO.getId() < 0L) {
                invRoDDO.setId(null);
            }
            invRoDDO.setLineNo(lineNo.addAndGet(1.0));
            this.invRoDRepo.save(invRoDDO);
            this.updateInvStk((InvStkVO)value, key.getQty(), InvStk28Enum.T_TYPE_10, UdcEnum.COM_DOC_CLS_RO.getValueCode(), invRoDDO.getMasId(), invRoDDO.getId(), invRoDDO.getLineNo(), invRoDO.getDocNo());
        });
        return id;
    }

    public void lockInvStk2(String bussKey) {
        ArrayList errMsg = new ArrayList();
        HashMap<InvRoDCreateParam, InvStkVO> map = new HashMap<InvRoDCreateParam, InvStkVO>();
        List invRoDVOS = this.invRoDService.findByApplyNo(bussKey);
        List<InvRoDDO> invRoDDOS = invRoDVOS.stream().map(InvRoDConvert.INSTANCE::voToDO).collect(Collectors.toList());
        invRoDDOS.forEach(i -> {
            InvBaseModel invBaseModel = new InvBaseModel();
            invBaseModel.setItemId(i.getItemId());
            invBaseModel.setVariId(i.getVariId());
            invBaseModel.setWhId(i.getWhId());
            invBaseModel.setLotNo(i.getLotNo());
            invBaseModel.setDeter1(i.getDeter1());
            invBaseModel.setDeter2(i.getDeter2());
            invBaseModel.setUom(i.getUom());
            InvStkVO stkVO = this.invStkCommonService.getInvStk(invBaseModel);
            if (stkVO == null) {
                errMsg.add(String.format(INV_COMMON_ERR_MSG, i.getItemId(), i.getVariId(), i.getLotNo(), "\u672a\u627e\u5230\u5e93\u5b58\u4fe1\u606f"));
            } else {
                Double avalQty = stkVO.getAvalQty() == null ? 0.0 : stkVO.getAvalQty();
                double v = i.getQty() - i.getRoFirstQty();
                if (avalQty < v) {
                    errMsg.add(String.format(INV_COMMON_ERR_MSG, i.getItemId(), i.getVariId(), i.getLotNo(), "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3"));
                }
                InvRoDCreateParam invRoDCreateParam = (InvRoDCreateParam)BeanUtil.copyProperties((Object)i, InvRoDCreateParam.class);
                invRoDCreateParam.setQty(Double.valueOf(v));
                map.put(invRoDCreateParam, stkVO);
            }
            i.setRoFirstQty(i.getQty());
        });
        if (!CollectionUtils.isEmpty(errMsg)) {
            map.clear();
            throw new BusinessException(errMsg.stream().collect(Collectors.joining(",")));
        }
        this.invRoDRepo.saveAll(invRoDDOS);
        map.forEach((key, value) -> {
            InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.invRoDCreateParamToInvRoDO((InvRoDCreateParam)key);
            this.updateInvStk((InvStkVO)value, key.getQty(), InvStk28Enum.T_TYPE_10, UdcEnum.COM_DOC_CLS_RO.getValueCode(), invRoDDO.getMasId(), invRoDDO.getId(), invRoDDO.getLineNo(), invRoDDO.getDocNo());
        });
    }

    public void lockInvStk(Long id) {
        InvRoDQueryParam param = new InvRoDQueryParam();
        param.setMasId(id);
        InvRoCommon31InVO createParam = new InvRoCommon31InVO();
        Optional ret = this.invRoRepo.findById(id);
        ret.ifPresent(w -> {
            List invRoDs = this.invRoDService.findByParams(param);
            InvRoCreateParam invRoCreateParam = (InvRoCreateParam)BeanUtil.copyProperties((Object)w, InvRoCreateParam.class);
            invRoCreateParam.setDocStatus(UdcEnum.INV_RO_STATUS_APPED.getValueCode());
            createParam.setInvRoCreateParam(invRoCreateParam);
            createParam.setInvRoDCreateParamList(invRoDs.stream().map(v -> (InvRoDCreateParam)BeanUtil.copyProperties((Object)v, InvRoDCreateParam.class)).collect(Collectors.toList()));
            Map<InvRoDCreateParam, InvStkVO> map = this.saveCheckIn(createParam.getInvRoCreateParam(), createParam.getInvRoDCreateParamList());
            map.forEach((key, value) -> {
                InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.invRoDCreateParamToInvRoDO((InvRoDCreateParam)key);
                this.updateInvStk((InvStkVO)value, key.getQty(), InvStk28Enum.T_TYPE_10, UdcEnum.COM_DOC_CLS_RO.getValueCode(), invRoDDO.getMasId(), invRoDDO.getId(), invRoDDO.getLineNo(), invRoDDO.getDocNo());
            });
        });
    }

    public void lockInvStkNew(List<InvRoDVO> invRoDVOS) {
        ArrayList errMsg = new ArrayList();
        HashMap<InvRoDCreateParam, InvStkVO> map = new HashMap<InvRoDCreateParam, InvStkVO>();
        invRoDVOS.forEach(i -> {
            InvBaseModel invBaseModel = new InvBaseModel();
            invBaseModel.setItemId(i.getItemId());
            invBaseModel.setVariId(i.getVariId());
            invBaseModel.setWhId(i.getWhId());
            invBaseModel.setLotNo(i.getLotNo());
            invBaseModel.setDeter1(i.getDeter1());
            invBaseModel.setDeter2(i.getDeter2());
            invBaseModel.setUom(i.getUom());
            InvStkVO stkVO = this.invStkCommonService.getInvStk(invBaseModel);
            if (stkVO == null) {
                errMsg.add(String.format(INV_COMMON_ERR_MSG, i.getItemId(), i.getVariId(), i.getLotNo(), "\u672a\u627e\u5230\u5e93\u5b58\u4fe1\u606f"));
            } else {
                Double avalQty = stkVO.getAvalQty() == null ? 0.0 : stkVO.getAvalQty();
                double v = i.getQty() - i.getRoFirstQty();
                if (avalQty < v) {
                    errMsg.add(String.format(INV_COMMON_ERR_MSG, i.getItemId(), i.getVariId(), i.getLotNo(), "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3"));
                }
                InvRoDCreateParam invRoDCreateParam = (InvRoDCreateParam)BeanUtil.copyProperties((Object)i, InvRoDCreateParam.class);
                invRoDCreateParam.setQty(Double.valueOf(v));
                map.put(invRoDCreateParam, stkVO);
            }
        });
        if (!CollectionUtils.isEmpty(errMsg)) {
            map.clear();
            throw new BusinessException(errMsg.stream().collect(Collectors.joining(",")));
        }
        map.forEach((key, value) -> {
            InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.invRoDCreateParamToInvRoDO((InvRoDCreateParam)key);
            this.updateInvStk((InvStkVO)value, key.getQty(), InvStk28Enum.T_TYPE_10, UdcEnum.COM_DOC_CLS_RO.getValueCode(), invRoDDO.getMasId(), invRoDDO.getId(), invRoDDO.getLineNo(), invRoDDO.getDocNo());
        });
    }

    @Transactional
    public List<InvRoCommon32OutVO> invRoDListUpdate(List<InvRoCommon32InVO> common32InVOList) {
        log.info("\u5171\u901a\u65b9\u6cd532\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", common32InVOList.stream().map(InvRoCommon32InVO::toString).collect(Collectors.toList())));
        if (CollectionUtils.isEmpty(common32InVOList)) {
            return Collections.emptyList();
        }
        this.checkIn(common32InVOList);
        String mode = common32InVOList.stream().map(InvRoCommon32InVO::getMode).distinct().findAny().get();
        ArrayList<InvRoCommon32OutVO> resultList = new ArrayList<InvRoCommon32OutVO>();
        HashMap<InvRoCommon32InVO, Map> infoMap = new HashMap<InvRoCommon32InVO, Map>();
        common32InVOList.forEach(i -> {
            InvRoVO invRoVO = (InvRoVO)this.invRoService.findCodeOne(i.getDocNo()).get();
            InvRoDVO invRoDVO = this.invRoDService.findByDocNo(i.getDocNo()).stream().filter(roDVO -> StringUtils.isEmpty((Object)i.getLineNo()) ? StringUtils.isEmpty((Object)roDVO.getLineNo()) : i.getLineNo().equals(roDVO.getLineNo())).findAny().orElse(null);
            InvRoDO invRoDO = InvRoConvert.INSTANCE.voToDO(invRoVO);
            InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.voToDO(invRoDVO);
            ArrayList<String> errMsgList = new ArrayList<String>();
            Object invStk = null;
            this.selectMode((List<String>)errMsgList, (InvStkVO)invStk, invRoDDO, mode, (InvRoCommon32InVO)i);
            if (errMsgList.size() == 0) {
                HashMap<String, BaseModel> map = new HashMap<String, BaseModel>();
                map.put("ro", invRoDO);
                map.put("roD", invRoDDO);
                map.put("stk", (BaseModel)invStk);
                infoMap.put((InvRoCommon32InVO)i, map);
            } else {
                resultList.add(this.recordError((InvRoCommon32InVO)i, errMsgList.stream().collect(Collectors.joining(","))));
                infoMap.clear();
            }
        });
        if (resultList.size() == 0) {
            if ("UPDATE".equals(mode)) {
                infoMap.forEach((key, value) -> {
                    this.updated((InvRoCommon32InVO)key, (InvRoDO)value.get("ro"), (InvRoDDO)value.get("roD"), (InvStkVO)value.get("stk"));
                    resultList.add(this.recordSuccess((InvRoCommon32InVO)key));
                });
            } else if ("USE".equals(mode)) {
                infoMap.forEach((key, value) -> {
                    this.used((InvRoCommon32InVO)key, (InvRoDO)value.get("ro"), (InvRoDDO)value.get("roD"));
                    resultList.add(this.recordSuccess((InvRoCommon32InVO)key));
                });
            } else if ("RELEASE".equals(mode)) {
                infoMap.forEach((key, value) -> {
                    this.released((InvRoCommon32InVO)key, (InvRoDO)value.get("ro"), (InvRoDDO)value.get("roD"), (InvStkVO)value.get("stk"));
                    resultList.add(this.recordSuccess((InvRoCommon32InVO)key));
                });
            }
        }
        return resultList;
    }

    public void selectMode(List<String> errMsgList, InvStkVO invStk, InvRoDDO invRoDDO, String mode, final InvRoCommon32InVO i) {
        if ("UPDATE".equals(mode)) {
            if (invRoDDO != null) {
                invStk = this.getInvStk(invRoDDO);
            } else {
                InvRoDDO temp = new InvRoDDO(){
                    {
                        this.setItemId(i.getItemId());
                        this.setVariId(i.getVariId());
                        this.setLotNo(i.getLotNo());
                        this.setWhId(i.getWhId());
                        this.setDeter1(i.getDeter1());
                        this.setDeter2(i.getDeter2());
                        this.setDeter3(i.getDeter3());
                        this.setUom(i.getUom());
                    }
                };
                invStk = this.getInvStk(temp);
            }
            if (invStk == null) {
                errMsgList.add("\u672a\u627e\u5230\u5e93\u5b58");
            } else {
                Double avalQty;
                Double adjustQty = i.getQty() - (invRoDDO == null ? 0.0 : invRoDDO.getQty());
                Double ohQty = invStk.getOhQty() == null ? 0.0 : invStk.getOhQty();
                if (ohQty < adjustQty) {
                    errMsgList.add("\u5e93\u5b58\u73b0\u6709\u91cf\u4e0d\u8db3");
                }
                if ((avalQty = Double.valueOf(invStk.getAvalQty() == null ? 0.0 : invStk.getAvalQty())) < adjustQty) {
                    errMsgList.add("\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3");
                }
            }
        } else if ("USE".equals(mode)) {
            if (this.setQty(invRoDDO.getQty()) - this.setQty(invRoDDO.getUsedQty()) - this.setQty(invRoDDO.getRoNowQty()) < i.getUsedQty()) {
                errMsgList.add("\u9884\u7559\u5355\u53ef\u7528\u6570\u91cf\u4e0d\u8db3");
            }
        } else if ("RELEASE".equals(mode) && (invStk = this.getInvStk(invRoDDO)) == null) {
            errMsgList.add("\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
    }

    private InvStkVO getInvStk(InvRoDDO invRoDDO) {
        InvBaseModel invStkQueryParam = new InvBaseModel();
        invStkQueryParam.setItemId(invRoDDO.getItemId());
        invStkQueryParam.setVariId(invRoDDO.getVariId());
        invStkQueryParam.setLotNo(invRoDDO.getLotNo());
        invStkQueryParam.setWhId(invRoDDO.getWhId());
        invStkQueryParam.setDeter1(invRoDDO.getDeter1());
        invStkQueryParam.setDeter2(invRoDDO.getDeter2());
        invStkQueryParam.setDeter3(invRoDDO.getDeter3());
        invStkQueryParam.setUom(invRoDDO.getUom());
        return this.invStkCommonService.getInvStk(invStkQueryParam);
    }

    private InvRoCommon32OutVO recordSuccess(InvRoCommon32InVO inVO) {
        InvRoCommon32OutVO outVO = new InvRoCommon32OutVO();
        outVO.setItemId(inVO.getItemId());
        outVO.setVariId(inVO.getVariId());
        outVO.setLotNo(inVO.getLotNo());
        outVO.setLineNo(inVO.getLineNo());
        outVO.setMsg(String.format(INV_COMMON_SUC_MSG, inVO.getLineNo(), inVO.getItemId(), inVO.getVariId(), inVO.getLotNo()));
        outVO.setSuccess(true);
        return outVO;
    }

    private InvRoCommon32OutVO recordError(InvRoCommon32InVO inVO, String errMsg) {
        InvRoCommon32OutVO outVO = new InvRoCommon32OutVO();
        outVO.setItemId(inVO.getItemId());
        outVO.setVariId(inVO.getVariId());
        outVO.setLotNo(inVO.getLotNo());
        outVO.setLineNo(inVO.getLineNo());
        outVO.setMsg(String.format(INV_COMMON_ERR_MSG, inVO.getItemId(), inVO.getVariId(), inVO.getLotNo(), errMsg));
        outVO.setSuccess(false);
        return outVO;
    }

    private void updateInvStk(InvStkVO invStkVO, Double qty, InvStk28Enum invStk28Enum, String srcDocCls, Long srcDocId, Long srcDocDid, Double lineNo, String docNo) {
        InvStkCommon28InVO common28InVO = InvCommonConvert.INSTANCE.invStkVOToInvStkCommon28InVO(invStkVO);
        common28InVO.setQty(qty);
        common28InVO.setInvStk28Enum1(invStk28Enum);
        common28InVO.setInvStk28Enum2(null);
        common28InVO.setLineNo(lineNo);
        common28InVO.setOpDate(LocalDateTime.now());
        common28InVO.setSrcDocCls(srcDocCls);
        common28InVO.setSrcDocId(srcDocId);
        common28InVO.setSrcDocDid(srcDocDid);
        common28InVO.setDocNo(docNo);
        this.invStkCommonService.invStkCommon28(Arrays.asList(common28InVO));
    }

    private List<InvRoDVO> getCheckInvRoDList(final InvRoCommon30InVO inVO) {
        if (!StringUtils.isEmpty((Object)inVO.getBrandCode())) {
            // empty if block
        }
        InvRoDQueryParam queryParam = new InvRoDQueryParam(){
            {
                this.setApplyDateS(inVO.getApplyDateS());
                this.setApplyDateE(inVO.getApplyDateE());
                this.setRsvDueDateS(inVO.getRsvDueDateS());
                this.setRsvDueDateE(inVO.getRsvDueDateE());
                this.setApplyEmpId(inVO.getApplyEmpId());
                this.setApplyNo(inVO.getApplyNo());
                this.setWhId(inVO.getWhId());
                this.setItemId(inVO.getItemId());
                this.setVariId(inVO.getVariId());
                this.setLotNo(inVO.getLotNo());
                this.setDeter1(inVO.getDeter1());
                this.setDeter2(inVO.getDeter2());
                this.setDeter3(inVO.getDeter3());
                this.setCustId(inVO.getCustId());
                this.setDocNo(inVO.getDocNo());
                this.setDocStatus(inVO.getDocStatus());
                this.setDocStatusList(inVO.getDocStatusList());
            }
        };
        if (!CollectionUtils.isEmpty((Collection)inVO.getDocStatusList()) && inVO.getDocStatusList().contains(UdcEnum.INV_RO_STATUS_RL.getValueCode())) {
            queryParam.setRlStatusFlag(Boolean.valueOf(false));
        } else {
            queryParam.setRlStatusFlag(inVO.getRlStatusFlag());
        }
        List invRoDList = this.invRoDService.findByParamsNew(queryParam);
        if (CollectionUtils.isEmpty((Collection)invRoDList)) {
            return Collections.EMPTY_LIST;
        }
        this.filterInvRoDList(inVO, invRoDList);
        if (!StringUtils.isEmpty((Object)inVO.getBrandCode()) && !CollectionUtils.isEmpty((Collection)invRoDList)) {
            List list = invRoDList.stream().map(InvRoDVO::getItemId).distinct().collect(Collectors.toList());
        }
        this.setOtherFields(invRoDList);
        return invRoDList;
    }

    public void filterInvRoDList(final InvRoCommon30InVO inVO, List<InvRoDVO> invRoDList) {
        if (!StringUtils.isEmpty((Object)inVO.getQty())) {
            invRoDList = invRoDList.stream().filter(i -> {
                Double q = (i.getQty() == null ? 0.0 : i.getQty()) - (i.getUsedQty() == null ? 0.0 : i.getUsedQty());
                if ("=".equals(inVO.getOpType())) {
                    return q.compareTo(inVO.getQty()) == 0;
                }
                if ("<".equals(inVO.getOpType())) {
                    return q.compareTo(inVO.getQty()) < 0;
                }
                if (">".equals(inVO.getOpType())) {
                    return q.compareTo(inVO.getQty()) > 0;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (!StringUtils.isEmpty((Object)inVO.getFirstLotNo())) {
            invRoDList = invRoDList.stream().filter(i -> inVO.getFirstLotNo().compareTo(i.getLotNo()) < 0).collect(Collectors.toList());
        }
        if (!(CollectionUtils.isEmpty(invRoDList) || StringUtils.isEmpty((Object)inVO.getFirstLotNo()) && inVO.getFressTypeDays() == null && inVO.getAdjustDays() == null && inVO.getMaxLotNum() == null && StringUtils.isEmpty((Object)inVO.getFressType()) && StringUtils.isEmpty((Object)inVO.getLotStatus()))) {
            List queryLotParams = Collections.synchronizedList(new ArrayList());
            invRoDList.parallelStream().forEach(i -> {
                InvLotCommon21InVO queryLotParam = new InvLotCommon21InVO((InvRoDVO)i){
                    final /* synthetic */ InvRoDVO val$i;
                    {
                        this.val$i = invRoDVO;
                        this.setItemId(this.val$i.getItemId());
                        this.setVariId(this.val$i.getVariId());
                        this.setLotNo(this.val$i.getLotNo());
                    }
                };
                queryLotParams.add(queryLotParam);
            });
            Map invLotVOMap = this.invLotCommonService.getInvLotVOList(queryLotParams);
            List<Object> invLotVoList = new ArrayList();
            for (Integer key : invLotVOMap.keySet()) {
                List invLotVOS = (List)invLotVOMap.get(key);
                invLotVoList.addAll(invLotVOS);
            }
            invLotVoList = invLotVoList.stream().distinct().collect(Collectors.toList());
            InvLotCommon21FilterVO lotCommon21FilterVO = new InvLotCommon21FilterVO(){
                {
                    this.setFirstLotNo(inVO.getFirstLotNo());
                    this.setFressTypeDays(inVO.getFressTypeDays());
                    this.setAdjustDays(inVO.getAdjustDays());
                    this.setMaxLotNum(inVO.getMaxLotNum());
                    this.setFressType(inVO.getFressType());
                    this.setLotStatus(inVO.getLotStatus());
                }
            };
            List invLotCheckedList = this.invLotCommonService.getInvLotCheckedList(invLotVoList, lotCommon21FilterVO);
            if (!StringUtils.isEmpty((Object)inVO.getFressTypeDays()) && StringUtils.isEmpty((Object)inVO.getAdjustDays())) {
                invLotCheckedList = invLotCheckedList.stream().filter(i -> {
                    Double untilExpireDays = i.getUntilExpireDays().doubleValue();
                    return untilExpireDays.compareTo(inVO.getFressTypeDays()) == 0;
                }).collect(Collectors.toList());
            }
            List finalInvLotCheckedList = invLotCheckedList;
            invRoDList = invRoDList.stream().filter(i -> {
                List collect = finalInvLotCheckedList.stream().filter(lot -> (StringUtils.isEmpty((Object)i.getItemId()) ? StringUtils.isEmpty((Object)lot.getItemId()) : i.getItemId().equals(lot.getItemId())) && (StringUtils.isEmpty((Object)i.getVariId()) ? StringUtils.isEmpty((Object)lot.getVariId()) : i.getVariId().equals(lot.getVariId())) && (StringUtils.isEmpty((Object)i.getLotNo()) ? StringUtils.isEmpty((Object)lot.getLotNo()) : i.getLotNo().equals(lot.getLotNo()))).collect(Collectors.toList());
                return !CollectionUtils.isEmpty(collect);
            }).distinct().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void released(InvRoCommon32InVO inVO, InvRoDO invRoDO, InvRoDDO invRoDDO, InvStkVO invStkVO) {
        Object object = this.$lock;
        synchronized (object) {
            Double qty = invRoDDO.getQty() == null ? 0.0 : invRoDDO.getQty();
            Double usedQty = invRoDDO.getUsedQty() == null ? 0.0 : invRoDDO.getUsedQty();
            Double roNowQty = invRoDDO.getRoNowQty() == null ? 0.0 : invRoDDO.getRoNowQty();
            if (inVO.getRoNowQty() != null && inVO.getRoNowQty() > 0.0) {
                invRoDDO.setUsedQty(inVO.getRoNowQty() + invRoDDO.getUsedQty());
            } else {
                invRoDDO.setUsedQty(qty);
            }
            invRoDDO.setRoNowQty(0.0);
            if (invRoDDO.getQty().compareTo(invRoDDO.getUsedQty()) == 0) {
                invRoDDO.setDocStatus(UdcEnum.INV_RO_STATUS_RL.getValueCode());
            }
            this.invRoDRepo.save(invRoDDO);
            InvRoDeducDO invRoDeducDO = new InvRoDeducDO();
            invRoDeducDO.setRoId(invRoDO.getId());
            invRoDeducDO.setRoDId(invRoDDO.getId());
            invRoDeducDO.setDeducType(inVO.getDeducType());
            invRoDeducDO.setDeducTime(LocalDateTime.now());
            if (roNowQty != 0.0) {
                invRoDeducDO.setQty(roNowQty);
            } else {
                invRoDeducDO.setQty(qty - usedQty - roNowQty);
            }
            invRoDeducDO.setSrcDocCls(inVO.getSrcDocCls());
            invRoDeducDO.setSrcDocId(inVO.getSrcDocId());
            invRoDeducDO.setSrcDocNo(inVO.getSrcDocNo());
            invRoDeducDO.setSrcDocDid(inVO.getSrcDocDid());
            invRoDeducDO.setDeleteFlag(0);
            this.invRoDeducRepo.save(invRoDeducDO);
            this.updateInvStk(invStkVO, invRoDeducDO.getQty(), UdcEnum.INV_RO_USE_TYPE_OD_RELEASE.getValueCode().equals(inVO.getDeducType()) ? InvStk28Enum.T_TYPE_12 : InvStk28Enum.T_TYPE_13, UdcEnum.COM_DOC_CLS_RO.getValueCode(), invRoDDO.getMasId(), invRoDDO.getId(), invRoDDO.getLineNo(), inVO.getDocNo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void used(InvRoCommon32InVO inVO, InvRoDO invRoDO, InvRoDDO invRoDDO) {
        Object object = this.$lock;
        synchronized (object) {
            invRoDDO.setUsedQty(invRoDDO.getUsedQty() + inVO.getUsedQty());
            this.invRoDRepo.save(invRoDDO);
            InvRoDeducDO invRoDeducDO = new InvRoDeducDO();
            invRoDeducDO.setRoId(invRoDO.getId());
            invRoDeducDO.setRoDId(invRoDDO.getId());
            invRoDeducDO.setDeducType(inVO.getDeducType());
            invRoDeducDO.setDeducTime(LocalDateTime.now());
            invRoDeducDO.setQty(inVO.getUsedQty());
            invRoDeducDO.setSrcDocCls(inVO.getSrcDocCls());
            invRoDeducDO.setSrcDocId(inVO.getSrcDocId());
            invRoDeducDO.setSrcDocNo(inVO.getSrcDocNo());
            invRoDeducDO.setSrcDocDid(inVO.getSrcDocDid());
            invRoDeducDO.setDeleteFlag(0);
            this.invRoDeducRepo.save(invRoDeducDO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updated(InvRoCommon32InVO inVO, InvRoDO invRoDO, InvRoDDO invRoDDO, InvStkVO invStkVO) {
        Object object = this.$lock;
        synchronized (object) {
            invRoDO.setRsvDueDate(inVO.getRsvDueDate());
            invRoDO.setCustId(inVO.getCustId());
            this.invRoRepo.save(invRoDO);
            Double adjustQty = inVO.getQty();
            if (invRoDDO == null) {
                Double maxLineNo = this.invRoDService.findMaxLineNoByMasId(invRoDO.getId());
                InvRoDDO newRoDDO = InvCommonConvert.INSTANCE.invRoCommon32InVOToInvRoDDO(inVO);
                newRoDDO.setMasId(invRoDO.getId());
                newRoDDO.setLineNo(maxLineNo + 1.0);
                newRoDDO.setRoNowQty(0.0);
                newRoDDO.setRoFirstQty(0.0);
                newRoDDO.setDeleteFlag(0);
                this.invRoDRepo.save(newRoDDO);
                invRoDDO = newRoDDO;
            } else {
                adjustQty = adjustQty - invRoDDO.getQty();
                invRoDDO.setQty(inVO.getQty());
                invRoDDO.setRsvDueDate(inVO.getRsvDueDate());
                this.invRoDRepo.save(invRoDDO);
            }
            this.updateInvStk(invStkVO, adjustQty, adjustQty > 0.0 ? InvStk28Enum.T_TYPE_10 : InvStk28Enum.T_TYPE_11, UdcEnum.COM_DOC_CLS_RO.getValueCode(), invRoDDO.getMasId(), invRoDDO.getId(), invRoDDO.getLineNo(), inVO.getDocNo());
        }
    }

    private void checkIn(List<InvRoCommon32InVO> invRoCommon32InVOList) {
        long count;
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(invRoCommon32InVOList);
        if (validResult.isError()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u90e8\u5206\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List modeList = invRoCommon32InVOList.stream().map(InvRoCommon32InVO::getMode).distinct().collect(Collectors.toList());
        if (modeList.size() != 1) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef,\u540c\u4e8b\u52a1\u64cd\u4f5c\u53ea\u80fd\u9009\u7528\u4e00\u79cd\u6a21\u5f0f");
        }
        long fclNumIsNullCount = invRoCommon32InVOList.stream().filter(i -> {
            if (i.getFclFlag() == 1) {
                return i.getFclNum() == null || i.getUsedQty() % (double)i.getFclFlag().intValue() > 0.0;
            }
            return false;
        }).count();
        if (fclNumIsNullCount > 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u6574\u7bb1\u6807\u8bc6\u4e3a\u53ef\u6574\u65f6\uff0c\u7bb1\u88c5\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u6d88\u8017\u6570\u91cf\u9700\u4e3a\u7bb1\u88c5\u6570\u7684\u6574\u6570\u500d");
        }
        long daterCount = invRoCommon32InVOList.stream().filter(i -> !StringUtils.isEmpty((Object)i.getDeter1()) && !StringUtils.isEmpty((Object)i.getDeter2()) && StringUtils.isEmpty((Object)i.getDeter3()) || StringUtils.isEmpty((Object)i.getDeter1()) && StringUtils.isEmpty((Object)i.getDeter2()) && !StringUtils.isEmpty((Object)i.getDeter3())).count();
        if (daterCount != (long)invRoCommon32InVOList.size()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u6e29\u5c42\u3001\u529f\u80fd\u5e93\u533a\u3001\u5ba2\u6237\u53f7 \u4e09\u8005\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u4e0d\u5b58\u5728");
        }
        String mode = (String)modeList.get(0);
        if (!"UPDATE".equals(mode) && (count = invRoCommon32InVOList.stream().filter(i -> i.getLineNo() != null).distinct().count()) != (long)invRoCommon32InVOList.size()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u6d88\u8017/\u91ca\u653e\u6a21\u5f0f\u4e0b\uff0c\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u91cd\u590d");
        }
        List docNoList = invRoCommon32InVOList.stream().map(InvRoCommon32InVO::getDocNo).distinct().collect(Collectors.toList());
        List invRoVOList = this.invRoDService.findByDocNos(docNoList);
        if (CollectionUtils.isEmpty((Collection)invRoVOList)) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u9884\u7559\u5355\u660e\u7ec6\u4fe1\u606f");
        }
        invRoCommon32InVOList.forEach(i -> {
            long count = invRoVOList.stream().filter(item -> item.getItemId().equals(i.getItemId()) && (StringUtils.isEmpty((Object)i.getVariId()) ? StringUtils.isEmpty((Object)item.getVariId()) : i.getVariId().equals(item.getVariId())) && (StringUtils.isEmpty((Object)i.getWhId()) ? StringUtils.isEmpty((Object)item.getWhId()) : i.getWhId().equals(item.getWhId())) && (StringUtils.isEmpty((Object)i.getCustId()) ? StringUtils.isEmpty((Object)item.getCustId()) : i.getCustId().equals(item.getCustId())) && (StringUtils.isEmpty((Object)i.getRsvDueDate()) ? StringUtils.isEmpty((Object)item.getRsvDueDate()) : i.getRsvDueDate().isEqual(item.getRsvDueDate()))).filter(item -> {
                if (!StringUtils.isEmpty((Object)item.getLotNo())) {
                    return item.getLotNo().equals(i.getLotNo());
                }
                return true;
            }).filter(item -> {
                if (!StringUtils.isEmpty((Object)item.getDeter1()) && !StringUtils.isEmpty((Object)item.getDeter2())) {
                    return item.getDeter1().equals(i.getDeter1()) && item.getDeter2().equals(i.getDeter2());
                }
                if (!StringUtils.isEmpty((Object)item.getDeter3())) {
                    return item.getDeter3().equals(i.getDeter3());
                }
                return false;
            }).filter(roDVO -> !"UPDATE".equals(mode) ? (StringUtils.isEmpty((Object)i.getLineNo()) ? StringUtils.isEmpty((Object)roDVO.getLineNo()) : i.getLineNo().equals(roDVO.getLineNo())) : true).count();
            if ("UPDATE".equals(mode) ? count > 1L : count != 1L) {
                throw new BusinessException("\u5165\u53c2\u4e0e\u9884\u7559\u5355\u660e\u7ec6\u4fe1\u606f\u5339\u914d\u5931\u8d25");
            }
        });
    }

    public Map<InvRoDCreateParam, InvStkVO> saveCheckIn(InvRoCreateParam invRoCreateParam, List<InvRoDCreateParam> invRoDCreateParamList) {
        if (invRoCreateParam == null) {
            throw new BusinessException("\u9884\u7559\u5355\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(invRoDCreateParamList)) {
            throw new BusinessException("\u9884\u7559\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(invRoCreateParam);
        if (validResult.isError()) {
            throw new BusinessException("\u4e3b\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u9884\u7559\u5ba2\u6237\u3001\u9884\u7559\u539f\u56e0\u3001\u7533\u8bf7\u65e5\u671f\u3001\u53d1\u8d77\u4eba\u3001\u9884\u7559\u622a\u6b62\u65e5\u671f\u3001\u9500\u552e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidationUtil.ValidResult validResult2 = ValidationUtil.validate(invRoDCreateParamList);
        if (validResult2.isError()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1ID,\u6279\u6b21,\u9884\u7559\u6570\u91cf,\u5355\u4f4d,\u9884\u7559\u5907\u6ce8,\u4ed3\u5e93,\u529f\u80fd\u5e93\u533a,\u6e29\u5c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long count = invRoDCreateParamList.stream().map(i -> i.getCustId() + "_" + i.getWhId() + "_" + i.getItemId() + "_" + i.getLotNo() + "_" + i.getDeter1() + "_" + i.getDeter2()).distinct().count();
        if (count != (long)invRoDCreateParamList.size()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1ID,\u6279\u6b21,\u4ed3\u5e93,\u529f\u80fd\u5e93\u533a,\u6e29\u5c42\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        if (invRoDCreateParamList.stream().filter(i -> i.getQty() < (i.getUsedQty() != null ? i.getUsedQty() : 0.0)).count() > 0L) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u521d\u59cb\u9884\u7559\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u6d88\u8017\u6570\u91cf");
        }
        this.paramCheck(invRoDCreateParamList, invRoCreateParam);
        ArrayList errMsg = new ArrayList();
        HashMap<InvRoDCreateParam, InvStkVO> map = new HashMap<InvRoDCreateParam, InvStkVO>();
        invRoDCreateParamList.forEach(i -> {
            InvBaseModel invBaseModel = new InvBaseModel();
            invBaseModel.setItemId(i.getItemId());
            invBaseModel.setVariId(i.getVariId());
            invBaseModel.setWhId(i.getWhId());
            invBaseModel.setLotNo(i.getLotNo());
            invBaseModel.setDeter1(i.getDeter1());
            invBaseModel.setDeter2(i.getDeter2());
            invBaseModel.setUom(i.getUom());
            InvStkVO stkVO = this.invStkCommonService.getInvStk(invBaseModel);
            if (stkVO == null) {
                errMsg.add(String.format(INV_COMMON_ERR_MSG, i.getItemId(), i.getVariId(), i.getLotNo(), "\u672a\u627e\u5230\u5e93\u5b58\u4fe1\u606f"));
            } else {
                Double avalQty = stkVO.getAvalQty() == null ? 0.0 : stkVO.getAvalQty();
                Double checkQty = i.getQty() - i.getRoFirstQty();
                if (avalQty < checkQty) {
                    errMsg.add(String.format(INV_COMMON_ERR_MSG, i.getItemId(), i.getVariId(), i.getLotNo(), "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3"));
                }
                map.put((InvRoDCreateParam)i, stkVO);
            }
        });
        if (!CollectionUtils.isEmpty(errMsg)) {
            map.clear();
            throw new BusinessException(errMsg.stream().collect(Collectors.joining(",")));
        }
        return map;
    }

    public void paramCheck(List<InvRoDCreateParam> invRoDCreateParamList, InvRoCreateParam invRoCreateParam) {
        final List custIdList = invRoDCreateParamList.stream().map(InvRoDCreateParam::getCustId).distinct().collect(Collectors.toList());
        final List whIdList = invRoDCreateParamList.stream().map(InvRoDCreateParam::getWhId).distinct().collect(Collectors.toList());
        if (custIdList.size() != 1 || whIdList.size() != 1) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u9884\u7559\u5355\u660e\u7ec6\u5ba2\u6237ID\u3001\u4ed3\u5e93ID\u9700\u4fdd\u6301\u4e00\u81f4");
        }
        InvRoDQueryParam queryParam = new InvRoDQueryParam(){
            {
                this.setCustId((Long)custIdList.get(0));
                this.setWhId((Long)whIdList.get(0));
            }
        };
        List invRoDVOList = this.invRoDService.findByParams(queryParam);
        List invRoDDocNoList = invRoDVOList.stream().filter(i -> !UdcEnum.INV_RO_STATUS_CL.getValueCode().equals(i.getDocStatus()) && !UdcEnum.INV_RO_STATUS_RL.getValueCode().equals(i.getDocStatus())).map(InvRoDVO::getDocNo).distinct().collect(Collectors.toList());
        if (!StringUtils.isEmpty((Object)invRoCreateParam.getDocNo())) {
            invRoDDocNoList.remove(invRoCreateParam.getDocNo());
        }
        if (!CollectionUtils.isEmpty(invRoDDocNoList)) {
            throw new BusinessException(String.format("\u8be5\u5ba2\u6237\u5df2\u7ecf\u5b58\u5728\u9884\u7559\u5355,\u5355\u53f7:%s", invRoDDocNoList.get(0)));
        }
        invRoDCreateParamList.forEach(i -> {
            List checkList = invRoDVOList.stream().filter(v -> !UdcEnum.INV_RO_STATUS_CL.getValueCode().equals(v.getDocStatus()) && !UdcEnum.INV_RO_STATUS_RL.getValueCode().equals(v.getDocStatus())).filter(v -> (v.getCustId() + "_" + v.getWhId() + "_" + v.getItemId() + "_" + v.getLotNo() + "_" + v.getDeter1() + "_" + v.getDeter2() + "_" + v.getDeter3()).equals(i.getCustId() + "_" + i.getWhId() + "_" + i.getItemId() + "_" + i.getLotNo() + "_" + i.getDeter1() + "_" + i.getDeter2() + "_" + i.getDeter3())).collect(Collectors.toList());
            if (checkList.size() > 1) {
                throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1ID,\u6279\u6b21,\u4ed3\u5e93,\u529f\u80fd\u5e93\u533a,\u6e29\u5c42\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (!(checkList.size() != 1 || i.getId() != null && ((InvRoDVO)checkList.get(0)).getId().equals(i.getId()))) {
                throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1ID,\u6279\u6b21,\u4ed3\u5e93,\u529f\u80fd\u5e93\u533a,\u6e29\u5c42\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
        });
        invRoDCreateParamList.forEach(i -> {
            i.setCustId((Long)custIdList.get(0));
            i.setWhId((Long)whIdList.get(0));
        });
    }

    @Transactional
    public List<InvRoDVO> setOtherFields(List<InvRoDVO> invRoDList) {
        if (!CollectionUtils.isEmpty(invRoDList)) {
            List itemIdList = invRoDList.stream().map(InvRoDVO::getItemId).distinct().collect(Collectors.toList());
            List whIdList = invRoDList.stream().map(InvRoDVO::getWhId).distinct().collect(Collectors.toList());
            List roCustIdList = invRoDList.stream().map(InvRoDVO::getCustId).distinct().collect(Collectors.toList());
            List whList = CollectionUtils.isEmpty(whIdList) ? Collections.emptyList() : this.invWhService.findIdBatch(whIdList);
            List invRoIdList = invRoDList.stream().map(InvRoDVO::getMasId).distinct().collect(Collectors.toList());
            List applyEmpIdList = invRoDList.stream().map(InvRoDVO::getApplyEmpId).distinct().collect(Collectors.toList());
            invRoDList.parallelStream().forEach(i -> {
                List invLotVOS;
                i.setRoQty(Double.valueOf((i.getQty() == null ? 0.0 : i.getQty()) - (i.getUsedQty() == null ? 0.0 : i.getUsedQty()) - (i.getRoNowQty() == null ? 0.0 : i.getRoNowQty())));
                i.setDocStatus(i.getDocStatus());
                i.setRoDocNo(i.getDocNo());
                InvLotParam queryParam = new InvLotParam();
                if (!StringUtils.isEmpty((Object)i.getItemId())) {
                    queryParam.setItemId(i.getItemId());
                }
                if (!StringUtils.isEmpty((Object)i.getVariId())) {
                    queryParam.setVariId(i.getVariId());
                }
                if (!StringUtils.isEmpty((Object)i.getLotNo())) {
                    queryParam.setLotNo(i.getLotNo());
                }
                if (!CollectionUtils.isEmpty((Collection)(invLotVOS = this.invLotService.findByParams(queryParam)))) {
                    InvLotRespVO lotVO = (InvLotRespVO)invLotVOS.get(0);
                    i.setManuDate(lotVO.getManuDate());
                    i.setExpireDate(lotVO.getExpireDate());
                    i.setMenuLotNo(lotVO.getMenuLotNo());
                    i.setFressType(lotVO.getFressType());
                    i.setUntilExpireDays(lotVO.getUntilExpireDays());
                }
                InvBaseModel invStkParam = new InvBaseModel();
                invStkParam.setItemId(i.getItemId());
                invStkParam.setWhId(i.getWhId());
                invStkParam.setVariId(i.getVariId());
                invStkParam.setLotNo(i.getLotNo());
                invStkParam.setDeter1(i.getDeter1());
                invStkParam.setDeter2(i.getDeter2());
                InvStkVO invStk = this.invStkCommonService.getInvStk(invStkParam);
                if (invStk != null) {
                    i.setAvalQty(invStk.getAvalQty());
                }
            });
        }
        return invRoDList;
    }

    private Double setQty(Double qty) {
        return qty == null ? 0.0 : qty;
    }

    public InvRoCommonServiceImpl(InvRoService invRoService, InvRoRepo invRoRepo, InvRoDService invRoDService, InvRoDRepo invRoDRepo, InvRoDeducService invRoDeducService, InvRoDeducRepo invRoDeducRepo, InvStkCommonService invStkCommonService, InvLotCommonService invLotCommonService, InvWhService invWhService, InvLotService invLotService) {
        this.invRoService = invRoService;
        this.invRoRepo = invRoRepo;
        this.invRoDService = invRoDService;
        this.invRoDRepo = invRoDRepo;
        this.invRoDeducService = invRoDeducService;
        this.invRoDeducRepo = invRoDeducRepo;
        this.invStkCommonService = invStkCommonService;
        this.invLotCommonService = invLotCommonService;
        this.invWhService = invWhService;
        this.invLotService = invLotService;
    }
}

