/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvRoConvert;
import com.elitesland.inv.convert.InvRoDConvert;
import com.elitesland.inv.entity.InvRoDDO;
import com.elitesland.inv.entity.InvRoDO;
import com.elitesland.inv.entity.QInvRoDDO;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.param.InvRoCreateParam;
import com.elitesland.inv.param.InvRoDCreateParam;
import com.elitesland.inv.param.InvRoDQueryParam;
import com.elitesland.inv.param.InvRoDUpdateParam;
import com.elitesland.inv.repo.InvRoDRepo;
import com.elitesland.inv.repo.InvRoDRepoProc;
import com.elitesland.inv.repo.InvRoRepo;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvLotStkCommonService;
import com.elitesland.inv.service.InvRoCommonService;
import com.elitesland.inv.service.InvRoDService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.InvLotCommon21FilterVO;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvLotStkCommon24InVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvRoCommon30OutVO;
import com.elitesland.inv.vo.InvRoCommon31InVO;
import com.elitesland.inv.vo.InvRoCommon32InVO;
import com.elitesland.inv.vo.InvRoDVO;
import com.elitesland.inv.vo.param.InvRoDQueryParamVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.system.service.SysUserService;
import com.elitesland.util.BeanCopyUtil;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invRoDService")
public class InvRoDServiceImpl
implements InvRoDService {
    private static final Logger log = LoggerFactory.getLogger(InvRoDServiceImpl.class);
    private final InvRoDRepo invRoDRepo;
    private final InvRoDRepoProc invRoDRepoProc;
    private final SysUserService sysUserService;
    private final InvRoRepo invRoRepo;
    private final InvLotService invLotService;
    private final SysNumberRuleService sysNumberRuleService;
    private InvRoCommonService invRoCommonService;
    private InvLotStkCommonService invLotStkCommonService;
    private final InvLotCommonService invLotCommonService;
    private final String RELEASE = "RELEASE";
    private final String LOCK = "LOCK";
    private final String RO = "RO";
    private final String EQUAL = "=";
    private final String GREATERTHEN = ">";
    private final String LESSTHEN = "<";

    @Autowired
    @Lazy
    public void setInvRoCommonService(InvRoCommonService invRoCommonService) {
        this.invRoCommonService = invRoCommonService;
    }

    @Autowired
    @Lazy
    public void invLotStkCommonService(InvLotStkCommonService invLotStkCommonService) {
        this.invLotStkCommonService = invLotStkCommonService;
    }

    @SysCodeProc
    public PagingVO<InvRoDVO> search(InvRoDQueryParamVO param) {
        return this.invRoDRepoProc.useSelect(param);
    }

    @SysCodeProc
    public Optional<InvRoDVO> findCodeOne(String itemCode) {
        InvRoDVO vo = (InvRoDVO)this.invRoDRepoProc.select(null).fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<InvRoDVO> findIdOne(Long id) {
        return this.invRoDRepo.findById(id).map(DO -> (InvRoDVO)BeanUtil.copyProperties((Object)DO, InvRoDVO.class));
    }

    @SysCodeProc
    public List<InvRoDVO> findIdBatch(List<Long> idList) {
        List<InvRoDVO> invRoDVOS = this.invRoDRepo.findAllById(idList).stream().map(DO -> {
            InvRoDVO invRoDVO = new InvRoDVO();
            BeanUtils.copyProperties((Object)DO, (Object)invRoDVO);
            return invRoDVO;
        }).collect(Collectors.toList());
        return invRoDVOS;
    }

    @Transactional
    public Long createOne(InvRoDVO invRoDVO) {
        InvRoDDO invRoDDO = new InvRoDDO();
        BeanUtils.copyProperties((Object)invRoDVO, (Object)invRoDDO);
        return ((InvRoDDO)this.invRoDRepo.save(invRoDDO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvRoDVO> list) {
        InvRoDDO invRoDDO = new InvRoDDO();
        ArrayList InvRoDDOS = new ArrayList();
        list.stream().forEach(invRoDDOSS -> {
            BeanUtils.copyProperties((Object)invRoDDOSS, (Object)invRoDDO);
            InvRoDDOS.add(invRoDDO);
        });
        return this.invRoDRepo.saveAll(InvRoDDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(InvRoDVO objDo) {
        Optional optional = this.invRoDRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invRoDRepo.save((InvRoDDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invRoDRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvRoDDO do1 = (InvRoDDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.invRoDRepo.save(do1);
    }

    public List<InvRoDVO> useInvLotStkCommon24(List<InvRoDVO> list) {
        LinkedList<InvLotStkCommon24InVO> inVOList = new LinkedList<InvLotStkCommon24InVO>();
        Iterator<InvRoDVO> it = list.iterator();
        while (it.hasNext()) {
            InvLotStkCommon24InVO inVo = new InvLotStkCommon24InVO();
            InvRoDVO current = it.next();
            inVo.setItemId(current.getItemId());
            inVo.setVariId(current.getVariId());
            inVo.setWhId(current.getWhId());
            inVo.setDeter1(current.getDeter1());
            inVo.setDeter2(current.getDeter2());
            inVo.setLotNo(current.getLotNo());
            inVOList.add(inVo);
        }
        Map outVoMap = this.invLotStkCommonService.invLotStkQuery(inVOList);
        LinkedList<InvRoDVO> validatedList = new LinkedList<InvRoDVO>();
        for (Map.Entry elem : outVoMap.entrySet()) {
            validatedList.add(list.get((Integer)elem.getKey()));
        }
        return validatedList;
    }

    public void updateUseInvLotStkCommon24(InvRoDUpdateParam param) {
        InvRoDVO DO = new InvRoDVO();
        BeanUtils.copyProperties((Object)param, (Object)DO);
        InvLotStkCommon24InVO inVo = new InvLotStkCommon24InVO();
        inVo.setItemId(DO.getItemId());
        inVo.setVariId(DO.getVariId());
        inVo.setWhId(DO.getWhId());
        inVo.setDeter1(DO.getDeter1());
        inVo.setDeter2(DO.getDeter2());
        inVo.setLotNo(DO.getLotNo());
        LinkedList<InvLotStkCommon24InVO> inVOList = new LinkedList<InvLotStkCommon24InVO>();
        inVOList.add(inVo);
        Map outVoMap = this.invLotStkCommonService.invLotStkQuery(inVOList);
        if (!outVoMap.entrySet().isEmpty()) {
            this.update(DO);
        }
    }

    @Transactional
    public void submit(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.FAIL, "\u63d0\u4ea4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List<InvRoDVO> invRoDVOS = this.findIdsBatch(ids);
        List<InvRoDDO> invRoDDOS = invRoDVOS.stream().filter(v -> UdcEnum.INV_RO_STATUS_DR.getValueCode().equals(v.getDocStatus()) || UdcEnum.INV_RO_STATUS_RJ.getValueCode().equals(v.getDocStatus())).map(InvRoDConvert.INSTANCE::voToDO).collect(Collectors.toList());
        String applyNo = null;
        if (!CollectionUtils.isEmpty(invRoDDOS)) {
            List rejectedRoDDOList = invRoDDOS.stream().filter(v -> UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode().equals(v.getApprStatus())).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(rejectedRoDDOList) && rejectedRoDDOList.size() > 1) {
                throw new BusinessException(ApiCode.FAIL, "\u63d0\u4ea4\u5931\u8d25\uff0c\u5b58\u5728\u591a\u5f20\u5ba1\u6279\u4e2d\u7684\u9884\u7559\u5355\uff0c\u8bf7\u786e\u8ba4");
            }
            if (!CollectionUtils.isEmpty(rejectedRoDDOList)) {
                applyNo = ((InvRoDDO)rejectedRoDDOList.get(0)).getApplyNo();
                String apprProcInstId = ((InvRoDDO)rejectedRoDDOList.get(0)).getApprProcInstId();
                invRoDDOS.forEach(d -> d.setApprProcInstId(apprProcInstId));
            }
            String finalApplyNo = applyNo;
            invRoDDOS.forEach(d -> {
                d.setApplyNo(finalApplyNo);
                d.setDocStatus(UdcEnum.INV_RO_STATUS_APPING.getValueCode());
                d.setApprTime(LocalDateTime.now());
            });
        }
        List<InvRoDDO> invRoDDOS2 = invRoDVOS.stream().filter(v -> UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode().equals(v.getApprStatus()) && v.getRoNowQty() > 0.0).map(InvRoDConvert.INSTANCE::voToDO).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invRoDDOS2)) {
            List common32InVOList = Collections.synchronizedList(new ArrayList());
            invRoDDOS2.forEach(i -> {
                InvRoDVO invRoDVO = InvRoDConvert.INSTANCE.doToVO((InvRoDDO)i);
                InvRoCommon32InVO common32InVO = InvCommonConvert.INSTANCE.invRoDVOToInvRoCommon32InVO(invRoDVO);
                common32InVO.setFclFlag(Integer.valueOf(0));
                common32InVO.setMode("RELEASE");
                common32InVO.setSrcDocDid(i.getId());
                common32InVO.setSrcDocId(i.getMasId());
                common32InVO.setSrcDocNo(i.getDocNo());
                common32InVO.setDocNo(i.getDocNo());
                common32InVO.setSrcDocDid(i.getSrcDocDid());
                common32InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_RO.getValueCode());
                common32InVO.setDeducType(UdcEnum.INV_RO_USE_TYPE_MU_RELEASE.getValueCode());
                common32InVO.setRoNowQty(i.getRoNowQty());
                common32InVO.setRoFirstQty(i.getRoFirstQty());
                common32InVOList.add(common32InVO);
            });
            if (!CollectionUtils.isEmpty(common32InVOList)) {
                this.invRoCommonService.invRoDListUpdate(common32InVOList);
            }
        }
    }

    @SysCodeProc
    public List<InvRoDVO> findRoDListById(String docNo, String applyNo) {
        InvRoDQueryParamVO param = new InvRoDQueryParamVO();
        param.setApplyNo(applyNo);
        param.setDocNo(docNo);
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        List invRoDVOS = ((JPAQuery)this.invRoDRepoProc.select(param).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).fetch();
        if (!CollectionUtils.isEmpty((Collection)invRoDVOS)) {
            List roDVOS = invRoDVOS.stream().filter(invRoDVO -> !UdcEnum.INV_RO_STATUS_RL.getValueCode().equals(invRoDVO.getDocStatus())).collect(Collectors.toList());
            if (!CollectionUtil.isEmpty(roDVOS)) {
                List<InvRoDVO> invRoDVOList = this.invRoCommonService.setOtherFields(roDVOS).stream().sorted(Comparator.comparing(BaseModelVO::getCreateTime)).collect(Collectors.toList());
                return invRoDVOList;
            }
            return null;
        }
        return null;
    }

    @Transactional
    public void deleteOne(Long id) {
        this.invRoDRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invRoDRepo.deleteById(id));
    }

    public List<InvRoDVO> findByDocNos(List<String> docNoList) {
        if (CollectionUtils.isEmpty(docNoList)) {
            return Collections.emptyList();
        }
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        List fetch = ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.docNo.in(docNoList))).fetch();
        return fetch;
    }

    public List<InvRoDVO> findByDocNo(String docNo) {
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        return ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.docNo.eq((Object)docNo))).fetch();
    }

    @Transactional
    public List<InvRoDVO> findByApplyNo(String applyNo) {
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        return ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.applyNo.eq((Object)applyNo))).fetch();
    }

    private void updateDocStatusAndApprStatus(String valueCode, String name, String bussKey) {
        List<InvRoDVO> byApplyNo = this.findApplyNo(bussKey);
        List invRoDDOS = Collections.synchronizedList(new ArrayList());
        byApplyNo.forEach(i -> {
            InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.voToDO((InvRoDVO)i);
            invRoDDO.setDocStatus(valueCode);
            invRoDDO.setApprStatus(name);
            invRoDDO.setApprTime(LocalDateTime.now());
            invRoDDOS.add(invRoDDO);
        });
        this.invRoDRepo.saveAll(invRoDDOS);
    }

    public List<InvRoDVO> findApplyNo(String applyNo) {
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        return ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.applyNo.eq((Object)applyNo))).fetch();
    }

    public InvRoDVO findById(Long id) {
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        return (InvRoDVO)((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.id.eq((Object)id))).fetchOne();
    }

    public List<InvRoDVO> findByParams(InvRoDQueryParam queryParam) {
        InvRoDQueryParamVO invRoDQueryParamVO = new InvRoDQueryParamVO();
        BeanUtils.copyProperties((Object)queryParam, (Object)invRoDQueryParamVO);
        List fetch = this.invRoDRepoProc.select(invRoDQueryParamVO).fetch();
        return fetch;
    }

    public List<InvRoDVO> findByParamsNew(InvRoDQueryParam queryParam) {
        InvRoDQueryParamVO invRoDQueryParamVO = new InvRoDQueryParamVO();
        BeanUtils.copyProperties((Object)queryParam, (Object)invRoDQueryParamVO);
        List fetch = this.invRoDRepoProc.findAll(invRoDQueryParamVO).fetch();
        return fetch;
    }

    public List<InvRoDVO> findByParamList(List<InvRoDQueryParamVO> queryParamList) {
        if (!CollectionUtils.isEmpty(queryParamList)) {
            List result = Collections.synchronizedList(new ArrayList());
            queryParamList.stream().forEach(i -> {
                List fetch = ((JPAQuery)this.invRoDRepoProc.select((InvRoDQueryParamVO)i).where(this.getPredicate(QInvRoDDO.invRoDDO, (InvRoDQueryParamVO)i))).fetch();
                result.addAll(fetch);
            });
            return result.stream().distinct().collect(Collectors.toList());
        }
        List fetch = this.invRoDRepoProc.select(null).fetch();
        return Optional.ofNullable(fetch).orElse(Collections.EMPTY_LIST);
    }

    private Predicate getPredicate(QInvRoDDO jpaQDo, InvRoDQueryParamVO queryParam) {
        BooleanExpression predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq((Object)queryParam.getItemId()) : null;
        BooleanExpression predicate2 = queryParam.getVariId() != null ? jpaQDo.variId.eq((Object)queryParam.getVariId()) : null;
        BooleanExpression predicate3 = !StringUtils.isEmpty((Object)queryParam.getLotNo()) ? jpaQDo.lotNo.eq((Object)queryParam.getLotNo()) : null;
        BooleanExpression predicate7 = queryParam.getWhId() != null ? jpaQDo.whId.eq((Object)queryParam.getWhId()) : null;
        BooleanExpression predicate4 = !StringUtils.isEmpty((Object)queryParam.getDeter1()) ? jpaQDo.deter1.eq((Object)queryParam.getDeter1()) : null;
        BooleanExpression predicate5 = !StringUtils.isEmpty((Object)queryParam.getDeter2()) ? jpaQDo.deter2.eq((Object)queryParam.getDeter2()) : null;
        BooleanExpression predicate6 = !StringUtils.isEmpty((Object)queryParam.getDeter3()) ? jpaQDo.deter3.eq((Object)queryParam.getDeter3()) : null;
        BooleanExpression predicate8 = !StringUtils.isEmpty((Object)queryParam.getUom()) ? jpaQDo.uom.eq((Object)queryParam.getUom()) : null;
        return ExpressionUtils.allOf((Predicate[])new Predicate[]{predicate1, predicate2, predicate3, predicate4, predicate5, predicate6, predicate7, predicate8});
    }

    public List<InvRoDVO> findByMasIds(List<Long> invMasIdList) {
        if (CollectionUtils.isEmpty(invMasIdList)) {
            return Collections.emptyList();
        }
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        List fetch = ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.masId.in(invMasIdList))).fetch();
        return fetch;
    }

    public List<InvRoDVO> findByInvIds(List<Long> invIdList) {
        if (CollectionUtils.isEmpty(invIdList)) {
            return Collections.emptyList();
        }
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        List fetch = ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.id.in(invIdList))).fetch();
        return fetch;
    }

    @SysCodeProc
    public PagingVO<InvRoDVO> findCombine(InvRoCommon30InVO param) {
        Map integerListMap = this.invRoCommonService.invRoDListQuery(Arrays.asList(param));
        List records = (List)integerListMap.get(0);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return PagingVO.builder().total(Long.valueOf(0L)).records(Collections.EMPTY_LIST).build();
        }
        List dataList = records.stream().map(i -> {
            InvRoDVO invRoDVO = InvCommonConvert.INSTANCE.invRoCommon30OutVOToInvRoDVO((InvRoCommon30OutVO)i);
            invRoDVO.setId(i.getRoDId());
            invRoDVO.setMasId(i.getRoId());
            return invRoDVO;
        }).sorted(Comparator.comparing(InvRoDVO::getDocNo).reversed()).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(records.size())).records(dataList).build();
    }

    @SysCodeProc
    public PagingVO<InvRoDVO> findInvRODVOS(InvRoDQueryParamVO param) {
        if (!CollectionUtils.isEmpty((Collection)param.getDocStatusList()) && param.getDocStatusList().contains(UdcEnum.INV_RO_STATUS_RL.getValueCode())) {
            param.setRlStatusFlag(Boolean.valueOf(false));
        }
        PagingVO pagingVO = this.invRoDRepoProc.useSelect(param);
        List invRoDList = pagingVO.getRecords();
        this.filterInvRoDList(param, invRoDList);
        this.invRoCommonService.setOtherFields(invRoDList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(invRoDList).build();
    }

    public void filterInvRoDList(final InvRoDQueryParamVO param, List<InvRoDVO> invRoDList) {
        if (!StringUtils.isEmpty((Object)param.getQty())) {
            invRoDList = invRoDList.stream().filter(i -> {
                Double q = (i.getQty() == null ? 0.0 : i.getQty()) - (i.getUsedQty() == null ? 0.0 : i.getUsedQty());
                if ("=".equals(param.getOpType())) {
                    return q.compareTo(param.getQty()) == 0;
                }
                if ("<".equals(param.getOpType())) {
                    return q.compareTo(param.getQty()) < 0;
                }
                if (">".equals(param.getOpType())) {
                    return q.compareTo(param.getQty()) > 0;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (!StringUtils.isEmpty((Object)param.getFirstLotNo())) {
            invRoDList = invRoDList.stream().filter(i -> param.getFirstLotNo().compareTo(i.getLotNo()) < 0).collect(Collectors.toList());
        }
        if (!(CollectionUtils.isEmpty(invRoDList) || StringUtils.isEmpty((Object)param.getFirstLotNo()) && param.getFressTypeDays() == null && param.getAdjustDays() == null && param.getMaxLotNum() == null && StringUtils.isEmpty((Object)param.getFressType()))) {
            List queryLotParams = Collections.synchronizedList(new ArrayList());
            invRoDList.parallelStream().forEach(i -> {
                InvLotCommon21InVO queryLotParam = new InvLotCommon21InVO((InvRoDVO)i){
                    final /* synthetic */ InvRoDVO val$i;
                    {
                        this.val$i = invRoDVO;
                        this.setItemId(this.val$i.getItemId());
                        this.setVariId(this.val$i.getVariId());
                        this.setLotNo(this.val$i.getLotNo());
                    }
                };
                queryLotParams.add(queryLotParam);
            });
            Map invLotVOMap = this.invLotCommonService.getInvLotVOList(queryLotParams);
            List<Object> invLotVoList = new ArrayList();
            for (Integer key : invLotVOMap.keySet()) {
                List vos = (List)invLotVOMap.get(key);
                invLotVoList.addAll(vos);
            }
            invLotVoList = invLotVoList.stream().distinct().collect(Collectors.toList());
            InvLotCommon21FilterVO lotCommon21FilterVO = new InvLotCommon21FilterVO(){
                {
                    this.setFirstLotNo(param.getFirstLotNo());
                    this.setFressTypeDays(param.getFressTypeDays());
                    this.setAdjustDays(param.getAdjustDays());
                    this.setMaxLotNum(param.getMaxLotNum());
                    this.setFressType(param.getFressType());
                }
            };
            List invLotCheckedList = this.invLotCommonService.getInvLotCheckedList(invLotVoList, lotCommon21FilterVO);
            if (!StringUtils.isEmpty((Object)param.getFressTypeDays()) && StringUtils.isEmpty((Object)param.getAdjustDays())) {
                invLotCheckedList = invLotCheckedList.stream().filter(i -> {
                    Double untilExpireDays = i.getUntilExpireDays().doubleValue();
                    return untilExpireDays.compareTo(param.getFressTypeDays()) == 0;
                }).collect(Collectors.toList());
            }
            List finalInvLotCheckedList = invLotCheckedList;
            invRoDList = invRoDList.stream().filter(i -> {
                List collect = finalInvLotCheckedList.stream().filter(lot -> (StringUtils.isEmpty((Object)i.getItemId()) ? StringUtils.isEmpty((Object)lot.getItemId()) : i.getItemId().equals(lot.getItemId())) && (StringUtils.isEmpty((Object)i.getVariId()) ? StringUtils.isEmpty((Object)lot.getVariId()) : i.getVariId().equals(lot.getVariId())) && (StringUtils.isEmpty((Object)i.getLotNo()) ? StringUtils.isEmpty((Object)lot.getLotNo()) : i.getLotNo().equals(lot.getLotNo()))).collect(Collectors.toList());
                return !CollectionUtils.isEmpty(collect);
            }).distinct().collect(Collectors.toList());
        }
    }

    public Double findMaxLineNoByMasId(Long maxId) {
        if (maxId == null) {
            return null;
        }
        return (Double)this.invRoDRepoProc.findMaxLineNoByMasId(maxId).fetchOne();
    }

    @Transactional
    public Map<Object, Object> createDoc(InvRoCommon31InVO invRoCommon31InVO) {
        InvRoCreateParam invRoD = invRoCommon31InVO.getInvRoCreateParam();
        this.invRoCommonService.saveCheckIn(invRoCommon31InVO.getInvRoCreateParam(), invRoCommon31InVO.getInvRoDCreateParamList());
        String docNo = invRoCommon31InVO.getInvRoDCreateParamList().stream().map(InvRoDCreateParam::getDocNo).filter(Objects::nonNull).distinct().findAny().orElse(null);
        if (!StringUtils.isEmpty((Object)docNo)) {
            List<InvRoDVO> invRoDVOS;
            List<InvRoDVO> finalInvRoDVOS = invRoDVOS = this.findByDocNo(docNo);
            invRoCommon31InVO.getInvRoDCreateParamList().forEach(i -> {
                if (i.getId() != null) {
                    finalInvRoDVOS.stream().filter(d -> i.getId().equals(d.getId())).findAny().ifPresent(d -> {
                        int q = Double.compare(i.getQty() == null ? 0.0 : i.getQty(), d.getQty() == null ? 0.0 : d.getQty());
                        if (q != 0) {
                            i.setDocStatus(UdcEnum.INV_RO_STATUS_DR.getValueCode());
                        }
                        i.setRoNowQty(Double.valueOf(i.getRoNowQty() == null ? 0.0 : i.getRoNowQty()));
                    });
                } else {
                    i.setDocStatus(UdcEnum.INV_RO_STATUS_DR.getValueCode());
                }
            });
        } else {
            docNo = this.sysNumberRuleService.generateCode("RO", List.of(String.valueOf(invRoD.getOuId())));
        }
        InvRoDO invRoDO = InvRoConvert.INSTANCE.invRoCreateParamToInvRoDO(invRoD);
        invRoDO.setDocNo(invRoDO.getDocNo() != null ? invRoDO.getDocNo() : docNo);
        invRoDO.setDocType(invRoDO.getDocType() != null ? invRoDO.getDocType() : UdcEnum.COM_DOC_CLS_RO.getValueCode());
        Long id = ((InvRoDO)this.invRoRepo.save(invRoDO)).getId();
        Double maxLineNo = invRoCommon31InVO.getInvRoDCreateParamList().stream().map(InvRoDCreateParam::getLineNo).filter(Objects::nonNull).max(Double::compareTo).orElse(0.0);
        AtomicDouble lineNo = new AtomicDouble(maxLineNo.doubleValue());
        String finalNewDocNo = docNo;
        List invRoDDOs = invRoCommon31InVO.getInvRoDCreateParamList().stream().map(d -> {
            if (d.getUsedQty() == null) {
                d.setUsedQty(Double.valueOf(0.0));
            }
            InvLotParam param = new InvLotParam();
            param.setItemId(d.getItemId());
            param.setLotNo(d.getLotNo());
            List ret = this.invLotService.findByParams(param);
            ret.stream().forEach(v -> {
                if ("LOCK".equals(v.getQcStatus())) {
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6279\u6b21\u8d28\u91cf\u72b6\u6001\u4e3a\u9501\u5b9a\u65f6\u4e0d\u80fd\u9884\u7559");
                }
            });
            List<InvLotVO> lot = ret.stream().map(r -> {
                InvLotVO lotVO = new InvLotVO();
                BeanUtil.copyProperties((Object)r, (Object)lotVO);
                return lotVO;
            }).collect(Collectors.toList());
            InvRoDCreateParam d1 = this.convertRoDcParams(lot, (InvRoDCreateParam)d);
            InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.invRoDCreateParamToInvRoDO(d1);
            invRoDDO.setMasId(id);
            invRoDDO.setRoFirstQty(d.getRoFirstQty() != null ? d.getRoFirstQty() : 0.0);
            double roNowQty = d.getRoNowQty() != null ? d.getRoNowQty() : 0.0;
            invRoDDO.setRoNowQty(roNowQty);
            invRoDDO.setApprProcInstId(d.getApprProcInstId());
            invRoDDO.setApprTime(d.getApprTime());
            invRoDDO.setApprStatus(d.getApprStatus());
            invRoDDO.setLineNo(invRoDDO.getLineNo() != null ? invRoDDO.getLineNo().doubleValue() : lineNo.addAndGet(1.0));
            invRoDDO.setDocType(invRoDDO.getDocType() != null ? invRoDDO.getDocType() : UdcEnum.COM_DOC_CLS_RO.getValueCode());
            invRoDDO.setDocStatus(invRoDDO.getDocStatus() != null ? invRoDDO.getDocStatus() : UdcEnum.INV_RO_STATUS_DR.getValueCode());
            invRoDDO.setRsvReason(invRoDDO.getRsvReason());
            invRoDDO.setDocNo(StringUtils.isEmpty((Object)invRoDDO.getDocNo()) ? finalNewDocNo : invRoDDO.getDocNo());
            return invRoDDO;
        }).collect(Collectors.toList());
        List ids = this.invRoDRepo.saveAll(invRoDDOs).stream().map(BaseModel::getId).collect(Collectors.toList());
        List sids = ids.stream().map(x -> "" + x).collect(Collectors.toList());
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("ids", sids);
        map.put("docNo", docNo);
        return map;
    }

    @Transactional
    public void checkBatch(List<Long> idList) {
        List<InvRoDVO> invRoDVOS = this.findByIds(idList);
        if (invRoDVOS.stream().filter(i -> !UdcEnum.INV_RO_STATUS_APPING.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u53ea\u6709\u63d0\u4ea4\u540e\u624d\u80fd\u5ba1\u6838");
        }
        if (invRoDVOS.size() > 0) {
            this.invRoCommonService.lockInvStkNew(invRoDVOS);
            invRoDVOS.forEach(ro -> {
                InvRoDDO invRoDDO = new InvRoDDO();
                BeanUtils.copyProperties((Object)ro, (Object)invRoDDO);
                invRoDDO.setDocStatus(UdcEnum.INV_RO_STATUS_APPED.getValueCode());
                invRoDDO.setApprStatus(UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
                invRoDDO.setRoFirstQty(ro.getQty());
                this.invRoDRepo.save(invRoDDO);
            });
        }
    }

    @Transactional
    public void refuseBatch(List<Long> idList) {
        List invRoDDOS = this.invRoDRepo.findAllById(idList);
        if (invRoDDOS.size() > 0) {
            invRoDDOS.forEach(ro -> ro.setDocStatus(UdcEnum.INV_RO_STATUS_RJ.getValueCode()));
            this.invRoDRepo.saveAll(invRoDDOS);
        }
    }

    @Transactional
    public void releaseInvRoList(List<Long> idList) {
        List invRoDOList = this.invRoDRepo.findAllById(idList);
        List checkIds = invRoDOList.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
        if (idList.stream().filter(i -> !checkIds.contains(i)).count() > 0L) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38");
        }
        if (invRoDOList.stream().filter(i -> !UdcEnum.INV_RO_STATUS_APPED.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u7684\u9884\u7559\u5355\u624d\u53ef\u4ee5\u91ca\u653e");
        }
        if (invRoDOList.stream().filter(i -> UdcEnum.INV_RO_STATUS_RL.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u9884\u7559\u5355\u5df2\u88ab\u91ca\u653e\uff0c\u4e0d\u53ef\u518d\u91ca\u653e");
        }
        List<InvRoDVO> invRoDVOList = this.findByIds(idList);
        List common32InVOList = Collections.synchronizedList(new ArrayList());
        invRoDVOList.parallelStream().forEach(roDVO -> {
            InvRoCommon32InVO common32InVO = InvCommonConvert.INSTANCE.invRoDVOToInvRoCommon32InVO((InvRoDVO)roDVO);
            common32InVO.setFclFlag(Integer.valueOf(0));
            common32InVO.setMode("RELEASE");
            common32InVO.setSrcDocDid(roDVO.getId());
            common32InVO.setSrcDocId(roDVO.getMasId());
            invRoDOList.stream().forEach(i -> {
                common32InVO.setSrcDocNo(i.getDocNo());
                common32InVO.setDocNo(i.getDocNo());
            });
            common32InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_RO.getValueCode());
            common32InVO.setDeducType(UdcEnum.INV_RO_USE_TYPE_MU_RELEASE.getValueCode());
            common32InVOList.add(common32InVO);
        });
        this.invRoCommonService.invRoDListUpdate(common32InVOList);
    }

    @Transactional
    public void cancelBatch(List<Long> idList) {
        List invRoVOList = this.invRoDRepo.findAllById(idList);
        if (idList.size() != invRoVOList.size()) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u9884\u7559\u5355\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        if (invRoVOList.parallelStream().filter(i -> UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode().equals(i.getApprStatus())).count() > 0L) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u5df2\u8fc7\u8d26\u7684\u9884\u7559\u5355\u65e0\u6cd5\u518d\u53d6\u6d88");
        }
        if (invRoVOList.parallelStream().filter(i -> UdcEnum.INV_RO_STATUS_CL.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u5df2\u53d6\u6d88\u7684\u9884\u7559\u5355\u65e0\u6cd5\u518d\u53d6\u6d88");
        }
        invRoVOList.stream().forEach(i -> i.setDocStatus(UdcEnum.INV_RO_STATUS_CL.getValueCode()));
        this.invRoDRepo.saveAll(invRoVOList);
    }

    public InvRoDCreateParam convertRoDcParams(List<InvLotVO> lotDOs, InvRoDCreateParam d1) {
        lotDOs.forEach(i -> {
            if (i.getLotNo().equals(d1.getLotNo()) && i.getItemId().equals(d1.getItemId())) {
                Long days = LocalDate.now().toEpochDay() - i.getManuDate().toLocalDate().toEpochDay();
                double fress = days.doubleValue() / i.getExpireDays().doubleValue();
                if (fress < 0.3333333333333333) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_1.getValueCode());
                } else if (fress >= 0.3333333333333333 && fress < 0.5) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_2.getValueCode());
                } else if (fress >= 0.5 && fress < 0.6666666666666666) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_3.getValueCode());
                } else if (fress >= 0.6666666666666666 && fress < 1.0) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_4.getValueCode());
                } else {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_5.getValueCode());
                }
                Long expireDays = i.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay();
                d1.setUnitExpireDays(Integer.valueOf(expireDays < 0L ? 0 : expireDays.intValue()));
            }
        });
        return d1;
    }

    private void startWorkflow(String applyNo, List<InvRoDDO> invRoDDOS) {
        log.info("-----------------\u5e93\u5b58\u9884\u7559\u6d41\u7a0b\u542f\u52a8---------");
        invRoDDOS.forEach(invRoDVO -> {
            invRoDVO.setApplyNo(applyNo);
            invRoDVO.setDocStatus(UdcEnum.INV_RO_STATUS_APPING.getValueCode());
            invRoDVO.setApprTime(LocalDateTime.now());
        });
        this.invRoDRepo.saveAll(invRoDDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public List<InvRoDVO> findByIds(List<Long> invIdList) {
        if (CollectionUtils.isEmpty(invIdList)) {
            return Collections.emptyList();
        }
        QInvRoDDO jpaQDo = QInvRoDDO.invRoDDO;
        List fetch = ((JPAQuery)((JPAQuery)this.invRoDRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.id.in(invIdList))).fetch();
        return fetch;
    }

    public List<InvRoDVO> findIdsBatch(List<Long> idList) {
        List<InvRoDVO> invRoDVOS = this.invRoDRepo.findAllById(idList).stream().map(DO -> {
            InvRoDVO invRoDVO = new InvRoDVO();
            BeanUtils.copyProperties((Object)DO, (Object)invRoDVO);
            return invRoDVO;
        }).collect(Collectors.toList());
        return invRoDVOS;
    }

    public InvRoDServiceImpl(InvRoDRepo invRoDRepo, InvRoDRepoProc invRoDRepoProc, SysUserService sysUserService, InvRoRepo invRoRepo, InvLotService invLotService, SysNumberRuleService sysNumberRuleService, InvLotCommonService invLotCommonService) {
        this.invRoDRepo = invRoDRepo;
        this.invRoDRepoProc = invRoDRepoProc;
        this.sysUserService = sysUserService;
        this.invRoRepo = invRoRepo;
        this.invLotService = invLotService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.invLotCommonService = invLotCommonService;
    }
}

