/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.convert.InvRoDeducConvert;
import com.elitesland.inv.entity.InvRoDeducDO;
import com.elitesland.inv.entity.QInvRoDeducDO;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.param.InvRoDeducQueryParam;
import com.elitesland.inv.param.InvRoDeducQuerySearchGroupParam;
import com.elitesland.inv.repo.InvRoDeducRepo;
import com.elitesland.inv.repo.InvRoDeducRepoProc;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvRoDeducService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvRoDeducVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invRoDeducService")
public class InvRoDeducServiceImpl
implements InvRoDeducService {
    private final InvRoDeducRepo invRoDeducRepo;
    private final InvRoDeducRepoProc invRoDeducRepoProc;
    private final InvLotService invLotService;
    private final InvWhService invWhService;

    @SysCodeProc
    public PagingVO<InvRoDeducVO> search(InvRoDeducQueryParam param) {
        Page ret = this.invRoDeducRepo.findAll(this.invRoDeducRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(InvRoDeducConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<InvRoDeducVO> findCodeOne(String itemCode) {
        JPAQuery<InvRoDeducVO> jpaQuery = this.invRoDeducRepoProc.select(null);
        InvRoDeducVO vo = (InvRoDeducVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<InvRoDeducVO> findIdOne(Long id) {
        return this.invRoDeducRepo.findById(id).map(InvRoDeducConvert.INSTANCE::doToVO);
    }

    @SysCodeProc
    public List<InvRoDeducVO> findIdBatch(List<Long> idList) {
        return this.invRoDeducRepo.findAllById(idList).stream().map(InvRoDeducConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(InvRoDeducDO invRoDeducDO) {
        return ((InvRoDeducDO)this.invRoDeducRepo.save(invRoDeducDO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvRoDeducDO> list) {
        return this.invRoDeducRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(InvRoDeducDO objDo) {
        Optional optional = this.invRoDeducRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (InvRoDeducDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invRoDeducRepo.save((InvRoDeducDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QInvRoDeducDO jpaQDo = QInvRoDeducDO.invRoDeducDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invRoDeducRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvRoDeducDO do1 = (InvRoDeducDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.invRoDeducRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.invRoDeducRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invRoDeducRepo.deleteById(id));
    }

    public List<InvRoDeducVO> findByParams(InvRoDeducQueryParam queryParam) {
        QInvRoDeducDO jpaQDo = QInvRoDeducDO.invRoDeducDO;
        BooleanExpression predicate = jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull());
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.invRoDeducRepoProc.where(queryParam));
        Iterable all = this.invRoDeducRepo.findAll((Predicate)predicate);
        return Lists.newArrayList((Iterable)all).stream().map(InvRoDeducConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @SysCodeProc
    public PagingVO<InvRoDeducVO> searchGroup(InvRoDeducQuerySearchGroupParam param) {
        if (!StringUtils.isEmpty((Object)param.getBrandCode())) {
            // empty if block
        }
        JPAQuery<InvRoDeducVO> jpaQuery = this.invRoDeducRepoProc.selectGroup(param);
        param.setPaging(jpaQuery);
        List records = jpaQuery.fetch();
        List itemIdList = records.stream().map(InvRoDeducVO::getItemId).distinct().collect(Collectors.toList());
        List whIdList = records.stream().map(InvRoDeducVO::getWhId).distinct().collect(Collectors.toList());
        List roCustIdList = records.stream().map(InvRoDeducVO::getRoDCustId).distinct().collect(Collectors.toList());
        List applyEmpIdList = records.stream().map(InvRoDeducVO::getApplyEmpId).distinct().collect(Collectors.toList());
        List brandCodeList = records.stream().map(InvRoDeducVO::getBrandCode).distinct().collect(Collectors.toList());
        List whList = CollectionUtils.isEmpty(whIdList) ? Collections.emptyList() : this.invWhService.findIdBatch(whIdList);
        records.parallelStream().forEach(i -> {
            List invLotVOS;
            InvLotParam queryParam = new InvLotParam();
            if (!StringUtils.isEmpty((Object)i.getItemId())) {
                queryParam.setItemId(i.getItemId());
            }
            if (!StringUtils.isEmpty((Object)i.getVariId())) {
                queryParam.setVariId(i.getVariId());
            }
            if (!StringUtils.isEmpty((Object)i.getLotNo())) {
                queryParam.setLotNo(i.getLotNo());
            }
            if (!CollectionUtils.isEmpty((Collection)(invLotVOS = this.invLotService.findByParams(queryParam)))) {
                InvLotRespVO lotVO = (InvLotRespVO)invLotVOS.get(0);
                i.setManuDate(lotVO.getManuDate());
                i.setExpireDate(lotVO.getExpireDate());
                i.setMenuLotNo(lotVO.getMenuLotNo());
            }
            whList.stream().filter(wh -> wh.getId().equals(i.getWhId())).findAny().ifPresent(o -> {
                i.setWhCode(o.getWhCode());
                i.setWhName(o.getWhName());
            });
        });
        return PagingVO.builder().total(Long.valueOf(jpaQuery.fetchCount())).records(records).build();
    }

    public InvRoDeducServiceImpl(InvRoDeducRepo invRoDeducRepo, InvRoDeducRepoProc invRoDeducRepoProc, InvLotService invLotService, InvWhService invWhService) {
        this.invRoDeducRepo = invRoDeducRepo;
        this.invRoDeducRepoProc = invRoDeducRepoProc;
        this.invLotService = invLotService;
        this.invWhService = invWhService;
    }
}

