/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvRoConvert;
import com.elitesland.inv.convert.InvRoDConvert;
import com.elitesland.inv.entity.InvRoDDO;
import com.elitesland.inv.entity.InvRoDO;
import com.elitesland.inv.entity.QInvRoDO;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.param.InvRoCreateParam;
import com.elitesland.inv.param.InvRoDCreateParam;
import com.elitesland.inv.repo.InvRoRepo;
import com.elitesland.inv.repo.InvRoRepoProc;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvRoCommonService;
import com.elitesland.inv.service.InvRoDService;
import com.elitesland.inv.service.InvRoService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.InvRoCommon30InVO;
import com.elitesland.inv.vo.InvRoCommon30OutVO;
import com.elitesland.inv.vo.InvRoCommon31InVO;
import com.elitesland.inv.vo.InvRoCommon32InVO;
import com.elitesland.inv.vo.InvRoDVO;
import com.elitesland.inv.vo.InvRoVO;
import com.elitesland.inv.vo.param.InvRoQueryParam;
import com.elitesland.inv.vo.resp.InvRoDDownloadRespVO;
import com.elitesland.inv.vo.resp.InvRoDRespVO;
import com.elitesland.inv.vo.resp.InvRoRespVO;
import com.elitesland.inv.vo.resp.InvStkRespVO;
import com.elitesland.org.service.OrgBuService;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUserService;
import com.elitesland.util.BeanCopyUtil;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invRoService")
public class InvRoServiceImpl
implements InvRoService {
    private static final Logger log = LoggerFactory.getLogger(InvRoServiceImpl.class);
    private final InvRoRepo invRoRepo;
    private final InvRoRepoProc invRoRepoProc;
    private final InvRoDService invRoDService;
    private final InvLotService invLotService;
    @Autowired
    private InvRoCommonService invRoCommonService;
    private final OrgOuService orgOuService;
    private final OrgBuService orgBuService;
    private final SysUserService sysUserService;
    private final InvStkService invStkService;
    private final String RELEASE = "RELEASE";
    private final String LOCK = "LOCK";

    @SysCodeProc
    public PagingVO<InvRoRespVO> search(InvRoQueryParam param) {
        return this.invRoRepoProc.useSelect(param);
    }

    @Transactional
    public void releaseInvRoList(List<Long> idList) {
        List invRoDOList = this.invRoRepo.findAllById(idList);
        List checkIds = invRoDOList.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
        if (idList.stream().filter(i -> !checkIds.contains(i)).count() > 0L) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38");
        }
        if (invRoDOList.stream().filter(i -> !UdcEnum.INV_RO_STATUS_APPED.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u7684\u9884\u7559\u5355\u624d\u53ef\u4ee5\u91ca\u653e");
        }
        if (invRoDOList.stream().filter(i -> UdcEnum.INV_RO_STATUS_RL.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u9884\u7559\u5355\u5df2\u88ab\u91ca\u653e\uff0c\u4e0d\u53ef\u518d\u91ca\u653e");
        }
        List invRoDVOList = this.invRoDService.findByMasIds(idList);
        List common32InVOList = Collections.synchronizedList(new ArrayList());
        invRoDVOList.parallelStream().forEach(roDVO -> {
            InvRoCommon32InVO common32InVO = InvCommonConvert.INSTANCE.invRoDVOToInvRoCommon32InVO((InvRoDVO)roDVO);
            common32InVO.setFclFlag(Integer.valueOf(0));
            common32InVO.setMode("RELEASE");
            common32InVO.setSrcDocDid(roDVO.getId());
            common32InVO.setSrcDocId(roDVO.getMasId());
            invRoDOList.stream().filter(i -> roDVO.getMasId().equals(i.getId())).findAny().ifPresent(i -> {
                common32InVO.setSrcDocNo(i.getDocNo());
                common32InVO.setDocNo(i.getDocNo());
            });
            common32InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_RO.getValueCode());
            common32InVO.setDeducType(UdcEnum.INV_RO_USE_TYPE_MU_RELEASE.getValueCode());
            common32InVOList.add(common32InVO);
        });
        this.invRoCommonService.invRoDListUpdate(common32InVOList);
    }

    @SysCodeProc
    public PagingVO<InvRoDRespVO> findCombine(InvRoCommon30InVO param) {
        Map integerListMap = this.invRoCommonService.invRoDListQuery(Arrays.asList(param));
        List records = (List)integerListMap.get(0);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return PagingVO.builder().total(Long.valueOf(0L)).records(Collections.EMPTY_LIST).build();
        }
        List dataList = records.stream().map(i -> {
            InvRoDVO invRoDVO = InvCommonConvert.INSTANCE.invRoCommon30OutVOToInvRoDVO((InvRoCommon30OutVO)i);
            invRoDVO.setId(i.getRoDId());
            invRoDVO.setMasId(i.getRoId());
            return invRoDVO;
        }).sorted(Comparator.comparing(BaseModelVO::getCreateTime).reversed()).collect(Collectors.toList());
        List collect = records.stream().map(i -> {
            InvRoDRespVO downloadRespVO = new InvRoDRespVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadRespVO);
            return downloadRespVO;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(records.size())).records(collect).build();
    }

    public List<InvRoRespVO> findByParams(InvRoQueryParam queryParam) {
        List fetch = this.invRoRepoProc.select(queryParam).fetch();
        List<InvRoRespVO> collect = fetch.stream().map(i -> {
            InvRoRespVO downloadRespVO = new InvRoRespVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadRespVO);
            return downloadRespVO;
        }).collect(Collectors.toList());
        return collect;
    }

    @SysCodeProc
    public Optional<InvRoVO> findCodeOne(String docNo) {
        InvRoVO vo = (InvRoVO)((JPAQuery)this.invRoRepoProc.select(null).where((Predicate)QInvRoDO.invRoDO.docNo.eq((Object)docNo))).fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<InvRoRespVO> findIdOne(Long id) {
        Optional<InvRoRespVO> invRoVO = this.invRoRepo.findById(id).map(DO -> (InvRoRespVO)BeanUtil.copyProperties((Object)DO, InvRoRespVO.class));
        if (invRoVO.isPresent()) {
            InvRoRespVO roVO = invRoVO.get();
            CompletableFuture<Void> orgOu = CompletableFuture.runAsync(() -> {});
            CompletableFuture<Void> orgBu = CompletableFuture.runAsync(() -> {});
            CompletableFuture<Void> orgCust = CompletableFuture.runAsync(() -> {});
            CompletableFuture<Void> orgEmp = CompletableFuture.runAsync(() -> {});
            try {
                CompletableFuture.allOf(orgOu, orgBu, orgCust, orgEmp).get();
                return Optional.of(roVO);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return invRoVO;
    }

    public List<InvRoDDownloadRespVO> useVOToDownload(List<InvRoDRespVO> records) {
        List<InvRoDDownloadRespVO> collect = records.stream().map(i -> {
            InvRoDDownloadRespVO downloadRespVO = new InvRoDDownloadRespVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadRespVO);
            return downloadRespVO;
        }).collect(Collectors.toList());
        return collect;
    }

    @SysCodeProc
    public List<InvRoVO> findIdBatch(List<Long> idList) {
        List<InvRoVO> invRoVOS = this.invRoRepo.findAllById(idList).stream().map(DO -> {
            InvRoVO invRoVO = new InvRoVO();
            BeanUtils.copyProperties((Object)DO, (Object)invRoVO);
            return invRoVO;
        }).collect(Collectors.toList());
        return invRoVOS;
    }

    @Transactional
    public Long createOne(InvRoVO invRoVO) {
        InvRoDO invRoDO = new InvRoDO();
        BeanUtils.copyProperties((Object)invRoVO, (Object)invRoDO);
        return ((InvRoDO)this.invRoRepo.save(invRoDO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvRoVO> list) {
        InvRoDO invRoDO = new InvRoDO();
        ArrayList invRoVOlist = new ArrayList();
        list.stream().forEach(invRoVOS -> {
            BeanUtils.copyProperties((Object)invRoVOS, (Object)invRoDO);
            invRoVOlist.add(invRoDO);
        });
        return this.invRoRepo.saveAll(invRoVOlist).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void updateDO(InvRoVO objDo) {
        Optional optional = this.invRoRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invRoRepo.save((InvRoDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QInvRoDO jpaQDo = QInvRoDO.invRoDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invRoRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvRoDO do1 = (InvRoDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.invRoRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.invRoRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invRoRepo.deleteById(id));
    }

    public List<InvRoVO> findByDocNos(List<String> docNoList) {
        if (CollectionUtils.isEmpty(docNoList)) {
            return Collections.emptyList();
        }
        QInvRoDO jpaQDo = QInvRoDO.invRoDO;
        return ((JPAQuery)((JPAQuery)this.invRoRepoProc.select(null).where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()))).where((Predicate)jpaQDo.docNo.in(docNoList))).fetch();
    }

    @Transactional
    public void cancelBatch(List<Long> idList) {
        List invRoVOList = this.invRoRepo.findAllById(idList);
        if (idList.size() != invRoVOList.size()) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u9884\u7559\u5355\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        if (invRoVOList.parallelStream().filter(i -> UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode().equals(i.getApprStatus())).count() > 0L) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u5df2\u8fc7\u8d26\u7684\u9884\u7559\u5355\u65e0\u6cd5\u518d\u53d6\u6d88");
        }
        if (invRoVOList.parallelStream().filter(i -> UdcEnum.INV_RO_STATUS_CL.getValueCode().equals(i.getDocStatus())).count() > 0L) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u5df2\u53d6\u6d88\u7684\u9884\u7559\u5355\u65e0\u6cd5\u518d\u53d6\u6d88");
        }
        invRoVOList.stream().forEach(i -> i.setDocStatus(UdcEnum.INV_RO_STATUS_CL.getValueCode()));
        this.invRoRepo.saveAll(invRoVOList);
    }

    @Transactional
    public Long create(InvRoCommon31InVO invRoCommon31InVO) {
        invRoCommon31InVO.getInvRoDCreateParamList().stream().forEach(i -> {
            InvLotParam param = new InvLotParam();
            param.setItemId(i.getItemId());
            param.setLotNo(i.getLotNo());
            List ret = this.invLotService.findByParams(param);
            ret.stream().forEach(v -> {
                if (v.getQcStatus() != null && v.getQcStatus().equals("LOCK")) {
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6279\u6b21\u8d28\u91cf\u72b6\u6001\u4e3a\u9501\u5b9a\u65f6\u4e0d\u80fd\u9884\u7559");
                }
            });
        });
        invRoCommon31InVO.getInvRoCreateParam().setDocStatus(UdcEnum.INV_RO_STATUS_DR.getValueCode());
        return this.invRoCommonService.invRoDListSave(invRoCommon31InVO);
    }

    @Transactional
    public Long createDoc(InvRoCommon31InVO invRoCommon31InVO) {
        InvRoDO invRoDO;
        InvRoCreateParam invRoD = invRoCommon31InVO.getInvRoCreateParam();
        invRoDO.setDocType((invRoDO = InvRoConvert.INSTANCE.invRoCreateParamToInvRoDO(invRoD)).getDocType() != null ? invRoDO.getDocType() : UdcEnum.COM_DOC_CLS_RO.getValueCode());
        invRoDO.setDocStatus(invRoDO.getDocStatus() != null ? invRoDO.getDocStatus() : UdcEnum.INV_RO_STATUS_DR.getValueCode());
        InvRoVO invRoVO = new InvRoVO();
        BeanUtils.copyProperties((Object)invRoDO, (Object)invRoVO);
        Long id = this.createOne(invRoVO);
        if (!CollectionUtils.isEmpty((Collection)invRoCommon31InVO.getInvRoDCreateParamList())) {
            AtomicDouble lineNo = new AtomicDouble(0.0);
            List invRoDDOs = invRoCommon31InVO.getInvRoDCreateParamList().stream().map(d -> {
                if (d.getUsedQty() == null) {
                    d.setUsedQty(Double.valueOf(0.0));
                }
                InvLotParam param = new InvLotParam();
                param.setItemId(d.getItemId());
                param.setLotNo(d.getLotNo());
                List ret = this.invLotService.findByParams(param);
                ret.stream().forEach(v -> {
                    if (v.getQcStatus() != null && v.getQcStatus().equals("LOCK")) {
                        throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6279\u6b21\u8d28\u91cf\u72b6\u6001\u4e3a\u9501\u5b9a\u65f6\u4e0d\u80fd\u9884\u7559");
                    }
                });
                List<InvLotVO> lot = ret.stream().map(r -> {
                    InvLotVO lotVO = new InvLotVO();
                    BeanUtil.copyProperties((Object)r, (Object)lotVO);
                    return lotVO;
                }).collect(Collectors.toList());
                InvRoDCreateParam d1 = this.convertRoDcParams(lot, (InvRoDCreateParam)d);
                InvRoDDO invRoDDO = InvRoDConvert.INSTANCE.invRoDCreateParamToInvRoDO(d1);
                invRoDDO.setMasId(id);
                invRoDDO.setDocNo(invRoDO.getDocNo());
                invRoDDO.setLineNo(invRoDDO.getLineNo() != null ? invRoDDO.getLineNo().doubleValue() : lineNo.addAndGet(1.0));
                return invRoDDO;
            }).collect(Collectors.toList());
            InvRoCreateParam invRoCreateParam = invRoCommon31InVO.getInvRoCreateParam();
            invRoCreateParam.setDocStatus(UdcEnum.INV_RO_STATUS_DR.getValueCode());
            this.invRoCommonService.saveCheckIn(invRoCreateParam, invRoCommon31InVO.getInvRoDCreateParamList());
        }
        return id;
    }

    public InvRoDCreateParam convertRoDcParams(List<InvLotVO> lotDOs, InvRoDCreateParam d1) {
        lotDOs.forEach(i -> {
            if (i.getLotNo().equals(d1.getLotNo()) && i.getItemId().equals(d1.getItemId())) {
                Long days = LocalDate.now().toEpochDay() - i.getManuDate().toLocalDate().toEpochDay();
                double fress = days.doubleValue() / i.getExpireDays().doubleValue();
                if (fress < 0.3333333333333333) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_1.getValueCode());
                } else if (fress >= 0.3333333333333333 && fress < 0.5) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_2.getValueCode());
                } else if (fress >= 0.5 && fress < 0.6666666666666666) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_3.getValueCode());
                } else if (fress >= 0.6666666666666666 && fress < 1.0) {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_4.getValueCode());
                } else {
                    d1.setFressType(UdcEnum.COM_FRESS_TYPE_5.getValueCode());
                }
                Long expireDays = i.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay();
                d1.setUnitExpireDays(Integer.valueOf(expireDays < 0L ? 0 : expireDays.intValue()));
            }
        });
        return d1;
    }

    @Transactional
    public void update(List<InvRoCommon32InVO> common32InVOList) {
        this.invRoCommonService.invRoDListUpdate(common32InVOList);
    }

    @Transactional
    public void submit(Long id) {
        Optional optional = this.invRoRepo.findById(id);
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u63d0\u4ea4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvRoDO invRoDO = (InvRoDO)optional.get();
        invRoDO.setDocStatus(UdcEnum.INV_RO_STATUS_APPING.getValueCode());
        invRoDO.setApprStatus(UdcEnum.COM_APPR_STATUS_APPROVING.getValueCode());
        this.invRoRepo.save(invRoDO);
    }

    @SysCodeProc
    public List<InvRoDRespVO> findRoDListById(Long roId) {
        List invRoDVOS = this.invRoDService.findByMasIds(Arrays.asList(roId));
        this.invRoCommonService.setOtherFields(invRoDVOS);
        List<InvRoDRespVO> collect = invRoDVOS.stream().map(i -> {
            InvRoDRespVO invRoDRespVO = new InvRoDRespVO();
            BeanUtils.copyProperties((Object)i, (Object)invRoDRespVO);
            return invRoDRespVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public boolean existsByDocStatus(List<String> docStatuses) {
        InvRoQueryParam invRoQueryParam = new InvRoQueryParam();
        invRoQueryParam.setDocStatuses(docStatuses);
        List ret = this.invRoRepoProc.select(invRoQueryParam).fetch();
        return this.invRoRepoProc.select(invRoQueryParam).fetch().size() > 0;
    }

    public Boolean checkRoExist(InvRoCommon30InVO queryParam) {
        InvBaseModel stkParam = new InvBaseModel();
        stkParam.setItemId(queryParam.getItemId());
        stkParam.setLotNo(queryParam.getLotNo());
        stkParam.setWhId(queryParam.getWhId());
        stkParam.setDeter1(queryParam.getDeter1());
        stkParam.setDeter2(queryParam.getDeter2());
        stkParam.setDeter3(queryParam.getDeter3());
        InvStkRespVO invStk = this.invStkService.getInvStk(stkParam);
        if (invStk == null) {
            return false;
        }
        if (invStk.getAvalQty() >= queryParam.getQty()) {
            return false;
        }
        double qty = queryParam.getQty();
        queryParam.setQty(null);
        List ret = this.findCombine(queryParam).getRecords().stream().filter(v -> v.getDocStatus() != null && !v.getDocStatus().equals(UdcEnum.INV_RO_STATUS_RL.getValueCode())).collect(Collectors.toList());
        if (ret.size() == 0) {
            throw new BusinessException("\u5e93\u5b58\u4f59\u989d\u4e0d\u8db3");
        }
        if (ret.stream().map(InvRoDRespVO::getQty).reduce(0.0, Double::sum) + invStk.getAvalQty() > qty) {
            return true;
        }
        throw new BusinessException("\u5e93\u5b58\u4f59\u989d\u4e0d\u8db3");
    }

    @Transactional
    public void checkBatch(List<Long> idList) {
        List invRoDOS = this.invRoRepo.findAllById(idList);
        if (invRoDOS.size() > 0) {
            invRoDOS.forEach(ro -> {
                ro.setDocStatus(UdcEnum.INV_RO_STATUS_APPED.getValueCode());
                ro.setApprStatus(UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
                this.invRoCommonService.lockInvStk(ro.getId());
            });
            this.invRoRepo.saveAll(invRoDOS);
        }
    }

    public void refuseBatch(List<Long> idList) {
        List invRoDOS = this.invRoRepo.findAllById(idList);
        if (invRoDOS.size() > 0) {
            invRoDOS.forEach(ro -> ro.setDocStatus(UdcEnum.INV_RO_STATUS_RJ.getValueCode()));
            this.invRoRepo.saveAll(invRoDOS);
        }
    }

    public InvRoServiceImpl(InvRoRepo invRoRepo, InvRoRepoProc invRoRepoProc, InvRoDService invRoDService, InvLotService invLotService, OrgOuService orgOuService, OrgBuService orgBuService, SysUserService sysUserService, InvStkService invStkService) {
        this.invRoRepo = invRoRepo;
        this.invRoRepoProc = invRoRepoProc;
        this.invRoDService = invRoDService;
        this.invLotService = invLotService;
        this.orgOuService = orgOuService;
        this.orgBuService = orgBuService;
        this.sysUserService = sysUserService;
        this.invStkService = invStkService;
    }
}

