/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvSinConvert;
import com.elitesland.inv.convert.InvSinDConvert;
import com.elitesland.inv.entity.InvSinDDO;
import com.elitesland.inv.entity.InvSinDO;
import com.elitesland.inv.param.InvSinCreateParam;
import com.elitesland.inv.param.InvSinDCreateParam;
import com.elitesland.inv.repo.InvSinDRepo;
import com.elitesland.inv.repo.InvSinRepo;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvSinDService;
import com.elitesland.inv.service.InvSinService;
import com.elitesland.inv.vo.InvSinDVO;
import com.google.common.util.concurrent.AtomicDouble;
import io.vavr.Tuple;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invSinService")
public class InvSinServiceImpl
implements InvSinService {
    private final InvSinRepo invSinRepo;
    private final InvSinDService invSinDService;
    private final InvSinDRepo invSinDRepo;
    private final InvLotService invLotService;

    @Transactional
    public Long saveOneInvSin(InvSinCreateParam createParam) {
        Optional<InvSinDO> invSinOpt = this.invSinRepo.findByDocNo(createParam.getDocNo());
        if (createParam.getId() == null) {
            invSinOpt.ifPresent(w -> {
                throw new BusinessException(ApiCode.FAIL, w.getDocNo() + "\u536b\u68c0\u5355\u53f7\u5df2\u5b58\u5728");
            });
        }
        createParam.getInvSinDCreateParamList().stream().forEach(i -> {
            if (i.getLotNo() != null && i.getItemId() != null) {
                List invSinDVOS = this.invSinDService.findByItemIdAndLotNoAndSrcDocNo(i.getItemId(), i.getLotNo(), i.getSrcDocNo()).stream().filter(v -> !v.getMasId().equals(i.getMasId())).collect(Collectors.toList());
                Double sum = createParam.getInvSinDCreateParamList().stream().filter(v -> v.getItemId().equals(i.getItemId()) && v.getLotNo().equals(i.getLotNo()) && v.hashCode() != i.hashCode()).map(InvSinDCreateParam::getSinQty).reduce(Double::sum).orElse(0.0);
                invSinDVOS.stream().map(InvSinDVO::getSinQty).reduce(Double::sum).ifPresent(w -> {
                    if (sum + w > i.getSrcQty()) {
                        throw new BusinessException(ApiCode.FAIL, createParam.getDocNo() + "\u536b\u68c0\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u53ef\u536b\u68c0\u6570\u91cf");
                    }
                });
            }
        });
        InvSinDO sinDoc = InvSinConvert.INSTANCE.newToDo(createParam);
        this.invSinDRepo.deleteByMasId(sinDoc.getId());
        InvSinDO newSinDoc = (InvSinDO)this.invSinRepo.save(sinDoc);
        AtomicDouble linoNo = new AtomicDouble(0.0);
        this.relateDocVerify(createParam.getInvSinDCreateParamList());
        List details = createParam.getInvSinDCreateParamList().stream().map(cp -> {
            InvSinDDO invSinDetail = InvSinDConvert.INSTANCE.newToDO((InvSinDCreateParam)cp);
            invSinDetail.setMasId(newSinDoc.getId()).setLineNo(linoNo.addAndGet(1.0));
            return invSinDetail;
        }).collect(Collectors.toList());
        this.invSinDRepo.saveAll(details);
        List itmLotTuples = details.stream().map(d -> Tuple.of((Object)d.getLotNo(), (Object)d.getItemId())).collect(Collectors.toList());
        itmLotTuples.stream().forEach(i -> {
            List ret = this.invSinDService.findByItemIdAndLotNo((Long)i._2, (String)i._1);
            if (ret.size() > 0) {
                List t = ret.stream().sorted(Comparator.comparing(InvSinDVO::getSinQty).reversed()).collect(Collectors.toList());
                Double sinQty = ret.stream().mapToDouble(v -> v.getSinQty()).sum();
                if (((InvSinDVO)ret.get(0)).getSrcQty().equals(sinQty)) {
                    this.invLotService.addSinQty((String)i._1, (Long)i._2, sinQty, UdcEnum.INV_LOT_SIN_STATUS_ALL.getValueCode(), ((InvSinDVO)t.get(0)).getDocNo());
                } else {
                    this.invLotService.addSinQty((String)i._1, (Long)i._2, sinQty, UdcEnum.INV_LOT_SIN_STATUS_PART.getValueCode(), ((InvSinDVO)t.get(0)).getDocNo());
                }
            }
        });
        return newSinDoc.getId();
    }

    private void relateDocVerify(List<InvSinDCreateParam> invSinDCreateParams) {
        if (invSinDCreateParams.stream().anyMatch(v -> v.getSrcDocCls() != null && v.getSrcDocCls().equals(UdcEnum.COM_DOC_CLS_ASM.getValueCode()))) {
            return;
        }
        List srcDocDids = invSinDCreateParams.stream().map(InvSinDCreateParam::getSrcDocDid).distinct().collect(Collectors.toList());
    }

    public InvSinServiceImpl(InvSinRepo invSinRepo, InvSinDService invSinDService, InvSinDRepo invSinDRepo, InvLotService invLotService) {
        this.invSinRepo = invSinRepo;
        this.invSinDService = invSinDService;
        this.invSinDRepo = invSinDRepo;
        this.invLotService = invLotService;
    }
}

