/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvStkConvert;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.dto.OrgOuVO2;
import com.elitesland.inv.entity.InvIoDO;
import com.elitesland.inv.entity.InvStkDO;
import com.elitesland.inv.param.PriGroupParam;
import com.elitesland.inv.repo.InvIoRepo;
import com.elitesland.inv.repo.InvStkRepo;
import com.elitesland.inv.service.InvCorssentryPricepolicyService;
import com.elitesland.inv.service.InvIoService;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvLotCommon21FilterVO;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.InvStkVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.resp.InvStkRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invStkCommonService")
@DubboService
public class InvStkCommonServiceImpl
implements InvStkCommonService {
    private static final Logger log = LoggerFactory.getLogger(InvStkCommonServiceImpl.class);
    private final InvStkService invStkService;
    private final InvStkRepo invStkRepo;
    private final InvLotCommonService invLotCommonService;
    private final InvIoService invIoService;
    private final InvIoRepo invIoRepo;
    private final InvWhService invWhService;
    private final OrgOuService orgOuService;
    private final InvCorssentryPricepolicyService invCorssentryPricepolicyService;
    private final OutService outService;

    public InvStkVO getInvStk(InvBaseModel queryParam) {
        InvStkRespVO invStk = this.invStkService.getInvStk(queryParam);
        if (invStk == null) {
            return null;
        }
        InvStkVO invStkVO = new InvStkVO();
        BeanUtils.copyProperties((Object)invStk, (Object)invStkVO);
        return invStkVO;
    }

    public List<InvStkVO> getInvStkList(List<? extends InvBaseModel> queryParamList) {
        List invStkList = this.invStkService.getInvStkList(queryParamList);
        List<InvStkVO> collect = invStkList.stream().map(D -> {
            InvStkVO invStkVO = new InvStkVO();
            BeanUtils.copyProperties((Object)D, (Object)invStkVO);
            return invStkVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public List<InvStkVO> getInvStkCheckedList(List<InvStkVO> source, InvLotCommon21FilterVO filterVO) {
        return source.stream().filter(i -> {
            if (filterVO.getFclNum() == null || filterVO.getFclNum() == 0.0) {
                return true;
            }
            int num = (int)((i.getAvalQty() == null ? 0.0 : i.getAvalQty()) / filterVO.getFclNum());
            return num > 0;
        }).filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getFirstLotNo())) {
                return filterVO.getFirstLotNo().compareTo(i.getLotNo()) <= 0;
            }
            return true;
        }).filter(i -> {
            if (filterVO.getFressTypeDays() != null) {
                if (filterVO.getAdjustDays() == null) {
                    return (i.getUntilExpireDays() == null ? 0.0 : (double)i.getUntilExpireDays().intValue()) >= filterVO.getFressTypeDays();
                }
                return (i.getUntilExpireDays() == null ? 0.0 : (double)i.getUntilExpireDays().intValue()) >= filterVO.getFressTypeDays() + filterVO.getAdjustDays();
            }
            return true;
        }).collect(Collectors.toList());
    }

    public synchronized void invStkCommon28(List<InvStkCommon28InVO> common28InVOList) {
        log.info("\u5171\u901a\u65b9\u6cd528\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", common28InVOList.stream().map(InvStkCommon28InVO::toString).collect(Collectors.toList())));
        this.doProcess(common28InVOList, false);
    }

    public synchronized void invStkCommon37(List<InvStkCommon37InVO> common37InVOList) {
        log.info("\u5171\u901a\u65b9\u6cd537\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", common37InVOList.stream().map(InvStkCommon37InVO::toString).collect(Collectors.toList())));
        List<InvStkCommon28InVO> common28InVOList = common37InVOList.stream().map(i -> InvCommonConvert.INSTANCE.InvStkCommon37InVOToInvStkCommon28InVO((InvStkCommon37InVO)i)).collect(Collectors.toList());
        this.doProcess(common28InVOList, true);
    }

    public List<InvStkVO> getInvStkListByIds(List<Long> invStkIdList) {
        return this.invStkService.findIdBatch(invStkIdList);
    }

    @Transactional
    void doProcess(List<InvStkCommon28InVO> common28InVOList, boolean invStkThrowExcFlag) {
        common28InVOList.forEach(inVO -> {
            if (StringUtils.isEmpty((Object)inVO.getSrcDocCls()) || StringUtils.isEmpty((Object)inVO.getDocNo()) || StringUtils.isEmpty((Object)inVO.getSrcDocId()) || StringUtils.isEmpty((Object)inVO.getSrcDocDid())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u6765\u6e90\u5355\u636e\u7c7b\u522b\u3001\u6765\u6e90\u5355\u636e\u7f16\u53f7\u3001\u6765\u6e90\u5355\u636eID\u3001\u6765\u6e90\u5355\u636e\u660e\u7ec6ID \u5747\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!inVO.checkDeter()) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c[\u6e29\u5c42\u3001\u529f\u80fd\u5e93\u533a]\u3001\u5ba2\u6237\u53f7 \u4e09\u8005\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isEmpty((Object)inVO.getUom())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        common28InVOList = common28InVOList.stream().filter(inVO -> inVO.getQty() != null && inVO.getQty() != 0.0).collect(Collectors.toList());
        List<ItmItemVO> itmItemVOS = this.getItmItemVOList(common28InVOList);
        List orgWhVOList = this.invWhService.findIdBatch(common28InVOList.stream().map(InvBaseModel::getWhId).distinct().collect(Collectors.toList()));
        Long ioBatchId = LocalDateTime.now().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        common28InVOList.forEach(common28InVO -> {
            InvStkVO invStk = this.getInvStk((InvBaseModel)common28InVO);
            if (invStkThrowExcFlag) {
                Double avalQty;
                Double qty;
                if (invStk == null) {
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u4e0d\u5b58\u5728");
                }
                if (common28InVO.getInvStk28Enum1() != null) {
                    switch (common28InVO.getInvStk28Enum1()) {
                        case T_TYPE_20: 
                        case T_TYPE_21: 
                        case T_TYPE_22: 
                        case T_TYPE_23: {
                            qty = common28InVO.getQty() == null ? 0.0 : Math.abs(common28InVO.getQty());
                            avalQty = invStk.getAvalQty() == null ? 0.0 : invStk.getAvalQty();
                            if (!(avalQty - qty < 0.0)) break;
                            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3");
                        }
                    }
                }
                if (common28InVO.getInvStk28Enum2() != null) {
                    switch (common28InVO.getInvStk28Enum2()) {
                        case T_TYPE_20: 
                        case T_TYPE_21: 
                        case T_TYPE_22: 
                        case T_TYPE_23: {
                            qty = common28InVO.getQty() == null ? 0.0 : Math.abs(common28InVO.getQty());
                            avalQty = invStk.getAvalQty() == null ? 0.0 : invStk.getAvalQty();
                            if (!(avalQty - qty < 0.0)) break;
                            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3");
                        }
                    }
                }
            }
            ItmItemVO itmItemVO = itmItemVOS.stream().filter(i -> i.getId().equals(common28InVO.getItemId())).findAny().get();
            InvWhRespVO invWhRespVO = orgWhVOList.stream().filter(i -> i.getId().equals(common28InVO.getWhId())).findAny().get();
            this.saveOrUpdate((InvStkCommon28InVO)common28InVO, invStk, itmItemVO, invWhRespVO, ioBatchId);
        });
    }

    private void saveOrUpdate(final InvStkCommon28InVO common28InVO, InvStkVO invStk, ItmItemVO itmItemVO, InvWhRespVO invWhRespVO, Long ioBatchId) {
        InvStkDO invStkDO;
        if (invStk == null) {
            invStkDO = new InvStkDO();
            invStkDO.setItemId(itmItemVO.getId());
            invStkDO.setItemCode(itmItemVO.getItemCode());
            invStkDO.setUom(itmItemVO.getUom());
            invStkDO.setUom2(itmItemVO.getUom2());
            if (itmItemVO.getVolume() != null) {
                invStkDO.setVolume(Double.valueOf(itmItemVO.getVolume().floatValue()));
            }
            if (itmItemVO.getNetWeight() != null) {
                invStkDO.setNetWeight(Double.valueOf(itmItemVO.getNetWeight().floatValue()));
            }
            if (itmItemVO.getGrossWeight() != null) {
                invStkDO.setGrossWeight(Double.valueOf(itmItemVO.getGrossWeight().floatValue()));
            }
            invStkDO.setWhId(invWhRespVO.getId());
            invStkDO.setOuId(invWhRespVO.getOuId());
            invStkDO.setVariId(common28InVO.getVariId());
            invStkDO.setDeter1(common28InVO.getDeter1());
            invStkDO.setDeter2(common28InVO.getDeter2());
            invStkDO.setDeter3(common28InVO.getDeter3());
            invStkDO.setLotNo(common28InVO.getLotNo());
            invStkDO.setInDate(common28InVO.getOpDate());
            invStkDO.setOhQty(0.0);
            invStkDO.setOhQty2(0.0);
            invStkDO.setRsvQty(0.0);
            invStkDO.setRsvQty2(0.0);
            invStkDO.setRsvQty3(0.0);
            invStkDO.setRsvQty4(0.0);
            invStkDO.setLockQty(0.0);
            invStkDO.setLockQty2(0.0);
            invStkDO.setLockQty3(0.0);
            invStkDO.setLockQty4(0.0);
            invStkDO.setOwQty(0.0);
            invStkDO.setOwQty2(0.0);
            invStkDO.setOwQty3(0.0);
            invStkDO.setOwQty4(0.0);
            invStkDO.setAvalQty(0.0);
            invStkDO.setAvalQty2(0.0);
            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO(){
                {
                    this.setItemId(common28InVO.getItemId());
                    this.setVariId(common28InVO.getVariId());
                    this.setLotNo(common28InVO.getLotNo());
                }
            };
            Map map = this.invLotCommonService.getInvLotVOList(Arrays.asList(invLotCommon21InVO));
            List invLotList = (List)map.get(0);
            if (CollectionUtils.isEmpty((Collection)invLotList)) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            invStkDO.setUntilExpireDays(((InvLotRespVO)invLotList.get(0)).getUntilExpireDays());
            invStkDO.setFressType(((InvLotRespVO)invLotList.get(0)).getFressType());
            invStkDO.setSrcDocCls(common28InVO.getSrcDocCls());
            invStkDO.setSrcDocId(common28InVO.getSrcDocId());
            invStkDO.setSrcDocDid(common28InVO.getSrcDocDid());
            invStkDO.setCreateUserId(common28InVO.getCreateUserId());
        } else {
            invStkDO = InvStkConvert.INSTANCE.voToDO(invStk);
        }
        this.checkNull(invStkDO, common28InVO);
        this.computePrice(invStkDO, common28InVO, itmItemVO, ioBatchId, invWhRespVO);
    }

    public void computePrice(InvStkDO invStkDO, InvStkCommon28InVO common28InVO, ItmItemVO itmItemVO, Long ioBatchId, InvWhRespVO invWhRespVO) {
        OrgOuVO2 ou = null;
        if (invWhRespVO != null) {
            OrgOuVO orgOuVO = this.outService.findOrgOuVOById(invWhRespVO.getOuId());
            ou = new OrgOuVO2();
            BeanUtils.copyProperties((Object)orgOuVO, (Object)ou);
            ou.setOuCurr(orgOuVO.getStdCurr());
        }
        PriGroupParam priGroupParam = new PriGroupParam();
        priGroupParam.setFromOuId(ou.getId());
        priGroupParam.setItemId(itmItemVO.getId());
        priGroupParam.setDocTime(common28InVO.getOpDate());
        PriSalePriceVO priSalePriceVO = this.invCorssentryPricepolicyService.costPrice(priGroupParam);
        BigDecimal costPrice = priSalePriceVO.getCostPrice();
        BigDecimal amt = costPrice.multiply(BigDecimal.valueOf(invStkDO.getOhQty() == null ? 0.0 : invStkDO.getOhQty()));
        invStkDO.setAmt(amt);
        this.invStkRepo.save(invStkDO);
        this.saveInvIoLog(common28InVO, common28InVO.getInvStk28Enum1(), itmItemVO, ou, costPrice, ioBatchId, 1.0);
        this.saveInvIoLog(common28InVO, common28InVO.getInvStk28Enum2(), itmItemVO, ou, costPrice, ioBatchId, 2.0);
    }

    public void checkNull(InvStkDO invStkDO, InvStkCommon28InVO common28InVO) {
        invStkDO.setOhQty(invStkDO.getOhQty() == null ? 0.0 : invStkDO.getOhQty());
        invStkDO.setOhQty2(invStkDO.getOhQty2() == null ? 0.0 : invStkDO.getOhQty2());
        invStkDO.setRsvQty(invStkDO.getRsvQty() == null ? 0.0 : invStkDO.getRsvQty());
        invStkDO.setRsvQty2(invStkDO.getRsvQty2() == null ? 0.0 : invStkDO.getRsvQty2());
        invStkDO.setRsvQty3(invStkDO.getRsvQty3() == null ? 0.0 : invStkDO.getRsvQty3());
        invStkDO.setRsvQty4(invStkDO.getRsvQty4() == null ? 0.0 : invStkDO.getRsvQty4());
        invStkDO.setLockQty(invStkDO.getLockQty() == null ? 0.0 : invStkDO.getLockQty());
        invStkDO.setLockQty2(invStkDO.getLockQty2() == null ? 0.0 : invStkDO.getLockQty2());
        invStkDO.setLockQty3(invStkDO.getLockQty3() == null ? 0.0 : invStkDO.getLockQty3());
        invStkDO.setLockQty4(invStkDO.getLockQty4() == null ? 0.0 : invStkDO.getLockQty4());
        invStkDO.setOwQty(invStkDO.getOwQty() == null ? 0.0 : invStkDO.getOwQty());
        invStkDO.setOwQty2(invStkDO.getOwQty2() == null ? 0.0 : invStkDO.getOwQty2());
        invStkDO.setOwQty3(invStkDO.getOwQty3() == null ? 0.0 : invStkDO.getOwQty3());
        invStkDO.setOwQty4(invStkDO.getOwQty4() == null ? 0.0 : invStkDO.getOwQty4());
        invStkDO.setAvalQty(invStkDO.getAvalQty() == null ? 0.0 : invStkDO.getAvalQty());
        invStkDO.setAvalQty2(invStkDO.getAvalQty2() == null ? 0.0 : invStkDO.getAvalQty2());
        this.setInvStkDOQty(common28InVO.getInvStk28Enum1(), common28InVO.getQty(), invStkDO);
        this.setInvStkDOQty(common28InVO.getInvStk28Enum2(), common28InVO.getQty(), invStkDO);
        if (invStkDO.getOhQty() < 0.0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u73b0\u6709\u91cf\u4e0d\u8db3\u3002");
        }
        if (invStkDO.getAvalQty() < 0.0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3\u3002");
        }
        if (invStkDO.getRsvQty() < 0.0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u786c\u627f\u8bfa\u91cf\u4e0d\u8db3\u3002");
        }
        if (invStkDO.getLockQty() < 0.0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u9501\u5b9a\u91cf\u4e0d\u8db3\u3002");
        }
        if (invStkDO.getRsvQty2() < 0.0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u9884\u7559\u91cf\u4e0d\u8db3\u3002");
        }
        if (invStkDO.getOwQty() < 0.0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u5728\u9014\u91cf\u4e0d\u8db3\u3002");
        }
    }

    private void saveInvIoLog(InvStkCommon28InVO common28InVO, InvStk28Enum invStk28Enum, ItmItemVO itmItemVO, OrgOuVO2 ou, BigDecimal costPrice, Long ioBatchId, Double lineNo) {
        log.info("\u5171\u901a\u65b9\u6cd529\uff0c\u65f6\u95f4\uff1a" + LocalDateTime.now() + "\uff0c\u5165\u53c2\uff1aInvStkCommon28InVO:" + (common28InVO == null ? null : common28InVO.toString()) + "InvStk28Enum:" + (invStk28Enum == null ? null : invStk28Enum.getIoCode()) + "ItmItemVO:" + (itmItemVO == null ? null : itmItemVO.toString()) + "OrgOuVO2:" + (ou == null ? null : ou.toString()) + "CostPrice:" + costPrice + "IoBatchId:" + ioBatchId + "LineNo:" + lineNo);
        if (invStk28Enum == null) {
            return;
        }
        ArrayList<InvIoDO> ioDOList = new ArrayList<InvIoDO>();
        InvIoDO invIoDO1 = InvCommonConvert.INSTANCE.invStkCommon28InVOToInvIoDO(common28InVO);
        invIoDO1.setIoBatchId(ioBatchId);
        invIoDO1.setLineNo(lineNo);
        invIoDO1.setDeleteFlag(0);
        invIoDO1.setIoCode(invStk28Enum.getIoCode());
        invIoDO1.setQty(this.setInvIoQty(invStk28Enum, common28InVO.getQty()));
        invIoDO1.setIoDate(common28InVO.getOpDate());
        invIoDO1.setUom2(itmItemVO.getUom2());
        if (itmItemVO.getVolume() != null) {
            invIoDO1.setVolume(Double.valueOf(itmItemVO.getVolume().floatValue()));
        }
        if (itmItemVO.getNetWeight() != null) {
            invIoDO1.setNetWeight(Double.valueOf(itmItemVO.getNetWeight().floatValue()));
        }
        if (itmItemVO.getGrossWeight() != null) {
            invIoDO1.setGrossWeight(Double.valueOf(itmItemVO.getGrossWeight().floatValue()));
        }
        invIoDO1.setWeightUomCode(itmItemVO.getWeightUom());
        if (costPrice != null) {
            invIoDO1.setCostPrice(costPrice);
            invIoDO1.setCostAmt(costPrice.multiply(new BigDecimal(invIoDO1.getQty())));
        }
        invIoDO1.setOuId(ou.getId());
        invIoDO1.setBuId(ou.getBuId());
        invIoDO1.setItemCode(itmItemVO.getItemCode());
        invIoDO1.setHomeCurr(ou.getOuCurr());
        invIoDO1.setIoStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());
        invIoDO1.setSrcDocNo(common28InVO.getDocNo());
        ioDOList.add(invIoDO1);
        this.invIoRepo.saveAll(ioDOList);
    }

    private Double setInvIoQty(InvStk28Enum invStk28Enum, Double qty) {
        qty = qty == null ? 0.0 : Math.abs(qty);
        switch (invStk28Enum) {
            case O_TYPE_01_01: 
            case O_TYPE_03: 
            case O_TYPE_05: 
            case O_TYPE_14: 
            case O_TYPE_17: 
            case O_TYPE_19: 
            case O_TYPE_01_02: 
            case T_TYPE_07_02: 
            case T_TYPE_07_04: 
            case T_TYPE_11: 
            case T_TYPE_12: 
            case T_TYPE_13: 
            case T_TYPE_24: 
            case T_TYPE_25: 
            case T_TYPE_26: 
            case T_TYPE_27: {
                qty = 0.0 - qty;
            }
        }
        return qty;
    }

    private void setInvStkDOQty(InvStk28Enum invStk28Enum, Double qty, InvStkDO invStkDO) {
        if (invStk28Enum == null) {
            return;
        }
        qty = qty == null ? 0.0 : Math.abs(qty);
        switch (invStk28Enum) {
            case O_TYPE_01_01: 
            case O_TYPE_03: 
            case O_TYPE_05: 
            case O_TYPE_14: 
            case O_TYPE_17: 
            case O_TYPE_19: {
                invStkDO.setOhQty(this.setQty(invStkDO.getOhQty()) - qty);
                break;
            }
            case I_TYPE_02: 
            case I_TYPE_04: 
            case I_TYPE_06: 
            case I_TYPE_15: 
            case I_TYPE_16: 
            case I_TYPE_18: {
                invStkDO.setOhQty(this.setQty(invStkDO.getOhQty()) + qty);
                break;
            }
            case O_TYPE_01_02: 
            case T_TYPE_07_02: {
                invStkDO.setRsvQty(this.setQty(invStkDO.getRsvQty()) - qty);
                break;
            }
            case T_TYPE_07_01: {
                invStkDO.setRsvQty(this.setQty(invStkDO.getRsvQty()) + qty);
                break;
            }
            case T_TYPE_07_04: 
            case T_TYPE_11: 
            case T_TYPE_12: 
            case T_TYPE_13: {
                invStkDO.setRsvQty2(this.setQty(invStkDO.getRsvQty2()) - qty);
                break;
            }
            case T_TYPE_07_03: 
            case T_TYPE_10: {
                invStkDO.setRsvQty2(this.setQty(invStkDO.getRsvQty2()) + qty);
                break;
            }
            case T_TYPE_20: 
            case T_TYPE_21: 
            case T_TYPE_22: 
            case T_TYPE_23: {
                invStkDO.setLockQty(this.setQty(invStkDO.getLockQty()) + qty);
                break;
            }
            case T_TYPE_24: 
            case T_TYPE_25: 
            case T_TYPE_26: 
            case T_TYPE_27: {
                invStkDO.setLockQty(this.setQty(invStkDO.getLockQty()) - qty);
            }
        }
        Double avalQty = (invStkDO.getOhQty() == null ? 0.0 : invStkDO.getOhQty()) - (invStkDO.getRsvQty() == null ? 0.0 : invStkDO.getRsvQty()) - (invStkDO.getRsvQty2() == null ? 0.0 : invStkDO.getRsvQty2()) - (invStkDO.getLockQty() == null ? 0.0 : invStkDO.getLockQty());
        invStkDO.setAvalQty(avalQty);
    }

    private Double setQty(Double qty) {
        return qty == null ? 0.0 : qty;
    }

    private List<ItmItemVO> getItmItemVOList(List<InvStkCommon28InVO> common28InVOList) {
        ArrayList<ItmItemVO> itmItemVOS = new ArrayList();
        List itemIdList = common28InVOList.stream().filter(f -> f.getItemId() != null).map(InvBaseModel::getItemId).distinct().collect(Collectors.toList());
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(itemIdList);
        if (CollectionUtils.isEmpty(itemIdList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<ItmItemDTO> itmItemDTOS = this.outService.itmItemAllSearch(itmItemPartParam);
        if (CollectionUtils.isEmpty(itmItemDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        itmItemVOS = itmItemDTOS.stream().map(e -> {
            ItmItemVO itmItemVO = new ItmItemVO();
            BeanUtils.copyProperties((Object)e, (Object)itmItemVO);
            return itmItemVO;
        }).collect(Collectors.toList());
        return itmItemVOS;
    }

    public InvStkCommonServiceImpl(InvStkService invStkService, InvStkRepo invStkRepo, InvLotCommonService invLotCommonService, InvIoService invIoService, InvIoRepo invIoRepo, InvWhService invWhService, OrgOuService orgOuService, InvCorssentryPricepolicyService invCorssentryPricepolicyService, OutService outService) {
        this.invStkService = invStkService;
        this.invStkRepo = invStkRepo;
        this.invLotCommonService = invLotCommonService;
        this.invIoService = invIoService;
        this.invIoRepo = invIoRepo;
        this.invWhService = invWhService;
        this.orgOuService = orgOuService;
        this.invCorssentryPricepolicyService = invCorssentryPricepolicyService;
        this.outService = outService;
    }
}

