/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.InvUdcEnum;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvStkConvert;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.dto.OrgOuVO2;
import com.elitesland.inv.entity.InvStkDO;
import com.elitesland.inv.entity.QInvStkDO;
import com.elitesland.inv.repo.InvStkRepo;
import com.elitesland.inv.repo.InvStkRepoProc;
import com.elitesland.inv.service.InvItemPkgService;
import com.elitesland.inv.service.InvStkService;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.InvBaseModel;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkDVO;
import com.elitesland.inv.vo.InvStkIOVO;
import com.elitesland.inv.vo.InvStkIOxVO;
import com.elitesland.inv.vo.InvStkVO;
import com.elitesland.inv.vo.param.InvStkDQueryParamVO;
import com.elitesland.inv.vo.param.InvStkIOParamVO;
import com.elitesland.inv.vo.param.InvStkQueryParamVO;
import com.elitesland.inv.vo.param.InvWhParamVO;
import com.elitesland.inv.vo.resp.InvStkDRespVO;
import com.elitesland.inv.vo.resp.InvStkIORespVO;
import com.elitesland.inv.vo.resp.InvStkRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvStkUpdateSaveVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@DubboService
public class InvStkServiceImpl
implements InvStkService {
    private final InvStkRepo invStkRepo;
    private final InvStkRepoProc invStkRepoProc;
    private final OrgOuService orgOuService;
    private final InvWhService invWhService;
    private final InvWhAreaService invWhAreaService;
    private final InvItemPkgService invItemPkgService;
    private final SysUdcService sysUdcService;
    private final OutService outService;
    private final String SMALL = "SMALL";

    @SysCodeProc
    public PagingVO<InvStkRespVO> search(InvStkQueryParamVO param) {
        PagingVO pagingVO = this.invStkRepoProc.useSelect(param);
        this.udcChange(pagingVO.getRecords());
        return pagingVO;
    }

    public List<InvStkRespVO> findInvStkRespVOs(InvStkQueryParamVO param) {
        ArrayList<InvStkRespVO> invStkRespVOS = new ArrayList<InvStkRespVO>();
        Iterable invStkDOIterable = this.invStkRepo.findAll(this.invStkRepoProc.findInvStkList(param));
        for (InvStkDO e : invStkDOIterable) {
            InvStkRespVO invStkRespVO = InvStkConvert.INSTANCE.doToRespVO(e);
            invStkRespVOS.add(invStkRespVO);
        }
        return invStkRespVOS;
    }

    public PagingVO<InvStkDRespVO> searchLot(InvStkDQueryParamVO param) {
        if (!CollectionUtils.isEmpty((Collection)param.getBrands())) {
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setIds(param.getItemIds());
            List brandItemIds = this.outService.itmItemPartSearch(itmItemPartParam).stream().map(ItmItemPartDTO::getId).collect(Collectors.toList());
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.builder().total(Long.valueOf(0L)).records(new ArrayList()).build();
            }
        }
        PagingVO pagingVO = this.invStkRepoProc.selectLot(param);
        List invStkDResults = pagingVO.getRecords();
        this.Results(invStkDResults);
        if (!CollectionUtils.isEmpty((Collection)invStkDResults.stream().map(InvStkDRespVO::getManuDate).collect(Collectors.toList()))) {
            invStkDResults = invStkDResults.stream().sorted(Comparator.comparing(InvStkDRespVO::getManuDate)).distinct().collect(Collectors.toList());
        }
        this.udcChange(invStkDResults);
        return PagingVO.builder().total(pagingVO.getTotal()).records(invStkDResults).build();
    }

    public List<InvStkDRespVO> udcChange(List<InvStkDRespVO> collect) {
        Map udcItemType = this.sysUdcService.getCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
        Map udcQcStatus = this.sysUdcService.getCodeMap(UdcEnum.INV_LOT_QC_STATUS_LOCK.getModel(), UdcEnum.INV_LOT_QC_STATUS_LOCK.getCode());
        Map udcFressType = this.sysUdcService.getCodeMap(UdcEnum.COM_FRESS_TYPE_1.getModel(), UdcEnum.COM_FRESS_TYPE_1.getCode());
        Map udcDeter1 = this.sysUdcService.getCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map udcDeter2 = this.sysUdcService.getCodeMap(InvUdcEnum.INV_FUNC_TYPE1_1.getModel(), InvUdcEnum.INV_FUNC_TYPE1_1.getCode());
        Map udcUom = this.sysUdcService.getCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map udcWhtype = this.sysUdcService.getCodeMap(InvUdcEnum.INV_WH_TYPE1_1.getModel(), InvUdcEnum.INV_WH_TYPE1_1.getCode());
        collect.stream().forEach(Stk -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getItemType()) && !MapUtils.isEmpty((Map)udcItemType)) {
                Stk.setItemTypeName((String)udcItemType.get(Stk.getItemType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getQcStatus()) && !MapUtils.isEmpty((Map)udcQcStatus)) {
                Stk.setQcStatusName((String)udcQcStatus.get(Stk.getQcStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getFressType()) && !MapUtils.isEmpty((Map)udcFressType)) {
                Stk.setFressTypeName((String)udcFressType.get(Stk.getFressType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                Stk.setDeter1Name((String)udcDeter1.get(Stk.getDeter1()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getDeter2()) && !MapUtils.isEmpty((Map)udcDeter2)) {
                Stk.setDeter2Name((String)udcDeter2.get(Stk.getDeter2()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                Stk.setUomName((String)udcUom.get(Stk.getUom()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getWhType()) && !MapUtils.isEmpty((Map)udcWhtype)) {
                Stk.setWhTypeName((String)udcWhtype.get(Stk.getWhType()));
            }
        });
        return collect;
    }

    @SysCodeProc
    public PagingVO<InvStkDRespVO> searchD(InvStkDQueryParamVO param) {
        if (!CollectionUtils.isEmpty((Collection)param.getBrands())) {
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setIds(param.getItemIds());
            List brandItemIds = this.outService.itmItemPartSearch(itmItemPartParam).stream().map(ItmItemPartDTO::getId).collect(Collectors.toList());
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.builder().total(Long.valueOf(0L)).records(new ArrayList()).build();
            }
        }
        if (!StringUtils.isEmpty((Object)param.getWhType())) {
            InvWhParamVO invWhParamVO = new InvWhParamVO();
            invWhParamVO.setWhIds(param.getWhIds());
            invWhParamVO.setWhType(param.getWhType());
            List collect = this.invWhService.search(invWhParamVO).getRecords().stream().map(BaseModelVO::getId).collect(Collectors.toList());
            if (collect.size() > 0) {
                param.setWhIds(collect);
            } else {
                return PagingVO.builder().total(Long.valueOf(0L)).records(new ArrayList()).build();
            }
        }
        PagingVO pagingVO = this.invStkRepoProc.useSelectD(param);
        List invStkDResults = pagingVO.getRecords();
        this.Results(invStkDResults);
        if (!CollectionUtils.isEmpty((Collection)invStkDResults.stream().map(InvStkDRespVO::getManuDate).collect(Collectors.toList()))) {
            invStkDResults = invStkDResults.stream().sorted(Comparator.comparing(InvStkDRespVO::getManuDate)).distinct().collect(Collectors.toList());
        }
        this.udcChange(invStkDResults);
        return PagingVO.builder().total(pagingVO.getTotal()).records(invStkDResults).build();
    }

    public void Results(List<InvStkDRespVO> invStkDResults) {
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(invStkDResults.stream().map(InvStkDRespVO::getItemId).collect(Collectors.toList()));
        List<ItmItemDTO> itmItemResults = this.outService.itmItemAllSearch(itmItemPartParam);
        List invWhRespVOS = this.invWhService.findIdBatch(invStkDResults.stream().map(InvStkDRespVO::getWhId).collect(Collectors.toList()));
        List<OrgOuVO> orgOuResults = this.outService.listOrgOuVOByIds(invStkDResults.stream().map(InvStkDRespVO::getOuId).collect(Collectors.toList()));
        List invItmPkgResults = this.invItemPkgService.findByItemIdIn(invStkDResults.stream().map(InvStkDRespVO::getItemId).collect(Collectors.toList()));
        List invWhArea = this.invWhAreaService.findAllByWhId(invStkDResults.stream().map(InvStkDRespVO::getWhId).collect(Collectors.toList()));
        invStkDResults.stream().forEach(i -> {
            invWhRespVOS.stream().filter(v -> v.getId().equals(i.getWhId())).findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
                i.setWhType(m.getWhType());
            });
            invWhArea.stream().filter(v -> v.getWhId().equals(i.getWhId()) && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2())).findFirst().ifPresent(m -> {
                i.setPCode(m.getPCode());
                i.setPName(m.getPName());
                i.setPType(m.getPType());
            });
            itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId())).findAny().ifPresent(m -> {
                i.setItemCode(m.getItemCode());
                i.setItemName(m.getItemName());
                i.setBrand(m.getBrand());
                i.setPackageSpec(m.getPackageSpec());
                i.setAgency(m.getAgency());
                i.setItemType(m.getItemType());
                i.setEn1(m.getEn1());
                i.setBrandName(i.getC2Name());
                i.setVolume(m.getVolume() == null ? null : Double.valueOf(m.getVolume().doubleValue()));
                i.setGrossWeight(m.getGrossWeight() == null ? null : Double.valueOf(m.getGrossWeight().doubleValue()));
                i.setNetWeight(m.getNetWeight() == null ? null : Double.valueOf(m.getNetWeight().doubleValue()));
                i.setTVolume(i.getOhQty() == null || m.getVolume() == null ? null : Double.valueOf(i.getOhQty() * (double)m.getVolume().floatValue()));
                i.setTGrossWeight(i.getOhQty() == null || m.getGrossWeight() == null ? null : Double.valueOf(i.getOhQty() * (double)m.getGrossWeight().floatValue()));
                i.setTNetWeight(i.getOhQty() == null || m.getNetWeight() == null ? null : Double.valueOf(i.getOhQty() * (double)m.getNetWeight().floatValue()));
                i.setTAvalQty(i.getAvalQty() == null || m.getEn1() == null ? null : Double.valueOf(i.getAvalQty() / (double)m.getEn1().floatValue()));
                i.setTOhQty(i.getOhQty() == null || m.getEn1() == null ? null : Double.valueOf(i.getOhQty() / (double)m.getEn1().floatValue()));
                i.setTRsvQty(i.getRsvQty() == null || m.getEn1() == null ? null : Double.valueOf(i.getRsvQty() / (double)m.getEn1().floatValue()));
                i.setItemOuterCode(m.getOuterCode());
                i.setBarCode(m.getBarCode());
                i.setSuppName(m.getSuppName());
            });
            orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                i.setOuCode(m.getCode());
                i.setOuName(m.getName());
            });
            invItmPkgResults.stream().filter(v -> v.getItemId().equals(i.getItemId()) && v.getPkgType().equals("SMALL")).findAny().ifPresent(m -> {
                i.setPkgGrossWeight(m.getGrossWeight());
                i.setPkgHeight(m.getDimHeight());
                i.setPkgLength(m.getDimLen());
                i.setPkgWidth(m.getDimWeight());
                if (i.getOhQty() != null && m.getGrossWeight() != null) {
                    i.setStkWeight(Double.valueOf(i.getOhQty() * (double)m.getGrossWeight().floatValue()));
                }
                if (i.getOhQty() != null && m.getVolume() != null) {
                    i.setStkVolume(Double.valueOf(i.getOhQty() * (double)m.getVolume().floatValue()));
                }
            });
            if (i.getManuDate() == null) {
                i.setManuDate(LocalDateTime.now());
            }
        });
    }

    @SysCodeProc
    public PagingVO<InvStkIORespVO> searchIO(InvStkIOParamVO param) {
        InvStkDQueryParamVO invStkDQueryParamVO = InvStkConvert.INSTANCE.IOParamToDParam(param);
        PagingVO pagingVO = this.invStkRepoProc.useSelectD(invStkDQueryParamVO);
        List invStkResults = pagingVO.getRecords();
        List invStkIOVOList = invStkResults.stream().map(InvStkConvert.INSTANCE::DVOToIOVO).collect(Collectors.toList());
        param.setBrands(param.getBrands() != null ? param.getBrands() : invStkResults.stream().map(InvStkDVO::getBrand).collect(Collectors.toList()));
        param.setWhIds(param.getWhIds() != null ? param.getWhIds() : invStkResults.stream().map(InvStkDVO::getWhId).collect(Collectors.toList()));
        param.setItemIds(param.getItemIds() != null ? param.getItemIds() : invStkResults.stream().map(InvStkDVO::getItemId).collect(Collectors.toList()));
        param.setLotNos(param.getLotNos() != null ? param.getLotNos() : invStkResults.stream().map(InvStkDVO::getLotNo).collect(Collectors.toList()));
        param.setDeter2s(param.getDeter2s() != null ? param.getDeter2s() : invStkResults.stream().map(InvStkDVO::getWhArea).collect(Collectors.toList()));
        List ioResults = this.invStkRepoProc.searchIO(param).fetch();
        List invWhResults = this.invWhService.findIdBatch(param.getWhIds());
        List collect = invStkIOVOList.stream().map(D -> {
            InvStkIORespVO invStkIORespVO = new InvStkIORespVO();
            BeanUtils.copyProperties((Object)D, (Object)invStkIORespVO);
            return invStkIORespVO;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(collect).build();
    }

    public void ioResultsQuery(List<InvStkIOxVO> ioResults, List<InvStkIOVO> invStkIOVOList, List<ItmItemVO> itmItemResults, List<OrgOuVO2> orgOuResults, List<InvWhRespVO> invWhResults) {
        invStkIOVOList.stream().forEach(v -> {
            ArrayList thQty = new ArrayList();
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.I_TYPE_02.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setGrIQty(m.getNum());
                v.setGrINetAmt(m.getNetAmt());
                v.setGriAmt(m.getAmt());
                v.setIoName(InvStk28Enum.I_TYPE_02.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.I_TYPE_06.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setSaBaIQty(m.getNum());
                v.setSaBaINetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.I_TYPE_06.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.I_TYPE_16.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setTrnIQty(m.getNum());
                v.setTrnINetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.I_TYPE_16.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.I_TYPE_18.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setAsmIQty(m.getNum());
                v.setAsmINetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.I_TYPE_18.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.I_TYPE_04.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setAjGQty(m.getNum());
                v.setAjGNetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.I_TYPE_04.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.O_TYPE_01_01.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setSaleOQty(m.getNum());
                v.setDeSaleONetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.O_TYPE_01_01.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.O_TYPE_05.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setAjOQty(m.getNum());
                v.setAjONetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.O_TYPE_05.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.O_TYPE_03.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setPurReOQty(m.getNum());
                v.setPurReONetAmt(m.getNetAmt());
                v.setPurReOAmt(m.getAmt());
                v.setIoName(InvStk28Enum.O_TYPE_03.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.O_TYPE_17.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setTrnOQty(m.getNum());
                v.setTrnONetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.O_TYPE_17.getIoName());
                thQty.add(m.getNum());
            });
            ioResults.stream().filter(i -> i.getIoCode().equals(InvStk28Enum.O_TYPE_19.getIoCode()) && i.getWhId().equals(v.getWhId()) && i.getLotNo().equals(v.getLotNo()) && i.getItemId().equals(v.getItemId()) && (i.getDeter3() == null && i.getDeter1().equals(v.getDeter1()) && i.getDeter2().equals(v.getDeter2()) || i.getDeter3() != null && i.getDeter3().equals(v.getDeter3()))).findAny().ifPresent(m -> {
                v.setAsmOQty(m.getNum());
                v.setAsmONetAmt(m.getNetAmt());
                v.setIoName(InvStk28Enum.O_TYPE_19.getIoName());
            });
            v.setThQty(Double.valueOf(thQty.stream().mapToDouble(Double::doubleValue).sum()));
            itmItemResults.stream().filter(i -> i.getId().equals(v.getItemId())).findAny().ifPresent(m -> {
                v.setItemName(m.getItemName());
                v.setItemCode(m.getItemCode());
                v.setUom(m.getUom());
                v.setUomName(m.getUomName());
                v.setPackageSpec(m.getPackageSpec());
            });
            orgOuResults.stream().filter(i -> i.getId().equals(v.getOuId())).findAny().ifPresent(m -> {
                v.setOuCode(m.getOuCode());
                v.setOuName(m.getOuName());
            });
            invWhResults.stream().filter(i -> i.getId().equals(v.getWhId())).findAny().ifPresent(m -> {
                v.setWhCode(m.getWhCode());
                v.setWhName(m.getWhName());
            });
        });
    }

    @SysCodeProc
    public Optional<InvStkRespVO> findCodeOne(String itemCode) {
        InvStkRespVO invStkRespVO = (InvStkRespVO)this.invStkRepoProc.select(null).fetchOne();
        return Optional.ofNullable(invStkRespVO);
    }

    @SysCodeProc
    public Optional<InvStkRespVO> findIdOne(Long id) {
        return this.invStkRepo.findById(id).map(DO -> (InvStkRespVO)BeanUtil.copyProperties((Object)DO, InvStkRespVO.class));
    }

    @SysCodeProc
    public List<InvStkVO> findIdBatch(List<Long> idList) {
        List<InvStkVO> invStkVOS = this.invStkRepo.findAllById(idList).stream().map(DO -> {
            InvStkVO invStkVO = new InvStkVO();
            BeanUtils.copyProperties((Object)DO, (Object)invStkVO);
            return invStkVO;
        }).collect(Collectors.toList());
        return invStkVOS;
    }

    @Transactional
    public Long createOne(InvStkVO invStkVO) {
        InvStkDO DO = new InvStkDO();
        BeanUtils.copyProperties((Object)invStkVO, (Object)DO);
        return ((InvStkDO)this.invStkRepo.save(DO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvStkVO> list) {
        List dos = list.stream().map(i -> {
            InvStkDO DO = new InvStkDO();
            BeanUtils.copyProperties((Object)i, (Object)DO);
            return DO;
        }).collect(Collectors.toList());
        return this.invStkRepo.saveAll(dos).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(InvStkUpdateSaveVO objDo) {
        Optional optional = this.invStkRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invStkRepo.save((InvStkDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        if (!StringUtils.isEmpty((Object)id)) {
            Optional optionalItem = this.invStkRepo.findById(id);
            if (optionalItem.isPresent()) {
                InvStkDO do1 = (InvStkDO)optionalItem.get();
                do1.setDeleteFlag(1);
                this.invStkRepo.save(do1);
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
    }

    @Transactional
    public void deleteOne(Long id) {
        this.invStkRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invStkRepo.deleteById(id));
    }

    public InvStkRespVO getInvStk(InvBaseModel queryParam) {
        this.checkInvBaseModelParam(queryParam);
        List fetch = ((JPAQuery)this.invStkRepoProc.select(null).where(this.getPredicate(QInvStkDO.invStkDO, queryParam))).fetch();
        if (!ObjectUtils.isEmpty((Object)fetch) && fetch.size() > 0) {
            return (InvStkRespVO)fetch.get(0);
        }
        return null;
    }

    public List<InvStkRespVO> getInvStkList(List<? extends InvBaseModel> queryParamList) {
        if (!CollectionUtils.isEmpty(queryParamList)) {
            List result = Collections.synchronizedList(new ArrayList());
            queryParamList.stream().forEach(i -> {
                List fetch = ((JPAQuery)this.invStkRepoProc.select(null).where(this.getPredicate(QInvStkDO.invStkDO, (InvBaseModel)i))).fetch();
                result.addAll(fetch);
            });
            return result.stream().distinct().collect(Collectors.toList());
        }
        return Optional.ofNullable(this.invStkRepoProc.select(null).fetch()).orElse(Collections.EMPTY_LIST);
    }

    private Predicate getPredicate(QInvStkDO jpaQDo, InvBaseModel queryParam) {
        BooleanExpression predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq((Object)queryParam.getItemId()) : null;
        BooleanExpression predicate2 = queryParam.getVariId() != null ? jpaQDo.variId.eq((Object)queryParam.getVariId()) : null;
        BooleanExpression predicate3 = !StringUtils.isEmpty((Object)queryParam.getLotNo()) ? jpaQDo.lotNo.eq((Object)queryParam.getLotNo()) : null;
        BooleanExpression predicate7 = queryParam.getWhId() != null ? jpaQDo.whId.eq((Object)queryParam.getWhId()) : null;
        BooleanExpression predicate4 = !StringUtils.isEmpty((Object)queryParam.getDeter1()) ? jpaQDo.deter1.eq((Object)queryParam.getDeter1()) : null;
        BooleanExpression predicate5 = !StringUtils.isEmpty((Object)queryParam.getDeter2()) ? jpaQDo.deter2.eq((Object)queryParam.getDeter2()) : null;
        BooleanExpression predicate6 = !StringUtils.isEmpty((Object)queryParam.getDeter3()) ? jpaQDo.deter3.eq((Object)queryParam.getDeter3()) : null;
        BooleanExpression predicate8 = !StringUtils.isEmpty((Object)queryParam.getUom()) ? jpaQDo.uom.eq((Object)queryParam.getUom()) : null;
        return ExpressionUtils.allOf((Predicate[])new Predicate[]{predicate1, predicate2, predicate3, predicate4, predicate5, predicate6, predicate7, predicate8});
    }

    private void checkInvBaseModelParam(InvBaseModel queryParam) {
        if (!(!StringUtils.isEmpty((Object)queryParam.getDeter1()) && !StringUtils.isEmpty((Object)queryParam.getDeter2()) && StringUtils.isEmpty((Object)queryParam.getDeter3()) || StringUtils.isEmpty((Object)queryParam.getDeter1()) && StringUtils.isEmpty((Object)queryParam.getDeter2()) && !StringUtils.isEmpty((Object)queryParam.getDeter3()))) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c[\u6e29\u5c42\u3001\u529f\u80fd\u5e93\u533a]\u3001\u5ba2\u6237\u53f7 \u4e09\u8005\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u4e0d\u5b58\u5728");
        }
    }

    public InvStkServiceImpl(InvStkRepo invStkRepo, InvStkRepoProc invStkRepoProc, OrgOuService orgOuService, InvWhService invWhService, InvWhAreaService invWhAreaService, InvItemPkgService invItemPkgService, SysUdcService sysUdcService, OutService outService) {
        this.invStkRepo = invStkRepo;
        this.invStkRepoProc = invStkRepoProc;
        this.orgOuService = orgOuService;
        this.invWhService = invWhService;
        this.invWhAreaService = invWhAreaService;
        this.invItemPkgService = invItemPkgService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

