/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvTrnDConvert;
import com.elitesland.inv.entity.InvTrnDO;
import com.elitesland.inv.repo.InvTrnDRepo;
import com.elitesland.inv.repo.InvTrnDRepoProc;
import com.elitesland.inv.repo.InvTrnRepo;
import com.elitesland.inv.repo.InvTrnRepoProc;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvTrnDService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.InvTrnAndTrnDDownloadVO;
import com.elitesland.inv.vo.InvTrnDVO;
import com.elitesland.inv.vo.param.InvTrnAllQueryParamVO;
import com.elitesland.inv.vo.resp.InvTrnAndTrnDRespVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvTrnDServiceImpl
implements InvTrnDService {
    private final InvTrnRepo invTrnRepo;
    private final InvTrnRepoProc invTrnRepoProc;
    private final InvTrnDRepo invTrnDRepo;
    private final InvTrnDRepoProc invTrnDRepoProc;
    private final InvWhService invWhService;
    private final OrgOuService orgOuService;
    private final InvStkCommonService invStkCommonService;
    private final SysUdcService sysUdcService;
    private final OutService outService;

    @SysCodeProc
    public PagingVO<InvTrnAndTrnDRespVO> search(InvTrnAllQueryParamVO param) {
        JPAQuery<InvTrnAndTrnDRespVO> invTrns = this.invTrnDRepoProc.selectH(param);
        param.fillOrders(invTrns);
        param.setPaging(invTrns);
        List ins = invTrns.fetch();
        ins.forEach(i -> Optional.of(i.getId()).ifPresent(t -> this.invTrnDRepo.findById(t).ifPresent(tt -> {
            i.setODeter1(tt.getODeter1());
            i.setODeter2(tt.getODeter2());
            i.setOWhId(tt.getOWhId());
            i.setOOuId(tt.getOOuId());
            i.setIDeter1(tt.getIDeter1());
            i.setIDeter2(tt.getIDeter2());
            i.setIWhId(tt.getIWhId());
        })));
        this.fillupNameList(ins);
        return PagingVO.builder().total(Long.valueOf(invTrns.fetchCount())).records(ins).build();
    }

    @SysCodeProc
    public List<InvTrnAndTrnDRespVO> findAll(InvTrnAllQueryParamVO param) {
        List invTrns = this.invTrnDRepoProc.selectD(param).fetch();
        invTrns.forEach(i -> Optional.of(i.getId()).ifPresent(t -> this.invTrnDRepo.findById(t).ifPresent(tt -> {
            i.setODeter1(tt.getODeter1());
            i.setODeter2(tt.getODeter2());
            i.setOWhId(tt.getOWhId());
            i.setIDeter1(tt.getIDeter1());
            i.setIDeter2(tt.getIDeter2());
            i.setIWhId(tt.getIWhId());
        })));
        this.fillupNameList(invTrns);
        return invTrns;
    }

    public List<Long> createInBatch(List<InvTrnDVO> list) {
        List invTrnDDOS = list.stream().map(InvTrnDConvert.INSTANCE::voToDO).collect(Collectors.toList());
        return this.invTrnDRepo.saveAll(invTrnDDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public int removeInBatch(List<Long> ids) {
        ids.forEach(id -> this.invTrnDRepo.deleteById(id));
        return ids.size();
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public void confirm(Long masId) {
        InvTrnAllQueryParamVO param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        List<InvTrnAndTrnDRespVO> invTrnAndTrnDVoList = this.findAll(param);
        List common28InvoOList = invTrnAndTrnDVoList.stream().map(v -> {
            InvStkCommon28InVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon28InVOO((InvTrnAndTrnDRespVO)v);
            tmp.setInvStk28Enum1(InvStk28Enum.O_TYPE_17);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            return tmp;
        }).collect(Collectors.toList());
        List common28InvoIList = invTrnAndTrnDVoList.stream().map(v -> {
            InvStkCommon28InVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon28InVOI((InvTrnAndTrnDRespVO)v);
            tmp.setInvStk28Enum1(InvStk28Enum.I_TYPE_16);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            return tmp;
        }).collect(Collectors.toList());
        this.releasLockQty(null, invTrnAndTrnDVoList);
        this.invStkCommonService.invStkCommon28(common28InvoOList);
        this.invStkCommonService.invStkCommon28(common28InvoIList);
        this.invTrnRepoProc.updateDocStatusByIds(List.of(masId), UdcEnum.INV_TRN_STATUS_CF.getValueCode());
    }

    public void check(Long masId) {
        Optional invTrnDOOptional = this.invTrnRepo.findById(masId);
        if (!invTrnDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvTrnDO)invTrnDOOptional.get()).setDocStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        this.invTrnRepo.save((InvTrnDO)invTrnDOOptional.get());
    }

    public void refuse(Long masId) {
        Optional invTrnDOOptional = this.invTrnRepo.findById(masId);
        if (!invTrnDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvTrnDO)invTrnDOOptional.get()).setDocStatus("RJ");
        this.invTrnRepo.save((InvTrnDO)invTrnDOOptional.get());
        this.releasLockQty(masId, null);
    }

    public List<InvTrnAndTrnDRespVO> fillupNameList(List<InvTrnAndTrnDRespVO> items) {
        Map trnStatusMap = this.sysUdcService.getCodeMap(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode());
        Map reasonMap = this.sysUdcService.getCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map deter2Map = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_ADJUST.getModel(), UdcEnum.INV_FUNC_TYPE_ADJUST.getCode());
        Map uomMap = this.sysUdcService.getCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        List<Long> ouIdList = items.stream().filter(f -> f.getOuId() != null).map(InvTrnAndTrnDRespVO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuVO> orgOuVOS = this.outService.listOrgOuVOByIds(ouIdList);
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        List itemIds = items.stream().filter(f -> f.getItemId() != null).map(InvTrnAndTrnDRespVO::getItemId).distinct().collect(Collectors.toList());
        itmItemPartParam.setIds(itemIds);
        List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
        List iwhIdList = items.stream().filter(f -> f.getIWhId() != null).map(InvTrnAndTrnDRespVO::getIWhId).distinct().collect(Collectors.toList());
        List iwhIdList2 = items.stream().filter(f -> f.getIWhId() != null).map(InvTrnAndTrnDRespVO::getOWhId).distinct().collect(Collectors.toList());
        List invWhRespVOS = this.invWhService.findIdBatch(iwhIdList);
        List invWhRespVOS2 = this.invWhService.findIdBatch(iwhIdList2);
        items.forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(f -> f.getId().equals(i.getItemId())).findFirst().ifPresent(e -> {
                    i.setItemCode(e.getItemCode());
                    i.setItemName(e.getItemName());
                    i.setBrand(e.getBrand());
                    i.setBrandName(e.getBrandName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)invWhRespVOS)) {
                invWhRespVOS.stream().filter(f -> f.getId().equals(i.getIWhId())).findFirst().ifPresent(w -> {
                    i.setIWhCode(w.getWhCode());
                    i.setIWhName(w.getWhName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)invWhRespVOS2)) {
                invWhRespVOS2.stream().filter(f -> f.getId().equals(i.getOWhId())).findFirst().ifPresent(w -> {
                    i.setOWhCode(w.getWhCode());
                    i.setOWhName(w.getWhName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS)) {
                orgOuVOS.stream().filter(f -> f.getId().equals(i.getOuId())).findFirst().ifPresent(o -> i.setOuName(o.getName()));
            }
            if (!CollectionUtils.isEmpty((Map)trnStatusMap) && trnStatusMap.containsKey(i.getDocStatus())) {
                i.setDocStatusName((String)trnStatusMap.get(i.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)reasonMap) && reasonMap.containsKey(i.getReasonCode())) {
                i.setReasonCodeName((String)reasonMap.get(i.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty((Map)deter2Map)) {
                if (deter2Map.containsKey(i.getODeter2())) {
                    i.setODeter2Name((String)deter2Map.get(i.getODeter2()));
                }
                if (deter2Map.containsKey(i.getIDeter2())) {
                    i.setIDeter2Name((String)deter2Map.get(i.getIDeter2()));
                }
            }
            if (!CollectionUtils.isEmpty((Map)uomMap) && uomMap.containsKey(i.getUom())) {
                i.setUomName((String)uomMap.get(i.getUom()));
            }
        });
        return items;
    }

    public List<InvTrnDVO> findByMasIds(List<Long> trnIds) {
        return this.invTrnDRepo.findByMasIdIn(trnIds).stream().map(v -> (InvTrnDVO)BeanUtil.copyProperties((Object)v, InvTrnDVO.class)).collect(Collectors.toList());
    }

    public List<InvTrnAndTrnDDownloadVO> findInvTrnAndTrnDDownloadVOList(InvTrnAllQueryParamVO param) {
        param.setSize(Integer.valueOf(20000));
        PagingVO<InvTrnAndTrnDRespVO> ret = this.search(param);
        List list = ret.getRecords();
        List<InvTrnAndTrnDDownloadVO> invTrnAndTrnDDownloadVOList = list.stream().map(i -> {
            String outerNo;
            InvTrnAndTrnDDownloadVO downloadVO = new InvTrnAndTrnDDownloadVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            downloadVO.setOwhCode(i.getOWhCode());
            downloadVO.setOwhName(i.getIWhName());
            downloadVO.setIwhCode(i.getIWhCode());
            downloadVO.setIwhName(i.getIWhName());
            downloadVO.setOdeter1Name(i.getODeter1Name());
            downloadVO.setIdeter1Name(i.getIDeter1Name());
            downloadVO.setOdeter2Name(i.getODeter2Name());
            downloadVO.setIdeter2Name(i.getIDeter2Name());
            String outerType = StringUtils.isEmpty((Object)downloadVO.getOuterType()) ? "" : downloadVO.getOuterType();
            String string = outerNo = StringUtils.isEmpty((Object)downloadVO.getOuterNo()) ? "" : downloadVO.getOuterNo();
            if (!StringUtils.isEmpty((Object)outerType) && !StringUtils.isEmpty((Object)outerNo)) {
                downloadVO.setOuterNo(outerType + outerNo);
            }
            return downloadVO;
        }).collect(Collectors.toList());
        return invTrnAndTrnDDownloadVOList;
    }

    private void updateDocStatusAndApprStatus(String valueCode, String name, Long id) {
        Optional invTrnDOOptional = this.invTrnRepo.findById(id);
        if (invTrnDOOptional.isPresent()) {
            ((InvTrnDO)invTrnDOOptional.get()).setDocStatus(valueCode);
            ((InvTrnDO)invTrnDOOptional.get()).setApprStatus(name);
            ((InvTrnDO)invTrnDOOptional.get()).setApprTime(LocalDateTime.now());
            this.invTrnRepo.save((InvTrnDO)invTrnDOOptional.get());
        }
    }

    public void releasLockQty(Long masId, List<InvTrnAndTrnDRespVO> invTrnAndTrnDVOList) {
        InvTrnAllQueryParamVO param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        if (CollectionUtils.isEmpty(invTrnAndTrnDVOList)) {
            invTrnAndTrnDVOList = this.findAll(param);
        }
        List common37InvoList = invTrnAndTrnDVOList.stream().map(v -> {
            InvStkCommon37InVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon37InVO((InvTrnAndTrnDRespVO)v);
            tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_25);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            return tmp;
        }).collect(Collectors.toList());
        this.invStkCommonService.invStkCommon37(common37InvoList);
    }

    public InvTrnDServiceImpl(InvTrnRepo invTrnRepo, InvTrnRepoProc invTrnRepoProc, InvTrnDRepo invTrnDRepo, InvTrnDRepoProc invTrnDRepoProc, InvWhService invWhService, OrgOuService orgOuService, InvStkCommonService invStkCommonService, SysUdcService sysUdcService, OutService outService) {
        this.invTrnRepo = invTrnRepo;
        this.invTrnRepoProc = invTrnRepoProc;
        this.invTrnDRepo = invTrnDRepo;
        this.invTrnDRepoProc = invTrnDRepoProc;
        this.invWhService = invWhService;
        this.orgOuService = orgOuService;
        this.invStkCommonService = invStkCommonService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

