/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.NumSendObjectEnum;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvCommonConvert;
import com.elitesland.inv.convert.InvTrnConvert;
import com.elitesland.inv.entity.InvTrnDDO;
import com.elitesland.inv.entity.InvTrnDO;
import com.elitesland.inv.entity.QInvTrnDO;
import com.elitesland.inv.param.PriGroupParam;
import com.elitesland.inv.repo.InvTrnDRepo;
import com.elitesland.inv.repo.InvTrnRepo;
import com.elitesland.inv.repo.InvTrnRepoProc;
import com.elitesland.inv.service.InvCorssentryPricepolicyService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvTrnDService;
import com.elitesland.inv.service.InvTrnService;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.InvTrnVO;
import com.elitesland.inv.vo.param.InvTrnAllQueryParamVO;
import com.elitesland.inv.vo.param.InvTrnDParamVO;
import com.elitesland.inv.vo.resp.InvTrnAndTrnDRespVO;
import com.elitesland.inv.vo.resp.InvTrnDRespVO;
import com.elitesland.inv.vo.resp.InvTrnDetailRespVO;
import com.elitesland.inv.vo.resp.InvTrnRespVO;
import com.elitesland.inv.vo.resp.InvWhAreaRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvTrnAndTrnDSaveVO;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.system.service.SysUserService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvTrnServiceImpl
implements InvTrnService {
    private final InvTrnRepo invTrnRepo;
    private final InvTrnRepoProc invTrnRepoProc;
    private final InvTrnDRepo invTrnDRepo;
    private final InvWhService invWhService;
    private final InvWhAreaService invWhAreaService;
    private final SysUserService sysUserService;
    private final InvStkCommonService invStkCommonService;
    private final SysNumberRuleService sysNumberRuleService;
    private final InvTrnDService invTrnDService;
    private final InvCorssentryPricepolicyService invCorssentryPricepolicyService;
    private final SysUdcService sysUdcService;
    private final OutService outService;

    @SysCodeProc
    public Optional<InvTrnRespVO> findIdOne(Long id) {
        Optional<InvTrnRespVO> invTrnRespVO = this.invTrnRepo.findById(id).map(invTrnDO -> (InvTrnRespVO)BeanUtil.copyProperties((Object)invTrnDO, InvTrnRespVO.class));
        if (invTrnRespVO.isPresent()) {
            Optional oWh = this.invWhService.findById(invTrnRespVO.get().getOWhId() != null ? invTrnRespVO.get().getOWhId() : 0L);
            Optional iWh = this.invWhService.findById(invTrnRespVO.get().getIWhId() != null ? invTrnRespVO.get().getIWhId() : 0L);
            if (oWh.isPresent()) {
                invTrnRespVO.get().setOWhName(((InvWhRespVO)oWh.get()).getWhName());
                invTrnRespVO.get().setOWhCode(((InvWhRespVO)oWh.get()).getWhCode());
            }
            if (iWh.isPresent()) {
                invTrnRespVO.get().setIWhName(((InvWhRespVO)oWh.get()).getWhName());
                invTrnRespVO.get().setIWhCode(((InvWhRespVO)oWh.get()).getWhCode());
            }
            if (invTrnRespVO.get().getApplyEmpId() != null) {
                // empty if block
            }
            return invTrnRespVO;
        }
        return invTrnRespVO;
    }

    public Long create(InvTrnVO invTrnVO) {
        InvTrnDO invTrnDO = InvTrnConvert.INSTANCE.voToDO(invTrnVO);
        Long id = ((InvTrnDO)this.invTrnRepo.save(invTrnDO)).getId();
        return id;
    }

    public List<Long> updateInBatch(List<InvTrnDO> list) {
        return this.invTrnRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        this.invTrnRepoProc.updateDocStatusByIds(ids, status);
        return ids;
    }

    public Long submit(Long id) {
        Optional invTrnVOOptional = this.invTrnRepo.findById(id);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        List<InvTrnDDO> invTrnDDOS = this.invTrnDRepo.findByMasId(id);
        List invStkCommon37InVOS = invTrnDDOS.stream().map(v -> {
            InvStkCommon37InVO common37InVo = InvCommonConvert.INSTANCE.invTrnDDOToInvStkCommon37InVO((InvTrnDDO)v);
            common37InVo.setInvStk28Enum1(InvStk28Enum.T_TYPE_21);
            common37InVo.setDocNo(((InvTrnDO)invTrnVOOptional.get()).getDocNo());
            common37InVo.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            common37InVo.setOpDate(LocalDateTime.now());
            return common37InVo;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invStkCommon37InVOS)) {
            this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
        }
        ((InvTrnDO)invTrnVOOptional.get()).setDocStatus(UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
        ((InvTrnDO)invTrnVOOptional.get()).setIoDate(LocalDateTime.now());
        ((InvTrnDO)invTrnVOOptional.get()).setApprTime(LocalDateTime.now());
        this.invTrnRepo.save((InvTrnDO)invTrnVOOptional.get());
        return id;
    }

    public List<InvTrnVO> findByIntfFlagAndRelate2No(Integer i, String relate2No) {
        return this.invTrnRepo.findByIntfFlagAndRelate2No(i, relate2No).stream().map(v -> (InvTrnVO)BeanUtil.copyProperties((Object)v, InvTrnVO.class)).collect(Collectors.toList());
    }

    public List<InvTrnVO> findByDocNos(List<String> docNos) {
        QInvTrnDO invTrnDO = QInvTrnDO.invTrnDO;
        Iterable all = this.invTrnRepo.findAll((Predicate)invTrnDO.deleteFlag.eq((Object)0).or((Predicate)invTrnDO.deleteFlag.isNull()).and((Predicate)invTrnDO.docNo.in(docNos)));
        ArrayList invTrnDOS = Lists.newArrayList((Iterable)all);
        List<InvTrnVO> invTrnVOS = invTrnDOS.stream().map(InvTrnConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return invTrnVOS;
    }

    public Long saveInvTrnInfo(InvTrnAndTrnDSaveVO inv) {
        ArrayList<String> runtimeValues = new ArrayList<String>();
        InvTrnVO invHeader = inv.getHeader();
        invHeader.setODeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        invHeader.setIDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        runtimeValues.add(String.valueOf(invHeader.getOuId()));
        String code = this.sysNumberRuleService.generateCode(NumSendObjectEnum.INV_IT.getCode(), runtimeValues);
        InvTrnVO invTrnVO = new InvTrnVO();
        inv.getHeader().setDocNo(inv.getHeader().getDocNo() != null ? inv.getHeader().getDocNo() : code);
        invHeader.setDocStatus(UdcEnum.INV_TRN_STATUS_DR.getValueCode());
        invHeader.setDocType(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
        BeanUtils.copyProperties((Object)invHeader, (Object)invTrnVO);
        Long id = this.create(invTrnVO);
        if (!CollectionUtils.isEmpty((Collection)inv.getDetails())) {
            List detailDOs = inv.getDetails().stream().map(d -> {
                InvTrnDDO invTrnDDO = new InvTrnDDO();
                BeanUtils.copyProperties((Object)d, (Object)invTrnDDO);
                invTrnDDO.setMasId(id);
                invTrnDDO.setIDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                invTrnDDO.setODeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                PriGroupParam param = new PriGroupParam();
                param.setItemId(d.getItemId());
                param.setDocTime(invTrnVO.getIoDate());
                param.setFromOuId(invTrnVO.getOOuId());
                param.setToOuId(invTrnVO.getIOuId());
                PriSalePriceVO priSalePriceVO = this.invCorssentryPricepolicyService.costPrice(param);
                if (priSalePriceVO != null) {
                    invTrnDDO.setCostPrice(priSalePriceVO.getCostPrice());
                }
                invTrnDDO.setCostAmt(invTrnDDO.getCostPrice() == null || invTrnDDO.getQty() == null ? null : invTrnDDO.getCostPrice().multiply(new BigDecimal(invTrnDDO.getQty().floatValue())));
                List whAreaList = this.invWhAreaService.findAllByWhId(inv.getDetails().stream().map(InvTrnDParamVO::getIWhId).collect(Collectors.toList()));
                List invWhAreaRespVOS = whAreaList.stream().filter(v -> v.getWhId().equals(d.getIWhId())).collect(Collectors.toList());
                List deter2List = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2).collect(Collectors.toList());
                if (!deter2List.contains(d.getIDeter2())) {
                    throw new BusinessException(ApiCode.FAIL, "\u672c\u4ed3\u5e93\u6ca1\u6709" + d.getIDeter2Name() + "\u529f\u80fd\u5e93\u533a");
                }
                return invTrnDDO;
            }).collect(Collectors.toList());
            this.invTrnDRepo.saveAll(detailDOs);
        }
        return id;
    }

    public InvTrnDetailRespVO invTrnDetail(Long id) {
        List invTrnAndTrnDRespVOS;
        InvTrnDetailRespVO invTrnDetailRespVO = new InvTrnDetailRespVO();
        Optional<InvTrnRespVO> invtrnOptional = this.findIdOne(id);
        if (!invtrnOptional.isPresent()) {
            return invTrnDetailRespVO;
        }
        InvTrnRespVO invTrnRespVO = invtrnOptional.get();
        BeanUtils.copyProperties((Object)invTrnRespVO, (Object)invTrnDetailRespVO);
        InvTrnAllQueryParamVO queryParamVO = new InvTrnAllQueryParamVO();
        queryParamVO.setMasId(invTrnRespVO.getId());
        Map deter2Map = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_ADJUST.getModel(), UdcEnum.INV_FUNC_TYPE_ADJUST.getCode());
        invTrnDetailRespVO.setDocStatusName(this.getUdcDesc(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode(), invTrnRespVO.getDocStatus()));
        invTrnDetailRespVO.setReasonCodeName(this.getUdcDesc(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode(), invTrnDetailRespVO.getReasonCode()));
        if (!CollectionUtils.isEmpty((Map)deter2Map)) {
            if (deter2Map.containsKey(invTrnDetailRespVO.getODeter2())) {
                invTrnDetailRespVO.setODeter2Name((String)deter2Map.get(invTrnDetailRespVO.getODeter2()));
            }
            if (deter2Map.containsKey(invTrnDetailRespVO.getIDeter2())) {
                invTrnDetailRespVO.setIDeter2Name((String)deter2Map.get(invTrnDetailRespVO.getIDeter2()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(invTrnAndTrnDRespVOS = this.invTrnDService.findAll(queryParamVO)))) {
            ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
            List itemIds = invTrnAndTrnDRespVOS.stream().filter(f -> f.getItemId() != null).map(InvTrnAndTrnDRespVO::getItemId).collect(Collectors.toList());
            itmItemPartParam.setIds(itemIds);
            List<ItmItemPartDTO> itmItemPartDTOS = this.outService.itmItemPartSearch(itmItemPartParam);
            List invTrnDRespVOList = invTrnAndTrnDRespVOS.stream().map(e -> {
                InvTrnDRespVO invTrnDRespVO = new InvTrnDRespVO();
                BeanUtils.copyProperties((Object)e, (Object)invTrnDRespVO);
                if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(i -> {
                        invTrnDRespVO.setItemCode(i.getItemCode());
                        invTrnDRespVO.setItemName(i.getItemName());
                    });
                }
                return invTrnDRespVO;
            }).collect(Collectors.toList());
            invTrnDetailRespVO.setInvTrnDRespVOList(invTrnDRespVOList);
        }
        return invTrnDetailRespVO;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty((Object)domain) || StringUtils.isEmpty((Object)udcCode)) {
            return null;
        }
        Map codeMap = this.sysUdcService.getCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty((Map)codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return (String)codeMap.get(udcVal);
        }
        return null;
    }

    public InvTrnServiceImpl(InvTrnRepo invTrnRepo, InvTrnRepoProc invTrnRepoProc, InvTrnDRepo invTrnDRepo, InvWhService invWhService, InvWhAreaService invWhAreaService, SysUserService sysUserService, InvStkCommonService invStkCommonService, SysNumberRuleService sysNumberRuleService, InvTrnDService invTrnDService, InvCorssentryPricepolicyService invCorssentryPricepolicyService, SysUdcService sysUdcService, OutService outService) {
        this.invTrnRepo = invTrnRepo;
        this.invTrnRepoProc = invTrnRepoProc;
        this.invTrnDRepo = invTrnDRepo;
        this.invWhService = invWhService;
        this.invWhAreaService = invWhAreaService;
        this.sysUserService = sysUserService;
        this.invStkCommonService = invStkCommonService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.invTrnDService = invTrnDService;
        this.invCorssentryPricepolicyService = invCorssentryPricepolicyService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

