/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.convert.InvWhAreaConvert;
import com.elitesland.inv.entity.InvWhAreaDO;
import com.elitesland.inv.entity.QInvWhAreaDO;
import com.elitesland.inv.entity.QInvWhDO;
import com.elitesland.inv.repo.InvWhAreaRepo;
import com.elitesland.inv.repo.InvWhAreaRepoProc;
import com.elitesland.inv.repo.InvWhRepoProc;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.vo.param.InvWhAreaParamVO;
import com.elitesland.inv.vo.param.InvWhParamVO;
import com.elitesland.inv.vo.resp.InvWhAreaRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orgWhAreaService")
public class InvWhAreaServiceImpl
implements InvWhAreaService {
    private final InvWhAreaRepo invWhAreaRepo;
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final InvWhRepoProc invWhRepoProc;

    public PagingVO<InvWhAreaRespVO> search(InvWhAreaParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invWhAreaRepoProc.select(null).where(this.invWhAreaRepoProc.searchWhere(param));
        this.invWhAreaRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QInvWhAreaDO.invWhAreaDO);
        long dataCount = jpaQuery.fetchCount();
        List lists = jpaQuery.fetch();
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @SysCodeProc
    public PagingVO<InvWhRespVO> searchWh(InvWhParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        List lists = jpaQuery.fetch();
        this.invWhRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QInvWhDO.invWhDO);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @SysCodeProc
    public Optional<InvWhAreaRespVO> findCodeOne(String itemCode) {
        JPAQuery<InvWhAreaRespVO> jpaQuery = this.invWhAreaRepoProc.select(null);
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        InvWhAreaRespVO vo = (InvWhAreaRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<InvWhAreaRespVO> findIdOne(Long id) {
        JPAQuery<InvWhAreaRespVO> jpaQuery = this.invWhAreaRepoProc.select(null);
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhAreaRespVO vo = (InvWhAreaRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    public List<InvWhAreaRespVO> findByWhId(Long whId) {
        InvWhAreaParamVO param = new InvWhAreaParamVO();
        param.setWhId(whId);
        JPAQuery<InvWhAreaRespVO> select = this.invWhAreaRepoProc.select(param);
        return select.fetch();
    }

    public List<InvWhAreaRespVO> findAllByWhId(List<Long> whIds) {
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        JPAQuery where = (JPAQuery)this.invWhAreaRepoProc.select(null).where((Predicate)jpaQDo.whId.in(whIds));
        return where.fetch();
    }

    public InvWhAreaRespVO findByWhIdAndWhArea(Long whId, String whArea) {
        return (InvWhAreaRespVO)BeanUtil.copyProperties((Object)this.invWhAreaRepo.findFirstByWhIdAndWhArea(whId, whArea), InvWhAreaRespVO.class);
    }

    @SysCodeProc
    public List<InvWhAreaRespVO> findIdBatch(List<Long> idList) {
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        JPAQuery where = (JPAQuery)this.invWhAreaRepoProc.select(null).where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    @Transactional
    public Long createOne(InvWhAreaRespVO invWhAreaRespVO) {
        return ((InvWhAreaDO)this.invWhAreaRepo.save(InvWhAreaConvert.INSTANCE.voToDO(invWhAreaRespVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<InvWhAreaRespVO> list) {
        return this.invWhAreaRepo.saveAll(list.stream().map(InvWhAreaConvert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(InvWhAreaRespVO item) {
        Optional optional = this.invWhAreaRepo.findById(item.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + item.getId());
        }
        this.invWhAreaRepo.save(InvWhAreaConvert.INSTANCE.voToDO(item));
    }

    @Transactional
    public void deleteOne(Long id) {
        this.invWhAreaRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invWhAreaRepo.deleteById(id));
    }

    @Transactional
    public void deleteByWhId(Long whId) {
        this.invWhAreaRepo.deleteByWhId(whId);
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QInvWhAreaDO jpaQDo = QInvWhAreaDO.invWhAreaDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.invWhAreaRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        InvWhAreaDO do1 = (InvWhAreaDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.invWhAreaRepo.save(do1);
    }

    public InvWhAreaServiceImpl(InvWhAreaRepo invWhAreaRepo, InvWhAreaRepoProc invWhAreaRepoProc, InvWhRepoProc invWhRepoProc) {
        this.invWhAreaRepo = invWhAreaRepo;
        this.invWhAreaRepoProc = invWhAreaRepoProc;
        this.invWhRepoProc = invWhRepoProc;
    }
}

