/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.convert.InvWhAreaConvert;
import com.elitesland.inv.convert.InvWhConvert;
import com.elitesland.inv.dto.OrgAddrAddressVO;
import com.elitesland.inv.dto.OrgCustVO;
import com.elitesland.inv.dto.PriPriceCustApplyQueryParam;
import com.elitesland.inv.entity.InvWhAreaDO;
import com.elitesland.inv.entity.InvWhDO;
import com.elitesland.inv.entity.QInvWhAreaDO;
import com.elitesland.inv.entity.QInvWhDO;
import com.elitesland.inv.repo.InvWhAreaRepoProc;
import com.elitesland.inv.repo.InvWhRepo;
import com.elitesland.inv.repo.InvWhRepoProc;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.param.InvWhAreaParamVO;
import com.elitesland.inv.vo.param.InvWhKeywordParamVO;
import com.elitesland.inv.vo.param.InvWhListParamVO;
import com.elitesland.inv.vo.param.InvWhParamVO;
import com.elitesland.inv.vo.resp.InvWhAreaRespVO;
import com.elitesland.inv.vo.resp.InvWhKeywordRespVO;
import com.elitesland.inv.vo.resp.InvWhListRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.resp.InvWhRptRespVO;
import com.elitesland.inv.vo.resp.InvWhSalListRespVO;
import com.elitesland.inv.vo.save.InvWhSaveVO;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.convert.OrgAddrAddressConvert;
import com.elitesland.out.entity.OrgAddrAddressDO;
import com.elitesland.out.repo.OrgAddrAddressRepo;
import com.elitesland.out.service.OutService;
import com.elitesland.out.vo.resp.OrgAddrAddressRespVO;
import com.elitesland.out.vo.resp.OrgCustRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.util.OrderUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orgWhService")
@DubboService
public class InvWhServiceImpl
implements InvWhService {
    private final SysUdcService sysUdcService;
    private final InvWhRepoProc invWhRepoProc;
    private final InvWhRepo invWhRepo;
    private final InvWhAreaService invWhAreaService;
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final OutService outService;
    private final OrgAddrAddressRepo orgAddrAddressRepo;

    @SysCodeProc
    public PagingVO<InvWhAreaRespVO> searchWhArea(InvWhAreaParamVO param) {
        InvWhParamVO orgWhQueryParam = new InvWhParamVO();
        orgWhQueryParam.setWhCode(param.getWhCode());
        orgWhQueryParam.setWhName(param.getWhName());
        orgWhQueryParam.setOuId(param.getOuId());
        orgWhQueryParam.setId(param.getId());
        orgWhQueryParam.setWhTypes(param.getWhTypes());
        orgWhQueryParam.setMultiKeywords(param.getMultiKeywords());
        orgWhQueryParam.setWhType(param.getWhType());
        orgWhQueryParam.setWhType2(param.getWhType2());
        PagingVO orgWhVOPagingVO = this.invWhAreaService.searchWh(orgWhQueryParam);
        List invWhRespVOList = orgWhVOPagingVO.getRecords();
        List whIds = invWhRespVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        param.setWhIds(whIds);
        if (param.getSize() == null && param.getCurrent() == null) {
            param.setSize(Integer.valueOf(1000));
        }
        PagingVO search = this.invWhAreaService.search(param);
        List invWhAreaRespVOS = search.getRecords();
        this.translateWh(invWhRespVOList);
        this.translateUdc(invWhRespVOList, invWhAreaRespVOS);
        if (param.getPName() != null && !param.getPName().equals("") || param.getPCode() != null && !param.getPCode().equals("") || param.getPType() != null && !param.getPType().equals("")) {
            this.translateWhArea2(invWhAreaRespVOS, invWhRespVOList, param.getPCode(), param.getPName(), param.getPType(), (PagingVO<InvWhAreaRespVO>)search);
        } else {
            this.translateWhArea(invWhAreaRespVOS, invWhRespVOList);
        }
        return search;
    }

    @Transactional
    public Long createWh(InvWhSaveVO param) {
        Long id = param.getId();
        if (this.existVerify(id, param.getWhCode()).booleanValue()) {
            throw new BusinessException(ApiCode.FAIL, "\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        Integer addrNo = null;
        InvWhDO invWhDO = (InvWhDO)BeanUtil.copyProperties((Object)param, InvWhDO.class);
        Optional optional = Optional.empty();
        if (id != null) {
            optional = this.invWhRepo.findById(id);
        }
        if (optional.isPresent()) {
            addrNo = ((InvWhDO)optional.get()).getAddrNo();
            this.outService.deleteByAddrNo(addrNo);
            this.invWhAreaService.deleteByWhId(id);
            this.update(invWhDO);
        } else {
            String orderCode = OrderUtils.getOrderCode("", "", 1);
            addrNo = Integer.valueOf(orderCode.substring(orderCode.length() - 8));
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            id = ((InvWhDO)this.invWhRepo.save(invWhDO)).getId();
        }
        Long finalId = id;
        List invWhAreaDOS = param.getOrgWhAreaCreateParamList().stream().map(orgWhArea -> {
            InvWhAreaDO invWhAreaDO = (InvWhAreaDO)BeanUtil.copyProperties((Object)orgWhArea, InvWhAreaDO.class);
            invWhAreaDO.setWhId(finalId);
            invWhAreaDO.setWhArea(orgWhArea.getDeter2());
            invWhAreaDO.setDeter3(orgWhArea.getPCode());
            return invWhAreaDO;
        }).collect(Collectors.toList());
        List invWhAreaRespVOS = invWhAreaDOS.stream().map(InvWhAreaConvert.INSTANCE::doToVO).collect(Collectors.toList());
        this.invWhAreaService.createBatch(invWhAreaRespVOS);
        this.createAddrAddress(param, addrNo);
        List<InvWhDO> WhDoList = this.invWhRepo.findByPhysicalWhCode(param.getPhysicalWhCode());
        ArrayList<Integer> addrNoList = new ArrayList<Integer>();
        WhDoList.forEach(whDo -> {
            if (!addrNoList.stream().filter(addr -> String.valueOf(addr).equals(whDo.getAddrNo())).findAny().isPresent()) {
                addrNoList.add(whDo.getAddrNo());
            }
        });
        List<OrgAddrAddressDO> orgAddrAddressList = this.orgAddrAddressRepo.findByAddrNoIn(addrNoList);
        List invAddrAddressList = orgAddrAddressList.stream().map(OrgAddrAddressConvert.INSTANCE::doToVO).collect(Collectors.toList());
        Map<Integer, OrgAddrAddressVO> orgAddrAddressMap = invAddrAddressList.stream().collect(Collectors.toMap(OrgAddrAddressVO::getAddrNo, t -> t, (t1, t2) -> t2));
        String paramEmail = param.getEmail() == null ? "null" : param.getEmail();
        String paramContPerson = param.getContPerson() == null ? "null" : param.getContPerson();
        String[] emailList = paramEmail.split(";");
        if (addrNoList.size() > 0 && !MapUtils.isEmpty(orgAddrAddressMap)) {
            addrNoList.forEach(addr -> {
                this.outService.deleteByAddrNo((Integer)addr);
                for (String s : emailList) {
                    OrgAddrAddressVO invAddrAddress = new OrgAddrAddressVO();
                    if (!orgAddrAddressMap.containsKey(addr)) continue;
                    BeanCopyUtil.beanCopy((OrgAddrAddressVO)orgAddrAddressMap.get(addr), invAddrAddress);
                    invAddrAddress.setId(null);
                    invAddrAddress.setEmail(s);
                    invAddrAddress.setContPerson(paramContPerson);
                    OrgAddrAddressDO orgAddrAddressDO = OrgAddrAddressConvert.INSTANCE.voToDO(invAddrAddress);
                    this.orgAddrAddressRepo.save(orgAddrAddressDO);
                }
            });
        }
        return id;
    }

    public Optional<InvWhRespVO> findWhAreaById(Long id) {
        Optional<InvWhRespVO> orgWhVOOptional = this.findIdOne(id);
        if (orgWhVOOptional.isPresent()) {
            Optional<OrgOuVO> ouVO;
            InvWhRespVO vo = orgWhVOOptional.get();
            Integer addrNo = vo.getAddrNo();
            List invWhAreaRespVOS = this.invWhAreaService.findByWhId(id);
            if (!CollectionUtils.isEmpty((Collection)invWhAreaRespVOS)) {
                invWhAreaRespVOS.forEach(orgWhAreaVO -> {
                    String es1 = orgWhAreaVO.getEs1();
                    String pType = orgWhAreaVO.getPType();
                    String pCode = orgWhAreaVO.getPCode();
                    if (UdcEnum.INV_PARTNER_TYPE_CUST.equals(pType) && StringUtils.isNotEmpty((CharSequence)pCode) && !UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(vo.getWhType()) && StringUtils.isNotEmpty((CharSequence)es1)) {
                        Optional<OrgCustRespVO> orgCustVOOptional = this.outService.findCustByIdOne(Long.valueOf(es1));
                        orgCustVOOptional.ifPresent(orgCustVO -> {
                            orgWhAreaVO.setPCode(orgCustVO.getCustCode());
                            orgWhAreaVO.setPName(orgCustVO.getCustName());
                        });
                    }
                });
            }
            ArrayList<InvWhRespVO> vos = new ArrayList<InvWhRespVO>();
            vos.add(vo);
            this.translateUdc(vos, invWhAreaRespVOS);
            vo.setInvWhAreaRespVOList(invWhAreaRespVOS);
            List<OrgAddrAddressRespVO> orgAddrAddressVOS = this.outService.findByAddrNo(addrNo);
            if (orgAddrAddressVOS.size() > 0) {
                OrgAddrAddressRespVO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                Object email = "";
                for (OrgAddrAddressRespVO address : orgAddrAddressVOS) {
                    email = (String)email + address.getEmail() + ";";
                }
                vo.setCountry(orgAddrAddressVO.getCountry());
                vo.setProvince(orgAddrAddressVO.getProvince());
                vo.setCity(orgAddrAddressVO.getCity());
                vo.setCounty(orgAddrAddressVO.getCounty());
                vo.setCountryName(orgAddrAddressVO.getCountryName());
                vo.setProvinceName(orgAddrAddressVO.getProvinceName());
                vo.setCityName(orgAddrAddressVO.getCityName());
                vo.setCountyName(orgAddrAddressVO.getCountyName());
                vo.setDetailaddr(orgAddrAddressVO.getDetailaddr());
                vo.setEmail((String)email);
                vo.setTel(orgAddrAddressVO.getTel());
                vo.setContPerson(orgAddrAddressVO.getContPerson());
            }
            if ((ouVO = this.outService.findOneOuById(vo.getOuId())).isPresent()) {
                OrgOuVO orgOuVO = ouVO.get();
                vo.setOuName(orgOuVO.getName());
                vo.setOuCode(orgOuVO.getCode());
            }
        }
        return orgWhVOOptional;
    }

    @SysCodeProc
    public Optional<InvWhRespVO> findIdOne(Long id) {
        JPAQuery<InvWhRespVO> jpaQuery = this.invWhRepoProc.select(null);
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhRespVO vo = (InvWhRespVO)jpaQuery.fetchOne();
        if (vo != null) {
            if (vo.getAddrNo() == null) {
                return Optional.ofNullable(vo);
            }
            List<OrgAddrAddressRespVO> orgAddrAddressVOS = this.outService.findByAddrNo(vo.getAddrNo());
            if (orgAddrAddressVOS.size() > 0) {
                OrgAddrAddressRespVO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                vo.setDetailaddr(orgAddrAddressVO.getDetailaddr());
            }
        }
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public List<InvWhRespVO> findWhIdOne(Long id) {
        List<OrgAddrAddressRespVO> orgAddrAddressVOS;
        JPAQuery<InvWhRespVO> jpaQuery = this.invWhRepoProc.select(null);
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhRespVO vo = (InvWhRespVO)jpaQuery.fetchOne();
        if (vo != null && (orgAddrAddressVOS = this.outService.findByAddrNo(vo.getAddrNo())).size() > 0) {
            OrgAddrAddressRespVO orgAddrAddressVO = orgAddrAddressVOS.get(0);
            vo.setDetailaddr(orgAddrAddressVO.getDetailaddr());
        }
        ArrayList<InvWhRespVO> invWhRespVoList = new ArrayList<InvWhRespVO>();
        invWhRespVoList.add(vo);
        return invWhRespVoList;
    }

    public List<InvWhSalListRespVO> searchSalWh(String keyword) throws ExecutionException, InterruptedException {
        List collect = this.invWhRepoProc.searchSalWh(keyword).fetch();
        List collect1 = collect.stream().map(InvWhSalListRespVO::getId).distinct().collect(Collectors.toList());
        List addrNos = collect.stream().map(InvWhSalListRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CompletableFuture<List> listCompletableFuture = CompletableFuture.supplyAsync(() -> {
            List<OrgAddrAddressRespVO> byAddrNos = this.outService.findByAddrNos(addrNos);
            return byAddrNos;
        });
        CompletableFuture<List> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            List allByWhId = this.invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        List orgWhAreaVOS = listCompletableFuture1.get();
        List byAddrNos = listCompletableFuture.get();
        Map<Long, String> byWhId = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter1() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter1, (key1, key2) -> key2));
        Map<Long, String> deter2 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter2() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter2, (key1, key2) -> key2));
        Map<Long, String> deter3 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter3() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter3, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (byWhId.get(v.getId()) != null) {
                v.setDeter1((String)byWhId.get(v.getId()));
            }
            if (deter2.get(v.getId()) != null) {
                v.setDeter2((String)byWhId.get(v.getId()));
            }
            if (deter3.get(v.getId()) != null) {
                v.setDeter2((String)byWhId.get(v.getId()));
            }
            Optional<OrgAddrAddressRespVO> first = byAddrNos.stream().filter(w -> v.getAddrNo() != null && v.getAddrNo().equals(w.getAddrNo())).findFirst();
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
        });
        return collect;
    }

    public PagingVO<InvWhRespVO> search(InvWhParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        this.invWhRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QInvWhDO.invWhDO);
        List lists = jpaQuery.fetch();
        this.translateWh(lists);
        this.translateUdc(lists, null);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @SysCodeProc
    public PagingVO<InvWhKeywordRespVO> findByMultiKeyword(InvWhKeywordParamVO param) {
        PagingVO kwVOPaging = new PagingVO();
        JPAQuery<InvWhKeywordRespVO> query = this.invWhRepoProc.findByKeyword(param);
        this.invWhRepoProc.openOrderAndLimit(query, (AbstractOrderQueryParam)param, QInvWhDO.invWhDO);
        long dataCount = query.fetchCount();
        List data = query.fetch();
        data.forEach(v -> v.setWhId(v.getId()));
        kwVOPaging.setRecords(data);
        kwVOPaging.setTotal(Long.valueOf(dataCount));
        return kwVOPaging;
    }

    public List<InvWhRespVO> findByCodes(List<String> codes) {
        List<InvWhRespVO> invWhRespVOS = this.invWhRepo.findByWhCodeIn(codes).stream().map(InvWhConvert.INSTANCE::doToVO).collect(Collectors.toList());
        this.translateWh(invWhRespVOS);
        this.translateUdc(invWhRespVOS, null);
        return invWhRespVOS;
    }

    @SysCodeProc
    public List<InvWhListRespVO> list(String keyword) throws ExecutionException, InterruptedException {
        List<InvWhListRespVO> collect = this.invWhRepoProc.list(keyword).fetch().stream().map(VO -> (InvWhListRespVO)BeanUtil.copyProperties((Object)VO, InvWhListRespVO.class)).collect(Collectors.toList());
        List collect1 = collect.stream().map(InvWhListRespVO::getId).distinct().collect(Collectors.toList());
        List addrNos = collect.stream().map(InvWhListRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CompletableFuture<List> listCompletableFuture = CompletableFuture.supplyAsync(() -> {
            List<OrgAddrAddressRespVO> byAddrNos = this.outService.findByAddrNos(addrNos);
            return byAddrNos;
        });
        CompletableFuture<List> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            List allByWhId = this.invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        List orgWhAreaVOS = listCompletableFuture1.get();
        List byAddrNos = listCompletableFuture.get();
        Map<Long, String> deter2 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter2() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter2, (key1, key2) -> key2));
        Map<Long, String> deter3 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter3() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter3, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (deter2.get(v.getId()) != null) {
                v.setDeter2((String)deter2.get(v.getId()));
            }
            if (deter3.get(v.getId()) != null) {
                v.setDeter3((String)deter3.get(v.getId()));
            }
            Optional<OrgAddrAddressRespVO> first = byAddrNos.stream().filter(w -> v.getAddrNo() != null && v.getAddrNo().equals(w.getAddrNo())).findFirst();
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
        });
        return collect;
    }

    @SysCodeProc
    public List<InvWhListRespVO> listWhType(String keyword) throws ExecutionException, InterruptedException {
        List<InvWhListRespVO> collect = this.invWhRepoProc.listWhType(keyword).fetch().stream().map(VO -> (InvWhListRespVO)BeanUtil.copyProperties((Object)VO, InvWhListRespVO.class)).collect(Collectors.toList());
        List collect1 = collect.stream().map(InvWhListRespVO::getId).distinct().collect(Collectors.toList());
        List addrNos = collect.stream().map(InvWhListRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CompletableFuture<List> listCompletableFuture = CompletableFuture.supplyAsync(() -> {
            List<OrgAddrAddressRespVO> byAddrNos = this.outService.findByAddrNos(addrNos);
            return byAddrNos;
        });
        CompletableFuture<List> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            List allByWhId = this.invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        List orgWhAreaVOS = listCompletableFuture1.get();
        List byAddrNos = listCompletableFuture.get();
        Map<Long, String> byWhId = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter1() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter1, (key1, key2) -> key2));
        Map<Long, String> deter2 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter2() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter2, (key1, key2) -> key2));
        Map<Long, String> deter3 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter3() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter3, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (byWhId.get(v.getId()) != null) {
                v.setDeter1((String)byWhId.get(v.getId()));
            }
            if (deter2.get(v.getId()) != null) {
                v.setDeter2((String)deter2.get(v.getId()));
            }
            if (deter3.get(v.getId()) != null) {
                v.setDeter3((String)deter3.get(v.getId()));
            }
            Optional<OrgAddrAddressRespVO> first = byAddrNos.stream().filter(w -> v.getAddrNo() != null && v.getAddrNo().equals(w.getAddrNo())).findFirst();
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
        });
        return collect;
    }

    @SysCodeProc
    public List<InvWhListRespVO> listGroup(String keyword) throws ExecutionException, InterruptedException {
        List<InvWhListRespVO> collect = this.invWhRepoProc.listGroup(keyword).fetch().stream().map(VO -> (InvWhListRespVO)BeanUtil.copyProperties((Object)VO, InvWhListRespVO.class)).collect(Collectors.toList());
        List collect1 = collect.stream().map(InvWhListRespVO::getId).distinct().collect(Collectors.toList());
        List addrNos = collect.stream().map(InvWhListRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CompletableFuture<List> listCompletableFuture = CompletableFuture.supplyAsync(() -> {
            List<OrgAddrAddressRespVO> byAddrNos = this.outService.findByAddrNos(addrNos);
            return byAddrNos;
        });
        CompletableFuture<List> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            List allByWhId = this.invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        List orgWhAreaVOS = listCompletableFuture1.get();
        List byAddrNos = listCompletableFuture.get();
        Map<Long, String> byWhId = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter1() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter1, (key1, key2) -> key2));
        Map<Long, String> deter2 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter2() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter2, (key1, key2) -> key2));
        Map<Long, String> deter3 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter3() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter3, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (byWhId.get(v.getId()) != null) {
                v.setDeter1((String)byWhId.get(v.getId()));
            }
            if (deter2.get(v.getId()) != null) {
                v.setDeter2((String)deter2.get(v.getId()));
            }
            if (deter3.get(v.getId()) != null) {
                v.setDeter3((String)deter3.get(v.getId()));
            }
            Optional<OrgAddrAddressRespVO> first = byAddrNos.stream().filter(w -> v.getAddrNo() != null && v.getAddrNo().equals(w.getAddrNo())).findFirst();
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
        });
        return collect;
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invWhRepo.deleteById(id));
    }

    public Boolean nonInterface(Long whId) {
        List invWhRespVOS = ((JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.interfaceWhere(whId))).fetch();
        return invWhRespVOS != null && invWhRespVOS.size() > 0;
    }

    @SysCodeProc
    public List<InvWhListRespVO> listBuId(InvWhListParamVO param) throws ExecutionException, InterruptedException {
        List<InvWhListRespVO> collect = this.invWhRepoProc.listBuId(param).fetch().stream().map(VO -> (InvWhListRespVO)BeanUtil.copyProperties((Object)VO, InvWhListRespVO.class)).collect(Collectors.toList());
        List collect1 = collect.stream().map(InvWhListRespVO::getId).distinct().collect(Collectors.toList());
        List addrNos = collect.stream().map(InvWhListRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CompletableFuture<List> listCompletableFuture = CompletableFuture.supplyAsync(() -> {
            List<OrgAddrAddressRespVO> byAddrNos = this.outService.findByAddrNos(addrNos);
            return byAddrNos;
        });
        CompletableFuture<List> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            List allByWhId = this.invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        List orgWhAreaVOS = listCompletableFuture1.get();
        List byAddrNos = listCompletableFuture.get();
        Map<Long, String> byWhId = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter1() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter1, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (byWhId.get(v.getId()) != null) {
                v.setDeter1((String)byWhId.get(v.getId()));
            }
            Optional<OrgAddrAddressRespVO> first = byAddrNos.stream().filter(w -> v.getAddrNo() != null && v.getAddrNo().equals(w.getAddrNo())).findFirst();
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
        });
        return collect;
    }

    @SysCodeProc
    public PagingVO<InvWhRptRespVO> findByOuterCode(InvWhAreaParamVO queryParam) {
        if (StringUtils.isEmpty((CharSequence)queryParam.getOuterCode())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "outerCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PagingVO rptVOPaging = new PagingVO();
        JPAQuery jpaQuery = (JPAQuery)this.invWhAreaRepoProc.select(null).where(this.invWhAreaRepoProc.deter2Where(queryParam));
        this.invWhAreaRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)queryParam, QInvWhAreaDO.invWhAreaDO);
        long dataCount = jpaQuery.fetchCount();
        List invWhAreaRespVOS = jpaQuery.fetch();
        List<Object> orgWhRptVOs = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)invWhAreaRespVOS)) {
            List whIdList = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getWhId).distinct().collect(Collectors.toList());
            InvWhParamVO orgWhQueryParam = new InvWhParamVO();
            orgWhQueryParam.setWhIds(whIdList);
            PagingVO orgWhVOPagingVO = this.invWhAreaService.searchWh(orgWhQueryParam);
            List invWhRespVOList = orgWhVOPagingVO.getRecords();
            this.translateWh(invWhRespVOList);
            this.translateUdc(invWhRespVOList, invWhAreaRespVOS);
            this.translateWhArea(invWhAreaRespVOS, invWhRespVOList);
            orgWhRptVOs = invWhAreaRespVOS.stream().map(v -> {
                InvWhRptRespVO rptVO = InvWhConvert.INSTANCE.voToRptVo(v.getInvWhRespVO());
                if (rptVO != null) {
                    rptVO.setRId(Long.valueOf(v.hashCode()));
                    rptVO.setDeter1(v.getDeter1());
                    rptVO.setDeter1Name(v.getDeter1Name());
                    rptVO.setDeter2(v.getDeter2());
                    rptVO.setDeter2Name(v.getDeter2Name());
                    rptVO.setOuterCode(v.getOuterCode());
                    rptVO.setOuterCodeName(v.getOuterCodeName());
                    rptVO.setOuterCode2(v.getOuterCode2());
                    rptVO.setOuterCode2Name(v.getOuterCode2Name());
                    rptVO.setCustCode(v.getPCode());
                    rptVO.setDeter3(v.getDeter3());
                    rptVO.setPCode(v.getPCode());
                    rptVO.setPType(v.getPType());
                    invWhRespVOList.stream().filter(o -> o.getId().equals(v.getWhId())).findFirst().ifPresent(o -> {
                        rptVO.setWhId(o.getId().toString());
                        rptVO.setWhName(o.getWhName());
                    });
                }
                return rptVO;
            }).collect(Collectors.toList());
        }
        rptVOPaging.setRecords(orgWhRptVOs);
        rptVOPaging.setTotal(Long.valueOf(dataCount));
        return rptVOPaging;
    }

    public List<InvWhRespVO> findIdBatch(List<Long> ids) {
        return this.invWhRepo.findAllById(ids).stream().map(InvWhConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    private Boolean existVerify(Long id, String whCode) {
        InvWhParamVO param = new InvWhParamVO();
        param.setWhCode(whCode);
        JPAQuery<InvWhRespVO> select = this.invWhRepoProc.select(param);
        return select.fetch().stream().anyMatch(w -> !w.getId().equals(id));
    }

    private void translateWh(List<InvWhRespVO> invWhRespVOList) {
        List<Integer> addrNos = invWhRespVOList.stream().map(InvWhRespVO::getAddrNo).distinct().collect(Collectors.toList());
        List<OrgAddrAddressRespVO> orgAddrAddressVOS = this.outService.findByAddrNos(addrNos);
        List<Long> ouIds = invWhRespVOList.stream().map(InvWhRespVO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuVO> orgOuVOS = this.outService.findBatchOus(ouIds);
        invWhRespVOList.forEach(VO -> {
            Optional<OrgOuVO> first1;
            List first;
            if (!CollectionUtils.isEmpty((Collection)orgAddrAddressVOS) && (first = orgAddrAddressVOS.stream().filter(a -> a.getAddrNo().equals(VO.getAddrNo())).collect(Collectors.toList())).size() > 0) {
                OrgAddrAddressRespVO orgAddrAddressVO = (OrgAddrAddressRespVO)first.get(0);
                Object email = "";
                for (OrgAddrAddressRespVO address : first) {
                    email = (String)email + address.getEmail() + ";";
                }
                VO.setCountry(orgAddrAddressVO.getCountry());
                VO.setProvince(orgAddrAddressVO.getProvince());
                VO.setCity(orgAddrAddressVO.getCity());
                VO.setCounty(orgAddrAddressVO.getCounty());
                VO.setCountryName(orgAddrAddressVO.getCountryName());
                VO.setProvinceName(orgAddrAddressVO.getProvinceName());
                VO.setCityName(orgAddrAddressVO.getCityName());
                VO.setCountyName(orgAddrAddressVO.getCountyName());
                VO.setDetailaddr(orgAddrAddressVO.getDetailaddr());
                VO.setEmail((String)email);
                VO.setContPerson(orgAddrAddressVO.getContPerson());
                VO.setTel(orgAddrAddressVO.getTel());
            }
            if ((first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst()).isPresent()) {
                OrgOuVO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getName());
                VO.setOuCode(orgOuVO.getCode());
                VO.setOuCurr(orgOuVO.getStdCurr());
            }
        });
    }

    public void translateUdc(List<InvWhRespVO> invWhRespVOList, List<InvWhAreaRespVO> orgWhAreaVOS) {
        Map whTypesMap = this.sysUdcService.getCodeMap(UdcEnum.INV_WH_TYPE_PHYSICAL.getModel(), UdcEnum.INV_WH_TYPE_PHYSICAL.getCode());
        Map whStatusMap = this.sysUdcService.getCodeMap(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getModel(), UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getCode());
        Map whEs1Map = this.sysUdcService.getCodeMap(UdcEnum.INV_WH_PROP_SAL.getModel(), UdcEnum.INV_WH_PROP_SAL.getCode());
        Map funcMap = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_GD.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
        Map tempMap = this.sysUdcService.getCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map erpMap = this.sysUdcService.getCodeMap(UdcEnum.INV_E1_BP_181012021.getModel(), UdcEnum.INV_E1_BP_181012021.getCode());
        Map e1Map = this.sysUdcService.getCodeMap(UdcEnum.INV_E1_LOC_DAMG.getModel(), UdcEnum.INV_E1_LOC_DAMG.getCode());
        Map pTypeMap = this.sysUdcService.getCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
        if (!CollectionUtils.isEmpty(invWhRespVOList)) {
            invWhRespVOList.forEach(v -> {
                if (StringUtils.isNotBlank((CharSequence)v.getWhType()) && !MapUtils.isEmpty((Map)whTypesMap)) {
                    v.setWhTypeName((String)whTypesMap.get(v.getWhType()));
                }
                if (StringUtils.isNotBlank((CharSequence)v.getWhType2()) && !MapUtils.isEmpty((Map)whTypesMap)) {
                    v.setWhType2Name((String)whTypesMap.get(v.getWhType2()));
                }
                if (StringUtils.isNotBlank((CharSequence)v.getWhStatus()) && !MapUtils.isEmpty((Map)whStatusMap)) {
                    v.setWhStatusName((String)whStatusMap.get(v.getWhStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)v.getEs1()) && !MapUtils.isEmpty((Map)whEs1Map)) {
                    v.setEs1Name((String)whEs1Map.get(v.getEs1()));
                }
            });
        }
        if (!CollectionUtils.isEmpty(orgWhAreaVOS)) {
            orgWhAreaVOS.forEach(area -> {
                if (StringUtils.isNotBlank((CharSequence)area.getDeter1()) && !MapUtils.isEmpty((Map)tempMap)) {
                    area.setDeter1Name((String)tempMap.get(area.getDeter1()));
                }
                if (StringUtils.isNotBlank((CharSequence)area.getDeter2()) && !MapUtils.isEmpty((Map)funcMap)) {
                    area.setDeter2Name((String)funcMap.get(area.getDeter2()));
                }
                if (StringUtils.isNotBlank((CharSequence)area.getOuterCode()) && !MapUtils.isEmpty((Map)erpMap)) {
                    area.setOuterCodeName((String)erpMap.get(area.getOuterCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)area.getOuterCode2()) && !MapUtils.isEmpty((Map)e1Map)) {
                    area.setOuterCode2Name((String)e1Map.get(area.getOuterCode2()));
                }
                if (StringUtils.isNotBlank((CharSequence)area.getPType()) && !MapUtils.isEmpty((Map)pTypeMap)) {
                    area.setPTypeName((String)pTypeMap.get(area.getPType()));
                }
            });
        }
    }

    public void update(InvWhDO invWhDO) {
        Optional optional = this.invWhRepo.findById(invWhDO.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + invWhDO.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(invWhDO, (InvWhDO)optional.get(), BeanCopyUtil.getNullAndIgnorePropertyNames(invWhDO, new String[0]));
        this.invWhRepo.save(invWhDO);
    }

    private void createAddrAddress(InvWhSaveVO param, Integer addrNo) {
        OrgAddrAddressVO orgAddrAddressVO = new OrgAddrAddressVO();
        orgAddrAddressVO.setAddrNo(addrNo);
        orgAddrAddressVO.setDetailaddr(param.getDetailaddr());
        orgAddrAddressVO.setCountry(param.getCountry());
        orgAddrAddressVO.setProvince(param.getProvince());
        orgAddrAddressVO.setCity(param.getCity());
        orgAddrAddressVO.setCounty(param.getCounty());
        orgAddrAddressVO.setEmail(param.getEmail());
        orgAddrAddressVO.setContPerson(param.getContPerson());
        orgAddrAddressVO.setTel(param.getTel());
        this.outService.createAddrOne(orgAddrAddressVO);
    }

    private void translateWhArea2(List<InvWhAreaRespVO> orgWhAreaVOS, List<InvWhRespVO> orgWhVOList, String custCode, String custName, String pType, PagingVO<InvWhAreaRespVO> search) {
        if (UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode().equals(pType)) {
            PriPriceCustApplyQueryParam param = new PriPriceCustApplyQueryParam();
            param.setCustCode(custCode);
            param.setCustName(custName);
            param.setSize(Integer.valueOf(1000));
            List<OrgCustRespVO> orgCustVOS = this.outService.findCustByParam(param);
            ArrayList orgWhAreaVOSOut = new ArrayList();
            orgWhAreaVOS.forEach(VO -> {
                Optional<OrgCustRespVO> first;
                orgWhVOList.stream().filter(record -> VO.getWhId().equals(record.getId())).findAny().ifPresent(arg_0 -> ((InvWhAreaRespVO)VO).setInvWhRespVO(arg_0));
                if (!CollectionUtils.isEmpty((Collection)orgCustVOS) && (first = orgCustVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst()).isPresent()) {
                    VO.setPCode(first.get().getCustCode());
                    VO.setPName(first.get().getCustName());
                    orgWhAreaVOSOut.add(VO);
                }
            });
            search.setRecords(orgWhAreaVOSOut);
            search.setTotal(Long.valueOf(orgWhAreaVOSOut.size()));
        }
    }

    private void translateWhArea(List<InvWhAreaRespVO> invWhAreaRespVOS, List<InvWhRespVO> invWhRespVOList) {
        List<Long> custIds = invWhAreaRespVOS.stream().filter(VO -> VO.getEs1() != null && StringUtils.isNumeric((CharSequence)VO.getEs1())).map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        List<OrgCustVO> orgCustVOS = this.outService.findCustByIdList(custIds);
        invWhAreaRespVOS.forEach(VO -> {
            invWhRespVOList.stream().filter(record -> VO.getWhId().equals(record.getId())).findAny().ifPresent(arg_0 -> ((InvWhAreaRespVO)VO).setInvWhRespVO(arg_0));
            if (!CollectionUtils.isEmpty((Collection)orgCustVOS)) {
                Optional<OrgCustVO> first = orgCustVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst();
                first.ifPresent(orgCustVO -> {
                    VO.setPCode(orgCustVO.getCustCode());
                    VO.setPName(orgCustVO.getCustName());
                });
            }
        });
    }

    public List<Long> findIdByPhyCode(String code) {
        List<Tuple> idByPhyCode = this.invWhRepo.findIdByPhyCode(code);
        List<Long> collect = idByPhyCode.stream().map(v -> Long.valueOf(v.get(0).toString())).collect(Collectors.toList());
        return collect;
    }

    public Optional<InvWhRespVO> findById(long id) {
        JPAQuery<InvWhRespVO> jpaQuery = this.invWhRepoProc.select(null);
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhRespVO vo = (InvWhRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    public InvWhServiceImpl(SysUdcService sysUdcService, InvWhRepoProc invWhRepoProc, InvWhRepo invWhRepo, InvWhAreaService invWhAreaService, InvWhAreaRepoProc invWhAreaRepoProc, OutService outService, OrgAddrAddressRepo orgAddrAddressRepo) {
        this.sysUdcService = sysUdcService;
        this.invWhRepoProc = invWhRepoProc;
        this.invWhRepo = invWhRepo;
        this.invWhAreaService = invWhAreaService;
        this.invWhAreaRepoProc = invWhAreaRepoProc;
        this.outService = outService;
        this.orgAddrAddressRepo = orgAddrAddressRepo;
    }
}

