/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.entity.QPriSalePriceDO;
import com.elitesland.inv.param.PriSalePriceQueryParam;
import com.elitesland.inv.repo.PriSalePriceRepo;
import com.elitesland.inv.repo.PriSalePriceRepoProc;
import com.elitesland.inv.service.PriSalePriceService;
import com.elitesland.item.vo.PriSalePriceVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="priSalePriceService")
public class PriSalePriceServiceImpl
implements PriSalePriceService {
    private final PriSalePriceRepo priSalePriceRepo;
    private final PriSalePriceRepoProc repoProc;

    @SysCodeProc
    public List<PriSalePriceVO> findByItemIdIn(List<Long> idList) {
        List priSalePriceVOS = ((JPAQuery)this.repoProc.select(null).where((Predicate)QPriSalePriceDO.priSalePriceDO.itemId.in(idList))).fetch();
        return priSalePriceVOS;
    }

    public List<PriSalePriceVO> findAllSrcDid(List<Long> idList) {
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        JPAQuery where = (JPAQuery)this.repoProc.select(null).where((Predicate)jpaQDo.srcDId.in(idList));
        return where.fetch();
    }

    public List<PriSalePriceVO> findAllSrcDocid(Long buId, Long ouId, Long bdId, Long itemId, String uom) {
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        JPAQuery where = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.repoProc.select(null).where((Predicate)(buId == null ? jpaQDo.buId.isNull() : jpaQDo.buId.eq((Object)buId)))).where((Predicate)(ouId == null ? jpaQDo.ouId.isNull() : jpaQDo.ouId.eq((Object)ouId)))).where((Predicate)(bdId == null ? jpaQDo.bdId.isNull() : jpaQDo.bdId.eq((Object)bdId)))).where((Predicate)jpaQDo.itemId.eq((Object)itemId))).where((Predicate)jpaQDo.priceType.eq((Object)"COST_PRICE"))).where((Predicate)(uom == null ? jpaQDo.uom.isNull() : jpaQDo.uom.eq((Object)uom)));
        return where.fetch();
    }

    public List<PriSalePriceVO> findByUomAndIdIn(String uom, List<Long> ids) {
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        JPAQuery where = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.repoProc.select(null).where((Predicate)(!CollectionUtils.isEmpty(ids) ? jpaQDo.itemId.in(ids) : jpaQDo.itemId.eq((Object)0L)))).where((Predicate)jpaQDo.priceType.eq((Object)"COST_PRICE"))).where((Predicate)(uom == null ? jpaQDo.uom.isNull() : jpaQDo.uom.eq((Object)uom)))).where((Predicate)jpaQDo.deleteFlag.eq((Object)0));
        return where.fetch();
    }

    public List<PriSalePriceVO> findAllSrcDocid(Long buId, Long bdId, Long itemId, String uom) {
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        JPAQuery where = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.repoProc.select(null).where((Predicate)(buId == null ? jpaQDo.buId.isNull() : jpaQDo.buId.eq((Object)buId)))).where((Predicate)(bdId == null ? jpaQDo.bdId.isNull() : jpaQDo.bdId.eq((Object)bdId)))).where((Predicate)jpaQDo.itemId.eq((Object)itemId))).where((Predicate)jpaQDo.priceType.eq((Object)"COST_PRICE"))).where((Predicate)(uom == null ? jpaQDo.uom.isNull() : jpaQDo.uom.eq((Object)uom)));
        return where.fetch();
    }

    public List<PriSalePriceVO> findAllSrcDocidAndType(Long buId, Long bdId, Long itemId, String priceGroupCode) {
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        JPAQuery where = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.repoProc.select(null).where((Predicate)(buId == null ? jpaQDo.buId.isNull() : jpaQDo.buId.eq((Object)buId)))).where((Predicate)(bdId == null ? jpaQDo.bdId.isNull() : jpaQDo.bdId.eq((Object)bdId)))).where((Predicate)jpaQDo.priceType.eq((Object)"PRICEGROUP_PRICE"))).where((Predicate)jpaQDo.itemId.eq((Object)itemId))).where((Predicate)(priceGroupCode == null ? jpaQDo.priceGroup.isNull() : jpaQDo.priceGroup.eq((Object)priceGroupCode)));
        return where.fetch();
    }

    public List<PriSalePriceVO> findAllSrcDocidAndType(Long buId, Long ouId, Long bdId, Long itemId, String priceGroupCode, String uom) {
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        JPAQuery where = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.repoProc.select(null).where((Predicate)(buId == null ? jpaQDo.buId.isNull() : jpaQDo.buId.eq((Object)buId)))).where((Predicate)(ouId == null ? jpaQDo.ouId.isNull() : jpaQDo.ouId.eq((Object)ouId)))).where((Predicate)(bdId == null ? jpaQDo.bdId.isNull() : jpaQDo.bdId.eq((Object)bdId)))).where((Predicate)(uom == null ? jpaQDo.uom.isNull() : jpaQDo.uom.eq((Object)uom)))).where((Predicate)jpaQDo.priceType.eq((Object)"PRICEGROUP_PRICE"))).where((Predicate)jpaQDo.itemId.eq((Object)itemId))).where((Predicate)(priceGroupCode == null ? jpaQDo.priceGroup.isNull() : jpaQDo.priceGroup.eq((Object)priceGroupCode)));
        return where.fetch();
    }

    public List<PriSalePriceVO> findListByType(PriSalePriceQueryParam param) {
        JPAQuery<PriSalePriceVO> jpaQuery = this.repoProc.select(param);
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        return jpaQuery.fetch();
    }

    @SysCodeProc
    public Optional<PriSalePriceVO> findByBuIdAndItemId(PriSalePriceQueryParam param) {
        if (StringUtils.isEmpty((Object)param.getBuId()) || StringUtils.isEmpty((Object)param.getItemId())) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a" + param);
        }
        param.setDateTime(LocalDateTime.now());
        PriSalePriceVO priSalePriceVO = (PriSalePriceVO)((JPAQuery)this.repoProc.select(null).where(this.repoProc.basePriceWhere(param))).fetchFirst();
        return Optional.ofNullable(priSalePriceVO);
    }

    @SysCodeProc
    public Optional<PriSalePriceVO> findByOuIdAndPriceGroupAndItemId(PriSalePriceQueryParam param) {
        if (StringUtils.isEmpty((Object)param.getItemId()) || StringUtils.isEmpty((Object)param.getPriceGroup())) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u6216\u8005\u4ef7\u683c\u7b56\u7565\u7ec4\u4e3a\u7a7a\uff01");
        }
        param.setDateTime(LocalDateTime.now());
        PriSalePriceVO priSalePriceVO = (PriSalePriceVO)((JPAQuery)this.repoProc.select(null).where(this.repoProc.basePriceWhere(param))).fetchFirst();
        return Optional.ofNullable(priSalePriceVO);
    }

    public List<PriSalePriceVO> listByParam(PriSalePriceQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.repoProc.select(param).where(this.repoProc.where(param));
        List priSalePriceVOList = jpaQuery.fetch();
        return Lists.newArrayList((Iterable)priSalePriceVOList);
    }

    public List<PriSalePriceVO> listByOuIdAndItemId(PriSalePriceQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.repoProc.selectByOuIdAndItemId(null).where(this.repoProc.where(param));
        List priSalePriceVOList = jpaQuery.fetch();
        return Lists.newArrayList((Iterable)priSalePriceVOList);
    }

    public List<Long> listByItemIdAndCostPriceNotNull(Long itemId) {
        JPAQuery<PriSalePriceVO> jpaQuery = this.repoProc.selectByOuIdAndItemId(null);
        QPriSalePriceDO jpaQDo = QPriSalePriceDO.priSalePriceDO;
        jpaQuery.where((Predicate)jpaQDo.itemId.eq((Object)itemId));
        jpaQuery.where((Predicate)jpaQDo.costPrice.isNotNull());
        List priSalePriceVOList = jpaQuery.fetch();
        List ouIds = priSalePriceVOList.stream().map(PriSalePriceVO::getOuId).distinct().collect(Collectors.toList());
        return Lists.newArrayList(ouIds);
    }

    @SysCodeProc
    public List<PriSalePriceVO> findByItemIdAndPriceType(Long ouId, Long itemId, String priceType, LocalDateTime docTime) {
        return ((JPAQuery)this.repoProc.select(null).where(this.repoProc.groupWhere(ouId, itemId, priceType, docTime))).fetch();
    }

    public PriSalePriceServiceImpl(PriSalePriceRepo priSalePriceRepo, PriSalePriceRepoProc repoProc) {
        this.priSalePriceRepo = priSalePriceRepo;
        this.repoProc = repoProc;
    }
}

