/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.service;

import com.elitesland.core.base.PagingVO;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.repo.InvLrRepoProc;
import com.elitesland.inv.service.InvLrService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.param.InvLrQueryParamVO;
import com.elitesland.inv.vo.resp.InvLrRespVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="InvLrService")
public class invLrServiceImpl
implements InvLrService {
    private final InvLrRepoProc invLrRepoProc;
    private final InvWhService invWhService;
    private final OrgOuService orgOuService;
    private final SysUdcService sysUdcService;
    private final OutService outService;

    public PagingVO<InvLrRespVO> search(InvLrQueryParamVO param) {
        ArrayList<String> ouList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)param.getOuCode())) {
            ouList.add(param.getOuCode());
            List collect = this.orgOuService.findCodeBatch(ouList).stream().map(OrgOuVO::getId).collect(Collectors.toList());
            if (collect.size() > 0) {
                param.setOuIds(collect);
            } else {
                return PagingVO.builder().total(Long.valueOf(0L)).records(new ArrayList()).build();
            }
        }
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        if (!CollectionUtils.isEmpty((Collection)param.getBrand())) {
            itmItemPartParam.setBrands(param.getBrand());
            List collect = this.outService.itmItemPartSearch(itmItemPartParam).stream().map(ItmItemPartDTO::getId).collect(Collectors.toList());
            if (collect.size() > 0) {
                param.setItemIds(collect);
            } else {
                return PagingVO.builder().total(Long.valueOf(0L)).records(new ArrayList()).build();
            }
        }
        PagingVO select = this.invLrRepoProc.select(param);
        List invLrResults = select.getRecords();
        List invWhRespVOS = this.invWhService.findIdBatch(invLrResults.stream().map(InvLrRespVO::getWhId).collect(Collectors.toList()));
        List orgOuResults = this.orgOuService.listByIds(invLrResults.stream().map(InvLrRespVO::getOuId).collect(Collectors.toList()));
        List collect = invLrResults.stream().map(InvLrRespVO::getItemId).collect(Collectors.toList());
        itmItemPartParam.setIds(collect);
        List<ItmItemDTO> itmItemPartDTOS = this.outService.itmItemAllSearch(itmItemPartParam);
        List finalInvWhRespVOS = invWhRespVOS;
        invLrResults.stream().forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)finalInvWhRespVOS)) {
                finalInvWhRespVOS.stream().filter(v -> v.getId().equals(i.getWhId())).findAny().ifPresent(m -> {
                    i.setWhName(m.getWhName());
                    i.setWhCode(m.getWhCode());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(v -> v.getId().equals(i.getItemId())).findAny().ifPresent(m -> {
                    i.setItemCode(m.getItemCode());
                    i.setItemName(m.getItemName());
                    i.setBrand(m.getBrand());
                    i.setPackageSpec(m.getPackageSpec());
                    i.setUom(m.getUom());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuResults)) {
                orgOuResults.stream().filter(v -> v.getId().equals(i.getOuId())).findFirst().ifPresent(m -> i.setOuCode(m.getCode()));
            }
            if (i.getLockValidFrom() != null && i.getLockEndDate() != null) {
                this.timeChange((InvLrRespVO)i);
            }
        });
        this.udcChange(invLrResults);
        return PagingVO.builder().total(select.getTotal()).records(invLrResults).build();
    }

    public void timeChange(InvLrRespVO invLrResults) {
        invLrResults.getLockValidFrom().getDayOfMonth();
        Duration duration = Duration.between(invLrResults.getLockValidFrom(), invLrResults.getLockEndDate());
        long millis = duration.toMillis();
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = millis / (long)dd.intValue();
        Long hour = (millis - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (millis - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (millis - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        StringBuffer time = new StringBuffer();
        if (day > 0L) {
            time.append(day + "\u5929");
        }
        if (hour > 0L) {
            time.append(hour + "\u5c0f\u65f6");
        }
        if (minute > 0L) {
            time.append(minute + "\u5206");
        }
        if (second > 0L) {
            time.append(second + "\u79d2");
        }
        invLrResults.setLockValidDuration(time.toString());
    }

    public List<InvLrRespVO> udcChange(List<InvLrRespVO> InvLrRespVO2) {
        Map udcDeter2 = this.sysUdcService.getCodeMap(UdcEnum.INV_FUNC_TYPE_GD.getModel(), UdcEnum.INV_FUNC_TYPE_GD.getCode());
        Map udcDoctype = this.sysUdcService.getCodeMap(UdcEnum.PUR_PO_TYPE_OP.getModel(), UdcEnum.PUR_PO_TYPE_OP.getCode());
        Map udcLockStatus = this.sysUdcService.getCodeMap(UdcEnum.INV_OCCUPANCY_STATUS_O.getModel(), UdcEnum.INV_OCCUPANCY_STATUS_O.getCode());
        InvLrRespVO2.stream().forEach(Asm -> {
            if (StringUtils.isNotBlank((CharSequence)Asm.getDeter2()) && !MapUtils.isEmpty((Map)udcDeter2)) {
                Asm.setDeter2Name((String)udcDeter2.get(Asm.getDeter2()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDocType()) && !MapUtils.isEmpty((Map)udcDoctype)) {
                Asm.setDocTypeName((String)udcDoctype.get(Asm.getDocType()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getLockStatus()) && !MapUtils.isEmpty((Map)udcLockStatus)) {
                Asm.setLockStatusName((String)udcLockStatus.get(Asm.getLockStatus()));
            }
        });
        return InvLrRespVO2;
    }

    public invLrServiceImpl(InvLrRepoProc invLrRepoProc, InvWhService invWhService, OrgOuService orgOuService, SysUdcService sysUdcService, OutService outService) {
        this.invLrRepoProc = invLrRepoProc;
        this.invWhService = invWhService;
        this.orgOuService = orgOuService;
        this.sysUdcService = sysUdcService;
        this.outService = outService;
    }
}

