/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.controller;

import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.out.entity.ComCurrDO;
import com.elitesland.out.service.ComCurrService;
import com.elitesland.out.service.OutService;
import com.elitesland.out.vo.param.ComCurrQueryParamVO;
import com.elitesland.out.vo.resp.ComCurrRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/com/comCurr"})
@Api(value="\u5e01\u79cd", tags={"\u5e01\u79cd"})
public class ComCurrController {
    private final ComCurrService comCurrService;
    private final OutService outService;

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u8d27\u5e01\u5217\u8868")
    public ApiResult<?> search(@RequestBody ComCurrQueryParamVO param) {
        PagingVO<ComCurrRespVO> ret = this.comCurrService.search(param);
        return ApiResult.ok(ret);
    }

    @GetMapping(value={"/findAll"})
    @ApiOperation(value="\u6240\u6709\u8d27\u5e01")
    public ApiResult<?> searchAll() {
        List<ComCurrRespVO> ret = this.outService.comCurrsearchAll();
        return ApiResult.ok(ret);
    }

    @GetMapping(value={"/findCodeOne/{code}"})
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u6bb5\uff0c\u8fd4\u56de\u5bf9\u5e94\u7684\u8d27\u5e01")
    ApiResult<?> findCodeOne(@PathVariable String code) {
        return ApiResult.ok((Object)this.comCurrService.findCodeOne(code).get());
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u6839\u636eid\uff0c\u8fd4\u56de\u5bf9\u5e94\u7684\u8d27\u5e01")
    ApiResult<?> findIdOne(@PathVariable Long id) {
        return ApiResult.ok((Object)this.comCurrService.findIdOne(id).get());
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u8d27\u5e01")
    public ApiResult<?> createOne(@RequestBody ComCurrDO comCurrDO) throws BusinessException {
        this.comCurrService.createOne(comCurrDO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u521b\u5efa\u591a\u8d27\u5e01")
    public ApiResult<?> createBatch(@RequestBody List<ComCurrDO> code) {
        this.comCurrService.createBatch(code);
        return ApiResult.ok();
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u8d27\u5e01")
    public ApiResult<?> updateCurr(@RequestBody ComCurrDO code) throws BusinessException {
        this.comCurrService.update(code);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u8d27\u5e01")
    public ApiResult<?> deleteOne(@PathVariable(value="id") Long id) throws BusinessException {
        this.comCurrService.deleteOne(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch/{ids}"})
    @ApiOperation(value="\u5220\u9664\u8d27\u5e01")
    public ApiResult<?> deleteBatch(@PathVariable(value="ids") List<Long> id) {
        this.comCurrService.deleteBatch(id);
        return ApiResult.ok();
    }

    @PatchMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u5220\u9664\u6807\u5fd7")
    public ApiResult<?> updateDeleteFlag(@PathVariable(value="id") Long id) throws BusinessException {
        this.comCurrService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    public ComCurrController(ComCurrService comCurrService, OutService outService) {
        this.comCurrService = comCurrService;
        this.outService = outService;
    }
}

