/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.inv.dto.ComDistrictVO;
import com.elitesland.out.entity.ComDistrictDO;
import com.elitesland.out.service.ComDistrictService;
import com.elitesland.out.vo.param.ComDistrictQueryParamVO;
import com.elitesland.out.vo.resp.ComDistrictRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/com/districts"})
@Api(value="\u57fa\u7840-\u533a\u57df", tags={"\u57fa\u7840-\u533a\u57df"})
public class ComDistrictController {
    private final ComDistrictService comDistrictService;

    @GetMapping(value={"/searchCity/{cityName}"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u57ce\u5e02,\u5e76\u5e26\u51fa\u7701,\u56fd\u5bb6\u4fe1\u606f")
    public ApiResult<?> searchCity(@PathVariable(value="cityName") String cityName) {
        ComDistrictQueryParamVO comDistrictQueryParam = new ComDistrictQueryParamVO();
        comDistrictQueryParam.setDistName(cityName);
        comDistrictQueryParam.setDistLevelNum(Integer.valueOf(3));
        List comDistrictVOS = this.comDistrictService.search(comDistrictQueryParam).getRecords().stream().map(comDistrictVO -> {
            ComDistrictVO comDistrictVO1 = new ComDistrictVO();
            comDistrictVO1.setCity(comDistrictVO.getDistCode());
            comDistrictVO1.setCityName(comDistrictVO.getDistName());
            comDistrictVO1.setCityId(comDistrictVO.getId());
            Optional<ComDistrictRespVO> comDistrictProvinceVO = this.comDistrictService.oneById(comDistrictVO.getParentId());
            if (comDistrictProvinceVO.isPresent()) {
                comDistrictVO1.setProvince(comDistrictProvinceVO.get().getDistCode());
                comDistrictVO1.setProvinceName(comDistrictProvinceVO.get().getDistName());
                comDistrictVO1.setProvinceId(comDistrictProvinceVO.get().getId());
                Optional<ComDistrictRespVO> comDistrictCountry = this.comDistrictService.oneById(comDistrictProvinceVO.get().getParentId());
                if (comDistrictCountry.isPresent()) {
                    comDistrictVO1.setCountry(comDistrictCountry.get().getDistCode());
                    comDistrictVO1.setCountryName(comDistrictCountry.get().getDistName());
                    comDistrictVO1.setCountryId(comDistrictCountry.get().getId());
                }
            }
            return comDistrictVO1;
        }).collect(Collectors.toList());
        return ApiResult.ok(comDistrictVOS);
    }

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u57df")
    public ApiResult<?> search(@RequestBody ComDistrictQueryParamVO param) {
        return ApiResult.ok(this.comDistrictService.search(param));
    }

    @GetMapping(value={"/byparent/{pid}"})
    @ApiOperation(value="\u6839\u636e\u7236\u7ea7ID\uff0c\u5217\u51fa\u6240\u6709\u7684\u5b50\u533a\u57df")
    public ApiResult<?> listByParentId(@PathVariable Long pid) {
        return ApiResult.ok(this.comDistrictService.listByPId(pid));
    }

    @GetMapping(value={"/bypcode/{pcode}"})
    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u7f16\u7801\uff0c\u8fd4\u56de\u5b50\u533a\u57df\u7684\u4e0b\u62c9\u5217\u8868")
    public ApiResult<?> listCombosByPCode(@PathVariable String pcode) {
        return ApiResult.ok(this.comDistrictService.listByPCode(pcode));
    }

    @GetMapping(value={"/bypcode/country"})
    @ApiOperation(value="\u8fd4\u56de\u56fd\u5bb6\u4e0b\u62c9\u5217\u8868")
    public ApiResult<?> listCountryCombos() {
        return ApiResult.ok(this.comDistrictService.listByPCode2(null));
    }

    @GetMapping(value={"/byDistLevelNum/{distLevelNum}"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u5c42\u7ea7\u8fd4\u56de\u533a\u57df\u4e0b\u62c9")
    public ApiResult<?> ListBydistLevelNum(@PathVariable Integer distLevelNum) {
        List<ComDistrictComboVO> comDistrictComboVOS = this.comDistrictService.listByDistLevelNum(distLevelNum);
        return ApiResult.ok(comDistrictComboVOS);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636e\u533a\u57dfID\u8fd4\u56de\u533a\u57df\u660e\u7ec6")
    public ApiResult<?> oneById(@PathVariable Long id) {
        return this.comDistrictService.oneById(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u533a\u57df")
    public ApiResult<?> create(@RequestBody ComDistrictDO districtDO) {
        Long id = this.comDistrictService.create(districtDO);
        return ApiResult.ok((Object)id);
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u533a\u57df\u4fe1\u606f")
    public ApiResult<?> update(@RequestBody ComDistrictDO districtDO) {
        this.comDistrictService.update(districtDO);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636e\u533a\u57dfID\u5220\u9664\u533a\u57df\u4fe1\u606f")
    public ApiResult<?> removeById(@PathVariable Long id) {
        this.comDistrictService.removeById(id);
        return ApiResult.ok();
    }

    public ComDistrictController(ComDistrictService comDistrictService) {
        this.comDistrictService = comDistrictService;
    }
}

