/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.out.entity.OrgBdDO;
import com.elitesland.out.service.OrgBdService;
import com.elitesland.out.vo.param.OrgBdQueryParamVO;
import com.elitesland.out.vo.resp.AntTreeNodeRespVO;
import com.elitesland.out.vo.resp.OrgBdRespVO;
import com.elitesland.out.vo.save.OrgBdSaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/org/orgBd"})
@Api(value="\u4e8b\u4e1a\u90e8", tags={"\u4e8b\u4e1a\u90e8"})
public class OrgBdController {
    private final OrgBdService orgBdService;

    @GetMapping(value={"/getRootTree"})
    @ApiOperation(value="\u83b7\u53d6\u4e8b\u4e1a\u90e8\u7ed3\u6784\u6811")
    public ApiResult<?> getRootTree(OrgBdQueryParamVO orgBdParam) {
        AntTreeNodeRespVO nodes = this.orgBdService.getRootTree(orgBdParam);
        return ApiResult.ok((Object)nodes);
    }

    @GetMapping(value={"/getManageRootTreeList"})
    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u7ec4\u7ec7\u4e1a\u52a1\u670d\u52a1\u7684\u6811  \u4e34\u65f6\u653e\u5728\u8fd9\u91cc")
    public ApiResult<?> getManageRootTreeList() {
        AntTreeNodeRespVO nodes = this.orgBdService.getManageRootTreeList();
        return ApiResult.ok((Object)nodes);
    }

    @GetMapping(value={"/findAll"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u4e8b\u4e1a\u90e8\u6570\u636e")
    ApiResult<?> findAll() {
        OrgBdQueryParamVO orgBdQueryParam = new OrgBdQueryParamVO();
        PagingVO<OrgBdRespVO> result = this.orgBdService.search(orgBdQueryParam);
        return ApiResult.ok((Object)result.getRecords());
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    ApiResult<?> findIdOne(@PathVariable Long id) {
        Optional<OrgBdRespVO> vo = this.orgBdService.findIdOne(id);
        return vo.isPresent() ? ApiResult.ok((Object)vo.get()) : ApiResult.fail((ApiCode)ApiCode.NOT_FOUND);
    }

    @GetMapping(value={"/findCodeOne/{key}"})
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u6bb5\u67e5\u8be2\u6570\u636e")
    public ApiResult<?> findCodeOne(@PathVariable String key) {
        Optional<OrgBdRespVO> vo = this.orgBdService.findCodeOne(key);
        return vo.isPresent() ? ApiResult.ok((Object)vo.get()) : ApiResult.fail((ApiCode)ApiCode.NOT_FOUND);
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody OrgBdQueryParamVO param) {
        PagingVO<OrgBdRespVO> ret = this.orgBdService.search(param);
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createOne(@RequestBody OrgBdSaveVO param) {
        OrgBdDO DO = new OrgBdDO();
        BeanUtils.copyProperties((Object)param, (Object)DO);
        return ApiResult.ok((Object)this.orgBdService.createOne(DO));
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createBatch(@RequestBody List<OrgBdDO> list) {
        List<OrgBdDO> dos = list.stream().map(i -> {
            OrgBdDO DO = new OrgBdDO();
            BeanUtils.copyProperties((Object)i, (Object)DO);
            return DO;
        }).collect(Collectors.toList());
        return ApiResult.ok(this.orgBdService.createBatch(dos));
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    public ApiResult<?> update(@RequestBody OrgBdSaveVO param) {
        OrgBdDO DO = new OrgBdDO();
        BeanUtils.copyProperties((Object)param, (Object)DO);
        this.orgBdService.update(DO);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteOne/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e")
    public ApiResult<?> deleteOne(@PathVariable Long id) {
        this.orgBdService.deleteOne(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<?> deleteBatch(List<Long> ids) {
        this.orgBdService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    public ApiResult<?> updateDeleteFlag(@PathVariable Long id) {
        this.orgBdService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    public OrgBdController(OrgBdService orgBdService) {
        this.orgBdService = orgBdService;
    }
}

