/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.controller;

import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.out.service.OrgEmpService;
import com.elitesland.out.vo.param.OrgEmpQueryParamVO;
import com.elitesland.out.vo.resp.OrgEmpRespVO;
import com.elitesland.pur.dto.OrgEmpVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/org/orgEmp"})
@Api(value="\u5458\u5de5", tags={"\u5458\u5de5"})
public class OrgEmpController {
    private final OrgEmpService orgEmpService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> search(@RequestBody OrgEmpQueryParamVO param) {
        PagingVO<OrgEmpRespVO> ret = this.orgEmpService.search(param);
        return ApiResult.ok(ret);
    }

    @GetMapping(value={"/findAllEmp"})
    @ApiOperation(value="\u5458\u5de5\u4e0b\u62c9")
    public ApiResult<?> findAllEmp() {
        return ApiResult.ok(this.orgEmpService.findAllEmp());
    }

    @PostMapping(value={"/findEmpByCodes"})
    @ApiOperation(value="\u6839\u636e\u5458\u5de5codes\u67e5\u8be2")
    public ApiResult<?> findEmpByCodes(@RequestBody List<String> codes) {
        return ApiResult.ok(this.orgEmpService.findEmpByCodes(codes));
    }

    @GetMapping(value={"/findByUserId/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237Id\u67e5\u8be2\u5458\u5de5\u4fe1\u606f")
    public ApiResult<?> findByUserId(@PathVariable long userId) {
        return ApiResult.ok(this.orgEmpService.findByUserIdData(userId));
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u5efa\u96c7\u5458\u4fe1\u606f")
    public ApiResult<?> create(@RequestBody OrgEmpVO emp) {
        Long id = this.orgEmpService.create(emp);
        return ApiResult.ok((Object)id);
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u96c7\u5458\u4fe1\u606f")
    public ApiResult<?> update(@RequestBody OrgEmpVO emp) {
        this.orgEmpService.update(emp);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636e\u96c7\u5458\u7684\u8bb0\u5f55ID\u5220\u9664\u96c7\u5458\u4fe1\u606f")
    public ApiResult<?> removeById(@PathVariable Long id) {
        this.orgEmpService.removeById(id);
        return ApiResult.ok();
    }

    @PutMapping(value={"/{empid}/bind/{sysusername}"})
    @ApiOperation(value="\u628a\u7cfb\u7edf\u8d26\u53f7\uff0c\u96c7\u5458\u8bb0\u5f55ID\u8fdb\u884c\u76f8\u4e92\u7ed1\u5b9a")
    public ApiResult<?> bindSysUsernameToEmp(@PathVariable Long empid, @PathVariable String sysusername) {
        this.orgEmpService.bindSysUserToEmp(sysusername, empid);
        return ApiResult.ok();
    }

    @PutMapping(value={"/{empid}/unbind"})
    @ApiOperation(value="\u6839\u636e\u96c7\u5458\u8bb0\u5f55ID, \u89e3\u7ed1\u7cfb\u7edf\u8d26\u53f7")
    public ApiResult<?> unbindEmpWithSysUser(@PathVariable Long empid) {
        this.orgEmpService.unbindEmpWithSysUser(empid);
        return ApiResult.ok();
    }

    public OrgEmpController(OrgEmpService orgEmpService) {
        this.orgEmpService = orgEmpService;
    }
}

