/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.out.entity.ComCurrDO;
import com.elitesland.out.entity.QComCurrDO;
import com.elitesland.out.repo.ComCurrRepo;
import com.elitesland.out.repo.ComCurrRepoProc;
import com.elitesland.out.service.ComCurrService;
import com.elitesland.out.vo.param.ComCurrQueryParamVO;
import com.elitesland.out.vo.resp.ComCurrRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComCurrServiceImpl
implements ComCurrService {
    final ComCurrRepoProc comCurrRepoProc;
    final ComCurrRepo comCurrRepo;

    @Override
    public PagingVO<ComCurrRespVO> search(ComCurrQueryParamVO param) {
        JPAQuery comcurrVOJPAQuery = (JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where(param));
        param.fillOrders(comcurrVOJPAQuery, (EntityPathBase)QComCurrDO.comCurrDO);
        param.setPaging(comcurrVOJPAQuery);
        List fetch = comcurrVOJPAQuery.fetch();
        return PagingVO.builder().total(Long.valueOf(comcurrVOJPAQuery.fetchCount())).records(fetch).build();
    }

    @Override
    public Optional<ComCurrRespVO> findCodeOne(String Code) {
        JPAQuery<ComCurrRespVO> comcurrVOJPAQuery = this.comCurrRepoProc.select();
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        comcurrVOJPAQuery.where((Predicate)comCurrDO.currCode.eq((Object)Code));
        ComCurrRespVO comcurrVO = (ComCurrRespVO)comcurrVOJPAQuery.fetchOne();
        return Optional.ofNullable(comcurrVO);
    }

    @Override
    public Optional<ComCurrRespVO> findIdOne(Long Id) {
        JPAQuery<ComCurrRespVO> comcurrVOJPAQuery = this.comCurrRepoProc.select();
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        comcurrVOJPAQuery.where((Predicate)comCurrDO.id.eq((Object)Id));
        ComCurrRespVO comcurrVO = (ComCurrRespVO)comcurrVOJPAQuery.fetchOne();
        return Optional.ofNullable(comcurrVO);
    }

    @Override
    public List<ComCurrRespVO> findIdBatch(List<Long> idList) {
        List<ComCurrRespVO> comCurrVOS = this.comCurrRepo.findAllById(idList).stream().map(comCurrDO -> {
            ComCurrRespVO comcurrVO = new ComCurrRespVO();
            BeanUtils.copyProperties((Object)comCurrDO, (Object)comcurrVO);
            return comcurrVO;
        }).collect(Collectors.toList());
        return comCurrVOS;
    }

    @Override
    @Transactional
    public Long createOne(ComCurrDO objDo) throws BusinessException {
        objDo.setId(null);
        return ((ComCurrDO)this.comCurrRepo.save(objDo)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<ComCurrDO> List2) {
        List2.forEach(i -> i.setId(null));
        return this.comCurrRepo.saveAll(List2).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(ComCurrDO objDo) throws BusinessException {
        if (!this.comCurrRepo.existsById(objDo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.comCurrRepo.save(objDo);
    }

    @Override
    @Transactional
    public void deleteOne(Long id) throws BusinessException {
        if (!this.comCurrRepo.existsById(id)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.comCurrRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.comCurrRepo.deleteById(id));
        ArrayList delList = new ArrayList();
        idList.stream().forEach(i -> delList.add(new ComCurrDO((Long)i){
            final /* synthetic */ Long val$i;
            {
                this.val$i = l;
                this.setId(this.val$i);
            }
        }));
        this.comCurrRepo.deleteInBatch(delList);
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        BooleanExpression predicate = comCurrDO.isNotNull();
        Optional item = this.comCurrRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)comCurrDO.id.eq((Object)id))));
        if (!item.isPresent()) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ComCurrDO comCurrDO1 = (ComCurrDO)item.get();
        comCurrDO1.setDeleteFlag(1);
        this.comCurrRepo.save(comCurrDO1);
    }

    @Override
    public List<ComCurrRespVO> findByCodes(List<String> currList) {
        if (currList == null || currList.size() == 0) {
            return new ArrayList<ComCurrRespVO>();
        }
        return ((JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where(currList))).fetch();
    }

    @Override
    public List<ComCurrRespVO> searchAll() {
        return ((JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where())).fetch();
    }

    public ComCurrServiceImpl(ComCurrRepoProc comCurrRepoProc, ComCurrRepo comCurrRepo) {
        this.comCurrRepoProc = comCurrRepoProc;
        this.comCurrRepo = comCurrRepo;
    }
}

