/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import com.elitesland.core.base.PagingVO;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.out.convert.ComDistrictConvert;
import com.elitesland.out.entity.ComDistrictDO;
import com.elitesland.out.repo.ComDistrictRepo;
import com.elitesland.out.repo.ComDistrictRepoProc;
import com.elitesland.out.service.ComDistrictService;
import com.elitesland.out.vo.param.ComDistrictQueryParamVO;
import com.elitesland.out.vo.resp.ComDistrictRespVO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ComDistrictServiceImpl
implements ComDistrictService {
    private final ComDistrictRepo districtRepo;
    private final ComDistrictRepoProc districtRepoProc;

    @Override
    public PagingVO<ComDistrictRespVO> search(ComDistrictQueryParamVO param) {
        Page ret = this.districtRepo.findAll(this.districtRepoProc.where(param), (Pageable)param.getPageRequest());
        List districts = ret.getContent().stream().map(ComDistrictConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(districts).build();
    }

    @Override
    public List<ComDistrictRespVO> listByPId(Long pId) {
        return this.districtRepo.findAllByParentId(pId).stream().map(ComDistrictConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public List<ComDistrictComboVO> listByPCode(String pCode) {
        String pCodeParam = StringUtils.isBlank((CharSequence)pCode) ? "" : pCode;
        return this.districtRepo.findAllByParentCode(pCodeParam).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    @Override
    public List<ComDistrictComboVO> listByPCode2(String pCode) {
        String pCodeParam = StringUtils.isBlank((CharSequence)pCode) ? "" : pCode;
        return this.districtRepo.findAllByParentCode(pCodeParam).stream().map(ComDistrictConvert.INSTANCE::doToComboVO2).collect(Collectors.toList());
    }

    @Override
    public List<ComDistrictComboVO> listByDistLevelNum(Integer distLevelNum) {
        return this.districtRepo.findAllByDistLevelNum(distLevelNum).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    @Override
    public Optional<ComDistrictRespVO> oneById(Long id) {
        return this.districtRepo.findById(id).map(ComDistrictConvert.INSTANCE::doToVO);
    }

    @Override
    public Long create(ComDistrictDO districtDO) {
        ComDistrictDO newDistrict = (ComDistrictDO)this.districtRepo.save(districtDO);
        return newDistrict.getId();
    }

    @Override
    public void update(ComDistrictDO districtDO) {
        this.districtRepo.findById(districtDO.getId()).ifPresent(d -> {
            districtDO.setCreateUserId(d.getCreateUserId());
            districtDO.setCreateTime(d.getCreateTime());
            this.districtRepo.save(districtDO);
        });
    }

    @Override
    public void removeById(Long id) {
        this.districtRepo.deleteById(id);
    }

    @Override
    public List<ComDistrictComboVO> getByDistCodes(List<String> distCodes) {
        return this.districtRepo.findByDistCode(distCodes).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    @Override
    public List<ComDistrictComboVO> getCityByDistCodes(List<String> distCodes, String distLevelNum) {
        return this.districtRepo.findByDistCode(distCodes, distLevelNum).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    public ComDistrictServiceImpl(ComDistrictRepo districtRepo, ComDistrictRepoProc districtRepoProc) {
        this.districtRepo = districtRepo;
        this.districtRepoProc = districtRepoProc;
    }
}

