/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.out.convert.ComPaymentTermConvert;
import com.elitesland.out.entity.ComPaymentTermDO;
import com.elitesland.out.entity.QComPaymentTermDO;
import com.elitesland.out.repo.ComPaymentTermRepo;
import com.elitesland.out.repo.ComPaymentTermRepoProc;
import com.elitesland.out.service.ComPaymentTermService;
import com.elitesland.out.vo.param.ComPaymentTermQueryParamVO;
import com.elitesland.out.vo.resp.ComPaymentTermRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ComPaymentTermServiceImpl
implements ComPaymentTermService {
    private static final Logger log = LoggerFactory.getLogger(ComPaymentTermServiceImpl.class);
    private final ComPaymentTermRepo comPaymentTermRepo;
    private final ComPaymentTermRepoProc comPaymentTermRepoProc;

    @Override
    public PagingVO<ComPaymentTermRespVO> search(ComPaymentTermQueryParamVO queryParam) {
        JPAQuery comPaymentTermVOJPAQuery = (JPAQuery)this.comPaymentTermRepoProc.select().where(this.comPaymentTermRepoProc.where(queryParam));
        queryParam.fillOrders(comPaymentTermVOJPAQuery, (EntityPathBase)QComPaymentTermDO.comPaymentTermDO);
        queryParam.setPaging(comPaymentTermVOJPAQuery);
        List records = comPaymentTermVOJPAQuery.fetch();
        return PagingVO.builder().total(Long.valueOf(comPaymentTermVOJPAQuery.fetchCount())).records(records).build();
    }

    @Override
    public Optional<ComPaymentTermRespVO> findCodeOne(String paymentTermCode) {
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.ptCode.eq((Object)paymentTermCode));
        return Optional.ofNullable((ComPaymentTermRespVO)jpaQuery.fetchOne());
    }

    @Override
    public List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes) {
        if (paymentTermCodes == null || paymentTermCodes.size() == 0) {
            return new ArrayList<ComPaymentTermRespVO>();
        }
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.ptCode.in(paymentTermCodes));
        return jpaQuery.fetch();
    }

    @Override
    public Optional<ComPaymentTermRespVO> findIdOne(Long paymentTermId) {
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.id.eq((Object)paymentTermId));
        return Optional.ofNullable((ComPaymentTermRespVO)jpaQuery.fetchOne());
    }

    @Override
    public List<ComPaymentTermRespVO> findIdBatch(List<Long> idList) {
        return this.comPaymentTermRepo.findAllById(idList).stream().map(paymentTermDO -> {
            ComPaymentTermRespVO comPaymentTermVO = new ComPaymentTermRespVO();
            BeanUtils.copyProperties((Object)paymentTermDO, (Object)comPaymentTermVO);
            return comPaymentTermVO;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(ComPaymentTermDO paymentTerm) {
        paymentTerm.setId(null);
        List<ComPaymentTermDO> comPaymentTermDOS = this.validDateProcessing(Collections.singletonList(paymentTerm));
        this.comPaymentTermRepo.saveAll(comPaymentTermDOS);
        return 0L;
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<ComPaymentTermDO> paymentTermList) {
        paymentTermList.forEach(i -> i.setId(null));
        List<ComPaymentTermDO> comPaymentTermDOS = this.validDateProcessing(paymentTermList);
        this.comPaymentTermRepo.saveAll(comPaymentTermDOS);
        return Collections.EMPTY_LIST;
    }

    @Override
    @Transactional
    public void update(ComPaymentTermDO paymentTerm) {
        if (!this.comPaymentTermRepo.existsById(paymentTerm.getId())) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List<ComPaymentTermDO> comPaymentTermDOS = this.validDateProcessing(Collections.singletonList(paymentTerm));
        this.comPaymentTermRepo.saveAll(comPaymentTermDOS);
    }

    @Override
    @Transactional
    public void deleteOne(Long paymentTermId) {
        if (!this.comPaymentTermRepo.existsById(paymentTermId)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.comPaymentTermRepo.deleteById(paymentTermId);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> paymentTermIdList) {
        ArrayList delList = new ArrayList();
        paymentTermIdList.forEach(i -> delList.add(new ComPaymentTermDO((Long)i){
            final /* synthetic */ Long val$i;
            {
                this.val$i = l;
                this.setId(this.val$i);
            }
        }));
        this.comPaymentTermRepo.deleteInBatch(delList);
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QComPaymentTermDO paymentTermDO = QComPaymentTermDO.comPaymentTermDO;
        BooleanExpression predicate = paymentTermDO.deleteFlag.isNull().or((Predicate)paymentTermDO.deleteFlag.eq((Object)0));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)paymentTermDO.id.eq((Object)id));
        Optional comPaymentTermDO = this.comPaymentTermRepo.findOne((Predicate)predicate);
        comPaymentTermDO.ifPresent(c -> {
            c.setDeleteFlag(1);
            this.comPaymentTermRepo.save(c);
        });
    }

    private List<ComPaymentTermDO> validDateProcessing(List<ComPaymentTermDO> paymentTermList) {
        List<ComPaymentTermDO> result = Collections.synchronizedList(new ArrayList());
        paymentTermList.parallelStream().forEach(i -> {
            i.setValidFrom(LocalDateTime.of(i.getValidFrom().toLocalDate(), LocalTime.of(0, 0, 0)));
            i.setValidTo(LocalDateTime.of(i.getValidTo().toLocalDate(), LocalTime.of(23, 59, 59)));
        });
        paymentTermList.forEach(i -> {
            if (StringUtils.isEmpty((Object)i.getPtCode())) {
                throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u652f\u4ed8\u6761\u6b3e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!i.getValidFrom().isBefore(i.getValidTo())) {
                throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5728\u751f\u6548\u65e5\u671f\u4e4b\u524d");
            }
        });
        List ptCodes = paymentTermList.stream().map(ComPaymentTermDO::getPtCode).distinct().collect(Collectors.toList());
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        List paymentTermVOList = ((JPAQuery)this.comPaymentTermRepoProc.select().where((Predicate)paymentTerm.ptCode.in(ptCodes))).fetch();
        if (CollectionUtils.isEmpty((Collection)paymentTermVOList)) {
            return paymentTermList;
        }
        for (ComPaymentTermDO paymentTermDO : paymentTermList) {
            List<ComPaymentTermRespVO> paymentTermVOS = paymentTermVOList.stream().filter(i -> paymentTermDO.getPtCode().equals(i.getPtCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(paymentTermVOS)) {
                result.add(paymentTermDO);
                continue;
            }
            List<ComPaymentTermDO> validProcessList = this.getValidProcessList(paymentTermDO, paymentTermVOS);
            result.addAll(validProcessList);
        }
        return result;
    }

    private List<ComPaymentTermDO> getValidProcessList(ComPaymentTermDO newDO, List<ComPaymentTermRespVO> paymentTermVOS) {
        ArrayList<ComPaymentTermDO> result = new ArrayList<ComPaymentTermDO>();
        for (ComPaymentTermRespVO oldVO : paymentTermVOS) {
            ComPaymentTermDO oldPaymentTerm;
            if (oldVO.getValidTo().isBefore(newDO.getValidFrom()) || oldVO.getValidFrom().isAfter(newDO.getValidTo())) continue;
            if (oldVO.getValidFrom().isBefore(newDO.getValidFrom())) {
                if (oldVO.getValidTo().isBefore(newDO.getValidTo()) || oldVO.getValidTo().isEqual(newDO.getValidTo())) {
                    ComPaymentTermDO oldPaymentTermDO = new ComPaymentTermDO();
                    BeanUtils.copyProperties((Object)oldVO, (Object)oldPaymentTermDO);
                    oldPaymentTermDO.setValidTo(LocalDateTime.of(LocalDate.from(newDO.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                    result.add(oldPaymentTermDO);
                    continue;
                }
                if (oldVO.getValidTo().isAfter(newDO.getValidTo())) {
                    ComPaymentTermDO beforeOldPaymentTerm = new ComPaymentTermDO();
                    ComPaymentTermDO afterOldPaymentTerm = new ComPaymentTermDO();
                    ComPaymentTermDO oldPaymentTerm2 = new ComPaymentTermDO();
                    BeanUtils.copyProperties((Object)oldVO, (Object)oldPaymentTerm2);
                    BeanUtils.copyProperties((Object)oldVO, (Object)beforeOldPaymentTerm);
                    BeanUtils.copyProperties((Object)oldVO, (Object)afterOldPaymentTerm);
                    beforeOldPaymentTerm.setValidTo(LocalDateTime.of(LocalDate.from(newDO.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                    afterOldPaymentTerm.setValidFrom(LocalDateTime.of(LocalDate.from(newDO.getValidTo().plusDays(1L)), LocalTime.MIN));
                    oldVO.setDeleteFlag(Integer.valueOf(1));
                    beforeOldPaymentTerm.setId(null);
                    afterOldPaymentTerm.setId(null);
                    oldPaymentTerm2.setDeleteFlag(1);
                    result.add(oldPaymentTerm2);
                    result.add(beforeOldPaymentTerm);
                    result.add(afterOldPaymentTerm);
                    continue;
                }
            }
            if (!oldVO.getValidFrom().isAfter(newDO.getValidFrom()) && !oldVO.getValidFrom().isEqual(newDO.getValidFrom())) continue;
            if (oldVO.getValidTo().isBefore(newDO.getValidTo()) || oldVO.getValidTo().isEqual(newDO.getValidTo())) {
                oldPaymentTerm = new ComPaymentTermDO();
                BeanUtils.copyProperties((Object)oldVO, (Object)oldPaymentTerm);
                oldPaymentTerm.setDeleteFlag(1);
                result.add(oldPaymentTerm);
            }
            if (!oldVO.getValidTo().isAfter(newDO.getValidTo())) continue;
            oldPaymentTerm = new ComPaymentTermDO();
            BeanUtils.copyProperties((Object)oldVO, (Object)oldPaymentTerm);
            oldPaymentTerm.setValidFrom(LocalDateTime.of(LocalDate.from(newDO.getValidTo().plusDays(1L)), LocalTime.MIN));
            result.add(oldPaymentTerm);
        }
        result.add(newDO);
        return result;
    }

    @Override
    public List<ComPaymentTermRespVO> list() {
        return this.comPaymentTermRepo.findAll().stream().map(ComPaymentTermConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public ComPaymentTermServiceImpl(ComPaymentTermRepo comPaymentTermRepo, ComPaymentTermRepoProc comPaymentTermRepoProc) {
        this.comPaymentTermRepo = comPaymentTermRepo;
        this.comPaymentTermRepoProc = comPaymentTermRepoProc;
    }
}

