/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.item.vo.ComTaxRateVO;
import com.elitesland.out.entity.ComTaxRateDO;
import com.elitesland.out.entity.QComTaxRateDO;
import com.elitesland.out.repo.ComTaxRateRepo;
import com.elitesland.out.repo.ComTaxRateRepoProc;
import com.elitesland.out.service.ComTaxRateService;
import com.elitesland.out.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitesland.out.vo.param.ComTaxRateQueryParamVO;
import com.elitesland.out.vo.resp.ComCommonTaxRateRespVO;
import com.elitesland.out.vo.resp.ComTaxRateRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ComTaxRateServiceImpl
implements ComTaxRateService {
    private final ComTaxRateRepo comTaxRateRepo;
    private final ComTaxRateRepoProc comTaxRateRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ComTaxRateRespVO> search(ComTaxRateQueryParamVO comTaxRateQueryParam) {
        JPAQuery records = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(comTaxRateQueryParam));
        this.comTaxRateRepoProc.openOrderAndLimit(records, (AbstractOrderQueryParam)comTaxRateQueryParam, QComTaxRateDO.comTaxRateDO);
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(records.fetch()).build();
    }

    @Override
    @SysCodeProc
    public Optional<ComTaxRateRespVO> findCodeOne(String Code) {
        return Optional.empty();
    }

    @Override
    @SysCodeProc
    public Optional<ComTaxRateRespVO> findIdOne(Long Id) {
        JPAQuery comTaxRateVOJPAQuery = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(Id));
        return Optional.ofNullable((ComTaxRateRespVO)comTaxRateVOJPAQuery.fetchOne());
    }

    @Override
    @SysCodeProc
    public List<ComTaxRateRespVO> findIdBatch(List<Long> idList) {
        QComTaxRateDO jpaQDo = QComTaxRateDO.comTaxRateDO;
        JPAQuery where = (JPAQuery)this.comTaxRateRepoProc.select().where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    @Override
    @Transactional
    public Long createOne(ComTaxRateDO objDo) {
        if (objDo.getDeleteFlag() == null) {
            objDo.setDeleteFlag(0);
        }
        if (objDo.getValidTo().isBefore(objDo.getValidFrom())) {
            throw new BusinessException("\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5728\u751f\u6548\u65e5\u671f\u4e4b\u524d");
        }
        ComTaxRateQueryParamVO comTaxRateQueryParam = new ComTaxRateQueryParamVO();
        comTaxRateQueryParam.setTaxRateIndex(objDo.getTaxRateIndex());
        comTaxRateQueryParam.setTaxRateNo(objDo.getTaxRateNo());
        List taxRateVoList = ((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.checkWhere(comTaxRateQueryParam))).fetch();
        ArrayList<ComTaxRateDO> action = new ArrayList<ComTaxRateDO>();
        if (taxRateVoList.size() > 0) {
            for (ComTaxRateRespVO oldTaxRate : taxRateVoList) {
                ComTaxRateDO comTaxRateDO;
                if (oldTaxRate.getValidTo().isBefore(objDo.getValidFrom()) || oldTaxRate.getValidFrom().isAfter(objDo.getValidTo())) continue;
                if (oldTaxRate.getValidFrom().isBefore(objDo.getValidFrom())) {
                    if (oldTaxRate.getValidTo().isBefore(objDo.getValidTo()) || oldTaxRate.getValidTo().isEqual(objDo.getValidTo())) {
                        comTaxRateDO = new ComTaxRateDO();
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO);
                        comTaxRateDO.setValidTo(LocalDateTime.of(LocalDate.from(oldTaxRate.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                        action.add(comTaxRateDO);
                        continue;
                    }
                    if (oldTaxRate.getValidTo().isAfter(objDo.getValidTo())) {
                        ComTaxRateDO beforeOldSal = new ComTaxRateDO();
                        ComTaxRateDO afterOldSal = new ComTaxRateDO();
                        ComTaxRateDO comTaxRateDO2 = new ComTaxRateDO();
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO2);
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)beforeOldSal);
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)afterOldSal);
                        beforeOldSal.setValidTo(LocalDateTime.of(LocalDate.from(objDo.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                        afterOldSal.setValidFrom(LocalDateTime.of(LocalDate.from(objDo.getValidTo().plusDays(1L)), LocalTime.MIN));
                        oldTaxRate.setDeleteFlag(Integer.valueOf(1));
                        beforeOldSal.setId(null);
                        afterOldSal.setId(null);
                        comTaxRateDO2.setDeleteFlag(1);
                        action.add(comTaxRateDO2);
                        action.add(beforeOldSal);
                        action.add(afterOldSal);
                        continue;
                    }
                }
                if (!oldTaxRate.getValidFrom().isAfter(objDo.getValidFrom()) && !oldTaxRate.getValidFrom().isEqual(objDo.getValidFrom())) continue;
                if (oldTaxRate.getValidTo().isBefore(objDo.getValidTo()) || oldTaxRate.getValidTo().isEqual(objDo.getValidTo())) {
                    comTaxRateDO = new ComTaxRateDO();
                    BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO);
                    comTaxRateDO.setDeleteFlag(1);
                    action.add(comTaxRateDO);
                }
                if (!oldTaxRate.getValidTo().isAfter(objDo.getValidTo())) continue;
                comTaxRateDO = new ComTaxRateDO();
                BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO);
                comTaxRateDO.setValidFrom(LocalDateTime.of(LocalDate.from(objDo.getValidTo().plusDays(1L)), LocalTime.MIN));
                action.add(comTaxRateDO);
            }
        }
        if (action.size() > 0) {
            this.comTaxRateRepo.saveAll(action);
        }
        return ((ComTaxRateDO)this.comTaxRateRepo.save(objDo)).getId();
    }

    @Override
    public List<Long> createBatch(List<ComTaxRateDO> List2) {
        return null;
    }

    @Override
    @Transactional
    public void update(ComTaxRateDO objDo) {
        Optional optional = this.comTaxRateRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (ComTaxRateDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.comTaxRateRepo.save((ComTaxRateDO)optional.get());
    }

    @Override
    @Transactional
    public void deleteOne(Long Id) {
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(arg_0 -> ((ComTaxRateRepo)this.comTaxRateRepo).deleteById(arg_0));
    }

    @Override
    public void updateDeleteFlag(Long id) {
    }

    @Override
    public List<ComTaxRateVO> findBytaxRateNoList(List<String> strings) {
        List<ComTaxRateDO> comTaxRateDOS = this.comTaxRateRepo.findByTaxRateNoIn(strings);
        return comTaxRateDOS.stream().map(comTaxRateDO -> {
            ComTaxRateVO comTaxRateVO = new ComTaxRateVO();
            BeanUtil.copyProperties((Object)comTaxRateDO, (Object)comTaxRateVO);
            return comTaxRateVO;
        }).collect(Collectors.toList());
    }

    @Override
    public Optional<ComCommonTaxRateRespVO> getRatio(ComCommonTaxRateQueryParamVO param) {
        List VOS;
        ComCommonTaxRateRespVO res = new ComCommonTaxRateRespVO();
        if (param == null || StringUtils.isEmpty((Object)param.getVTxa1())) {
            res.setACn(Integer.valueOf(0));
            res.setAItm(null);
            res.setTRate(Double.valueOf(0.0));
            return Optional.of(res);
        }
        if (!"V".equals(param.getVExr1()) || "N".equals(param.getVItm())) {
            res.setACn(Integer.valueOf(0));
            res.setAItm(null);
            res.setTRate(Double.valueOf(0.0));
            return Optional.of(res);
        }
        if ("Y".equals(param.getVItm())) {
            param.setAItm("Y");
        } else {
            if (StringUtils.isEmpty((Object)param.getVItm())) {
                res.setACn(Integer.valueOf(0));
                res.setAItm(null);
                res.setTRate(Double.valueOf(0.0));
                return Optional.of(res);
            }
            param.setAItm(param.getVItm());
        }
        if (param.getVDj() == null) {
            param.setVDj(LocalDateTime.now());
        }
        if ((VOS = ((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param))).fetch()).size() > 0) {
            if (VOS.size() == 1) {
                res.setACn(Integer.valueOf(1));
                res.setAItm(param.getAItm());
                res.setTRate(((ComTaxRateRespVO)VOS.get(0)).getTaxRateValue());
            } else {
                param.setAItm("Y");
                ComTaxRateRespVO VO = (ComTaxRateRespVO)((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param))).fetchOne();
                if (VO != null) {
                    res.setACn(Integer.valueOf(VOS.size()));
                    res.setAItm(param.getAItm());
                    res.setTRate(VO.getTaxRateValue());
                } else {
                    res.setACn(Integer.valueOf(VOS.size()));
                    res.setAItm(param.getAItm());
                    res.setTRate(Double.valueOf(0.0));
                }
            }
        } else {
            res.setACn(Integer.valueOf(0));
            res.setAItm(param.getAItm());
            res.setTRate(Double.valueOf(0.0));
        }
        return Optional.of(res);
    }

    @Override
    public Optional<ComTaxRateVO> findBytaxRateNoAndIndex(String taxRateNo, String taxRateIndex) {
        ComTaxRateDO byTaxRateNoAndTaxRateIndex = this.comTaxRateRepo.findByTaxRateNoAndTaxRateIndex(taxRateNo, taxRateIndex);
        return byTaxRateNoAndTaxRateIndex == null ? Optional.empty() : Optional.of((ComTaxRateVO)BeanUtil.copyProperties((Object)byTaxRateNoAndTaxRateIndex, ComTaxRateVO.class));
    }

    @Override
    public List<ComTaxRateRespVO> findBytaxRateNoInAndIndexIn(Set<String> taxRateNo, Set<String> taxRateIndex) {
        return this.comTaxRateRepo.findByTaxRateNoInAndTaxRateIndexIn(taxRateNo, taxRateIndex).stream().map(comTaxRateDO -> {
            ComTaxRateRespVO comTaxRateVO = new ComTaxRateRespVO();
            BeanUtil.copyProperties((Object)comTaxRateDO, (Object)comTaxRateVO);
            return comTaxRateVO;
        }).collect(Collectors.toList());
    }

    @Override
    public PagingVO<ComTaxRateRespVO> searchAll(ComTaxRateQueryParamVO param) {
        JPAQuery records = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param));
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(records.fetch()).build();
    }

    public ComTaxRateServiceImpl(ComTaxRateRepo comTaxRateRepo, ComTaxRateRepoProc comTaxRateRepoProc) {
        this.comTaxRateRepo = comTaxRateRepo;
        this.comTaxRateRepoProc = comTaxRateRepoProc;
    }
}

