/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.out.entity.OrgAddrAddressDO;
import com.elitesland.out.entity.QOrgAddrAddressDO;
import com.elitesland.out.repo.OrgAddrAddressRepo;
import com.elitesland.out.repo.OrgAddrAddressRepoProc;
import com.elitesland.out.service.ComDistrictService;
import com.elitesland.out.service.OrgAddrAddressService;
import com.elitesland.out.vo.param.OrgAddrAddressQueryParamVO;
import com.elitesland.out.vo.resp.OrgAddrAddressRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class OrgAddrAddressServiceImpl
implements OrgAddrAddressService {
    private final OrgAddrAddressRepo orgAddrAddressRepo;
    private final OrgAddrAddressRepoProc orgAddrAddressRepoProc;
    private final ComDistrictService comDistrictService;

    @Override
    @SysCodeProc
    public PagingVO<OrgAddrAddressRespVO> search(OrgAddrAddressQueryParamVO orgAddrAddressQueryParam) {
        return null;
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrAddressRespVO> findCodeOne(String Code) {
        return Optional.empty();
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrAddressRespVO> findIdOne(Long Id) {
        JPAQuery jpaQuery = (JPAQuery)this.orgAddrAddressRepoProc.select().where((Predicate)QOrgAddrAddressDO.orgAddrAddressDO.id.eq((Object)Id));
        return Optional.ofNullable((OrgAddrAddressRespVO)jpaQuery.fetchOne());
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findIdBatch(List<Long> idList) {
        List orgAddrAddressDOS = this.orgAddrAddressRepo.findAllById(idList);
        return orgAddrAddressDOS.stream().map(DO -> (OrgAddrAddressRespVO)BeanUtil.copyProperties((Object)DO, OrgAddrAddressRespVO.class)).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(OrgAddrAddressDO objDo) {
        return ((OrgAddrAddressDO)this.orgAddrAddressRepo.save(objDo)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<OrgAddrAddressDO> List2) {
        return this.orgAddrAddressRepo.saveAll(List2).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(OrgAddrAddressDO objDo) {
        Optional<OrgAddrAddressDO> optional = this.orgAddrAddressRepo.findByAddrNo(objDo.getAddrNo());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.orgAddrAddressRepo.save(optional.get());
    }

    @Override
    @Transactional
    public void deleteOne(Long Id) {
        this.orgAddrAddressRepo.deleteById(Id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(arg_0 -> ((OrgAddrAddressRepo)this.orgAddrAddressRepo).deleteById(arg_0));
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findByAddrNo(Integer addrNo) {
        OrgAddrAddressQueryParamVO param = new OrgAddrAddressQueryParamVO();
        param.setAddrNo(addrNo);
        List fetch = ((JPAQuery)this.orgAddrAddressRepoProc.select().where(this.orgAddrAddressRepoProc.where(param))).fetch();
        this.translate(fetch);
        return fetch;
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findByAddrNos(List<Integer> addrNo) {
        QOrgAddrAddressDO orgAddrAddressDO = QOrgAddrAddressDO.orgAddrAddressDO;
        List fetch = ((JPAQuery)this.orgAddrAddressRepoProc.select().where((Predicate)orgAddrAddressDO.addrNo.in(addrNo))).fetch();
        this.translate(fetch);
        return fetch;
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findByAddrNoscity(List<Integer> addrNo) {
        QOrgAddrAddressDO orgAddrAddressDO = QOrgAddrAddressDO.orgAddrAddressDO;
        List fetch = ((JPAQuery)this.orgAddrAddressRepoProc.selectcity().where((Predicate)orgAddrAddressDO.addrNo.in(addrNo).and((Predicate)orgAddrAddressDO.addressType.eq((Object)"DEFAULT")))).fetch();
        this.translate(fetch);
        return fetch;
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findByaddrNoLikeAndIn(String keyWord, List<Integer> addrNos, Long ouId) {
        List orgAddrAddressVOS = ((JPAQuery)this.orgAddrAddressRepoProc.select().where(this.orgAddrAddressRepoProc.likeWhere(keyWord, addrNos, ouId))).fetch();
        this.translate(orgAddrAddressVOS);
        return orgAddrAddressVOS;
    }

    @Override
    public List<OrgAddrAddressRespVO> findByAddrNoAndAddressType(Integer addrNo) {
        List orgAddrAddressVOS = ((JPAQuery)this.orgAddrAddressRepoProc.select().where(this.orgAddrAddressRepoProc.findByAddrNoAndAddressType(addrNo))).fetch();
        this.translate(orgAddrAddressVOS);
        return orgAddrAddressVOS;
    }

    @Override
    @Transactional
    public void deleteByAddrNo(Integer addrNo) {
        this.orgAddrAddressRepo.deleteByAddrNo(addrNo);
    }

    private void translate(List<OrgAddrAddressRespVO> lists) {
        List<String> countries = lists.stream().map(OrgAddrAddressRespVO::getCountry).distinct().collect(Collectors.toList());
        List provinces = lists.stream().map(OrgAddrAddressRespVO::getProvince).distinct().collect(Collectors.toList());
        List cities = lists.stream().map(OrgAddrAddressRespVO::getCity).distinct().collect(Collectors.toList());
        List county = lists.stream().map(OrgAddrAddressRespVO::getCounty).distinct().collect(Collectors.toList());
        countries.addAll(provinces);
        countries.addAll(cities);
        countries.addAll(county);
        List<ComDistrictComboVO> comDistrictComboVOS = this.comDistrictService.getByDistCodes(countries);
        lists.forEach(VO -> {
            Optional<ComDistrictComboVO> comboVOOptional4;
            Optional<ComDistrictComboVO> comboVOOptional3;
            Optional<ComDistrictComboVO> comboVOOptional2;
            Optional<ComDistrictComboVO> comboVOOptional1 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCountry())).findFirst();
            if (comboVOOptional1.isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional1.get();
                VO.setCountryName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional2 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getProvince())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional2.get();
                VO.setProvinceName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional3 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCity())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional3.get();
                VO.setCityName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional4 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCounty())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional4.get();
                VO.setCountyName(comDistrictComboVO.getName());
            }
        });
    }

    public OrgAddrAddressServiceImpl(OrgAddrAddressRepo orgAddrAddressRepo, OrgAddrAddressRepoProc orgAddrAddressRepoProc, ComDistrictService comDistrictService) {
        this.orgAddrAddressRepo = orgAddrAddressRepo;
        this.orgAddrAddressRepoProc = orgAddrAddressRepoProc;
        this.comDistrictService = comDistrictService;
    }
}

