/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.out.entity.OrgAddrQualifyDO;
import com.elitesland.out.entity.QOrgAddrQualifyDO;
import com.elitesland.out.repo.OrgAddrQualifyRepo;
import com.elitesland.out.repo.OrgAddrQualifyRepoProc;
import com.elitesland.out.service.OrgAddrQualifyService;
import com.elitesland.out.vo.param.OrgAddrQualifyQueryParamVO;
import com.elitesland.out.vo.param.OrgAddrapplyQualifyQueryParamVO;
import com.elitesland.out.vo.resp.OrgAddrQualifyRespVO;
import com.elitesland.out.vo.resp.OrgOuRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class OrgAddrQualifyServiceImpl
implements OrgAddrQualifyService {
    private final OrgAddrQualifyRepo orgAddrQualifyRepo;
    private final OrgAddrQualifyRepoProc orgAddrQualifyRepoProc;
    private final OrgOuService orgOuService;

    @Override
    @SysCodeProc
    public PagingVO<OrgAddrQualifyRespVO> search(OrgAddrapplyQualifyQueryParamVO orgAddrapplyQualifyQueryParam) {
        return null;
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrQualifyRespVO> findCodeOne(String Code) {
        return Optional.empty();
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrQualifyRespVO> findIdOne(Long Id) {
        JPAQuery jpaQuery = (JPAQuery)this.orgAddrQualifyRepoProc.select().where((Predicate)QOrgAddrQualifyDO.orgAddrQualifyDO.id.eq((Object)Id));
        return Optional.ofNullable((OrgAddrQualifyRespVO)jpaQuery.fetchOne());
    }

    @Override
    @SysCodeProc
    public List<OrgAddrQualifyRespVO> findIdBatch(List<Long> idList) {
        List orgAddrQualifyDOS = this.orgAddrQualifyRepo.findAllById(idList);
        return orgAddrQualifyDOS.stream().map(DO -> (OrgAddrQualifyRespVO)BeanUtil.copyProperties((Object)DO, OrgAddrQualifyRespVO.class)).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(OrgAddrQualifyDO objDo) {
        return ((OrgAddrQualifyDO)this.orgAddrQualifyRepo.save(objDo)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<OrgAddrQualifyDO> List2) {
        return this.orgAddrQualifyRepo.saveAll(List2).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(OrgAddrQualifyDO objDo) {
        Optional optional = this.orgAddrQualifyRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (OrgAddrQualifyDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.orgAddrQualifyRepo.save((OrgAddrQualifyDO)optional.get());
    }

    @Override
    @Transactional
    public void deleteOne(Long Id) {
        this.orgAddrQualifyRepo.deleteById(Id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(arg_0 -> ((OrgAddrQualifyRepo)this.orgAddrQualifyRepo).deleteById(arg_0));
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
    }

    @Override
    @SysCodeProc
    public List<OrgAddrQualifyRespVO> findByAddrNo(Integer addrNo) {
        OrgAddrQualifyQueryParamVO param = new OrgAddrQualifyQueryParamVO();
        param.setAddrNo(addrNo);
        List fetch = ((JPAQuery)this.orgAddrQualifyRepoProc.select().where(this.orgAddrQualifyRepoProc.where(param))).fetch();
        this.translate(fetch);
        return fetch;
    }

    private void translate(List<OrgAddrQualifyRespVO> lists) {
        List ouIds = lists.stream().map(OrgAddrQualifyRespVO::getOuId).distinct().collect(Collectors.toList());
        ArrayList orgOuList = new ArrayList();
        lists.forEach(VO -> {
            Optional<OrgOuRespVO> ouVOOptional = orgOuList.stream().filter(v -> v.getKey().equals(VO.getOuId())).findFirst();
            if (ouVOOptional.isPresent()) {
                OrgOuRespVO orgOuVO = ouVOOptional.get();
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuName(orgOuVO.getTitle());
            }
        });
    }

    @Override
    @Transactional
    public void deleteByAddrNo(Integer addrNo) {
        this.orgAddrQualifyRepo.deleteByAddrNo(addrNo);
    }

    public OrgAddrQualifyServiceImpl(OrgAddrQualifyRepo orgAddrQualifyRepo, OrgAddrQualifyRepoProc orgAddrQualifyRepoProc, OrgOuService orgOuService) {
        this.orgAddrQualifyRepo = orgAddrQualifyRepo;
        this.orgAddrQualifyRepoProc = orgAddrQualifyRepoProc;
        this.orgOuService = orgOuService;
    }
}

