/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.out.entity.OrgAddrDO;
import com.elitesland.out.entity.QOrgAddrDO;
import com.elitesland.out.repo.OrgAddrRepo;
import com.elitesland.out.repo.OrgAddrRepoProc;
import com.elitesland.out.service.OrgAddrService;
import com.elitesland.out.vo.param.OrgAddrQueryParamVO;
import com.elitesland.out.vo.resp.OrgAddrRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orgAddrService")
public class OrgAddrServiceImpl
implements OrgAddrService {
    private final OrgAddrRepo orgAddrRepo;
    private final OrgAddrRepoProc orgAddrRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<OrgAddrRespVO> search(OrgAddrQueryParamVO param) {
        JPAQuery<OrgAddrRespVO> jpaQuery = this.orgAddrRepoProc.select(param);
        long dataCount = jpaQuery.fetchCount();
        List lists = jpaQuery.fetch();
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrRespVO> findCodeOne(String itemCode) {
        JPAQuery<OrgAddrRespVO> jpaQuery = this.orgAddrRepoProc.select(null);
        QOrgAddrDO jpaQDo = QOrgAddrDO.orgAddrDO;
        jpaQuery.where((Predicate)jpaQDo.addrCode.eq((Object)itemCode));
        OrgAddrRespVO vo = (OrgAddrRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrRespVO> findIdOne(Long id) {
        JPAQuery<OrgAddrRespVO> jpaQuery = this.orgAddrRepoProc.select(null);
        QOrgAddrDO jpaQDo = QOrgAddrDO.orgAddrDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        OrgAddrRespVO vo = (OrgAddrRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public List<OrgAddrRespVO> findIdBatch(List<Long> idList) {
        QOrgAddrDO jpaQDo = QOrgAddrDO.orgAddrDO;
        JPAQuery where = (JPAQuery)this.orgAddrRepoProc.select(null).where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    @Override
    @Transactional
    public Long createOne(OrgAddrDO orgAddrDO) {
        return ((OrgAddrDO)this.orgAddrRepo.save(orgAddrDO)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<OrgAddrDO> list) {
        return this.orgAddrRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(OrgAddrDO item) {
        Optional optional = this.orgAddrRepo.findById(item.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + item.getId());
        }
        this.orgAddrRepo.save(item);
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QOrgAddrDO jpaQDo = QOrgAddrDO.orgAddrDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.orgAddrRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        OrgAddrDO do1 = (OrgAddrDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.orgAddrRepo.save(do1);
    }

    @Override
    @Transactional
    public void deleteOne(Long id) {
        this.orgAddrRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.orgAddrRepo.deleteById(id));
    }

    @Override
    public OrgAddrRespVO findByAddrNo(Integer addrNo) {
        JPAQuery<OrgAddrRespVO> jpaQuery = this.orgAddrRepoProc.select(null);
        QOrgAddrDO jpaQDo = QOrgAddrDO.orgAddrDO;
        jpaQuery.where((Predicate)jpaQDo.addrNo.eq((Object)addrNo));
        return (OrgAddrRespVO)jpaQuery.fetchFirst();
    }

    @Override
    public List<OrgAddrRespVO> findByAddrNos(List<Integer> addrNos) {
        JPAQuery<OrgAddrRespVO> jpaQuery = this.orgAddrRepoProc.select(null);
        QOrgAddrDO jpaQDo = QOrgAddrDO.orgAddrDO;
        jpaQuery.where((Predicate)jpaQDo.addrNo.in(addrNos));
        return jpaQuery.fetch();
    }

    @Override
    public void deleteByAddrNo(Integer addrNo) {
        this.orgAddrRepo.deleteByAddrNo(addrNo);
    }

    public OrgAddrServiceImpl(OrgAddrRepo orgAddrRepo, OrgAddrRepoProc orgAddrRepoProc) {
        this.orgAddrRepo = orgAddrRepo;
        this.orgAddrRepoProc = orgAddrRepoProc;
    }
}

