/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.out.entity.OrgAddrapplyAddressDO;
import com.elitesland.out.entity.QOrgAddrapplyAddressDO;
import com.elitesland.out.repo.OrgAddrapplyAddressRepo;
import com.elitesland.out.repo.OrgAddrapplyAddressRepoProc;
import com.elitesland.out.service.ComDistrictService;
import com.elitesland.out.service.OrgAddrapplyAddressService;
import com.elitesland.out.vo.param.OrgAddrapplyAddressQueryParamVO;
import com.elitesland.out.vo.resp.OrgAddrapplyAddressRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgAddrapplyAddressServiceImpl
implements OrgAddrapplyAddressService {
    private final OrgAddrapplyAddressRepo orgAddrapplyAddressRepo;
    private final OrgAddrapplyAddressRepoProc orgAddrapplyAddressRepoProc;
    private final ComDistrictService comDistrictService;

    @Override
    @SysCodeProc
    public PagingVO<OrgAddrapplyAddressRespVO> search(OrgAddrapplyAddressQueryParamVO orgAddrapplyAddressParam) {
        return null;
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrapplyAddressRespVO> findCodeOne(String Code) {
        return Optional.empty();
    }

    @Override
    @SysCodeProc
    public Optional<OrgAddrapplyAddressRespVO> findIdOne(Long Id) {
        JPAQuery jpaQuery = (JPAQuery)this.orgAddrapplyAddressRepoProc.select().where((Predicate)QOrgAddrapplyAddressDO.orgAddrapplyAddressDO.id.eq((Object)Id));
        return Optional.ofNullable((OrgAddrapplyAddressRespVO)jpaQuery.fetchOne());
    }

    @Override
    @SysCodeProc
    public List<OrgAddrapplyAddressRespVO> findIdBatch(List<Long> idList) {
        return this.orgAddrapplyAddressRepo.findAllById(idList).stream().map(DO -> (OrgAddrapplyAddressRespVO)BeanUtil.copyProperties((Object)DO, OrgAddrapplyAddressRespVO.class)).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(OrgAddrapplyAddressDO objDo) {
        return ((OrgAddrapplyAddressDO)this.orgAddrapplyAddressRepo.save(objDo)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<OrgAddrapplyAddressDO> list) {
        return this.orgAddrapplyAddressRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(OrgAddrapplyAddressDO objDo) {
        Optional optional = this.orgAddrapplyAddressRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (OrgAddrapplyAddressDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.orgAddrapplyAddressRepo.save((OrgAddrapplyAddressDO)optional.get());
    }

    @Override
    @Transactional
    public void deleteOne(Long Id) {
        this.orgAddrapplyAddressRepo.deleteById(Id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(arg_0 -> ((OrgAddrapplyAddressRepo)this.orgAddrapplyAddressRepo).deleteById(arg_0));
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
    }

    @Override
    @SysCodeProc
    public List<OrgAddrapplyAddressRespVO> findByMasIdDocCls(Long masId, String masDocCls) {
        return ((JPAQuery)this.orgAddrapplyAddressRepoProc.select().where(this.orgAddrapplyAddressRepoProc.whereByMasidAndMasDocCls(masId, masDocCls))).fetch();
    }

    @Override
    @Transactional
    public void deleteByMasIdDocCls(Long masId, String masDocCls) {
        this.orgAddrapplyAddressRepo.deleteByMasIdAndMasDocCls(masId, masDocCls);
    }

    @Override
    @SysCodeProc
    public List<OrgAddrapplyAddressRespVO> findByMasIdAndMasDidAndMasDocCls(Long masId, Long masDid, String masDocCls) {
        List<OrgAddrapplyAddressRespVO> collect = this.orgAddrapplyAddressRepo.findByMasIdAndMasDidAndMasDocCls(masId, masDid, masDocCls).stream().map(DO -> (OrgAddrapplyAddressRespVO)BeanUtil.copyProperties((Object)DO, OrgAddrapplyAddressRespVO.class)).collect(Collectors.toList());
        this.translate(collect);
        return collect;
    }

    @Override
    @SysCodeProc
    public List<OrgAddrapplyAddressRespVO> findByMasDidAndMasDocCls(Long masDid, String masDocCls) {
        List<OrgAddrapplyAddressRespVO> collect = this.orgAddrapplyAddressRepo.findByMasDidAndMasDocCls(masDid, masDocCls).stream().map(DO -> (OrgAddrapplyAddressRespVO)BeanUtil.copyProperties((Object)DO, OrgAddrapplyAddressRespVO.class)).collect(Collectors.toList());
        this.translate(collect);
        return collect;
    }

    @Override
    @SysCodeProc
    public List<OrgAddrapplyAddressRespVO> findByMasDidAndMasDocClses(Long masDid, List<String> masDocClses) {
        OrgAddrapplyAddressQueryParamVO queryParam = new OrgAddrapplyAddressQueryParamVO();
        queryParam.setMasDid(masDid);
        queryParam.setMasDocClses(masDocClses);
        List<OrgAddrapplyAddressRespVO> collect = ((JPAQuery)this.orgAddrapplyAddressRepoProc.select().where(this.orgAddrapplyAddressRepoProc.where(queryParam))).fetch().stream().map(DO -> (OrgAddrapplyAddressRespVO)BeanUtil.copyProperties((Object)DO, OrgAddrapplyAddressRespVO.class)).collect(Collectors.toList());
        this.translate(collect);
        return collect;
    }

    private void translate(List<OrgAddrapplyAddressRespVO> lists) {
        List<String> countries = lists.stream().map(OrgAddrapplyAddressRespVO::getCountry).distinct().collect(Collectors.toList());
        List provinces = lists.stream().map(OrgAddrapplyAddressRespVO::getProvince).distinct().collect(Collectors.toList());
        List cities = lists.stream().map(OrgAddrapplyAddressRespVO::getCity).distinct().collect(Collectors.toList());
        countries.addAll(provinces);
        countries.addAll(cities);
        List<ComDistrictComboVO> comDistrictComboVOS = this.comDistrictService.getByDistCodes(countries);
        lists.forEach(VO -> {
            Optional<ComDistrictComboVO> comboVOOptional3;
            Optional<ComDistrictComboVO> comboVOOptional2;
            Optional<ComDistrictComboVO> comboVOOptional1 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCountry())).findFirst();
            if (comboVOOptional1.isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional1.get();
                VO.setCountryName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional2 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getProvince())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional2.get();
                VO.setProvinceName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional3 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCity())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional3.get();
                VO.setCityName(comDistrictComboVO.getName());
            }
        });
    }

    public OrgAddrapplyAddressServiceImpl(OrgAddrapplyAddressRepo orgAddrapplyAddressRepo, OrgAddrapplyAddressRepoProc orgAddrapplyAddressRepoProc, ComDistrictService comDistrictService) {
        this.orgAddrapplyAddressRepo = orgAddrapplyAddressRepo;
        this.orgAddrapplyAddressRepoProc = orgAddrapplyAddressRepoProc;
        this.comDistrictService = comDistrictService;
    }
}

