/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.out.entity.OrgBdDO;
import com.elitesland.out.entity.QOrgBdDO;
import com.elitesland.out.repo.OrgBdRepo;
import com.elitesland.out.repo.OrgBdRepoProc;
import com.elitesland.out.repo.OrgProfcenterRepo;
import com.elitesland.out.service.OrgBdService;
import com.elitesland.out.service.OrgProfcenterService;
import com.elitesland.out.vo.param.OrgBdQueryParamVO;
import com.elitesland.out.vo.resp.AntTreeNodeRespVO;
import com.elitesland.out.vo.resp.OrgBdRespVO;
import com.elitesland.out.vo.resp.OrgProfcenterRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orgBdService")
public class OrgBdServiceImpl
implements OrgBdService {
    private static final Logger log = LoggerFactory.getLogger(OrgBdServiceImpl.class);
    private final OrgBdRepo orgBdRepo;
    private final OrgBdRepoProc orgBdRepoProc;
    private final OrgProfcenterService orgProfcenterService;
    private final OrgProfcenterRepo orgProfcenterRepo;

    @Override
    public AntTreeNodeRespVO getRootTree(OrgBdQueryParamVO orgBdParam) {
        QOrgBdDO orgBdDO = QOrgBdDO.orgBdDO;
        Iterable orgBdDOS = this.orgBdRepo.findAll((Predicate)orgBdDO.deleteFlag.eq((Object)0));
        ArrayList<AntTreeNodeRespVO> antTreeNodeVOS = new ArrayList<AntTreeNodeRespVO>();
        orgBdDOS.forEach(orgBdDO1 -> {
            if (orgBdDO1.getPid() == null) {
                log.error("\u8868org_bd\u4e2d,ID\u4e3a{}\u7684\u6570\u636e\u5f02\u5e38", (Object)orgBdDO1.getId());
                return;
            }
            AntTreeNodeRespVO antTreeNodeVO = new AntTreeNodeRespVO();
            antTreeNodeVO.setKey(orgBdDO1.getId().toString());
            antTreeNodeVO.setTitle(orgBdDO1.getBdName());
            antTreeNodeVO.setId(orgBdDO1.getId().toString());
            antTreeNodeVO.setPid(orgBdDO1.getPid().toString());
            antTreeNodeVO.setValue(orgBdDO1.getId().toString());
            antTreeNodeVO.setSort(orgBdDO1.getSortNum());
            if (orgBdParam.getFilterStatus() != null && orgBdParam.getFilterStatus().booleanValue()) {
                if (!orgBdDO1.getBdStatus().equals("INACTIVE")) {
                    antTreeNodeVO.setAttributes(orgBdDO1);
                    antTreeNodeVOS.add(antTreeNodeVO);
                }
            } else {
                antTreeNodeVO.setAttributes(orgBdDO1);
                antTreeNodeVOS.add(antTreeNodeVO);
            }
        });
        AntTreeNodeRespVO root = this.newRootNode();
        antTreeNodeVOS.add(root);
        Map<String, List<AntTreeNodeRespVO>> collect = antTreeNodeVOS.stream().collect(Collectors.groupingBy(AntTreeNodeRespVO::getPid));
        OrgBdServiceImpl.forEach(collect, root);
        return root;
    }

    private AntTreeNodeRespVO newRootNode() {
        AntTreeNodeRespVO root = new AntTreeNodeRespVO();
        root.setKey("0");
        root.setTitle("\u9876\u5c42");
        root.setId("0");
        root.setPid("root");
        root.setValue("0");
        root.setSort(Integer.valueOf(1));
        return root;
    }

    @Override
    public AntTreeNodeRespVO getManageRootTreeList() {
        QOrgBdDO orgBdDO = QOrgBdDO.orgBdDO;
        Iterable orgBdDOS = this.orgBdRepo.findAll((Predicate)orgBdDO.deleteFlag.eq((Object)0));
        ArrayList<AntTreeNodeRespVO> antTreeNodeVOS = new ArrayList<AntTreeNodeRespVO>();
        orgBdDOS.forEach(orgBdDO1 -> {
            if (orgBdDO1.getPid() == null) {
                log.error("\u8868org_bd\u4e2d,ID\u4e3a{}\u7684\u6570\u636e\u5f02\u5e38", (Object)orgBdDO1.getId());
                return;
            }
            AntTreeNodeRespVO antTreeNodeVO = new AntTreeNodeRespVO();
            antTreeNodeVO.setKey(orgBdDO1.getId().toString());
            antTreeNodeVO.setTitle(orgBdDO1.getBdName());
            antTreeNodeVO.setId(orgBdDO1.getId().toString());
            antTreeNodeVO.setPid(orgBdDO1.getPid().toString());
            antTreeNodeVO.setValue(orgBdDO1.getId().toString());
            antTreeNodeVO.setAttributes(orgBdDO1);
            antTreeNodeVO.setType("1");
            antTreeNodeVO.setSort(orgBdDO1.getSortNum());
            antTreeNodeVOS.add(antTreeNodeVO);
        });
        Iterable orgProfcenterDOS = null;
        orgProfcenterDOS.forEach(orgProfcenterDO -> {
            if (orgProfcenterDO.getBdId() == null) {
                log.error("\u8868org_rofcenter\u4e2d,ID\u4e3a{}\u7684\u6570\u636e\u5f02\u5e38", (Object)orgProfcenterDO.getId());
                return;
            }
            AntTreeNodeRespVO antTreeNodeVO = new AntTreeNodeRespVO();
            antTreeNodeVO.setKey(orgProfcenterDO.getId().toString());
            antTreeNodeVO.setTitle(orgProfcenterDO.getPcName());
            antTreeNodeVO.setId(orgProfcenterDO.getId().toString());
            antTreeNodeVO.setPid(orgProfcenterDO.getBdId().toString());
            antTreeNodeVO.setValue(orgProfcenterDO.getPcCode());
            antTreeNodeVO.setType("2");
            antTreeNodeVO.setSort(orgProfcenterDO.getSortNum());
            antTreeNodeVO.setAttributes(orgProfcenterDO);
            antTreeNodeVOS.add(antTreeNodeVO);
        });
        AntTreeNodeRespVO root = this.newRootNode();
        antTreeNodeVOS.add(root);
        Map<String, List<AntTreeNodeRespVO>> collect = antTreeNodeVOS.stream().collect(Collectors.groupingBy(AntTreeNodeRespVO::getPid));
        OrgBdServiceImpl.forEach(collect, root);
        return root;
    }

    @Override
    public List<OrgBdRespVO> findAllByParam(OrgBdQueryParamVO param) {
        return this.orgBdRepoProc.select(param).fetch();
    }

    @Override
    public List<OrgBdRespVO> findCodeBatch(List<String> bdCodeList) {
        JPAQuery<OrgBdRespVO> orgBdVOJPAQuery = this.orgBdRepoProc.select(null);
        QOrgBdDO orgBdDO = QOrgBdDO.orgBdDO;
        orgBdVOJPAQuery.where((Predicate)orgBdDO.bdCode.in(bdCodeList));
        return orgBdVOJPAQuery.fetch();
    }

    private static void forEach(Map<String, List<AntTreeNodeRespVO>> collect, AntTreeNodeRespVO treeMenuNode) {
        List<AntTreeNodeRespVO> treeMenuNodes = collect.get(treeMenuNode.getId());
        if (collect.get(treeMenuNode.getId()) != null) {
            treeMenuNodes.sort((u1, u2) -> u1.getId().compareTo(u2.getId()));
            List<AntTreeNodeRespVO> children = treeMenuNodes.stream().sorted(Comparator.comparing(AntTreeNodeRespVO::getId)).sorted((h1, h2) -> h2.getSort().compareTo(h1.getSort())).collect(Collectors.toList());
            treeMenuNode.setChildren(children);
            children.forEach(t -> OrgBdServiceImpl.forEach(collect, t));
        }
    }

    @Override
    @SysCodeProc
    public List<OrgBdRespVO> getTree() {
        QOrgBdDO orgBdDO = QOrgBdDO.orgBdDO;
        List orgBdVOS = ((JPAQuery)this.orgBdRepoProc.select(null).orderBy(orgBdDO.id.asc())).fetch();
        orgBdVOS.stream().forEach(orgBdVO -> {
            List<OrgProfcenterRespVO> orgProfcenterVOS = this.orgProfcenterService.findByBdId(orgBdVO.getId());
            orgBdVO.setProfcenterVOS(orgProfcenterVOS);
        });
        return orgBdVOS;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBdRespVO> search(OrgBdQueryParamVO param) {
        JPAQuery<OrgBdRespVO> jpaQuery = this.orgBdRepoProc.select(param);
        long dataCount = jpaQuery.fetchCount();
        List lists = jpaQuery.fetch();
        return new PagingVO(dataCount, lists);
    }

    @Override
    @SysCodeProc
    public Optional<OrgBdRespVO> findCodeOne(String bdCode) {
        JPAQuery<OrgBdRespVO> jpaQuery = this.orgBdRepoProc.select(null);
        QOrgBdDO jpaQDo = QOrgBdDO.orgBdDO;
        jpaQuery.where((Predicate)jpaQDo.bdCode.eq((Object)bdCode));
        OrgBdRespVO vo = (OrgBdRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public Optional<OrgBdRespVO> findIdOne(Long id) {
        JPAQuery<OrgBdRespVO> jpaQuery = this.orgBdRepoProc.select(null);
        QOrgBdDO jpaQDo = QOrgBdDO.orgBdDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        OrgBdRespVO vo = (OrgBdRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public List<OrgBdRespVO> findIdBatch(List<Long> idList) {
        QOrgBdDO jpaQDo = QOrgBdDO.orgBdDO;
        JPAQuery<OrgBdRespVO> where = this.orgBdRepoProc.select(null);
        if (!idList.isEmpty()) {
            where.where((Predicate)jpaQDo.id.in(idList));
        }
        return where.fetch();
    }

    @Override
    @Transactional
    public Long createOne(OrgBdDO orgBdDO) {
        orgBdDO.setId(null);
        long count = ((JPAQuery)this.orgBdRepoProc.select(null).where((Predicate)QOrgBdDO.orgBdDO.bdCode.eq((Object)orgBdDO.getBdCode()))).fetchCount();
        if (count > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u4e1a\u90e8\u7f16\u7801\uff1a" + orgBdDO.getBdCode() + " \u5df2\u5b58\u5728");
        }
        if (orgBdDO.getPid() == null) {
            orgBdDO.setPid(0L);
        }
        if (orgBdDO.getPid() == 0L) {
            orgBdDO.setBdPath("/");
        } else {
            this.orgBdRepo.findById(orgBdDO.getPid()).map(parent -> orgBdDO.setBdPath(parent.getBdPath() + parent.getId() + "/")).orElseThrow(new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u7236\u7ea7\u4e8b\u4e1a\u90e8\u4e0d\u5b58\u5728"));
        }
        orgBdDO.setSortNum(1);
        return ((OrgBdDO)this.orgBdRepo.save(orgBdDO)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<OrgBdDO> list) {
        return list.stream().map(this::createOne).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(OrgBdDO item) {
        OrgBdDO orgBdDO;
        Optional optional = this.orgBdRepo.findById(item.getId());
        if (optional.isPresent()) {
            orgBdDO = (OrgBdDO)optional.get();
            OrgBdRespVO orgBdVO = (OrgBdRespVO)((JPAQuery)this.orgBdRepoProc.select(null).where((Predicate)QOrgBdDO.orgBdDO.bdCode.eq((Object)item.getBdCode()))).fetchOne();
            if (orgBdVO != null && !orgBdVO.getId().equals(item.getId())) {
                throw new BusinessException(ApiCode.FAIL, "\u4e8b\u4e1a\u90e8\u7f16\u7801\uff1a" + item.getBdCode() + " \u5df2\u5b58\u5728");
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + item.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(item, orgBdDO, BeanCopyUtil.getNullPropertyNames(item));
        this.orgBdRepo.save(orgBdDO);
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QOrgBdDO jpaQDo = QOrgBdDO.orgBdDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.orgBdRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        OrgBdDO do1 = (OrgBdDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.orgBdRepo.save(do1);
    }

    @Override
    @Transactional
    public void deleteOne(Long id) {
        if (this.orgProfcenterService.findByBdId(id) != null) {
            throw new BusinessException(ApiCode.FAIL, "\u6709\u6240\u5c5e\u8be5\u4e8b\u4e1a\u90e8\u7684\u5229\u6da6\u4e2d\u5fc3\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664" + id);
        }
        this.orgBdRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.orgBdRepo.deleteById(id));
    }

    public OrgBdServiceImpl(OrgBdRepo orgBdRepo, OrgBdRepoProc orgBdRepoProc, OrgProfcenterService orgProfcenterService, OrgProfcenterRepo orgProfcenterRepo) {
        this.orgBdRepo = orgBdRepo;
        this.orgBdRepoProc = orgBdRepoProc;
        this.orgProfcenterService = orgProfcenterService;
        this.orgProfcenterRepo = orgProfcenterRepo;
    }
}

