/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.PriPriceCustApplyQueryParam;
import com.elitesland.org.repo.OrgBuRepo;
import com.elitesland.org.repo.OrgOuRepo;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.out.convert.OrgCustConvert;
import com.elitesland.out.entity.OrgCustDO;
import com.elitesland.out.entity.QOrgCustDO;
import com.elitesland.out.repo.ComDistrictRepo;
import com.elitesland.out.repo.OrgCustRepo;
import com.elitesland.out.repo.OrgCustRepoProc;
import com.elitesland.out.service.OrgAddrAddressService;
import com.elitesland.out.service.OrgAddrQualifyService;
import com.elitesland.out.service.OrgCustService;
import com.elitesland.out.vo.param.OrgCustQueryParamVO;
import com.elitesland.out.vo.resp.OrgAddrAddressRespVO;
import com.elitesland.out.vo.resp.OrgCustRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.repo.SysUdcRepo;
import com.elitesland.util.BeanCopyUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import io.jsonwebtoken.lang.Collections;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCustServiceImpl
implements OrgCustService {
    private final Object $lock = new Object[0];
    private final OrgCustRepo orgCustRepo;
    private final OrgOuRepo orgOuRepo;
    private final OrgOuService orgOuService;
    private final OrgBuRepo orgBuRepo;
    private final ComDistrictRepo comDistrictRepo;
    private final OrgCustRepoProc orgCustRepoProc;
    private final SysUdcRepo sysUdcRepo;
    private final OrgAddrAddressService orgAddrAddressService;
    private final OrgAddrQualifyService orgAddrQualifyService;

    @Override
    @SysCodeProc
    public List<OrgCustRespVO> findCustByParam(OrgCustQueryParamVO param) {
        JPAQuery records = (JPAQuery)this.orgCustRepoProc.select().where(this.orgCustRepoProc.where(param));
        return records.fetch();
    }

    @Override
    public Optional<OrgCustRespVO> findByAddrNo(Integer addrNo) {
        JPAQuery jpaQuery = (JPAQuery)this.orgCustRepoProc.select().where((Predicate)QOrgCustDO.orgCustDO.addrNo.eq((Object)addrNo));
        return Optional.ofNullable((OrgCustRespVO)jpaQuery.fetchFirst());
    }

    @Override
    public List<OrgCustRespVO> findByAddrNos(List<Integer> addrNos) {
        return ((JPAQuery)this.orgCustRepoProc.select().where((Predicate)QOrgCustDO.orgCustDO.addrNo.in(addrNos))).fetch();
    }

    @Override
    public Optional<OrgCustRespVO> findByOuId(Long ouId, Long salOuId) {
        return Optional.empty();
    }

    public Optional<OrgCustDO> findBuCodeByOuIdAndCust(Long custId, Long ouId) {
        return this.orgCustRepo.findByIdAndOuId(custId, ouId);
    }

    @Override
    public List<OrgCustDO> findByCodes(List<String> codes) {
        List<OrgCustDO> byCustCodeIn = this.orgCustRepo.findByCustCodeIn(codes);
        return byCustCodeIn;
    }

    @Override
    @Transactional
    public List<OrgCustRespVO> findDataToTemp() {
        QOrgCustDO jpaDo = QOrgCustDO.orgCustDO;
        JPAQuery<OrgCustRespVO> jpaQuery = this.orgCustRepoProc.select();
        jpaQuery.where((Predicate)jpaDo.deleteFlag.eq((Object)0).or((Predicate)jpaDo.deleteFlag.isNull()));
        jpaQuery.where((Predicate)jpaDo.intfStatus.eq((Object)"0").or((Predicate)jpaDo.intfStatus.isNull()));
        return jpaQuery.fetch();
    }

    @Override
    @Transactional
    public List<OrgCustRespVO> findCustCode(List<String> custcodes) {
        QOrgCustDO jpaDo = QOrgCustDO.orgCustDO;
        JPAQuery<OrgCustRespVO> jpaQuery = this.orgCustRepoProc.select();
        jpaQuery.where((Predicate)jpaDo.deleteFlag.eq((Object)0).or((Predicate)jpaDo.deleteFlag.isNull()));
        jpaQuery.where((Predicate)jpaDo.custCode.in(custcodes));
        return jpaQuery.fetch();
    }

    @Override
    @Transactional
    public void updateIntfStatusByIds(String intfStatus, List<Long> ids) {
        this.orgCustRepo.updateIntfStatusByIds(intfStatus, LocalDateTime.now(), ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean updateOpenSoAmtOccupy(Long custId, BigDecimal openSoAmt) {
        Object object = this.$lock;
        synchronized (object) {
            BigDecimal custOpenSoAmt;
            BigDecimal compareAmt;
            if (custId == null) {
                throw new BusinessException("\u5ba2\u6237ID \u4e0d\u80fd\u4e3a\u7a7a");
            }
            Optional<OrgCustDO> orgCustDOOptional = this.orgCustRepo.findById(custId);
            if (!orgCustDOOptional.isPresent()) {
                throw new BusinessException("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            openSoAmt = openSoAmt == null ? BigDecimal.ZERO : openSoAmt.abs();
            OrgCustDO orgCustDO = orgCustDOOptional.get();
            BigDecimal custCreditLimit = orgCustDO.getCreditLimit() == null ? BigDecimal.ZERO : orgCustDO.getCreditLimit();
            if (custCreditLimit.compareTo(compareAmt = (custOpenSoAmt = orgCustDO.getOpenSoAmt() == null ? BigDecimal.ZERO : orgCustDO.getOpenSoAmt()).add(openSoAmt)) >= 0) {
                orgCustDO.setOpenSoAmt(compareAmt);
                orgCustDO.setCreditBal(custCreditLimit.subtract(compareAmt));
                this.orgCustRepo.save(orgCustDO);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean updateOpenSoAmtRelease(Long custId, BigDecimal openSoAmt) {
        Object object = this.$lock;
        synchronized (object) {
            if (custId == null) {
                throw new BusinessException("\u5ba2\u6237ID \u4e0d\u80fd\u4e3a\u7a7a");
            }
            Optional<OrgCustDO> orgCustDOOptional = this.orgCustRepo.findById(custId);
            if (!orgCustDOOptional.isPresent()) {
                throw new BusinessException("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            openSoAmt = openSoAmt == null ? BigDecimal.ZERO : openSoAmt.abs();
            OrgCustDO orgCustDO = orgCustDOOptional.get();
            BigDecimal custCreditLimit = orgCustDO.getCreditLimit() == null ? BigDecimal.ZERO : orgCustDO.getCreditLimit();
            BigDecimal custOpenSoAmt = orgCustDO.getOpenSoAmt() == null ? BigDecimal.ZERO : orgCustDO.getOpenSoAmt();
            BigDecimal compareAmt = custOpenSoAmt.subtract(openSoAmt);
            orgCustDO.setOpenSoAmt(compareAmt);
            orgCustDO.setCreditBal(custCreditLimit.subtract(compareAmt));
            this.orgCustRepo.save(orgCustDO);
            return true;
        }
    }

    @Override
    @SysCodeProc
    public Optional<OrgCustRespVO> findCodeOne(String code) {
        OrgCustQueryParamVO orgCustQueryParamVO = new OrgCustQueryParamVO();
        orgCustQueryParamVO.setCustCode(code);
        JPAQuery records = (JPAQuery)this.orgCustRepoProc.select().where(this.orgCustRepoProc.where(orgCustQueryParamVO));
        return Optional.ofNullable((OrgCustRespVO)records.fetchOne());
    }

    @Override
    @SysCodeProc
    public Optional<OrgCustRespVO> findIdOne(Long Id) {
        JPAQuery jpaQuery = (JPAQuery)this.orgCustRepoProc.select().where((Predicate)QOrgCustDO.orgCustDO.id.eq((Object)Id).and((Predicate)QOrgCustDO.orgCustDO.deleteFlag.eq((Object)0)));
        return Optional.ofNullable((OrgCustRespVO)jpaQuery.fetchOne());
    }

    @Override
    @SysCodeProc
    public List<OrgCustRespVO> findByCustGroup(List<String> custGroup) {
        JPAQuery jpaQuery = (JPAQuery)this.orgCustRepoProc.select().where((Predicate)QOrgCustDO.orgCustDO.c2Code.in(custGroup).and((Predicate)QOrgCustDO.orgCustDO.deleteFlag.eq((Object)0)));
        return jpaQuery.fetch();
    }

    @Override
    public List<OrgCustRespVO> listByParam(PriPriceCustApplyQueryParam param) {
        JPAQuery select = (JPAQuery)this.orgCustRepoProc.select().where(this.orgCustRepoProc.custSearchWhere(param));
        this.orgCustRepoProc.openOrderAndLimit(select, (AbstractOrderQueryParam)param, QOrgCustDO.orgCustDO);
        return Lists.newArrayList((Iterable)select.fetch());
    }

    @Override
    public List<OrgCustRespVO> listByParamCustName(String custName) {
        QOrgCustDO orgCustDO = QOrgCustDO.orgCustDO;
        OrgCustQueryParamVO orgCustQueryParam = new OrgCustQueryParamVO();
        orgCustQueryParam.setCustCode(custName);
        JPAQuery select = (JPAQuery)this.orgCustRepoProc.listByParamCustName().where((Predicate)orgCustDO.custName.like("%" + custName + "%").or((Predicate)orgCustDO.id.like("%" + custName + "%")).or((Predicate)orgCustDO.custCode.like("%" + custName + "%")));
        return Lists.newArrayList((Iterable)select.fetch());
    }

    @Override
    @SysCodeProc
    public List<OrgCustRespVO> findIdBatch(List<Long> idList) {
        List orgCustDOS = this.orgCustRepo.findAllById(idList);
        return orgCustDOS.stream().map(DO -> (OrgCustRespVO)BeanUtil.copyProperties((Object)DO, OrgCustRespVO.class)).collect(Collectors.toList());
    }

    @Override
    public Long createOne(OrgCustDO objDo) {
        return ((OrgCustDO)this.orgCustRepo.save(objDo)).getId();
    }

    @Override
    public List<Long> createBatch(List<OrgCustDO> List2) {
        List orgCustDOS = this.orgCustRepo.saveAll(List2);
        return orgCustDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    public void update(OrgCustDO objDo) {
        Optional<OrgCustDO> optional = this.orgCustRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.orgCustRepo.save(optional.get());
    }

    @Override
    public void deleteOne(Long Id) {
    }

    @Override
    public void deleteBatch(List<Long> idList) {
    }

    @Override
    public void updateDeleteFlag(Long id) {
    }

    @Override
    public PagingVO<OrgCustRespVO> findList(OrgCustQueryParamVO param, List<Long> codes) {
        QOrgCustDO orgCustDO = QOrgCustDO.orgCustDO;
        JPAQuery select = (JPAQuery)((JPAQuery)this.orgCustRepoProc.select().where(this.orgCustRepoProc.searchWhere(param))).where((Predicate)orgCustDO.id.in(codes));
        return PagingVO.builder().total(Long.valueOf(select.fetchCount())).records(select.fetch()).build();
    }

    @Override
    public List<OrgCustRespVO> findAllByParam(OrgCustQueryParamVO param) {
        return null;
    }

    @Override
    public PagingVO<OrgCustRespVO> findAllByParamSal(OrgCustQueryParamVO param) {
        return null;
    }

    @Override
    @SysCodeProc
    public List<OrgCustRespVO> findListByParam(OrgCustQueryParamVO param, List<Long> codes) {
        QOrgCustDO orgCustDO = QOrgCustDO.orgCustDO;
        JPAQuery<OrgCustRespVO> select = this.orgCustRepoProc.select();
        if (param != null && StringUtils.isNotBlank((CharSequence)param.getCustCode())) {
            select.where((Predicate)orgCustDO.custCode.like("%" + param.getCustCode() + "%").or((Predicate)orgCustDO.custName.like("%" + param.getCustCode() + "%")));
        }
        if (!Collections.isEmpty(codes)) {
            select.where((Predicate)orgCustDO.id.in(codes));
        }
        return select.fetch();
    }

    @Override
    public Optional<OrgCustRespVO> findOneByIdIncludeAddress(Long Id) {
        return Optional.empty();
    }

    @Override
    public List<OrgCustRespVO> findListByParamAndCodesIn(OrgCustQueryParamVO param, List<Long> codes) {
        QOrgCustDO orgCustDO = QOrgCustDO.orgCustDO;
        JPAQuery<OrgCustRespVO> select = this.orgCustRepoProc.select();
        if (param != null && StringUtils.isNotBlank((CharSequence)param.getCustCode())) {
            select.where((Predicate)orgCustDO.custCode.like("%" + param.getCustCode() + "%").or((Predicate)orgCustDO.custName.like("%" + param.getCustCode() + "%")));
        }
        if (!Collections.isEmpty(codes)) {
            select.where((Predicate)orgCustDO.id.in(codes));
        }
        return select.fetch();
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgCustRespVO> search(OrgCustQueryParamVO param) {
        JPAQuery records = (JPAQuery)this.orgCustRepoProc.select().where(this.orgCustRepoProc.searchWhere(param));
        List fetch = records.fetch();
        List<Integer> addrNos = fetch.stream().map(OrgCustRespVO::getAddrNo).distinct().collect(Collectors.toList());
        List orgAddrAddressVOS = this.orgAddrAddressService.findByAddrNos(addrNos).stream().filter(a -> UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode().equals(a.getAddressType())).collect(Collectors.toList());
        fetch.forEach(V -> {
            Optional<OrgAddrAddressRespVO> first = orgAddrAddressVOS.stream().filter(a -> a.getAddrNo().equals(V.getAddrNo())).findFirst();
            if (first.isPresent()) {
                OrgAddrAddressRespVO orgAddrAddressVO = first.get();
                V.setDetailaddr(orgAddrAddressVO.getDetailaddr());
                String countryName = orgAddrAddressVO.getCountryName();
                String provinceName = orgAddrAddressVO.getProvinceName();
                String cityName = orgAddrAddressVO.getCityName();
                V.setRegion(countryName + "-" + provinceName + "-" + cityName);
            }
        });
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(fetch).build();
    }

    @Override
    public List<OrgCustRespVO> findByOuterCodes(List<String> an8s) {
        return this.orgCustRepo.findByOuterCodeIn(an8s).stream().map(OrgCustConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public OrgCustRespVO findByOuterCodeAndOuId(String outerCode, Long ouId) {
        OrgCustDO byOuterCodeAndOuId = this.orgCustRepo.findByOuterCodeAndOuId(outerCode, ouId);
        return OrgCustConvert.INSTANCE.doToVO(byOuterCodeAndOuId);
    }

    @Override
    public Optional<OrgCustDO> findById(Long custId) {
        return this.orgCustRepo.findById(custId);
    }

    @Override
    public List<Long> findIdByLike(String custKeyWord) {
        return this.orgCustRepoProc.findIdByLike(custKeyWord).fetch();
    }

    @Override
    public Optional<OrgCustDO> findByCustCode(String custCode) {
        return this.orgCustRepoProc.findByCustCode(custCode);
    }

    @Override
    @SysCodeProc
    public List<OrgCustRespVO> findByBuId(Long buId) {
        return this.orgCustRepo.findByBuId(buId).stream().map(OrgCustConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public List<OrgCustRespVO> findAllByAddrLike(OrgCustQueryParamVO param) {
        return null;
    }

    public OrgCustServiceImpl(OrgCustRepo orgCustRepo, OrgOuRepo orgOuRepo, OrgOuService orgOuService, OrgBuRepo orgBuRepo, ComDistrictRepo comDistrictRepo, OrgCustRepoProc orgCustRepoProc, SysUdcRepo sysUdcRepo, OrgAddrAddressService orgAddrAddressService, OrgAddrQualifyService orgAddrQualifyService) {
        this.orgCustRepo = orgCustRepo;
        this.orgOuRepo = orgOuRepo;
        this.orgOuService = orgOuService;
        this.orgBuRepo = orgBuRepo;
        this.comDistrictRepo = comDistrictRepo;
        this.orgCustRepoProc = orgCustRepoProc;
        this.sysUdcRepo = sysUdcRepo;
        this.orgAddrAddressService = orgAddrAddressService;
        this.orgAddrQualifyService = orgAddrQualifyService;
    }
}

