/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.out.convert.OrgEmpConvert;
import com.elitesland.out.entity.OrgEmpDO;
import com.elitesland.out.entity.QOrgEmpDO;
import com.elitesland.out.repo.OrgEmpRepo;
import com.elitesland.out.repo.OrgEmpRepoProc;
import com.elitesland.out.service.OrgEmpService;
import com.elitesland.out.vo.param.OrgEmpQueryParamVO;
import com.elitesland.out.vo.resp.OrgEmpRespVO;
import com.elitesland.pur.dto.OrgEmpVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.param.SysUserNewParam;
import com.elitesland.system.service.SysUserService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgEmpServiceImpl
implements OrgEmpService {
    private final OrgEmpRepo orgEmpRepo;
    private final OrgEmpRepoProc orgEmpRepoProc;
    private SysUserService sysUserService;

    @Autowired
    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    @Override
    public List<OrgEmpRespVO> findAllByIdIn(List<Long> ids) {
        List<Tuple> allByIdIn = this.orgEmpRepo.findAllByIdIn(ids);
        List<OrgEmpRespVO> collect = allByIdIn.stream().map(v -> {
            OrgEmpRespVO orgEmpVO = new OrgEmpRespVO();
            orgEmpVO.setId(Long.valueOf(v.get(0).toString()));
            orgEmpVO.setEmpName(v.get(1).toString());
            return orgEmpVO;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<OrgEmpRespVO> findEmpNameIn(List<String> ids) {
        List<Tuple> allByIdIn = this.orgEmpRepo.findAllByEmpNameIn(ids);
        List<OrgEmpRespVO> collect = allByIdIn.stream().map(v -> {
            OrgEmpRespVO orgEmpVO = new OrgEmpRespVO();
            orgEmpVO.setId(Long.valueOf(v.get(0).toString()));
            orgEmpVO.setEmpName(v.get(1).toString());
            return orgEmpVO;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    @SysCodeProc
    public List<OrgEmpRespVO> findIdBatch(List<Long> idList) {
        return this.orgEmpRepo.findAllById(idList).stream().map(OrgEmpConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<OrgEmpRespVO> findcodeBatch(List<String> idList) {
        QOrgEmpDO orgEmpDO = QOrgEmpDO.orgEmpDO;
        JPAQuery where = (JPAQuery)this.orgEmpRepoProc.select(null).where((Predicate)orgEmpDO.empCode.in(idList));
        return where.fetch();
    }

    @Override
    public List<OrgEmpRespVO> findByIdIn(List<Long> idList) {
        return this.orgEmpRepo.findByIdIn(idList).stream().map(OrgEmpConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public Optional<OrgEmpDO> findByUserId(Long userId) {
        if (userId == null) {
            return Optional.empty();
        }
        QOrgEmpDO jpaQDo = QOrgEmpDO.orgEmpDO;
        BooleanExpression predicate = jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull());
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.userId.eq((Object)userId));
        return this.orgEmpRepo.findOne((Predicate)predicate);
    }

    @Override
    public String findOne(Long userId) {
        Optional orgEmpDO = this.orgEmpRepo.findById(userId);
        String empName = "";
        if (orgEmpDO.isPresent()) {
            empName = ((OrgEmpDO)orgEmpDO.get()).getEmpName();
        }
        return empName;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgEmpRespVO> search(OrgEmpQueryParamVO param) {
        JPAQuery<OrgEmpRespVO> jpaQuery = this.orgEmpRepoProc.select(param);
        long dataCount = jpaQuery.fetchCount();
        List lists = jpaQuery.fetch();
        return new PagingVO(dataCount, lists);
    }

    @Override
    public List<OrgEmpRespVO> findAllEmp() {
        return this.orgEmpRepo.findAll().stream().map(OrgEmpConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public List<OrgEmpRespVO> findEmpByCodes(List<String> codes) {
        return this.orgEmpRepo.findByEmpCodeIn(codes).stream().map(OrgEmpConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public Optional<OrgEmpRespVO> findByEmpCode(String code) {
        return this.orgEmpRepo.findByEmpCode(code).map(OrgEmpConvert.INSTANCE::doToVO);
    }

    @Override
    public Optional<OrgEmpRespVO> findByEmpid(Long id) {
        return this.orgEmpRepo.findById(id).map(OrgEmpConvert.INSTANCE::doToVO);
    }

    @Override
    public List<OrgEmpDO> findByUserIdData(long userId) {
        return this.orgEmpRepo.findByUserId(userId);
    }

    @Override
    public List<OrgEmpRespVO> findAllByUserIdIn(List<Long> getUpdaters) {
        List<OrgEmpRespVO> byUserIdIn = this.orgEmpRepo.findByUserIdIn(getUpdaters).stream().map(OrgEmpConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return byUserIdIn;
    }

    @Override
    public List<Long> findIdByLike(String createUserKeyWord) {
        return this.orgEmpRepoProc.findIdByLike(createUserKeyWord).fetch();
    }

    @Override
    public Long create(OrgEmpVO emp) {
        return null;
    }

    public Long create(OrgEmpRespVO emp) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{emp.getSysUsername()})) {
            SysUserNewParam user = new SysUserNewParam().setUsername(emp.getSysUsername()).setFirstName(emp.getEmpName()).setLastName(emp.getEnglishName()).setMobile(emp.getMobile()).setEmail(emp.getEmail()).setEnabled(Boolean.valueOf(true));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{emp.getSysPassword()})) {
                user.setPassword(emp.getSysPassword());
            } else {
                user.setPassword("111111");
            }
            Long userId = this.sysUserService.create(user);
            emp.setUserId(userId);
        }
        OrgEmpDO newEmp = (OrgEmpDO)this.orgEmpRepo.save(OrgEmpConvert.INSTANCE.voToDO(emp));
        return newEmp.getId();
    }

    @Override
    public void update(OrgEmpVO emp) {
        this.orgEmpRepo.findById(emp.getId()).ifPresent(e -> {
            e.setEmpCode(emp.getEmpCode()).setEmpName(emp.getEmpName()).setEnglishName(emp.getEnglishName()).setMobile(emp.getMobile()).setEmail(emp.getEmail());
            this.orgEmpRepo.save(e);
        });
    }

    @Override
    public void removeById(Long id) {
        this.orgEmpRepo.deleteById(id);
    }

    @Override
    public void bindSysUserToEmp(String sysUsername, Long empId) {
        this.sysUserService.getUserByUsername(sysUsername).ifPresentOrElse(u -> this.orgEmpRepo.findById(empId).ifPresentOrElse(e -> {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getSysUsername()}) || e.getUserId() != null && e.getUserId() > 0L) {
                throw new BusinessException("\u5458\u5de5\uff1a" + e.getEmpName() + ", \u5df2\u7ecf\u7ed1\u5b9a\u8d26\u53f7\uff1a" + sysUsername);
            }
            e.setUserId(u.getId()).setSysUsername(sysUsername);
            this.orgEmpRepo.save(e);
        }, () -> {
            throw new BusinessException("\u672a\u627e\u5230\u7f16\u53f7\u4e3a\uff1a" + empId + ", \u7684\u5458\u5de5\u8bb0\u5f55");
        }), () -> {
            throw new BusinessException("\u672a\u627e\u5230\uff1a" + sysUsername + ", \u7684\u8d26\u53f7\u8bb0\u5f55");
        });
    }

    @Override
    public void unbindEmpWithSysUser(Long empId) {
        this.orgEmpRepo.findById(empId).ifPresentOrElse(e -> {
            e.setUserId(null).setSysUsername(null);
            this.orgEmpRepo.save(e);
        }, () -> {
            throw new BusinessException("\u672a\u627e\u5230\u7f16\u53f7\u4e3a\uff1a" + empId + ", \u7684\u5458\u5de5\u8bb0\u5f55");
        });
    }

    public OrgEmpServiceImpl(OrgEmpRepo orgEmpRepo, OrgEmpRepoProc orgEmpRepoProc) {
        this.orgEmpRepo = orgEmpRepo;
        this.orgEmpRepoProc = orgEmpRepoProc;
    }
}

