/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.out.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.inv.dto.OrgAddrAddressVO;
import com.elitesland.inv.dto.OrgCustVO;
import com.elitesland.inv.dto.PriPriceCustApplyQueryParam;
import com.elitesland.org.convert.OrgOuConvert;
import com.elitesland.org.repo.OrgOuRepo;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.convert.OrgAddrAddressConvert;
import com.elitesland.out.convert.OrgEmpConvert;
import com.elitesland.out.entity.OrgAddrAddressDO;
import com.elitesland.out.entity.OrgEmpDO;
import com.elitesland.out.entity.QOrgAddrAddressDO;
import com.elitesland.out.entity.QOrgCustDO;
import com.elitesland.out.repo.OrgAddrAddressRepo;
import com.elitesland.out.repo.OrgAddrAddressRepoProc;
import com.elitesland.out.repo.OrgCustRepo;
import com.elitesland.out.repo.OrgCustRepoProc;
import com.elitesland.out.service.ComCurrRateService;
import com.elitesland.out.service.ComCurrService;
import com.elitesland.out.service.ComDistrictService;
import com.elitesland.out.service.ComPaymentTermService;
import com.elitesland.out.service.OrgCustService;
import com.elitesland.out.service.OrgEmpService;
import com.elitesland.out.service.OutPurService;
import com.elitesland.out.service.OutService;
import com.elitesland.out.vo.param.ComCurrRateQueryParamVO;
import com.elitesland.out.vo.param.OrgQueryParamVO;
import com.elitesland.out.vo.resp.ComCurrRespVO;
import com.elitesland.out.vo.resp.ComPaymentTermRespVO;
import com.elitesland.out.vo.resp.OrgAddrAddressRespVO;
import com.elitesland.out.vo.resp.OrgCustRespVO;
import com.elitesland.out.vo.resp.OrgEmpRespVO;
import com.elitesland.out.vo.resp.OrgRespVO;
import com.elitesland.pur.dto.OrgEmpVO;
import com.elitesland.pur.service.PurPoDService;
import com.elitesland.pur.service.PurPoService;
import com.elitesland.pur.service.PurSceneService;
import com.elitesland.pur.service.PurSuppService;
import com.elitesland.pur.vo.param.PurPoDUpdateParamVO;
import com.elitesland.pur.vo.resp.PurPoDRespVO;
import com.elitesland.pur.vo.resp.PurPoRespVO;
import com.elitesland.pur.vo.resp.PurSceneRespVO;
import com.elitesland.pur.vo.resp.PurSuppRespVO;
import com.elitesland.pur.vo.save.PurPoSaveVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.convert.SysUserConvert;
import com.elitesland.system.repo.SysUserRepo;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.system.vo.SysUdcComboVO;
import com.elitesland.system.vo.SysUserVO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmBrandPartParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.service.ItmBrandRemoteService;
import com.elitesland.yst.supportdomain.provider.item.service.ItmItemRemoteService;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmBrandAllDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmBrandPartDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPartDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemPoDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmReBrandDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OutserviceImpl
implements OutService {
    private static final Logger log = LoggerFactory.getLogger(OutserviceImpl.class);
    private final OrgCustService orgCustService;
    private final OrgOuService orgOuService;
    private final OrgOuRepo orgOuRepo;
    private final OrgEmpService orgEmpservice;
    private final OrgAddrAddressRepo orgAddrAddressRepo;
    private final OrgAddrAddressRepoProc orgAddrAddressRepoProc;
    private final ComDistrictService comDistrictService;
    private final OrgCustRepo orgCustRepo;
    private final OrgCustRepoProc orgCustRepoProc;
    private final ComPaymentTermService comPaymentTermService;
    private final ComCurrRateService comCurrRateService;
    private final ComCurrService comCurrService;
    private final SysUserRepo sysUserRepo;
    private final OrgEmpService orgEmpService;
    private final SysUdcService sysUdcService;
    @DubboReference
    private PurSceneService purSceneService;
    @DubboReference
    private PurPoService purPoService;
    @DubboReference
    private ItmItemRemoteService itmItemRemoteService;
    @DubboReference
    private ItmBrandRemoteService itmBrandRemoteService;
    @DubboReference
    private OutPurService outPurService;
    @DubboReference
    private PurSuppService purSuppService;
    @DubboReference
    private PurPoDService purPoDService;

    @Override
    public List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds) {
        try {
            List sysUserDOS = this.sysUserRepo.findAllByIdIn(calcEmpIds);
            if (!CollectionUtils.isEmpty((Collection)sysUserDOS)) {
                List<SysUserVO> sysUserVOList = sysUserDOS.stream().map(arg_0 -> ((SysUserConvert)SysUserConvert.INSTANCE).doToVo(arg_0)).collect(Collectors.toList());
                return sysUserVOList;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<OrgCustRespVO> findCodeOne(String Code) {
        try {
            Optional<OrgCustRespVO> codeOne = this.orgCustService.findCodeOne(Code);
            if (codeOne.isPresent()) {
                return codeOne;
            }
        }
        catch (Exception e) {
            log.error("listOrgOuVOByIds error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<OrgCustRespVO> findCustByParam(PriPriceCustApplyQueryParam param) {
        JPAQuery select = (JPAQuery)this.orgCustRepoProc.select().where(this.orgCustRepoProc.custSearchWhere(param));
        this.orgCustRepoProc.openOrderAndLimit(select, (AbstractOrderQueryParam)param, QOrgCustDO.orgCustDO);
        return Lists.newArrayList((Iterable)select.fetch());
    }

    @Override
    @SysCodeProc
    public Optional<OrgCustRespVO> findCustByIdOne(Long Id) {
        JPAQuery jpaQuery = (JPAQuery)this.orgCustRepoProc.select().where((Predicate)QOrgCustDO.orgCustDO.id.eq((Object)Id).and((Predicate)QOrgCustDO.orgCustDO.deleteFlag.eq((Object)0)));
        return Optional.ofNullable((OrgCustRespVO)jpaQuery.fetchOne());
    }

    @Override
    public List<OrgCustVO> findCustByIdList(List<Long> custIds) {
        try {
            List orgCustDOS = this.orgCustRepo.findAllById(custIds);
            if (!CollectionUtils.isEmpty((Collection)orgCustDOS)) {
                return orgCustDOS.stream().map(DO -> (OrgCustVO)BeanUtil.copyProperties((Object)DO, OrgCustVO.class)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            log.error("findCustByIdList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuVO> listOrgOuVOByIds(List<Long> ids) {
        try {
            List orgOuVOS = this.orgOuService.listByIds(ids);
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS)) {
                return orgOuVOS;
            }
        }
        catch (Exception e) {
            log.error("listOrgOuVOByIds error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuVO> findOusByBatch(List<Long> ouIds) {
        try {
            List orgOuVOS = this.orgOuService.batch(ouIds);
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS)) {
                return orgOuVOS;
            }
        }
        catch (Exception e) {
            log.error("findOusByBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public OrgOuVO findOrgOuVOById(Long id) {
        try {
            Optional orgOuVO = this.orgOuService.oneById(id);
            if (orgOuVO.isPresent()) {
                return (OrgOuVO)orgOuVO.get();
            }
        }
        catch (Exception e) {
            log.error("findOrgOuVOById error:", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<OrgOuVO> findBatchOus(List<Long> ouIds) {
        return this.orgOuRepo.findAllById(ouIds).stream().map(arg_0 -> ((OrgOuConvert)OrgOuConvert.INSTANCE).doToVO(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Optional<OrgOuVO> findOneOuById(Long id) {
        return this.orgOuRepo.findById((Object)id).map(arg_0 -> ((OrgOuConvert)OrgOuConvert.INSTANCE).doToVO(arg_0));
    }

    @Override
    public Optional<OrgEmpRespVO> findEmpById(Long empId) {
        try {
            Optional<OrgEmpRespVO> orgEmpRespVO = this.orgEmpService.findByEmpid(empId);
            if (orgEmpRespVO.isPresent()) {
                return orgEmpRespVO;
            }
        }
        catch (Exception e) {
            log.error("findEmpById error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<OrgEmpVO> findEmpByBatch(List<Long> empIds) {
        try {
            List<OrgEmpRespVO> empRespVOS = this.orgEmpService.findIdBatch(empIds);
            if (!CollectionUtils.isEmpty(empRespVOS)) {
                return empRespVOS.stream().map(OrgEmpConvert.INSTANCE::respToVo).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            log.error("findEmpByBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<OrgEmpDO> findByUserId(Long userId) {
        try {
            Optional<OrgEmpDO> byUserId = this.orgEmpservice.findByUserId(userId);
            if (byUserId.isPresent()) {
                return byUserId;
            }
        }
        catch (Exception e) {
            log.error("listOrgOuVOByIds error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<OrgEmpRespVO> findAllByIdIn(List<Long> ids) {
        try {
            List<OrgEmpRespVO> allByIdIn = this.orgEmpservice.findAllByIdIn(ids);
            if (!CollectionUtils.isEmpty(allByIdIn)) {
                return allByIdIn;
            }
        }
        catch (Exception e) {
            log.error("listOrgOuVOByIds error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public void deleteByAddrNo(Integer addrNo) {
        this.orgAddrAddressRepo.deleteByAddrNo(addrNo);
    }

    @Override
    @Transactional
    public Long createAddrOne(OrgAddrAddressVO objVo) {
        OrgAddrAddressDO addressDO = OrgAddrAddressConvert.INSTANCE.voToDO(objVo);
        return ((OrgAddrAddressDO)this.orgAddrAddressRepo.save(addressDO)).getId();
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findByAddrNos(List<Integer> addrNo) {
        try {
            QOrgAddrAddressDO orgAddrAddressDO = QOrgAddrAddressDO.orgAddrAddressDO;
            List fetch = ((JPAQuery)this.orgAddrAddressRepoProc.select().where((Predicate)orgAddrAddressDO.addrNo.in(addrNo))).fetch();
            if (!CollectionUtils.isEmpty((Collection)fetch)) {
                this.translate(fetch);
                return fetch;
            }
        }
        catch (Exception e) {
            log.error("findByAddrNos error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    @SysCodeProc
    public List<OrgAddrAddressRespVO> findByAddrNo(Integer addrNo) {
        QOrgAddrAddressDO orgAddrAddressDO = QOrgAddrAddressDO.orgAddrAddressDO;
        List fetch = ((JPAQuery)this.orgAddrAddressRepoProc.select().where((Predicate)orgAddrAddressDO.addrNo.eq((Object)addrNo))).fetch();
        if (!CollectionUtils.isEmpty((Collection)fetch)) {
            this.translate(fetch);
            return fetch;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ComPaymentTermRespVO> comPaymentservicelist() {
        try {
            List<ComPaymentTermRespVO> list = this.comPaymentTermService.list();
            if (!CollectionUtils.isEmpty(list)) {
                return list;
            }
        }
        catch (Exception e) {
            log.error("itmItemAllSearch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Double comCurrRatefindRatio(ComCurrRateQueryParamVO param) {
        try {
            return this.comCurrRateService.findRatio(param);
        }
        catch (Exception e) {
            log.error("itmItemAllSearch error:", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ComCurrRespVO> comCurrsearchAll() {
        try {
            List<ComCurrRespVO> comCurrRespVOS = this.comCurrService.searchAll();
            if (!CollectionUtils.isEmpty(comCurrRespVOS)) {
                return comCurrRespVOS;
            }
        }
        catch (Exception e) {
            log.error("itmItemAllSearch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ComCurrRespVO> findCurrByCode(List<String> currCode) {
        try {
            List<ComCurrRespVO> comCurrRespVOS = this.comCurrService.findByCodes(currCode);
            if (!CollectionUtils.isEmpty(comCurrRespVOS)) {
                return comCurrRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findCurrByCode error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmItemPartDTO> itmItemPartSearch(ItmItemPartParam param) {
        try {
            List itmItemPartDTOS = this.itmItemRemoteService.itmItemPartSearch(param);
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                List sysUdcComboVOS = this.sysUdcService.listCodeCombos("COM", "UOM");
                itmItemPartDTOS.stream().forEach(v -> {
                    Optional<SysUdcComboVO> first;
                    if (!StringUtils.isEmpty((Object)v.getUom()) && (first = sysUdcComboVOS.stream().filter(t -> v.getUom().equals(t.getUdcVal())).findFirst()).isPresent()) {
                        v.setUomName(first.get().getValDesc());
                    }
                });
                return itmItemPartDTOS;
            }
        }
        catch (Exception e) {
            log.error("itmItemPartSearch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    @SysCodeProc
    public List<ItmItemPoDTO> itmItemPOSearch(ItmItemPartParam param) {
        try {
            List itmItemPoDTOS = this.itmItemRemoteService.itmItemPOSearch(param);
            if (!CollectionUtils.isEmpty((Collection)itmItemPoDTOS)) {
                List sysUdcComboVOS = this.sysUdcService.listCodeCombos("COM", "UOM");
                itmItemPoDTOS.stream().forEach(v -> {
                    Optional<SysUdcComboVO> first;
                    if (!StringUtils.isEmpty((Object)v.getUom()) && (first = sysUdcComboVOS.stream().filter(t -> v.getUom().equals(t.getUdcVal())).findFirst()).isPresent()) {
                        v.setUomName(first.get().getValDesc());
                    }
                });
                return itmItemPoDTOS;
            }
        }
        catch (Exception e) {
            log.error("itmItemAllSearch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmItemDTO> itmItemAllSearch(ItmItemPartParam param) {
        try {
            List itmItemDTOS = this.itmItemRemoteService.itmItemAllSearch(param);
            if (!CollectionUtils.isEmpty((Collection)itmItemDTOS)) {
                return itmItemDTOS;
            }
        }
        catch (Exception e) {
            log.error("itmItemAllSearch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmReBrandDTO> itmBrandRemoteSearch(List<String> brandCodeList) {
        try {
            List itmReBrandDTOS = this.itmBrandRemoteService.itmBrandRemoteSearch(brandCodeList);
            if (!CollectionUtils.isEmpty((Collection)itmReBrandDTOS)) {
                return itmReBrandDTOS;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDInfoByBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmBrandPartDTO> itmBrandPartSearch(ItmBrandPartParam param) {
        try {
            List itmBrandPartDTOS = this.itmBrandRemoteService.itmBrandPartSearch(param);
            if (!CollectionUtils.isEmpty((Collection)itmBrandPartDTOS)) {
                return itmBrandPartDTOS;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDInfoByBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmBrandAllDTO> itmBrandAllSearch(ItmBrandPartParam param) {
        try {
            List itmBrandAllDTOS = this.itmBrandRemoteService.itmBrandAllSearch(param);
            if (!CollectionUtils.isEmpty((Collection)itmBrandAllDTOS)) {
                return itmBrandAllDTOS;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDInfoByBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<PurPoRespVO> findPurPoByIdBatch(List<Long> poIds) {
        try {
            List idBatch = this.purPoService.findIdBatch(poIds);
            if (!CollectionUtils.isEmpty((Collection)idBatch)) {
                return idBatch;
            }
        }
        catch (Exception e) {
            log.error("findPurPoByIdList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Integer updatePurPoQty(PurPoSaveVO purPoSaveVO) {
        try {
            this.purPoService.update(purPoSaveVO);
            return 0;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u53d1\u8d27\u6570\u91cf\u5f02\u5e38:", (Throwable)e);
            return 1;
        }
    }

    @Override
    public Optional<PurPoRespVO> findPoById(Long poId) {
        try {
            Optional purPoRespVO = this.purPoService.findIdOne(poId);
            if (purPoRespVO.isPresent()) {
                return purPoRespVO;
            }
        }
        catch (Exception e) {
            log.error("findPoById error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public Optional<PurPoRespVO> findPurByCodeOne(String code) {
        try {
            Optional purPoRespVO = this.purPoService.findCodeOne(code);
            if (purPoRespVO.isPresent()) {
                return purPoRespVO;
            }
        }
        catch (Exception e) {
            log.error("findPurByCOdeOne:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<PurPoRespVO> findPurPoDocNoBatch(List<String> docNos) {
        try {
            List poRespVOS = this.purPoService.findDocNoBatch(docNos);
            if (!CollectionUtils.isEmpty((Collection)poRespVOS)) {
                return poRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDocNoBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<PurPoDRespVO> findPurPoDInfoByBatch(List<Long> poDids) {
        try {
            List poDRespVOS = this.purPoDService.findIdBatch(poDids);
            if (!CollectionUtils.isEmpty((Collection)poDRespVOS)) {
                return poDRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDInfoByBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public void addShippedQty(PurPoDUpdateParamVO purPoDUpdateParamVO) {
        try {
            this.purPoDService.addShippedQty(purPoDUpdateParamVO);
            return;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u53d1\u8d27\u6570\u91cf\u5f02\u5e38:", (Throwable)e);
            return;
        }
    }

    @Override
    public List<PurPoDRespVO> findPurPoDByBatch(List<Long> idList) {
        try {
            List purPoDRespVOS = this.purPoDService.findIdBatch(idList);
            if (!CollectionUtils.isEmpty((Collection)purPoDRespVOS)) {
                return purPoDRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findPurByCOdeOne:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<PurPoDRespVO> findPurPoDByMasId(Long masId) {
        try {
            List purPoDRespVOS = this.purPoDService.findMasId(masId);
            if (!CollectionUtils.isEmpty((Collection)purPoDRespVOS)) {
                return purPoDRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDByMasId error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<PurPoDRespVO> findPurPoDInfoById(Long poDid) {
        try {
            Optional purPoDRespVO = this.purPoDService.findIdOne(poDid);
            if (purPoDRespVO.isPresent()) {
                return purPoDRespVO;
            }
        }
        catch (Exception e) {
            log.error("findPurPoDInfoById error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public Integer addPurPoDAcceptQty(PurPoDUpdateParamVO purPoDUpdateParamVO) {
        try {
            this.purPoDService.addAcceptQty(purPoDUpdateParamVO);
            return 0;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u6570\u91cf\u5f02\u5e38:", (Throwable)e);
            return 1;
        }
    }

    @Override
    public List<PurSuppRespVO> findSuppByIdBatch(List<Long> suppIds) {
        try {
            List idBatch = this.purSuppService.findIdBatch(suppIds);
            if (!CollectionUtils.isEmpty((Collection)idBatch)) {
                return idBatch;
            }
        }
        catch (Exception e) {
            log.error("findSuppByIdBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgRespVO> findSpuuByParam(OrgQueryParamVO param) {
        try {
            List respVOS = this.purSuppService.findcodeAndName(param);
            if (!CollectionUtils.isEmpty((Collection)respVOS)) {
                return respVOS;
            }
        }
        catch (Exception e) {
            log.error("findSpuuByParam error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<PurSuppRespVO> findIdPurSuppOne(Long id) {
        try {
            Optional param = this.purSuppService.findIdOne(id);
            if (param.isPresent()) {
                return param;
            }
        }
        catch (Exception e) {
            log.error("findPurByCOdeOne:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public Optional<PurSceneRespVO> findPurSceneOne(String code) {
        try {
            Optional sceneRespVO = this.purSceneService.findCodeOne(code);
            if (sceneRespVO.isPresent()) {
                return sceneRespVO;
            }
        }
        catch (Exception e) {
            log.error("findPurSceneOne error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<PurSceneRespVO> findCodeBatch(List<String> genTypes) {
        try {
            List sceneRespVOS = this.purSceneService.findCodeBatch(genTypes);
            if (!CollectionUtils.isEmpty((Collection)sceneRespVOS)) {
                return sceneRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findCodeBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgRespVO> findcodeAndName(OrgQueryParamVO param) {
        try {
            List orgRespVOList = this.outPurService.findcodeAndName(param);
            if (!CollectionUtils.isEmpty((Collection)orgRespVOList)) {
                return orgRespVOList;
            }
        }
        catch (Exception e) {
            log.error("findBdIdBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    private void translate(List<OrgAddrAddressRespVO> lists) {
        List<String> countries = lists.stream().map(OrgAddrAddressRespVO::getCountry).distinct().collect(Collectors.toList());
        List provinces = lists.stream().map(OrgAddrAddressRespVO::getProvince).distinct().collect(Collectors.toList());
        List cities = lists.stream().map(OrgAddrAddressRespVO::getCity).distinct().collect(Collectors.toList());
        List county = lists.stream().map(OrgAddrAddressRespVO::getCounty).distinct().collect(Collectors.toList());
        countries.addAll(provinces);
        countries.addAll(cities);
        countries.addAll(county);
        List<ComDistrictComboVO> comDistrictComboVOS = this.comDistrictService.getByDistCodes(countries);
        lists.forEach(VO -> {
            Optional<ComDistrictComboVO> comboVOOptional4;
            Optional<ComDistrictComboVO> comboVOOptional3;
            Optional<ComDistrictComboVO> comboVOOptional2;
            Optional<ComDistrictComboVO> comboVOOptional1 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCountry())).findFirst();
            if (comboVOOptional1.isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional1.get();
                VO.setCountryName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional2 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getProvince())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional2.get();
                VO.setProvinceName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional3 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCity())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional3.get();
                VO.setCityName(comDistrictComboVO.getName());
            }
            if ((comboVOOptional4 = comDistrictComboVOS.stream().filter(d -> d.getCode().equals(VO.getCounty())).findFirst()).isPresent()) {
                ComDistrictComboVO comDistrictComboVO = comboVOOptional4.get();
                VO.setCountyName(comDistrictComboVO.getName());
            }
        });
    }

    public OutserviceImpl(OrgCustService orgCustService, OrgOuService orgOuService, OrgOuRepo orgOuRepo, OrgEmpService orgEmpservice, OrgAddrAddressRepo orgAddrAddressRepo, OrgAddrAddressRepoProc orgAddrAddressRepoProc, ComDistrictService comDistrictService, OrgCustRepo orgCustRepo, OrgCustRepoProc orgCustRepoProc, ComPaymentTermService comPaymentTermService, ComCurrRateService comCurrRateService, ComCurrService comCurrService, SysUserRepo sysUserRepo, OrgEmpService orgEmpService, SysUdcService sysUdcService) {
        this.orgCustService = orgCustService;
        this.orgOuService = orgOuService;
        this.orgOuRepo = orgOuRepo;
        this.orgEmpservice = orgEmpservice;
        this.orgAddrAddressRepo = orgAddrAddressRepo;
        this.orgAddrAddressRepoProc = orgAddrAddressRepoProc;
        this.comDistrictService = comDistrictService;
        this.orgCustRepo = orgCustRepo;
        this.orgCustRepoProc = orgCustRepoProc;
        this.comPaymentTermService = comPaymentTermService;
        this.comCurrRateService = comCurrRateService;
        this.comCurrService = comCurrService;
        this.sysUserRepo = sysUserRepo;
        this.orgEmpService = orgEmpService;
        this.sysUdcService = sysUdcService;
    }
}

