/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pln.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.excel.listener.DchExcelEntityDataListener;
import com.elitesland.pln.convert.PlnItemPropConvert;
import com.elitesland.pln.service.PlnItemPropService;
import com.elitesland.pln.vo.param.PlnItemPropParamVO;
import com.elitesland.pln.vo.resp.PlnItemPropRespVO;
import com.elitesland.pln.vo.resp.PlnItemPropRptRespVO;
import com.elitesland.pln.vo.save.PlnItemPropImportSaveVO;
import com.elitesland.pln.vo.save.PlnItemPropSaveVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/pln/plnItemProp"})
@Api(value="\u54c1\u9879\u8ba1\u5212\u5c5e\u6027", tags={"\u54c1\u9879\u8ba1\u5212\u5c5e\u6027"})
public class PlnItemPropController {
    private final PlnItemPropService plnItemPropService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58(\u65b0\u589e/\u4fee\u6539/\u5220\u9664)")
    public ApiResult<Object> createBatch(@RequestBody List<PlnItemPropSaveVO> list) {
        List idList = this.plnItemPropService.creatPlnItem(list);
        return ApiResult.ok((Object)idList.toString());
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<PlnItemPropRespVO>> search(@RequestBody PlnItemPropParamVO param) {
        PagingVO ret = this.plnItemPropService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/findByIdBatch"})
    @ApiOperation(value="\u901a\u8fc7ids\u67e5\u8be2\u591a\u6761\u6570\u636e")
    ApiResult<List<PlnItemPropRespVO>> findIdBatch(@RequestBody List<Long> ids) {
        return ApiResult.ok((Object)this.plnItemPropService.findIdBatch(ids));
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        this.plnItemPropService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, @RequestBody PlnItemPropParamVO param) throws IOException {
        param.setSize(Integer.valueOf(2000));
        List ret = this.plnItemPropService.search(param).getRecords().stream().map(PlnItemPropConvert.INSTANCE::voToRptVo).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, ret, PlnItemPropRptRespVO.class, "\u5546\u54c1\u8ba1\u5212\u53c2\u6570", "\u5546\u54c1\u8ba1\u5212\u53c2\u6570");
    }

    @GetMapping(value={"/brand_template"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void getBrandTemplate(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u5546\u54c1\u8ba1\u5212\u53c2\u6570\u5bfc\u5165", StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).build();
        WriteSheet writeSheetA = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)"\u5546\u54c1\u8ba1\u5212\u53c2\u6570-\u54c1\u724c\u5bfc\u5165").head(PlnItemPropImportSaveVO.class)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        excelWriter.write(new ArrayList(), writeSheetA);
        WriteSheet writeSheetB = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)"\u54c1\u724c\u7f16\u7801\u5bf9\u7167\u8868").head(List.of(List.of("\u54c1\u724c\u4ee3\u7801"), List.of("\u54c1\u724c\u540d")))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        List brand = Collections.emptyList();
        excelWriter.write(brand.stream().map(v -> List.of(v.getC2Code(), v.getC2Name())).collect(Collectors.toList()), writeSheetB);
        excelWriter.finish();
    }

    @PostMapping(value={"importByBrand"})
    @ApiOperation(value="\u6309\u54c1\u724c\u5bfc\u5165")
    public ApiResult<Map<String, List<?>>> importByBrand(@RequestBody MultipartFile file) {
        DchExcelEntityDataListener dchExcelDataListener = new DchExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), PlnItemPropImportSaveVO.class, dchExcelDataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List data = dchExcelDataListener.getDatas();
        return ApiResult.ok((Object)this.plnItemPropService.importByBrand(data));
    }

    @PostMapping(value={"/saveDO"})
    @ApiOperation(value="\u4fdd\u5b58(\u65b0\u589e/\u4fee\u6539/\u5220\u9664)")
    public ApiResult<Object> createDOBatch(@RequestBody List<PlnItemPropSaveVO> list) {
        List idList = this.plnItemPropService.creatPlnItem(list);
        return ApiResult.ok((Object)idList.toString());
    }

    public PlnItemPropController(PlnItemPropService plnItemPropService) {
        this.plnItemPropService = plnItemPropService;
    }
}

