/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pln.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.dto.ComC2VO;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.resp.InvSuppRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.out.service.OutService;
import com.elitesland.pln.convert.PlnItemPropConvert;
import com.elitesland.pln.entity.PlnItemPropDO;
import com.elitesland.pln.entity.QPlnItemPropDO;
import com.elitesland.pln.repo.PlnItemPropRepo;
import com.elitesland.pln.repo.PlnItemPropRepoProc;
import com.elitesland.pln.service.PlnItemPropService;
import com.elitesland.pln.vo.param.PlnItemPropParamVO;
import com.elitesland.pln.vo.resp.PlnItemPropRespVO;
import com.elitesland.pln.vo.save.PlnItemPropImportSaveVO;
import com.elitesland.pln.vo.save.PlnItemPropSaveVO;
import com.elitesland.pur.vo.resp.PurSuppRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.vo.SysUserVO;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="plnItemPropService")
public class PlnItemPropServiceImpl
implements PlnItemPropService {
    private final PlnItemPropRepo plnItemPropRepo;
    private final PlnItemPropRepoProc plnItemPropRepoProc;
    private final InvWhService invWhService;
    private final OutService outService;

    @Transactional
    public List<Long> creatPlnItem(List<PlnItemPropSaveVO> list) {
        Map<Long, List<PlnItemPropSaveVO>> itemIdMap = list.stream().collect(Collectors.groupingBy(PlnItemPropSaveVO::getItemId));
        for (Long itemId : itemIdMap.keySet()) {
            List<PlnItemPropSaveVO> itemPropVOS = itemIdMap.get(itemId);
            Map<Long, List<PlnItemPropSaveVO>> whIdMap = itemPropVOS.stream().collect(Collectors.groupingBy(PlnItemPropSaveVO::getWhId));
            for (Long whId : whIdMap.keySet()) {
                if (whIdMap.get(whId).size() <= 1) continue;
                throw new BusinessException(ApiCode.FAIL, "\u4e0d\u80fd\u51fa\u73b0\u5546\u54c1\u548c\u4ed3\u5e93\u91cd\u590d\u7684\u6570\u636e!");
            }
        }
        for (PlnItemPropSaveVO VO : list) {
            List redundantIds = this.plnItemPropRepoProc.selectRedundant(VO.getId(), VO.getItemId(), VO.getWhId()).fetch();
            if (VO.getId() == null || redundantIds.size() <= 0) continue;
            VO.setId((Long)redundantIds.get(0));
        }
        List plnItemPropDOS = list.stream().map(PlnItemPropConvert.INSTANCE::voToDO).collect(Collectors.toList());
        return this.plnItemPropRepo.saveAll(plnItemPropDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @SysCodeProc
    public PagingVO<PlnItemPropRespVO> search(PlnItemPropParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.plnItemPropRepoProc.select(null).where(this.plnItemPropRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        this.plnItemPropRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QPlnItemPropDO.plnItemPropDO);
        List lists = jpaQuery.fetch();
        List<PlnItemPropRespVO> plnItemPropVOList = this.splicingVO(lists);
        PagingVO paging = new PagingVO();
        paging.setRecords(plnItemPropVOList.stream().map(i -> (PlnItemPropRespVO)BeanUtil.copyProperties((Object)i, PlnItemPropRespVO.class)).collect(Collectors.toList()));
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @SysCodeProc
    public Optional<PlnItemPropRespVO> findCodeOne(String itemCode) {
        JPAQuery<PlnItemPropRespVO> jpaQuery = this.plnItemPropRepoProc.select(null);
        QPlnItemPropDO jpaQDo = QPlnItemPropDO.plnItemPropDO;
        PlnItemPropRespVO vo = (PlnItemPropRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<PlnItemPropRespVO> findIdOne(Long id) {
        return this.plnItemPropRepo.findById(id).map(PlnItemPropConvert.INSTANCE::doToVO);
    }

    @Transactional
    public Long createOne(PlnItemPropSaveVO plnItemPropVO) {
        return ((PlnItemPropDO)this.plnItemPropRepo.save(PlnItemPropConvert.INSTANCE.voToDO(plnItemPropVO))).getId();
    }

    @SysCodeProc
    public List<PlnItemPropRespVO> findIdBatch(List<Long> idList) {
        List<PlnItemPropRespVO> list = this.plnItemPropRepo.findAllById(idList).stream().map(PlnItemPropConvert.INSTANCE::doToVO).collect(Collectors.toList());
        List<PlnItemPropRespVO> plnItemPropVOS = this.splicingVO(list);
        List<PlnItemPropRespVO> respVOS = plnItemPropVOS.stream().map(vo -> (PlnItemPropRespVO)BeanUtil.copyProperties((Object)vo, PlnItemPropRespVO.class)).collect(Collectors.toList());
        return respVOS;
    }

    @Transactional
    public List<Long> createBatch(List<PlnItemPropSaveVO> list) {
        List plnItemPropDOS = list.stream().map(PlnItemPropConvert.INSTANCE::voToDO).collect(Collectors.toList());
        return this.plnItemPropRepo.saveAll(plnItemPropDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(PlnItemPropSaveVO objVo) {
        Optional optional = this.plnItemPropRepo.findById(objVo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objVo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objVo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objVo));
        this.plnItemPropRepo.save((PlnItemPropDO)optional.get());
    }

    @Transactional
    public void deleteOne(Long id) {
        this.plnItemPropRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        if (null == list || list.size() == 0) {
            return;
        }
        this.plnItemPropRepoProc.updateDelFlat(list).execute();
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QPlnItemPropDO jpaQDo = QPlnItemPropDO.plnItemPropDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.plnItemPropRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        PlnItemPropDO do1 = (PlnItemPropDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.plnItemPropRepo.save(do1);
    }

    private List<PlnItemPropRespVO> splicingVO(List<PlnItemPropRespVO> lists) {
        List itemIdS = lists.stream().map(PlnItemPropRespVO::getItemId).distinct().collect(Collectors.toList());
        List whIds = lists.stream().map(PlnItemPropRespVO::getWhId).distinct().collect(Collectors.toList());
        List<Long> calcEmpIds = lists.stream().map(PlnItemPropRespVO::getCalcEmpId).distinct().collect(Collectors.toList());
        List purEmpIds = lists.stream().map(PlnItemPropRespVO::getPurEmpId).distinct().collect(Collectors.toList());
        List<Long> suppIds = lists.stream().map(PlnItemPropRespVO::getSuppId).distinct().collect(Collectors.toList());
        List brandCodes = lists.stream().map(PlnItemPropRespVO::getBrand).distinct().collect(Collectors.toList());
        calcEmpIds.removeAll(purEmpIds);
        calcEmpIds.addAll(purEmpIds);
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemIdS);
        List<ItmItemDTO> itemDTOS = this.outService.itmItemAllSearch(partParam);
        List invWhRespVOS = this.invWhService.findIdBatch(whIds);
        List<PurSuppRespVO> suppRespVOS = this.outService.findSuppByIdBatch(suppIds);
        List<SysUserVO> empVOS = this.outService.findAllEmpsByIdIn(calcEmpIds);
        List comC2VOS = Collections.emptyList();
        lists.forEach(vo -> {
            Optional<PurSuppRespVO> orgSuppVO;
            Optional<ItmItemDTO> itmItemVO;
            if (!CollectionUtils.isEmpty((Collection)itemDTOS) && (itmItemVO = itemDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst()).isPresent()) {
                ItmItemDTO itemVO = itmItemVO.get();
                vo.setItemCode(itemVO.getItemCode());
                vo.setItemName(itemVO.getItemName());
                vo.setBrand(itemVO.getBrand());
            }
            Optional<InvWhRespVO> orgWhVO = invWhRespVOS.stream().filter(v -> v.getId().equals(vo.getWhId())).findFirst();
            if (!CollectionUtils.isEmpty((Collection)suppRespVOS) && (orgSuppVO = suppRespVOS.stream().filter(v -> v.getId().equals(vo.getSuppId())).findFirst()).isPresent()) {
                PurSuppRespVO suppVO = orgSuppVO.get();
                vo.setSuppCode(suppVO.getSuppCode());
                vo.setSuppName(suppVO.getSuppName());
            }
            if (!CollectionUtils.isEmpty((Collection)empVOS)) {
                SysUserVO sysUserDO;
                Optional<SysUserVO> calcEmpVO = empVOS.stream().filter(v -> v.getId().equals(vo.getCalcEmpId())).findFirst();
                Optional<SysUserVO> purEmpVO = empVOS.stream().filter(v -> v.getId().equals(vo.getPurEmpId())).findFirst();
                if (calcEmpVO.isPresent()) {
                    sysUserDO = calcEmpVO.get();
                    vo.setCalcEmpCode(sysUserDO.getUsername());
                    vo.setCalcEmpName(sysUserDO.getFirstName());
                }
                if (purEmpVO.isPresent()) {
                    sysUserDO = purEmpVO.get();
                    vo.setPurEmpCode(sysUserDO.getUsername());
                    vo.setPurEmpName(sysUserDO.getFirstName());
                }
            }
            Optional<ComC2VO> comC2VO = comC2VOS.stream().filter(v -> v.getC2Code().equals(vo.getBrand())).findFirst();
            comC2VO.ifPresent(C2VO -> vo.setBrandName(C2VO.getC2Name()));
            if (orgWhVO.isPresent()) {
                InvWhRespVO whVO = orgWhVO.get();
                vo.setWhCode(whVO.getWhCode());
                vo.setWhName(whVO.getWhName());
            }
        });
        return lists;
    }

    public Map<String, List<?>> importByBrand(List<PlnItemPropImportSaveVO> importVOS) {
        List itmItemVOS = Collections.emptyList();
        List comC2VOS = Collections.emptyList();
        List invWhRespVOS = this.invWhService.findByCodes(importVOS.stream().map(PlnItemPropImportSaveVO::getWhCode).distinct().collect(Collectors.toList()));
        List brandsWithNoSupp = importVOS.stream().filter(v -> v.getSuppCode() == null).map(PlnItemPropImportSaveVO::getBrand).distinct().collect(Collectors.toList());
        List absentAgency = itmItemVOS.stream().filter(v -> brandsWithNoSupp.contains(v.getBrand())).map(ItmItemVO::getAgency).distinct().collect(Collectors.toList());
        List InvSuppRespVOS = Collections.emptyList();
        List presentSuppCodes = importVOS.stream().map(PlnItemPropImportSaveVO::getSuppCode).distinct().collect(Collectors.toList());
        if (!presentSuppCodes.isEmpty()) {
            InvSuppRespVOS.addAll(Collections.emptyList());
        }
        importVOS.forEach(v -> {
            if (v.getSuppCode() == null) {
                v.setSuppCode(InvSuppRespVOS.stream().filter(supp -> supp.getAgencyCode().equals(itmItemVOS.stream().filter(u -> u.getBrand().equals(v.getBrand())).findFirst().map(ItmItemVO::getAgency).orElse(""))).findAny().map(InvSuppRespVO::getSuppCode).orElseThrow(new BusinessException("\u627e\u4e0d\u5230\u54c1\u724c" + v.getBrand() + "\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u7f16\u7801")));
            }
        });
        InvSuppRespVOS.addAll(InvSuppRespVOS.stream().filter(v -> !InvSuppRespVOS.contains(v)).collect(Collectors.toList()));
        ArrayList plnItemPropVOS = new ArrayList();
        importVOS.forEach(importVO -> {
            ComC2VO comC2VO = comC2VOS.stream().filter(v -> v.getC2Code().equals(importVO.getBrand())).findAny().orElseThrow(new BusinessException("\u627e\u4e0d\u5230" + importVO.getBrand() + "\u5bf9\u5e94\u54c1\u724c"));
            InvWhRespVO invWhRespVO = invWhRespVOS.stream().filter(v -> v.getWhCode().equals(importVO.getWhCode())).findAny().orElseThrow(new BusinessException("\u627e\u4e0d\u5230" + importVO.getWhCode() + "\u5bf9\u5e94\u4ed3\u5e93"));
            InvSuppRespVO InvSuppRespVO2 = InvSuppRespVOS.stream().filter(v -> v.getSuppCode().equals(importVO.getSuppCode())).findAny().orElse(new InvSuppRespVO());
            importVO.setBrandName(comC2VO.getC2Name());
            importVO.setSuppName(InvSuppRespVO2.getSuppName());
            importVO.setWhName(invWhRespVO.getWhName());
            plnItemPropVOS.addAll(itmItemVOS.stream().filter(v -> v.getBrand().equals(importVO.getBrand())).map(itemVO -> {
                PlnItemPropRespVO propVO = new PlnItemPropRespVO();
                propVO.setItemId(itemVO.getId());
                propVO.setItemCode(itemVO.getItemCode());
                propVO.setItemName(itemVO.getItemName());
                propVO.setWhId(invWhRespVO.getId());
                propVO.setWhCode(importVO.getWhCode());
                propVO.setWhName(invWhRespVO.getWhName());
                propVO.setSuppId(InvSuppRespVO2.getId());
                propVO.setSuppCode(importVO.getSuppCode());
                propVO.setSuppName(InvSuppRespVO2.getSuppName());
                propVO.setBrand(itemVO.getBrand());
                propVO.setBrandName(comC2VO.getC2Name());
                propVO.setReplePolicy(importVO.getReplePolicy());
                propVO.setRepleFrequencyDays(importVO.getRepleFrequencyDays());
                propVO.setOnelevelLeadDays(importVO.getOnelevelLeadDays());
                propVO.setRepleCoverDays(importVO.getRepleCoverDays());
                propVO.setSafeDays(importVO.getSafeDays());
                propVO.setDefaultPercentRatio(importVO.getDefaultPercentRatio());
                propVO.setDeleteFlag(Integer.valueOf(0));
                return propVO;
            }).collect(Collectors.toList()));
        });
        HashMap resultMap = new HashMap();
        resultMap.put("upper", importVOS);
        resultMap.put("lower", plnItemPropVOS);
        return resultMap;
    }

    public PlnItemPropServiceImpl(PlnItemPropRepo plnItemPropRepo, PlnItemPropRepoProc plnItemPropRepoProc, InvWhService invWhService, OutService outService) {
        this.plnItemPropRepo = plnItemPropRepo;
        this.plnItemPropRepoProc = plnItemPropRepoProc;
        this.invWhService = invWhService;
        this.outService = outService;
    }
}

