/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.pur.service.PurGrService;
import com.elitesland.pur.service.PurTaskService;
import com.elitesland.pur.vo.constant.TaskEnum;
import com.elitesland.pur.vo.param.PurGrParamVO;
import com.elitesland.pur.vo.resp.PurGrRespVO;
import com.elitesland.pur.vo.save.PurGrBackSaveVO;
import com.elitesland.pur.vo.save.PurGrExelSaveVO;
import com.elitesland.pur.vo.save.PurGrSaveVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pur/purGr"})
@Api(value="\u91c7\u8d2d\u6536\u8d27\u5355", tags={"\u91c7\u8d2d\u6536\u8d27\u5355"})
public class PurGrController {
    private final PurGrService purGrService;
    private final PurTaskService purTaskService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<PurGrRespVO>> search(@RequestBody PurGrParamVO param) {
        PagingVO ret = this.purGrService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\uff08\u66f4\u65b0\uff09\u91c7\u8d2d\u6536\u8d27\u5355")
    public ApiResult<Object> createPurGr(@RequestBody PurGrSaveVO createParam) {
        Long id = this.purGrService.createPurGr(createParam);
        return ApiResult.ok((Object)id.toString());
    }

    @PutMapping(value={"/confirm/{id}"})
    @ApiOperation(value="\u786e\u8ba4\u91c7\u8d2d\u6536\u8d27\u5355")
    public ApiResult<Object> confirm(@PathVariable(value="id") Long id) {
        this.purGrService.confirm(id);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("taskModel", TaskEnum.PUR_GR_COMFIRM.getTaskModel());
        return ApiResult.ok(data);
    }

    @PostMapping(value={"/submit"})
    @ApiOperation(value="\u63d0\u4ea4\u91c7\u8d2d\u6536\u8d27\u5355")
    public ApiResult<Object> submitPurGr(@RequestBody PurGrSaveVO createParam) {
        Long id = this.purGrService.submitPurGr(createParam);
        return ApiResult.ok((Object)id.toString());
    }

    @PutMapping(value={"/confirmReceipt/{id}/{recvEmpId}"})
    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u786e\u8ba4")
    public ApiResult<Object> confirmReceipt(@PathVariable(value="id") Long id, @PathVariable(value="recvEmpId") Long recvEmpId) {
        String taskId = this.purTaskService.applyTask(TaskEnum.PUR_GR_COMFIRM);
        CompletableFuture.runAsync(() -> {
            try {
                this.purGrService.confirmReceipt(id, recvEmpId);
            }
            catch (Exception e) {
                this.purTaskService.appenErrorMsg(TaskEnum.PUR_GR_COMFIRM, taskId, e.getMessage());
            }
            finally {
                this.purTaskService.updateProgress(TaskEnum.PUR_GR_COMFIRM, taskId);
            }
        });
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("taskId", taskId);
        data.put("taskModel", TaskEnum.PUR_GR_COMFIRM.getTaskModel());
        return ApiResult.ok(data);
    }

    @PostMapping(value={"/changePurGr"})
    @ApiOperation(value="\u91c7\u8d2d\u6536\u8d27\u5355\u4fee\u6539")
    public ApiResult<Object> changePurGr(@RequestBody PurGrBackSaveVO purGrBackSaveVO) {
        this.purGrService.changePurGr(purGrBackSaveVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u91c7\u8d2d\u6a21\u5757\u2014\u2014\u91c7\u8d2d\u8ba2\u5355\u2014\u5bfc\u51fa\u6570\u636e")
    public void exportOB(HttpServletResponse response, @RequestBody PurGrParamVO param) throws IOException, ExecutionException, InterruptedException {
        param.setSize(Integer.valueOf(20000));
        PagingVO ret = this.purGrService.search(param);
        List records = ret.getRecords();
        List dos = records.stream().map(i -> {
            PurGrExelSaveVO DO = new PurGrExelSaveVO();
            BeanUtils.copyProperties((Object)i, (Object)DO);
            DO.setModifyTime(LocalDateTime.now());
            DO.setCreateTime(LocalDateTime.now());
            return DO;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, records, PurGrExelSaveVO.class, "\u91c7\u8d2d\u6536\u8d27\u767b\u8bb0", "\u91c7\u8d2d\u6536\u8d27\u767b\u8bb0");
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        this.purGrService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ApiResult<PurGrRespVO> findIdOne(@PathVariable Long id) {
        return this.purGrService.findIdPurGr(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    public PurGrController(PurGrService purGrService, PurTaskService purTaskService) {
        this.purGrService = purGrService;
        this.purTaskService = purTaskService;
    }
}

