/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.controller;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.ApiResult;
import com.elitesland.core.base.PagingVO;
import com.elitesland.pur.service.PurSs2Service;
import com.elitesland.pur.vo.param.PurSsParamVO;
import com.elitesland.pur.vo.resp.PurSsRespVO;
import com.elitesland.pur.vo.save.PurSsDownloadSaveVO;
import com.elitesland.pur.vo.save.PurSsEmailSaveVO;
import com.elitesland.pur.vo.save.PurSsExeSaveVO;
import com.elitesland.pur.vo.save.PurSsSaveVO;
import com.elitesland.util.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pur/purSs"})
@Api(value="\u4f9b\u5e94\u5546\u53d1\u8d27\u5355", tags={"\u4f9b\u5e94\u5546\u53d1\u8d27\u5355"})
public class PurSsController {
    private final PurSs2Service purSs2Service;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<PurSsRespVO>> search(@RequestBody PurSsParamVO param) {
        PagingVO ret = this.purSs2Service.searchPurSs(param);
        return ApiResult.ok((Object)ret);
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ApiResult<PurSsRespVO> findIdOne(@PathVariable Long id) {
        return this.purSs2Service.findPurSsOne(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\uff08\u66f4\u65b0\uff09\u4f9b\u5e94\u5546\u53d1\u8d27\u5355")
    public ApiResult<Object> createPurSs(@RequestBody PurSsSaveVO createParam) {
        Long id = this.purSs2Service.createPurSs(createParam);
        return ApiResult.ok((Object)id.toString());
    }

    @PostMapping(value={"/submit"})
    @ApiOperation(value="\u63d0\u4ea4\u4f9b\u5e94\u5546\u53d1\u8d27\u5355")
    public ApiResult<Object> submitPurSs(@RequestBody PurSsSaveVO createParam) {
        Long id = this.purSs2Service.submitPurSs(createParam);
        return ApiResult.ok((Object)id.toString());
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u53d6\u6d88")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        this.purSs2Service.deleteBatchPurSs(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/sendMail"})
    @ApiOperation(value="\u53d1\u9001\u90ae\u4ef6")
    public ApiResult<Object> sendMail(@RequestBody PurSsEmailSaveVO param) {
        this.purSs2Service.sendMail(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/downloadPurSs"})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u8d27\u4fe1\u606f")
    public void downloadPurSs(HttpServletResponse response, @RequestBody PurSsParamVO param) throws IOException {
        PagingVO ret = this.purSs2Service.searchPurSs(param);
        List list = ret.getRecords();
        List collect = list.stream().map(i -> {
            PurSsDownloadSaveVO downloadVO = new PurSsDownloadSaveVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            return downloadVO;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, collect, PurSsDownloadSaveVO.class, "\u4f9b\u5e94\u5546\u53d1\u8d27\u4fe1\u606f", "\u4f9b\u5e94\u5546\u53d1\u8d27\u4fe1\u606f");
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u91c7\u8d2d\u6a21\u5757\u2014\u2014\u91c7\u8d2d\u8ba2\u5355\u2014\u5bfc\u51fa\u6570\u636e")
    public void exportOB(HttpServletResponse response, @RequestBody PurSsParamVO param) throws IOException, ExecutionException, InterruptedException {
        param.setSize(Integer.valueOf(20000));
        PagingVO ret = this.purSs2Service.searchPurSs(param);
        List records = ret.getRecords();
        List dos = records.stream().map(i -> {
            PurSsExeSaveVO DO = new PurSsExeSaveVO();
            BeanUtils.copyProperties((Object)i, (Object)DO);
            return DO;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, dos, PurSsExeSaveVO.class, "\u4f9b\u5e94\u5546\u53d1\u8d27\u5355", "\u91c7\u8d2d\u6536\u8d27\u767b\u8bb0");
    }

    public PurSsController(PurSs2Service purSs2Service) {
        this.purSs2Service = purSs2Service;
    }
}

