/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.service;

import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.pur.convert.PurGrDCovert;
import com.elitesland.pur.entity.PurGrDDO;
import com.elitesland.pur.entity.QPurGrDDO;
import com.elitesland.pur.repo.PurGrDRepo;
import com.elitesland.pur.repo.PurGrDRepoProc;
import com.elitesland.pur.service.PurGrDService;
import com.elitesland.pur.vo.param.PurGrDParamVO;
import com.elitesland.pur.vo.resp.PurGrDRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purGrDService")
public class PurGrDServiceImpl
implements PurGrDService {
    private final PurGrDRepo purGrDRepo;
    private final PurGrDRepoProc purGrDRepoProc;

    @SysCodeProc
    public PagingVO<PurGrDRespVO> search(PurGrDParamVO param) {
        Page ret = this.purGrDRepo.findAll(this.purGrDRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(PurGrDCovert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<PurGrDRespVO> findCodeOne(String itemCode) {
        JPAQuery<PurGrDRespVO> jpaQuery = this.purGrDRepoProc.select(null);
        QPurGrDDO jpaQDo = QPurGrDDO.purGrDDO;
        PurGrDRespVO vo = (PurGrDRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<PurGrDRespVO> findIdOne(Long id) {
        return this.purGrDRepo.findById(id).map(PurGrDCovert.INSTANCE::doToVO);
    }

    @SysCodeProc
    public List<PurGrDRespVO> findIdBatch(List<Long> idList) {
        return this.purGrDRepo.findAllById(idList).stream().map(PurGrDCovert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(PurGrDRespVO purGrDRespVO) {
        return ((PurGrDDO)this.purGrDRepo.save(PurGrDCovert.INSTANCE.voToDO(purGrDRespVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<PurGrDRespVO> list) {
        return this.purGrDRepo.saveAll(list.stream().map(PurGrDCovert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(PurGrDRespVO objVo) {
        Optional optional = this.purGrDRepo.findById(objVo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objVo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objVo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objVo));
        this.purGrDRepo.save((PurGrDDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QPurGrDDO jpaQDo = QPurGrDDO.purGrDDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.purGrDRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        PurGrDDO do1 = (PurGrDDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.purGrDRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.purGrDRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.purGrDRepo.deleteById(id));
    }

    @SysCodeProc
    public List<PurGrDRespVO> findByMasId(Long masId) {
        PurGrDParamVO param = new PurGrDParamVO();
        param.setMasId(masId);
        JPAQuery<PurGrDRespVO> jpaQuery = this.purGrDRepoProc.select(param);
        List purGrDRespVOS = jpaQuery.fetch();
        return purGrDRespVOS;
    }

    public void deleteByMasId(Long masId) {
        this.purGrDRepo.deleteByMasId(masId);
    }

    @SysCodeProc
    public List<PurGrDRespVO> findByMasIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        JPAQuery<PurGrDRespVO> jpaQuery = this.purGrDRepoProc.select(null);
        QPurGrDDO jpaQDo = QPurGrDDO.purGrDDO;
        jpaQuery.where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()));
        jpaQuery.where((Predicate)jpaQDo.masId.in(idList));
        List purGrDRespVOS = jpaQuery.fetch();
        return purGrDRespVOS;
    }

    public PurGrDServiceImpl(PurGrDRepo purGrDRepo, PurGrDRepoProc purGrDRepoProc) {
        this.purGrDRepo = purGrDRepo;
        this.purGrDRepoProc = purGrDRepoProc;
    }
}

