/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.InvSuppVO;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotStkCommonService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvLotCommon21InVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.InvStkCommon37InVO;
import com.elitesland.inv.vo.PurPoVO;
import com.elitesland.inv.vo.ServiceResult;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.out.vo.resp.ComCurrRespVO;
import com.elitesland.out.vo.resp.OrgEmpRespVO;
import com.elitesland.pur.convert.PurGrCovert;
import com.elitesland.pur.dto.ItmItemuomConvRatioQueryParm;
import com.elitesland.pur.dto.ItmItemuomConvRatioVO;
import com.elitesland.pur.dto.OrgEmpVO;
import com.elitesland.pur.dto.PurRnsVO;
import com.elitesland.pur.dto.SysSettingVO;
import com.elitesland.pur.entity.PurGrDO;
import com.elitesland.pur.entity.QPurGrDO;
import com.elitesland.pur.repo.PurGrDRepo;
import com.elitesland.pur.repo.PurGrDRepoProc;
import com.elitesland.pur.repo.PurGrRepo;
import com.elitesland.pur.repo.PurGrRepoProc;
import com.elitesland.pur.service.PurGrDService;
import com.elitesland.pur.service.PurGrService;
import com.elitesland.pur.service.PurSsDService;
import com.elitesland.pur.service.PurSsService;
import com.elitesland.pur.vo.param.PurGrParamVO;
import com.elitesland.pur.vo.param.PurPoDUpdateParamVO;
import com.elitesland.pur.vo.resp.PurGrDRespVO;
import com.elitesland.pur.vo.resp.PurGrRespVO;
import com.elitesland.pur.vo.resp.PurPoDRespVO;
import com.elitesland.pur.vo.resp.PurPoRespVO;
import com.elitesland.pur.vo.resp.PurSceneRespVO;
import com.elitesland.pur.vo.resp.PurSsDRespVO;
import com.elitesland.pur.vo.resp.PurSsRespVO;
import com.elitesland.pur.vo.resp.PurSuppRespVO;
import com.elitesland.pur.vo.save.PurGrBackSaveVO;
import com.elitesland.pur.vo.save.PurGrDSaveVO;
import com.elitesland.pur.vo.save.PurGrSaveVO;
import com.elitesland.pur.vo.save.PurPoSaveVO;
import com.elitesland.sal.repo.SalDoRepoProc;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.repo.SysUserRepo;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purGrService")
public class PurGrServiceImpl
implements PurGrService {
    private static final Logger log = LoggerFactory.getLogger(PurGrServiceImpl.class);
    private final PurGrRepo purGrRepo;
    private final PurGrDRepo purGrDRepo;
    private final PurGrRepoProc purGrRepoProc;
    private final PurGrDRepoProc purGrDRepoProc;
    private final InvWhService invWhService;
    private final OrgOuService orgOuService;
    private final InvStkCommonService invStkCommonService;
    private final InvLotCommonService invLotCommonService;
    private final SysUserRepo sysUserRepo;
    private final InvLotStkCommonService invLotStkCommonService;
    private final SysNumberRuleService sysNumberRuleService;
    private final PurGrDService purGrDService;
    private final OutService outService;
    private final PurSsService purSsService;
    private final SalDoRepoProc salDoRepoProc;
    private final PurSsDService purSsDService;

    @SysCodeProc
    public PagingVO<PurGrRespVO> search(PurGrParamVO param) {
        Page ret = this.purGrRepo.findAll(this.purGrRepoProc.searchWhere(param), (Pageable)param.getPageRequest());
        List<PurGrRespVO> vos = ret.getContent().stream().map(PurGrCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        this.translate(vos);
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<PurGrRespVO> findCodeOne(String itemCode) {
        JPAQuery<PurGrRespVO> jpaQuery = this.purGrRepoProc.select(null);
        QPurGrDO jpaQDo = QPurGrDO.purGrDO;
        PurGrRespVO vo = (PurGrRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    public List<PurGrRespVO> findByParams(PurGrParamVO queryParam) {
        return this.purGrRepoProc.select(queryParam).fetch();
    }

    public List<PurGrRespVO> findByDocNos(List<String> docNos) {
        if (!CollectionUtils.isEmpty(docNos)) {
            QPurGrDO jpaDo = QPurGrDO.purGrDO;
            Iterable all = this.purGrRepo.findAll((Predicate)jpaDo.deleteFlag.eq((Object)0).or((Predicate)jpaDo.deleteFlag.isNull()).and((Predicate)jpaDo.docNo.in(docNos)));
            return Lists.newArrayList((Iterable)all).stream().map(PurGrCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<PurGrRespVO> findByRelateDoc2No(String relateDocNo) {
        QPurGrDO jpaDo = QPurGrDO.purGrDO;
        Iterable all = this.purGrRepo.findAll((Predicate)jpaDo.deleteFlag.eq((Object)0).or((Predicate)jpaDo.deleteFlag.isNull()).and((Predicate)jpaDo.relateDoc2No.eq((Object)relateDocNo)));
        return Lists.newArrayList((Iterable)all).stream().map(PurGrCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Transactional
    public String confirm(Long id) {
        Optional<PurGrRespVO> optional = this.findIdOne(id);
        if (optional.isEmpty() || !UdcEnum.PUR_GR_STATUS_DR.getValueCode().equals(optional.get().getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5");
        }
        PurGrSaveVO purGrSaveVO = new PurGrSaveVO();
        purGrSaveVO.setId(id);
        purGrSaveVO.setDocStatus(UdcEnum.PUR_GR_STATUS_CF.getValueCode());
        this.update(purGrSaveVO);
        List purGrDRespVOS = this.purGrDService.findByMasId(id);
        PurGrRespVO purGrRespVO = optional.get();
        if (purGrRespVO.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_PO.getValueCode())) {
            this.checkGr(purGrRespVO);
        }
        this.qtyVerify(purGrRespVO, purGrDRespVOS);
        String msg = this.createLot(purGrRespVO, purGrDRespVOS);
        this.unLockInvStk(purGrRespVO, purGrDRespVOS);
        this.changeInvStk(purGrRespVO, purGrDRespVOS);
        return msg;
    }

    @Transactional
    public Long submitPurGr(PurGrSaveVO createParam) {
        Long masId;
        this.verifiesNumber(createParam);
        Optional<PurGrRespVO> optional = this.findIdOne(createParam.getId());
        if (optional.isEmpty()) {
            masId = this.createPurGr(createParam);
        } else if (UdcEnum.PUR_GR_STATUS_DR.getValueCode().equals(optional.get().getDocStatus())) {
            masId = this.createPurGr(createParam);
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u5355\u636e\u624d\u53ef\u63d0\u4ea4");
        }
        PurGrSaveVO purGrSaveVO = new PurGrSaveVO();
        purGrSaveVO.setId(masId);
        purGrSaveVO.setDocStatus(UdcEnum.PUR_SS_STATUS_CF.getValueCode());
        this.update(purGrSaveVO);
        return masId;
    }

    @Transactional
    public String confirmReceipt(Long id, Long recvEmpId) {
        Optional<PurGrRespVO> optional = this.findIdOne(id);
        if (optional.isEmpty() || !UdcEnum.PUR_GR_STATUS_DR.getValueCode().equals(optional.get().getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5");
        }
        PurGrSaveVO purGrSaveVO = new PurGrSaveVO();
        purGrSaveVO.setId(id);
        purGrSaveVO.setRecvEmpId(recvEmpId);
        purGrSaveVO.setRecvDate(LocalDateTime.now());
        purGrSaveVO.setDocStatus(UdcEnum.PUR_GR_STATUS_CF.getValueCode());
        this.update(purGrSaveVO);
        List purGrDRespVOS = this.purGrDService.findByMasId(id);
        PurGrRespVO grVO = optional.get();
        if (grVO.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_PO.getValueCode())) {
            this.checkGr(grVO);
        }
        this.qtyVerify(grVO, purGrDRespVOS);
        String msg = this.createLot(grVO, purGrDRespVOS);
        this.unLockInvStk(grVO, purGrDRespVOS);
        this.changeInvStk(grVO, purGrDRespVOS);
        this.btbLotSoDO(grVO, purGrDRespVOS);
        return msg;
    }

    @Transactional
    public void changePurGr(PurGrBackSaveVO purGrBackSaveVO) {
        List purGrDRespVOS;
        PurGrSaveVO grVO = new PurGrSaveVO();
        grVO.setId(purGrBackSaveVO.getId());
        grVO.setDeter1(purGrBackSaveVO.getDeter1());
        grVO.setDeter2(purGrBackSaveVO.getDeter2());
        grVO.setDeter3(purGrBackSaveVO.getDeter3());
        this.update(grVO);
        if (purGrBackSaveVO.getPurGrDBackRespVos() != null && (purGrDRespVOS = this.purGrDService.findByMasId(purGrBackSaveVO.getId())) != null && purGrDRespVOS.size() > 0) {
            ArrayList grDVOS = new ArrayList();
            purGrBackSaveVO.getPurGrDBackRespVos().forEach(i -> {
                Optional<PurGrDRespVO> optionalPurGrDVO = purGrDRespVOS.stream().filter(grD -> i.getId().equals(grD.getId())).findFirst();
                if (optionalPurGrDVO.isPresent()) {
                    PurGrDRespVO purGrDRespVO = new PurGrDRespVO();
                    BeanUtils.copyProperties((Object)optionalPurGrDVO.get(), (Object)purGrDRespVO);
                    purGrDRespVO.setId(i.getId());
                    purGrDRespVO.setDeter1(i.getDeter1());
                    purGrDRespVO.setDeter2(i.getDeter2());
                    purGrDRespVO.setDeter3(i.getDeter3());
                    grDVOS.add(purGrDRespVO);
                }
            });
            this.purGrDService.createBatch(grDVOS);
        }
    }

    private void verifiesNumber(PurGrSaveVO createParam) {
        List purGrDSaveVOS = createParam.getPurGrDSaveVOList();
        if ((purGrDSaveVOS = purGrDSaveVOS.stream().filter(purGrDSaveVO -> purGrDSaveVO.getQty() != 0.0).collect(Collectors.toList())).size() == 0) {
            throw new BusinessException(ApiCode.FAIL, "\u660e\u7ec6\u884c\u6570\u91cf\u5747\u4e3a0\uff0c\u8bf7\u68c0\u67e5");
        }
        createParam.setPurGrDSaveVOList(purGrDSaveVOS);
    }

    private void checkGr(PurGrRespVO purGrRespVO) {
        Optional<PurPoRespVO> purPoVO = this.outService.findPoById(purGrRespVO.getRelateDocId());
        purPoVO.ifPresent(i -> {
            Optional<PurSceneRespVO> purSceneVO = this.outService.findPurSceneOne(i.getGenType());
            purSceneVO.ifPresent(k -> {
                if (k.getEs2().equals(UdcEnum.ORG_SUPP_TYPE2_INNER.getValueCode())) {
                    Optional optional = this.purSsService.findIdOne(purGrRespVO.getRelateDoc2Id());
                }
            });
        });
    }

    private void qtyVerify(PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        double overGrPercent = 0.0;
        Optional sysSettingVOOptional = Optional.empty();
        if (sysSettingVOOptional.isPresent()) {
            SysSettingVO sysSettingVO = (SysSettingVO)sysSettingVOOptional.get();
            overGrPercent = Double.parseDouble("ACTIVE".equals(sysSettingVO.getSettingStatus()) ? sysSettingVO.getSettingVal() : "0");
        }
        this.verifiesNumber2(purGrDRespVOS);
        this.ssQtyVerify(overGrPercent, purGrRespVO, purGrDRespVOS);
        this.updateAcceptQty(overGrPercent, purGrRespVO, purGrDRespVOS);
    }

    private void updateAcceptQty(Double overGrPercent, PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        if (!UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(purGrRespVO.getRelateDocCls())) {
            return;
        }
        double acceptQtySumToTal = 0.0;
        List itemIds = purGrDRespVOS.stream().map(PurGrDRespVO::getItemId).collect(Collectors.toList());
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemIds);
        List<ItmItemDTO> itemVOS = this.outService.itmItemAllSearch(partParam);
        List<Long> purPoDIds = purGrDRespVOS.stream().map(PurGrDRespVO::getRelateDocDid).distinct().collect(Collectors.toList());
        List<PurPoDRespVO> purPoDVOS = this.outService.findPurPoDInfoByBatch(purPoDIds);
        Map<Long, List<PurGrDRespVO>> groupByRelateDocDidMap = purGrDRespVOS.stream().collect(Collectors.groupingBy(PurGrDRespVO::getRelateDocDid));
        for (Long relateDocDid : groupByRelateDocDidMap.keySet()) {
            List<PurGrDRespVO> purGrDVOSPart = groupByRelateDocDidMap.get(relateDocDid);
            double acceptQtySum = 0.0;
            Optional<PurPoDRespVO> purPoVOOptional = purPoDVOS.stream().filter(poDid -> poDid.getId().equals(relateDocDid)).findFirst();
            if (purPoVOOptional.isEmpty()) {
                throw new BusinessException(ApiCode.FAIL, "\u6536\u8d27\u5355\u5546\u54c1\u4e0d\u5c5e\u4e8e\u6b64\u91c7\u8d2d\u5355");
            }
            PurPoDRespVO purPoDVO = purPoVOOptional.get();
            for (PurGrDRespVO purGrDRespVO : purGrDVOSPart) {
                Optional<ItmItemDTO> itmItemVOOptional = itemVOS.stream().filter(i -> i.getId().equals(purGrDRespVO.getItemId())).findFirst();
                ItmItemDTO itemVO = itmItemVOOptional.get();
                Double uomRatio = this.getUomRatio(itemVO.getItemCode(), itemVO.getItemName(), purGrDRespVO.getUom(), purPoDVO.getUom());
                acceptQtySum += purGrDRespVO.getQty() * uomRatio;
            }
            acceptQtySumToTal += acceptQtySum;
            this.overGrVerify(overGrPercent, acceptQtySum, purPoDVO);
            PurPoDUpdateParamVO purPoDSaveVO = new PurPoDUpdateParamVO();
            purPoDSaveVO.setId(relateDocDid);
            purPoDSaveVO.setAcceptQty(Double.valueOf(acceptQtySum));
            purPoDSaveVO.setAcceptDate(LocalDateTime.now());
            this.outService.addPurPoDAcceptQty(purPoDSaveVO);
        }
        Long relateDocId = purGrRespVO.getRelateDocId();
        PurPoSaveVO purPoSaveVO = new PurPoSaveVO();
        purPoSaveVO.setId(relateDocId);
        purPoSaveVO.setDocStatus(UdcEnum.PUR_PO_STATUS_RSVING.getValueCode());
        purPoSaveVO.setAcceptQty(Double.valueOf(acceptQtySumToTal));
        Optional<PurPoRespVO> purPoVO = this.outService.findPoById(relateDocId);
        double finalAcceptQtySumToTal = acceptQtySumToTal;
        purPoVO.ifPresent(i -> {
            Optional<PurSceneRespVO> purSceneVO = this.outService.findPurSceneOne(i.getGenType());
            purSceneVO.ifPresent(k -> {
                if (k.getEs2().equals(UdcEnum.ORG_SUPP_TYPE2_INNER.getValueCode()) && i.getQty() == finalAcceptQtySumToTal) {
                    purPoSaveVO.setDocStatus(UdcEnum.PUR_PO_STATUS_DONE.getValueCode());
                }
            });
        });
        this.outService.updatePurPoQty(purPoSaveVO);
    }

    private void ssQtyVerify(Double overGrPercent, PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        if (!UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(purGrRespVO.getRelateDocCls())) {
            return;
        }
        if (UdcEnum.COM_DOC_CLS_SS.getValueCode().equals(purGrRespVO.getRelateDoc2Cls())) {
            this.ssQtyVerify(overGrPercent, purGrDRespVOS);
        } else {
            this.purQtyVerify(overGrPercent, purGrDRespVOS);
        }
    }

    private void ssQtyVerify(Double overGrPercent, List<PurGrDRespVO> purGrDRespVOS) {
        List purSsDIds = purGrDRespVOS.stream().map(PurGrDRespVO::getRelateDoc2Did).distinct().collect(Collectors.toList());
        List purSsVOS = Collections.emptyList();
        for (PurGrDRespVO grd : purGrDRespVOS) {
            Optional<PurSsDRespVO> purSsDVOOptional = purSsVOS.stream().filter(ssd -> ssd.getId().equals(grd.getRelateDoc2Did())).findFirst();
            if (!purSsDVOOptional.isPresent()) continue;
            PurSsDRespVO purSsDRespVO = purSsDVOOptional.get();
            Double uomRatio = this.getUomRatio(grd.getItemCode(), grd.getItemName(), grd.getUom(), purSsDRespVO.getUom());
            if (!(grd.getQty() * uomRatio > purSsDRespVO.getQty() * (1.0 + overGrPercent))) continue;
            throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + grd.getItemName() + "\u3011\u6536\u8d27\u6570\u5df2\u8d85\u8fc7\u53d1\u8d27\u5355\u5355\u53ef\u6536\u8d27\u6570\uff08\u5141\u8bb8\u8d85\u6536" + overGrPercent * 100.0 + "%\uff09");
        }
    }

    private void purQtyVerify(Double overGrPercent, List<PurGrDRespVO> purGrDRespVOS) {
        List<Long> purPoDIds = purGrDRespVOS.stream().map(PurGrDRespVO::getRelateDocDid).distinct().collect(Collectors.toList());
        List<PurPoDRespVO> purPoDVOS = this.outService.findPurPoDInfoByBatch(purPoDIds);
        for (PurGrDRespVO grd : purGrDRespVOS) {
            Optional<PurPoDRespVO> purPurVOOptional = purPoDVOS.stream().filter(ssd -> ssd.getId().equals(grd.getRelateDocDid())).findFirst();
            if (!purPurVOOptional.isPresent()) continue;
            PurPoDRespVO purPoDRespVO = purPurVOOptional.get();
            Double uomRatio = this.getUomRatio(grd.getItemCode(), grd.getItemName(), grd.getUom(), purPoDRespVO.getUom());
            if (!(grd.getQty() * uomRatio > purPoDRespVO.getQty() * (1.0 + overGrPercent))) continue;
            throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + grd.getItemName() + "\u3011\u6536\u8d27\u6570\u5df2\u8d85\u8fc7\u53d1\u8d27\u5355\u5355\u53ef\u6536\u8d27\u6570\uff08\u5141\u8bb8\u8d85\u6536" + overGrPercent * 100.0 + "%\uff09");
        }
    }

    private void verifiesNumber2(List<PurGrDRespVO> purGrDRespVOS) {
        if (purGrDRespVOS.stream().noneMatch(i -> i.getQty() != 0.0)) {
            throw new BusinessException(ApiCode.FAIL, "\u660e\u7ec6\u884c\u6570\u91cf\u5747\u4e3a0\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    private void overGrVerify(Double overGrPercent, Double acceptQty, PurPoDRespVO purPoDVO) {
        double d = acceptQty;
        double d2 = purPoDVO.getAcceptQty() == null ? 0.0 : purPoDVO.getAcceptQty();
        if (d + d2 > purPoDVO.getQty() * (1.0 + overGrPercent)) {
            throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + purPoDVO.getItemName() + "\u3011\u6536\u8d27\u6570\u5df2\u8d85\u8fc7\u8ba2\u5355\u5269\u4f59\u53ef\u6536\u8d27\u6570\uff08\u5141\u8bb8\u8d85\u6536" + overGrPercent * 100.0 + "%\uff09");
        }
    }

    private String createLot(PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        ArrayList invLotVOS = new ArrayList();
        List invLotCommon21InVOS = purGrDRespVOS.stream().map(grd -> {
            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO();
            invLotCommon21InVO.setItemId(grd.getItemId());
            invLotCommon21InVO.setVariId(grd.getVariId());
            invLotCommon21InVO.setLotNo(grd.getLotNo());
            return invLotCommon21InVO;
        }).collect(Collectors.toList());
        Map invLotVOList = this.invLotCommonService.getInvLotVOList(invLotCommon21InVOS);
        purGrDRespVOS.forEach(grd -> {
            if (invLotVOList.get(purGrDRespVOS.indexOf(grd)) != null && ((List)invLotVOList.get(purGrDRespVOS.indexOf(grd))).size() != 0) {
                return;
            }
            InvLotSaveVO invLotVO = new InvLotSaveVO();
            invLotVO.setOuId(purGrRespVO.getOuId());
            invLotVO.setSuppId(purGrRespVO.getSuppId());
            invLotVO.setItemId(grd.getItemId());
            invLotVO.setManuDate(grd.getManuDate());
            invLotVO.setExpireDate(grd.getExpireDate());
            invLotVO.setExpireDays(grd.getExpireDays());
            invLotVO.setUntilExpireDays(grd.getUntilExpireDays());
            invLotVO.setLotNo(grd.getLotNo());
            invLotVO.setMenuLotNo(grd.getMenuLotNo());
            invLotVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_GR.getValueCode());
            invLotVO.setSrcDocId(purGrRespVO.getId());
            invLotVO.setSrcDocNo(purGrRespVO.getDocNo());
            invLotVO.setSrcDocDid(grd.getId());
            invLotVO.setVariId(grd.getVariId());
            if (UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(purGrRespVO.getRelateDocCls())) {
                invLotVO.setPoId(grd.getRelateDocId());
                invLotVO.setPoNo(grd.getRelateDocNo());
                invLotVO.setPoDId(grd.getRelateDocDid());
            }
            invLotVOS.add(invLotVO);
        });
        if (invLotVOS.size() > 0) {
            ServiceResult invLotInfo = this.invLotCommonService.createInvLotInfo(invLotVOS);
            if (invLotInfo.getCode() == 1) {
                return invLotInfo.getMsg();
            }
            return null;
        }
        return null;
    }

    private void unLockInvStk(PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        if (!UdcEnum.COM_DOC_CLS_RNS.getValueCode().equals(purGrRespVO.getRelateDocCls())) {
            return;
        }
        ArrayList<InvStkCommon37InVO> invStkCommon37InVOS = new ArrayList<InvStkCommon37InVO>();
        for (PurGrDRespVO purGrDRespVO : purGrDRespVOS) {
            InvStkCommon37InVO invStkCommon37InVO = new InvStkCommon37InVO();
            invStkCommon37InVO.setDocNo(purGrRespVO.getDocNo());
            invStkCommon37InVO.setLineNo(purGrDRespVO.getLineNo());
            invStkCommon37InVO.setOpDate(purGrRespVO.getRecvDate());
            invStkCommon37InVO.setCreateUserId(purGrRespVO.getRecvEmpId());
            invStkCommon37InVO.setInvStk28Enum1(InvStk28Enum.T_TYPE_24);
            invStkCommon37InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_GR.getValueCode());
            invStkCommon37InVO.setSrcDocId(purGrRespVO.getId());
            invStkCommon37InVO.setSrcDocDid(purGrDRespVO.getId());
            invStkCommon37InVO.setItemId(purGrDRespVO.getItemId());
            invStkCommon37InVO.setVariId(purGrDRespVO.getVariId());
            invStkCommon37InVO.setQty(purGrDRespVO.getQty2());
            invStkCommon37InVO.setUom(purGrDRespVO.getUom2());
            invStkCommon37InVO.setWhId(purGrRespVO.getWhId());
            invStkCommon37InVO.setDeter1(purGrDRespVO.getDeter1());
            invStkCommon37InVO.setDeter2(purGrDRespVO.getDeter2());
            invStkCommon37InVO.setDeter3(purGrDRespVO.getDeter3());
            invStkCommon37InVO.setLotNo(purGrDRespVO.getLotNo());
            invStkCommon37InVOS.add(invStkCommon37InVO);
        }
        this.invStkCommonService.invStkCommon37(invStkCommon37InVOS);
    }

    private void changeInvStk(PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        ArrayList<InvStkCommon28InVO> invStkCommon28InVOS = new ArrayList<InvStkCommon28InVO>();
        for (PurGrDRespVO purGrDRespVO : purGrDRespVOS) {
            InvStkCommon28InVO invStkCommon28InVO = new InvStkCommon28InVO();
            invStkCommon28InVO.setQty(purGrDRespVO.getQty2());
            invStkCommon28InVO.setUom(purGrDRespVO.getUom2());
            invStkCommon28InVO.setDocNo(purGrRespVO.getDocNo());
            invStkCommon28InVO.setLineNo(purGrDRespVO.getLineNo());
            invStkCommon28InVO.setOpDate(purGrRespVO.getRecvDate());
            invStkCommon28InVO.setCreateUserId(purGrRespVO.getRecvEmpId());
            String relateDocCls = purGrRespVO.getRelateDocCls();
            if (UdcEnum.COM_DOC_CLS_RNS.getValueCode().equals(relateDocCls)) {
                invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_03);
            } else if (UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(relateDocCls)) {
                invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.I_TYPE_02);
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u91c7\u8d2d\u6536\u8d27\u5165\u5e93\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            invStkCommon28InVO.setInvStk28Enum2(null);
            invStkCommon28InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_GR.getValueCode());
            invStkCommon28InVO.setSrcDocId(purGrRespVO.getId());
            invStkCommon28InVO.setSrcDocDid(purGrDRespVO.getId());
            invStkCommon28InVO.setItemId(purGrDRespVO.getItemId());
            invStkCommon28InVO.setVariId(purGrDRespVO.getVariId());
            invStkCommon28InVO.setWhId(purGrRespVO.getWhId());
            invStkCommon28InVO.setDeter1(purGrDRespVO.getDeter1());
            invStkCommon28InVO.setDeter2(purGrDRespVO.getDeter2());
            invStkCommon28InVO.setDeter3(purGrDRespVO.getDeter3());
            invStkCommon28InVO.setLotNo(purGrDRespVO.getLotNo());
            invStkCommon28InVOS.add(invStkCommon28InVO);
        }
        this.invStkCommonService.invStkCommon28(invStkCommon28InVOS);
    }

    private void btbLotSoDO(PurGrRespVO purGrRespVO, List<PurGrDRespVO> purGrDRespVOS) {
        if (!UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(purGrRespVO.getRelateDocCls())) {
            return;
        }
        Long poId = purGrRespVO.getRelateDocId();
        Optional purPoVOOptional = Optional.empty();
        PurPoVO poVO = (PurPoVO)purPoVOOptional.get();
        Long whId = purGrRespVO.getWhId();
        Optional orgWhVOOptional = this.invWhService.findIdOne(whId);
        if (orgWhVOOptional.isPresent()) {
            InvWhRespVO invWhRespVO = (InvWhRespVO)orgWhVOOptional.get();
            if (UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(invWhRespVO.getWhType())) {
                return;
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4ed3\u5e93\u4e3b\u6570\u636e\u672a\u67e5\u8be2\u5230,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        AtomicReference salSoCreateParam = new AtomicReference();
    }

    @SysCodeProc
    public Optional<PurGrRespVO> findIdOne(Long id) {
        return this.purGrRepo.findById(id).map(PurGrCovert.INSTANCE::doToRespVO);
    }

    @SysCodeProc
    public List<PurGrRespVO> findIdBatch(List<Long> idList) {
        return this.purGrRepo.findAllById(idList).stream().map(PurGrCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(PurGrSaveVO purGrSaveVO) {
        return ((PurGrDO)this.purGrRepo.save(PurGrCovert.INSTANCE.voToDO(purGrSaveVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<PurGrSaveVO> list) {
        return this.purGrRepo.saveAll(list.stream().map(PurGrCovert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(PurGrSaveVO objVo) {
        Optional optional = this.purGrRepo.findById(objVo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objVo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objVo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objVo));
        this.purGrRepo.save((PurGrDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QPurGrDO jpaQDo = QPurGrDO.purGrDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.purGrRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        PurGrDO do1 = (PurGrDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.purGrRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.purGrRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> {
            Optional<PurGrRespVO> optional = this.findIdOne((Long)id);
            if (optional.isPresent()) {
                PurGrRespVO purGrRespVO = optional.get();
                if (!UdcEnum.PUR_GR_STATUS_DR.getValueCode().equals(purGrRespVO.getDocStatus())) {
                    throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u8ba2\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u8ba2\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
            }
            PurGrSaveVO purGrSaveVO = new PurGrSaveVO();
            purGrSaveVO.setId(id);
            purGrSaveVO.setDocStatus(UdcEnum.PUR_GR_STATUS_CL.getValueCode());
            this.update(purGrSaveVO);
            List list = this.purGrDService.findByMasId(id);
        });
    }

    @SysCodeProc
    public Optional<PurGrRespVO> findIdPurGr(Long id) {
        Optional<PurGrRespVO> purGrVOOptional = this.purGrRepo.findById(id).map(PurGrCovert.INSTANCE::doToRespVO);
        if (purGrVOOptional.isPresent()) {
            PurGrRespVO purGrRespVO = purGrVOOptional.get();
            this.translate(List.of(purGrRespVO));
            purGrRespVO.setPurGrDRespVOList(this.purGrDService.findByMasId(id));
        }
        return purGrVOOptional;
    }

    public Long createPurGr(PurGrSaveVO createParam) {
        if (StringUtils.isNotBlank((CharSequence)createParam.getRelateDoc2No())) {
            this.relatePurSsDocVerify(createParam);
        }
        if (!StringUtils.isNotBlank((CharSequence)createParam.getRelateDoc2No()) && StringUtils.isNotBlank((CharSequence)createParam.getRelateDocNo())) {
            this.relatePoDocVerify(createParam);
        }
        this.whTypeVerify(createParam);
        PurGrDO purGrDO = (PurGrDO)BeanUtil.copyProperties((Object)createParam, PurGrDO.class);
        purGrDO.setDocStatus(UdcEnum.PUR_GR_STATUS_DR.getValueCode());
        Double totalQty = createParam.getPurGrDSaveVOList().stream().map(PurGrDSaveVO::getQty).reduce(0.0, Double::sum);
        purGrDO.setQty(totalQty);
        this.purGrDateHandle(purGrDO, createParam);
        String suppTaxCode = this.outService.findIdPurSuppOne(createParam.getSuppId()).map(PurSuppRespVO::getTaxCode).orElse(null);
        purGrDO.setTaxRateNo(suppTaxCode);
        Long masId = purGrDO.getId();
        if (masId == null || !this.purGrRepo.existsById(masId)) {
            ArrayList<String> runtimeValues = new ArrayList<String>();
            String ouCode = this.outService.findOrgOuVOById(createParam.getOuId()) == null ? "18010" : this.outService.findOrgOuVOById(createParam.getOuId()).getCode();
            runtimeValues.add(ouCode.substring(ouCode.length() - 3));
            String purGrCode = this.sysNumberRuleService.generateCode("GR", runtimeValues);
            purGrDO.setDocNo(purGrCode);
            masId = this.createOne(PurGrCovert.INSTANCE.doToVO(purGrDO));
        } else {
            Optional purGrDOOptional = this.purGrRepo.findById(masId);
            if (UdcEnum.PUR_GR_STATUS_DR.getValueCode().equals(((PurGrDO)purGrDOOptional.get()).getDocStatus())) {
                this.update(PurGrCovert.INSTANCE.doToVO(purGrDO));
                this.purGrDService.deleteByMasId(masId);
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u9519\u8bef,\u65e0\u6cd5\u4fdd\u5b58");
            }
        }
        if (createParam.getPurGrDSaveVOList() == null) {
            return masId;
        }
        List<PurGrDRespVO> purGrDRespVOS = this.purGrDDateHandle(createParam, masId, purGrDO, suppTaxCode);
        this.purGrDService.createBatch(purGrDRespVOS);
        return masId;
    }

    private List<PurGrDRespVO> purGrDDateHandle(PurGrSaveVO createParam, Long masId, PurGrDO purGrDO, String suppTaxCode) {
        List purPrDCreateParams = createParam.getPurGrDSaveVOList();
        if (createParam.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_PO.getValueCode())) {
            this.dateVerify(purPrDCreateParams);
        }
        List itemIds = purPrDCreateParams.stream().map(PurGrDSaveVO::getItemId).collect(Collectors.toList());
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemIds);
        List<ItmItemDTO> itmItemVOS = this.outService.itmItemAllSearch(partParam);
        List<Long> relateDocIds = purPrDCreateParams.stream().map(PurGrDSaveVO::getRelateDocId).distinct().collect(Collectors.toList());
        ArrayList<String> genTypes = new ArrayList();
        List<Object> purPoVOList = new ArrayList();
        List<Object> purSceneVOList = new ArrayList();
        if (createParam.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_PO.getValueCode())) {
            purPoVOList = this.outService.findPurPoByIdBatch(relateDocIds);
            genTypes = purPoVOList.stream().map(PurPoRespVO::getGenType).distinct().collect(Collectors.toList());
            purSceneVOList = this.outService.findCodeBatch(genTypes);
        }
        Long finalMasId = masId;
        AtomicDouble purGrDdLineNo = new AtomicDouble(0.0);
        List<Object> finalPurPoVOList = purPoVOList;
        ArrayList finalPurSceneVOList = purSceneVOList;
        List<PurGrDRespVO> purGrDRespVOS = purPrDCreateParams.stream().map(param -> {
            PurGrDRespVO purGrDRespVO = (PurGrDRespVO)BeanUtil.copyProperties((Object)param, PurGrDRespVO.class);
            if (param.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_PO.getValueCode())) {
                Optional<PurPoRespVO> poVOOptional = finalPurPoVOList.stream().filter(i -> i.getId().equals(param.getRelateDocId())).findFirst();
                if (poVOOptional.isPresent()) {
                    PurPoRespVO purPoVO = poVOOptional.get();
                    Optional<PurSceneRespVO> purSceneVO = finalPurSceneVOList.stream().filter(i -> i.getSceneCode().equals(purPoVO.getGenType())).findFirst();
                    purSceneVO.ifPresent(i -> purGrDRespVO.setLineType(i.getEs5()));
                }
            } else if (param.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_RNS.getValueCode())) {
                purGrDRespVO.setLineType("S");
            }
            if (purGrDRespVO.getManuDate() != null && purGrDRespVO.getExpireDate() != null) {
                purGrDRespVO.setLotNo((String)(StringUtils.isEmpty((CharSequence)purGrDRespVO.getLotNo()) ? purGrDRespVO.getManuDate().toLocalDate().format(DateTimeFormatter.ofPattern("yyMMdd")) + "/" + purGrDRespVO.getExpireDate().toLocalDate().format(DateTimeFormatter.ofPattern("yyMMdd")) : purGrDRespVO.getLotNo()));
            }
            purGrDRespVO.setTaxRateNo(suppTaxCode);
            purGrDRespVO.setWhId(purGrDO.getWhId());
            purGrDRespVO.setMasId(finalMasId);
            purGrDRespVO.setGrNo(purGrDO.getDocNo());
            purGrDRespVO.setLineNo(Double.valueOf(purGrDdLineNo.addAndGet(1.0)));
            return purGrDRespVO;
        }).collect(Collectors.toList());
        return purGrDRespVOS;
    }

    private void purGrDateHandle(PurGrDO purGrDO, PurGrSaveVO createParam) {
        Optional purRnsVOOptional;
        if (createParam.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_PO.getValueCode())) {
            Optional<PurPoRespVO> purPoVOOptional = this.outService.findPoById(createParam.getRelateDocId());
            if (purPoVOOptional.isPresent()) {
                PurPoRespVO purPoVO = purPoVOOptional.get();
                purGrDO.setEmpId(purPoVO.getAgentEmpId());
                purGrDO.setPaymentTerm(purPoVO.getPaymentTerm());
                if (purPoVO.getAgentEmpId() != null) {
                    Optional<OrgEmpRespVO> orgEmpVOOptional = this.outService.findEmpById(purGrDO.getEmpId());
                    orgEmpVOOptional.ifPresent(i -> purGrDO.setEmpCode(i.getEmpCode()));
                }
                if (purPoVO.getGenType() != null) {
                    Optional<PurSceneRespVO> purSceneVOOptional = this.outService.findPurSceneOne(purPoVO.getGenType());
                    purSceneVOOptional.ifPresent(i -> {
                        purGrDO.setPoType(i.getPoType());
                        purGrDO.setEs3(i.getEs7());
                    });
                }
            }
        } else if (createParam.getRelateDocCls().equals(UdcEnum.COM_DOC_CLS_RNS.getValueCode()) && (purRnsVOOptional = Optional.empty()).isPresent()) {
            PurRnsVO purRnsVO = (PurRnsVO)purRnsVOOptional.get();
            purGrDO.setEmpId(purRnsVO.getDocEmpId());
            Optional<InvSuppVO> orgSuppVOOptional = Optional.empty();
            orgSuppVOOptional.ifPresent(i -> purGrDO.setPaymentTerm(i.getPaymentTerm()));
            if (purRnsVO.getDocEmpId() != null) {
                Optional<OrgEmpVO> orgEmpVOOptional = Optional.empty();
                orgEmpVOOptional.ifPresent(i -> purGrDO.setEmpCode(i.getEmpCode()));
            }
            purGrDO.setPoType("OE");
        }
    }

    private void dateVerify(List<PurGrDSaveVO> purPrDCreateParams) {
        StringBuilder erRecord = new StringBuilder();
        AtomicInteger line = new AtomicInteger(0);
        purPrDCreateParams.forEach(i -> {
            line.addAndGet(1);
            if (!(i.getQty() >= 0.0)) {
                erRecord.append("\u3010" + line + "\u3011");
            }
        });
        if (erRecord.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u660e\u7ec6\u4e2d" + erRecord + "\u884c\u4fe1\u606f\u7684\u6536\u8d27\u4fe1\u606f\u4e0d\u5e94\u8be5\u4e3a\u8d1f\u503c,\u8bf7\u68c0\u67e5");
        }
    }

    private void relatePoDocVerify(PurGrSaveVO createParam) {
        Object relateDoc2No = null;
        String relateDocNo = createParam.getRelateDocNo();
        Optional<PurPoRespVO> purPoOptiona = this.outService.findPurByCodeOne(relateDocNo);
        if (purPoOptiona.isPresent()) {
            PurPoRespVO purPoRespVO = purPoOptiona.get();
            Long relateDocId = purPoRespVO.getId();
            String relateDocCls = UdcEnum.COM_DOC_CLS_PO.getValueCode();
            this.poVerify(relateDocId);
            createParam.setPoId(relateDocId);
            createParam.setRelateDocId(purPoRespVO.getId());
            createParam.setRelateDocNo(purPoRespVO.getDocNo());
            createParam.setRelateDocCls(createParam.getRelateDocCls());
            createParam.setOuId(purPoRespVO.getOuId());
            createParam.setSuppId(purPoRespVO.getSuppId());
            createParam.setWhId(purPoRespVO.getWhId());
            createParam.setHomeCurr(purPoRespVO.getHomeCurr());
            createParam.setCurrCode(purPoRespVO.getCurrCode());
            createParam.setCurrRate(purPoRespVO.getCurrRate());
            createParam.setTaxCode(purPoRespVO.getTaxCode());
        }
        List purGrDSaveVOList = createParam.getPurGrDSaveVOList();
        List<Long> purDIds = purGrDSaveVOList.stream().map(PurGrDSaveVO::getRelateDocDid).distinct().collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)createParam.getRelateDoc2No()) && !StringUtils.isNotBlank((CharSequence)createParam.getRelateNo())) {
            List<PurPoDRespVO> purPoDVOS = this.outService.findPurPoDByBatch(purDIds);
            List itemIds = purGrDSaveVOList.stream().map(PurGrDSaveVO::getItemId).distinct().collect(Collectors.toList());
            ItmItemPartParam partParam = new ItmItemPartParam();
            partParam.setIds(itemIds);
            List<ItmItemDTO> itemVOS = this.outService.itmItemAllSearch(partParam);
            AtomicDouble lineNo = new AtomicDouble(0.0);
            purGrDSaveVOList.forEach(grd -> {
                Optional<PurPoDRespVO> purSsDVOOptional = purPoDVOS.stream().filter(ssd -> ssd.getId().equals(grd.getRelateDoc2Did())).findFirst();
                Optional<ItmItemDTO> itmItemVOOptional = itemVOS.stream().filter(item -> item.getId().equals(grd.getItemId())).findFirst();
                if (purSsDVOOptional.isPresent() && itmItemVOOptional.isPresent()) {
                    PurPoDRespVO purPoDRespVO = purSsDVOOptional.get();
                    grd.setPoDId(purPoDRespVO.getId());
                    grd.setRelateDocCls(UdcEnum.COM_DOC_CLS_PO.getValueCode());
                    grd.setRelateDocId(purPoDRespVO.getMasId());
                    grd.setRelateDocNo(purPoDRespVO.getPoNo());
                    grd.setRelateDocDid(purPoDRespVO.getId());
                    grd.setRelateDocLineno(Double.valueOf(purPoDRespVO.getLineNo().doubleValue()));
                    ItmItemDTO itemVO = itmItemVOOptional.get();
                    grd.setUom2(itemVO.getUom());
                    Double uomRatio = this.getUomRatio(itemVO.getItemCode(), itemVO.getItemName(), grd.getUom(), itemVO.getUom());
                    grd.setQty2(Double.valueOf(grd.getQty() * uomRatio));
                    grd.setUomRatio(uomRatio);
                    grd.setNetPrice(purPoDRespVO.getNetPrice());
                    grd.setPrice(purPoDRespVO.getPrice());
                    grd.setCurrNetPrice(purPoDRespVO.getCurrNetPrice());
                    grd.setCurrPrice(purPoDRespVO.getCurrPrice());
                    grd.setPbPrice(purPoDRespVO.getPbPrice());
                    grd.setPbCurr(purPoDRespVO.getPbCurr());
                    grd.setPbUom(purPoDRespVO.getPbUom());
                    grd.setTaxCode(purPoDRespVO.getTaxCode());
                    grd.setTaxRate(purPoDRespVO.getTaxRate());
                    grd.setAmt(purPoDRespVO.getPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                    grd.setNetAmt(purPoDRespVO.getNetPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                    grd.setCurrAmt(purPoDRespVO.getCurrPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                    grd.setCurrNetAmt(purPoDRespVO.getCurrNetPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                    grd.setTaxAmt(grd.getCurrAmt().subtract(grd.getCurrNetAmt()).setScale(2, RoundingMode.HALF_UP));
                    grd.setCurrCode(purPoDRespVO.getCurrCode());
                    grd.setCurrRate(purPoDRespVO.getCurrRate());
                    createParam.setTaxAmt((createParam.getTaxAmt() == null ? BigDecimal.ZERO : createParam.getTaxAmt()).add(grd.getTaxAmt()));
                    createParam.setAmt((createParam.getAmt() == null ? BigDecimal.ZERO : createParam.getAmt()).add(grd.getAmt()));
                    createParam.setNetAmt((createParam.getNetAmt() == null ? BigDecimal.ZERO : createParam.getNetAmt()).add(grd.getNetAmt()));
                    createParam.setCurrAmt((createParam.getCurrAmt() == null ? BigDecimal.ZERO : createParam.getCurrAmt()).add(grd.getCurrAmt()));
                    createParam.setCurrNetAmt((createParam.getCurrNetAmt() == null ? BigDecimal.ZERO : createParam.getCurrNetAmt()).add(grd.getCurrNetAmt()));
                }
            });
        }
    }

    private void relatePurSsDocVerify(PurGrSaveVO createParam) {
        PurSsRespVO purSsRespVO;
        String relateDoc2No = null;
        relateDoc2No = createParam.getRelateDoc2No();
        Optional purSsVOOptional = this.purSsService.findCodeOne(relateDoc2No);
        if (purSsVOOptional.isPresent()) {
            purSsRespVO = (PurSsRespVO)purSsVOOptional.get();
            Long relateDocId = purSsRespVO.getRelateDocId();
            String relateDocCls = purSsRespVO.getRelateDocCls();
            if (UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(relateDocCls)) {
                this.poVerify(relateDocId);
                createParam.setPoId(purSsRespVO.getRelateDocId());
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u53d1\u8d27\u5355" + relateDoc2No + "\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        createParam.setRelateDocId(purSsRespVO.getRelateDocId());
        createParam.setRelateDocNo(purSsRespVO.getRelateDocNo());
        createParam.setRelateDocCls(purSsRespVO.getRelateDocCls());
        createParam.setPoId(purSsRespVO.getPoId());
        createParam.setRelateDoc2Id(purSsRespVO.getId());
        createParam.setSuppDocNo(purSsRespVO.getSuppDocNo());
        createParam.setRelateDoc2No(purSsRespVO.getDocNo());
        createParam.setRelateDoc2Cls(UdcEnum.COM_DOC_CLS_SS.getValueCode());
        createParam.setOuId(purSsRespVO.getOuId());
        createParam.setSuppId(purSsRespVO.getSuppId());
        createParam.setWhId(purSsRespVO.getWhId());
        createParam.setHomeCurr(purSsRespVO.getHomeCurr());
        createParam.setCurrCode(purSsRespVO.getCurrCode());
        createParam.setCurrRate(purSsRespVO.getCurrRate());
        createParam.setTaxCode(purSsRespVO.getTaxCode());
        List purGrDSaveVOList = createParam.getPurGrDSaveVOList();
        List purSsDIds = purGrDSaveVOList.stream().map(PurGrDSaveVO::getRelateDoc2Did).distinct().collect(Collectors.toList());
        List purSsVOS = this.purSsDService.findIdBatch(purSsDIds);
        List itemIds = purGrDSaveVOList.stream().map(PurGrDSaveVO::getItemId).distinct().collect(Collectors.toList());
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemIds);
        List<ItmItemDTO> itemVOS = this.outService.itmItemAllSearch(partParam);
        AtomicDouble lineNo = new AtomicDouble(0.0);
        purGrDSaveVOList.forEach(grd -> {
            Optional<PurSsDRespVO> purSsDVOOptional = purSsVOS.stream().filter(ssd -> ssd.getId().equals(grd.getRelateDoc2Did())).findFirst();
            Optional<ItmItemDTO> itmItemVOOptional = itemVOS.stream().filter(item -> item.getId().equals(grd.getItemId())).findFirst();
            if (purSsDVOOptional.isPresent() && itmItemVOOptional.isPresent()) {
                PurSsDRespVO purSsDVO = purSsDVOOptional.get();
                grd.setPoDId(purSsDVO.getRelateDocDid());
                grd.setRelateDocCls(purSsDVO.getRelateDocCls());
                grd.setRelateDocId(purSsDVO.getRelateDocId());
                grd.setRelateDocNo(purSsDVO.getRelateDocNo());
                grd.setRelateDocDid(purSsDVO.getRelateDocDid());
                grd.setRelateDocLineno(purSsDVO.getRelateDocLineno());
                grd.setSsDId(purSsDVO.getId());
                grd.setRelateDoc2Cls(UdcEnum.COM_DOC_CLS_SS.getValueCode());
                grd.setRelateDoc2Id(purSsDVO.getMasId());
                grd.setRelateDoc2No(createParam.getRelateDoc2No());
                grd.setRelateDoc2Did(purSsDVO.getId());
                grd.setRelateDoc2Lineno(purSsDVO.getLineNo());
                ItmItemDTO itemVO = itmItemVOOptional.get();
                grd.setUom2(itemVO.getUom());
                Double uomRatio = this.getUomRatio(itemVO.getItemCode(), itemVO.getItemName(), grd.getUom(), itemVO.getUom());
                grd.setQty2(Double.valueOf(grd.getQty() * uomRatio));
                grd.setUomRatio(uomRatio);
                grd.setNetPrice(purSsDVO.getNetPrice());
                grd.setPrice(purSsDVO.getPrice());
                grd.setCurrNetPrice(purSsDVO.getCurrNetPrice());
                grd.setCurrPrice(purSsDVO.getCurrPrice());
                grd.setPbPrice(purSsDVO.getPbPrice());
                grd.setPbCurr(purSsDVO.getPbCurr());
                grd.setPbUom(purSsDVO.getPbUom());
                grd.setTaxCode(purSsDVO.getTaxCode());
                grd.setTaxRate(purSsDVO.getTaxRate());
                grd.setAmt(purSsDVO.getPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                grd.setNetAmt(purSsDVO.getNetPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                grd.setCurrAmt(purSsDVO.getCurrPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                grd.setCurrNetAmt(purSsDVO.getCurrNetPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(grd.getQty())).setScale(2, RoundingMode.HALF_UP));
                grd.setTaxAmt(grd.getCurrAmt().subtract(grd.getCurrNetAmt()).setScale(2, RoundingMode.HALF_UP));
                grd.setCurrCode(purSsDVO.getCurrCode());
                grd.setCurrRate(purSsDVO.getCurrRate());
                createParam.setTaxAmt((createParam.getTaxAmt() == null ? BigDecimal.ZERO : createParam.getTaxAmt()).add(grd.getTaxAmt()));
                createParam.setAmt((createParam.getAmt() == null ? BigDecimal.ZERO : createParam.getAmt()).add(grd.getAmt()));
                createParam.setNetAmt((createParam.getNetAmt() == null ? BigDecimal.ZERO : createParam.getNetAmt()).add(grd.getNetAmt()));
                createParam.setCurrAmt((createParam.getCurrAmt() == null ? BigDecimal.ZERO : createParam.getCurrAmt()).add(grd.getCurrAmt()));
                createParam.setCurrNetAmt((createParam.getCurrNetAmt() == null ? BigDecimal.ZERO : createParam.getCurrNetAmt()).add(grd.getCurrNetAmt()));
            }
        });
    }

    private void poVerify(Long relateDocId) {
        Optional<PurPoRespVO> purPoVOOptional = this.outService.findPoById(relateDocId);
        if (purPoVOOptional.isPresent()) {
            PurPoRespVO poVO = purPoVOOptional.get();
            String docStatus = poVO.getDocStatus();
            if (!(UdcEnum.PUR_PO_STATUS_SHIPPED.getValueCode().equals(docStatus) || UdcEnum.PUR_PO_STATUS_RSVING.getValueCode().equals(docStatus) || UdcEnum.PUR_PO_STATUS_DONE.getValueCode().equals(docStatus))) {
                throw new BusinessException(ApiCode.FAIL, "\u91c7\u8d2d\u8ba2\u5355\u4f9b\u5e94\u5546\u672a\u53d1\u8d27\uff0c\u8bf7\u68c0\u67e5");
            }
            if (UdcEnum.PUR_PO_STATUS_DONE.getValueCode().equals(docStatus)) {
                throw new BusinessException(ApiCode.FAIL, "\u91c7\u8d2d\u8ba2\u5355\u5df2\u6536\u8d27\u5b8c\u6210\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6536\u8d27");
            }
        }
    }

    private Double getUomRatio(String itemCode, String itemName, String fromUom, String toUom) {
        double uomRatio = 1.0;
        if (fromUom == null || toUom == null || fromUom.equals(toUom)) {
            return uomRatio;
        }
        ItmItemuomConvRatioQueryParm queryParm = new ItmItemuomConvRatioQueryParm();
        queryParm.setItemCode(itemCode);
        queryParm.setFromUom(fromUom);
        queryParm.setToUom(toUom);
        ArrayList<ItmItemuomConvRatioVO> radio = new ArrayList<ItmItemuomConvRatioVO>();
        ItmItemuomConvRatioVO itmItemuomConvRatioVO = new ItmItemuomConvRatioVO();
        itmItemuomConvRatioVO.setRatio(Double.valueOf(1.0));
        radio.add(itmItemuomConvRatioVO);
        if (radio != null && radio.size() == 1) {
            return ((ItmItemuomConvRatioVO)radio.get(0)).getRatio();
        }
        throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + itemName + "\u3011\u5355\u4f4d\u8f6c\u6362" + fromUom + "->" + toUom + "\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u4e3b\u6570\u636e");
    }

    private void whTypeVerify(PurGrSaveVO createParam) {
        Long whId = createParam.getWhId();
        Integer crosswhFlag = createParam.getCrosswhFlag();
        if (crosswhFlag == null) {
            return;
        }
        Optional orgWhVOOptional = this.invWhService.findIdOne(whId);
        if (orgWhVOOptional.isPresent()) {
            InvWhRespVO invWhRespVO = (InvWhRespVO)orgWhVOOptional.get();
            String string = invWhRespVO.getWhType();
        }
    }

    private void translate(List<PurGrRespVO> lists) {
        if (lists == null || lists.size() == 0) {
            return;
        }
        List<Long> ouIds = lists.stream().map(PurGrRespVO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuVO> orgOuVOList = this.outService.findOusByBatch(ouIds);
        List<Long> suppIds = lists.stream().map(PurGrRespVO::getSuppId).distinct().collect(Collectors.toList());
        List<PurSuppRespVO> invSuppVOList = this.outService.findSuppByIdBatch(suppIds);
        List whIds = lists.stream().map(PurGrRespVO::getWhId).distinct().collect(Collectors.toList());
        List invWhRespVOList = this.invWhService.findIdBatch(whIds);
        List empIds = lists.stream().map(PurGrRespVO::getRecvEmpId).distinct().collect(Collectors.toList());
        List sysUserDOS = this.sysUserRepo.findAllByIdIn(empIds);
        List<String> currCode = lists.stream().map(PurGrRespVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ComCurrRespVO> comCurrVOS = this.outService.findCurrByCode(currCode);
        lists.forEach(vo -> {
            Optional<InvWhRespVO> whVO;
            Optional<PurSuppRespVO> orgSuppVO;
            Optional<OrgOuVO> orgOuVO;
            if (!CollectionUtils.isEmpty((Collection)orgOuVOList) && (orgOuVO = orgOuVOList.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst()).isPresent()) {
                OrgOuVO ouVO = orgOuVO.get();
                vo.setOuCode(ouVO.getCode());
                vo.setOuName(ouVO.getName());
            }
            if (!CollectionUtils.isEmpty((Collection)sysUserDOS)) {
                sysUserDOS.stream().filter(v -> v.getId().equals(vo.getRecvEmpId())).findFirst().ifPresent(empVo -> vo.setRecvEmpName(empVo.getFirstName()));
            }
            if (!CollectionUtils.isEmpty((Collection)invSuppVOList) && (orgSuppVO = invSuppVOList.stream().filter(v -> v.getId().equals(vo.getSuppId())).findFirst()).isPresent()) {
                PurSuppRespVO suppVO = orgSuppVO.get();
                vo.setSuppCode(suppVO.getSuppCode());
                vo.setSuppName(suppVO.getSuppName());
            }
            if (!CollectionUtils.isEmpty((Collection)invWhRespVOList) && (whVO = invWhRespVOList.stream().filter(v -> v.getId().equals(vo.getWhId())).findFirst()).isPresent()) {
                InvWhRespVO invWhRespVO = whVO.get();
                vo.setWhCode(invWhRespVO.getWhCode());
                vo.setWhName(invWhRespVO.getWhName());
            }
            if (!CollectionUtils.isEmpty((Collection)comCurrVOS)) {
                Optional<ComCurrRespVO> comCurrVO = comCurrVOS.stream().filter(c -> c.getCurrCode().equals(vo.getCurrCode())).findFirst();
                comCurrVO.ifPresent(currVO -> vo.setCurrName(currVO.getCurrName()));
            }
        });
    }

    public PurGrServiceImpl(PurGrRepo purGrRepo, PurGrDRepo purGrDRepo, PurGrRepoProc purGrRepoProc, PurGrDRepoProc purGrDRepoProc, InvWhService invWhService, OrgOuService orgOuService, InvStkCommonService invStkCommonService, InvLotCommonService invLotCommonService, SysUserRepo sysUserRepo, InvLotStkCommonService invLotStkCommonService, SysNumberRuleService sysNumberRuleService, PurGrDService purGrDService, OutService outService, PurSsService purSsService, SalDoRepoProc salDoRepoProc, PurSsDService purSsDService) {
        this.purGrRepo = purGrRepo;
        this.purGrDRepo = purGrDRepo;
        this.purGrRepoProc = purGrRepoProc;
        this.purGrDRepoProc = purGrDRepoProc;
        this.invWhService = invWhService;
        this.orgOuService = orgOuService;
        this.invStkCommonService = invStkCommonService;
        this.invLotCommonService = invLotCommonService;
        this.sysUserRepo = sysUserRepo;
        this.invLotStkCommonService = invLotStkCommonService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.purGrDService = purGrDService;
        this.outService = outService;
        this.purSsService = purSsService;
        this.salDoRepoProc = salDoRepoProc;
        this.purSsDService = purSsDService;
    }
}

